/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BeginShutdownControllerHandleAdapter;
import kafka.server.BeginShutdownControllerHandleAdapter$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.KafkaFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00192Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\tA#)Z4j]NCW\u000f\u001e3po:\u001cuN\u001c;s_2dWM\u001d%b]\u0012dW-\u00113baR,'\u000fV3ti*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0011\u0005M\u0001Q\"\u0001\u0003\u00025Q,7\u000f^$f]\u0016\u0014\u0018\r^3S_2d\u0017M\u00197f'R\fG/^:\u0015\u0003Y\u0001\"aC\f\n\u0005aa!\u0001B+oSRD#A\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003Kq\u0011A\u0001V3ti\u0002")
public class BeginShutdownControllerHandleAdapterTest {
    @Test
    public void testGenerateRollableStatus() {
        int maxLag = BeginShutdownControllerHandleAdapter$.MODULE$.MaxAllowedOffsetLag();
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        KafkaFuture quorumFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        DescribeMetadataQuorumResult metadataQuorumResult = (DescribeMetadataQuorumResult)Mockito.mock(DescribeMetadataQuorumResult.class);
        QuorumInfo.ReplicaState repl1 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl2 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl3 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo quorumInfo = (QuorumInfo)Mockito.mock(QuorumInfo.class);
        BeginShutdownControllerHandleAdapter adapter = new BeginShutdownControllerHandleAdapter("", 10000, admin);
        Mockito.when((Object)metadataQuorumResult.quorumInfo()).thenReturn((Object)quorumFuture);
        Mockito.when((Object)admin.describeMetadataQuorum((DescribeMetadataQuorumOptions)ArgumentMatchers.any())).thenReturn((Object)metadataQuorumResult);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)200L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)300L));
        Buffer voters = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)quorumInfo.leaderId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)quorumInfo.observers()).thenReturn(null);
        Mockito.when((Object)quorumInfo.voters()).thenReturn(JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)voters).asJava());
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)adapter.generateRollableStatus().rollable()));
        Assertions.assertEquals((Object)"", (Object)adapter.generateRollableStatus().reason());
        voters.clear();
        Mockito.reset((Object[])new Object[]{quorumFuture, repl1, repl2, repl3});
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)maxLag));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag + 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag + maxLag)));
        voters = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)quorumInfo.leaderId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)quorumInfo.observers()).thenReturn(null);
        Mockito.when((Object)quorumInfo.voters()).thenReturn(JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)voters).asJava());
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)adapter.generateRollableStatus().rollable()));
        Assertions.assertEquals((Object)"", (Object)adapter.generateRollableStatus().reason());
        voters.clear();
        Mockito.reset((Object[])new Object[]{quorumFuture, repl1, repl2, repl3});
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)1L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag + 2)));
        voters = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)quorumInfo.leaderId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)quorumInfo.observers()).thenReturn(null);
        Mockito.when((Object)quorumInfo.voters()).thenReturn(JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)voters).asJava());
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)adapter.generateRollableStatus().rollable()));
        Assertions.assertEquals((Object)new StringBuilder(124).append("Found at least one quorum voter with an offset 1 while the primary controller was at offset ").append(maxLag + 2).append(". The max allowed offset lag is ").append(BeginShutdownControllerHandleAdapter$.MODULE$.MaxAllowedOffsetLag()).toString(), (Object)adapter.generateRollableStatus().reason());
        voters.clear();
        Mockito.reset((Object[])new Object[]{quorumFuture, repl1, repl2, repl3});
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag + maxLag)));
        voters = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)quorumInfo.leaderId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)quorumInfo.observers()).thenReturn(null);
        Mockito.when((Object)quorumInfo.voters()).thenReturn(JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)voters).asJava());
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)adapter.generateRollableStatus().rollable()));
        Assertions.assertEquals((Object)BeginShutdownControllerHandleAdapter$.MODULE$.UnreachableQuorumMemberMsg(), (Object)adapter.generateRollableStatus().reason());
        voters.clear();
        Mockito.reset((Object[])new Object[]{quorumFuture, repl1, repl2, repl3});
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)1L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.abs(maxLag + maxLag)));
        voters = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)quorumInfo.leaderId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)quorumInfo.observers()).thenReturn(null);
        Mockito.when((Object)quorumInfo.voters()).thenReturn(JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)voters).asJava());
        Mockito.when((Object)quorumFuture.get()).thenThrow(new Throwable[]{new UnsupportedOperationException()});
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)adapter.generateRollableStatus().rollable()));
        Assertions.assertTrue((boolean)adapter.generateRollableStatus().reason().contains("There was an exception"));
    }
}

