/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.BrokerToControllerRequestThread;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$TestControllerRequestCompletionHandler$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)\u0001\u0007\u0001C\u0001?!)!\u0007\u0001C\u0001?!)A\u0007\u0001C\u0001?!)a\u0007\u0001C\u0001?!)\u0001\b\u0001C\u0001?!)!\b\u0001C\u0001?!)A\b\u0001C\u0001?!)a\b\u0001C\u0001?!)\u0001\t\u0001C\u0005\u0003\"9A\u000bAI\u0001\n\u0013)&a\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u0014V-];fgR$\u0006N]3bIR+7\u000f\u001e\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005q\u0011a\u000b;fgR\u0014V\r\u001e:z)&lWm\\;u/\"LG.Z\"p]R\u0014x\u000e\u001c7fe:{G/\u0011<bS2\f'\r\\3\u0015\u0003\u0001\u0002\"!F\u0011\n\u0005\t2\"\u0001B+oSRD#A\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYC&A\u0003kk:LGOC\u0001.\u0003\ry'oZ\u0005\u0003_\u0019\u0012A\u0001V3ti\u0006\u0001B/Z:u%\u0016\fX/Z:ugN+g\u000e\u001e\u0015\u0003\u0007\u0011\nQ\u0003^3ti\u000e{g\u000e\u001e:pY2,'o\u00115b]\u001e,G\r\u000b\u0002\u0005I\u0005\tB/Z:u\u001d>$8i\u001c8ue>dG.\u001a:)\u0005\u0015!\u0013A\u000b;fgR,eN^3m_B,'+Z:q_:\u001cXmV5uQ:{GoQ8oiJ|G\u000e\\3s\u000bJ\u0014xN\u001d\u0015\u0003\r\u0011\n\u0001\u0003^3tiJ+GO]=US6,w.\u001e;)\u0005\u001d!\u0013A\b;fgR,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8IC:$G.\u001b8hQ\tAA%A\u0012uKN$\u0018)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\u001c%b]\u0012d\u0017N\\4)\u0005%!\u0013\u0001\u0006;fgR$\u0006N]3bI:{Go\u0015;beR,G\r\u000b\u0002\u000bI\u0005I\u0001o\u001c7m+:$\u0018\u000e\u001c\u000b\u0005A\t;u\nC\u0003D\u0017\u0001\u0007A)A\u0007sKF,Xm\u001d;UQJ,\u0017\r\u001a\t\u0003;\u0015K!A\u0012\b\u0003?\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM\u001d*fcV,7\u000f\u001e+ie\u0016\fG\rC\u0003I\u0017\u0001\u0007\u0011*A\u0005d_:$\u0017\u000e^5p]B\u0019QC\u0013'\n\u0005-3\"!\u0003$v]\u000e$\u0018n\u001c81!\t)R*\u0003\u0002O-\t9!i\\8mK\u0006t\u0007b\u0002)\f!\u0003\u0005\r!U\u0001\u000b[\u0006D(+\u001a;sS\u0016\u001c\bCA\u000bS\u0013\t\u0019fCA\u0002J]R\f1\u0003]8mYVsG/\u001b7%I\u00164\u0017-\u001e7uIM*\u0012A\u0016\u0016\u0003#^[\u0013\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005u3\u0012AC1o]>$\u0018\r^5p]&\u0011qL\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class BrokerToControllerRequestThreadTest {
    @Test
    public void testRetryTimeoutWhileControllerNotAvailable() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)None$.MODULE$);
        int retryTimeoutMs = 30000;
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)None$.MODULE$);
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        time.sleep((long)retryTimeoutMs);
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testRequestsSent() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        Node activeController = new Node(controllerId, "host", 1234);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)2, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testControllerChanged() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node oldController = new Node(oldControllerId, "host1", 1234);
        Node newController = new Node(newControllerId, "host2", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)oldController), (Object[])new Option[]{new Some((Object)newController)});
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Assertions.assertFalse((boolean)completionHandler.completed().get());
        mockClient.setUnreachable(oldController, time.milliseconds() + 5000L);
        testRequestThread.doWork();
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testNotController() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        int port = 1234;
        Node oldController = new Node(oldControllerId, "host1", port);
        Node newController = new Node(newControllerId, "host2", port);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)oldController), (Object[])new Option[]{new Some((Object)newController)});
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Node oldBrokerNode = new Node(oldControllerId, "host1", port);
        Assertions.assertEquals((Object)new Some((Object)oldBrokerNode), (Object)testRequestThread.activeControllerAddress());
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)testRequestThread.activeControllerAddress());
        testRequestThread.doWork();
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Node newControllerNode = new Node(newControllerId, "host2", port);
        Assertions.assertEquals((Object)new Some((Object)newControllerNode), (Object)testRequestThread.activeControllerAddress());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testEnvelopeResponseWithNotControllerError() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        mockClient.setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.ENVELOPE.id, (short)((short)0), (short)((short)0)));
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        int port = 1234;
        Node oldController = new Node(oldControllerId, "host1", port);
        Node newController = new Node(newControllerId, "host2", port);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)oldController), (Object[])new Option[]{new Some((Object)newController)});
        EnvelopeResponse envelopeResponseWithNotControllerError = new EnvelopeResponse(new EnvelopeResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", "principal", true);
        DefaultKafkaPrincipalBuilder kafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
        EnvelopeRequest.Builder envelopeRequestBuilder = new EnvelopeRequest.Builder(ByteBuffer.allocate(0), kafkaPrincipalBuilder.serialize(kafkaPrincipal), "client-address".getBytes());
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)envelopeRequestBuilder, (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Node oldBrokerNode = new Node(oldControllerId, "host1", port);
        Assertions.assertEquals((Object)new Some((Object)oldBrokerNode), (Object)testRequestThread.activeControllerAddress());
        mockClient.prepareResponse(body -> body instanceof EnvelopeRequest, (AbstractResponse)envelopeResponseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)testRequestThread.activeControllerAddress());
        testRequestThread.doWork();
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Node newControllerNode = new Node(newControllerId, "host2", port);
        Assertions.assertEquals((Object)new Some((Object)newControllerNode), (Object)testRequestThread.activeControllerAddress());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testRetryTimeout() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 1;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node controller = new Node(controllerId, "host1", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)controller));
        int retryTimeoutMs = 30000;
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler(TestUtils$TestControllerRequestCompletionHandler$.MODULE$.$lessinit$greater$default$1());
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        time.sleep((long)retryTimeoutMs);
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testUnsupportedVersionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$1;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$1.set(response);
            }
            {
                this.callbackResponse$1 = callbackResponse$1;
            }
        };
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            ApiKeys apiKeys2 = ApiKeys.METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        });
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!BrokerToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$2(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!BrokerToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$2(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).versionMismatch());
    }

    @Test
    public void testAuthenticationExceptionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.get()).thenReturn((Object)new Some((Object)activeController));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$2;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$2.set(response);
            }
            {
                this.callbackResponse$2 = callbackResponse$2;
            }
        };
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.createPendingAuthenticationError(activeController, 50L);
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!BrokerToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$1(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!BrokerToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$1(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).authenticationException());
    }

    @Test
    public void testThreadNotStarted() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        BrokerToControllerRequestThread testRequestThread = new BrokerToControllerRequestThread((KafkaClient)mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)None$.MODULE$);
        BrokerToControllerQueueItem queueItem = new BrokerToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        Assertions.assertThrows(IllegalStateException.class, () -> testRequestThread.enqueue(queueItem));
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
    }

    private void pollUntil(BrokerToControllerRequestThread requestThread, Function0<Object> condition, int maxRetries) {
        int tries = 0;
        do {
            requestThread.doWork();
        } while (!condition.apply$mcZ$sp() && ++tries < maxRetries);
        if (!condition.apply$mcZ$sp()) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(tries).append(" times").toString());
        }
    }

    private int pollUntil$default$3() {
        return 10;
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionHandling$2(AtomicReference callbackResponse$1) {
        return callbackResponse$1.get() != null;
    }

    public static final /* synthetic */ boolean $anonfun$testAuthenticationExceptionHandling$1(AtomicReference callbackResponse$2) {
        return callbackResponse$2.get() != null;
    }
}

