/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaType;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002*T\u0001aCQ!\u0018\u0001\u0005\u0002yCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004f\u0001\u0001\u0006IA\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0011\u0019Y\u0007\u0001)A\u0005Q\")A\u000e\u0001C\u0005[\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBA{\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003s\u0004A\u0011AAm\u0011\u001d\ti\u0010\u0001C\u0001\u00033DqA!\u0001\u0001\t\u0003\tI\u000eC\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t%\u0002\u0001\"\u0001\u0002Z\"9!Q\u0006\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0019\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005k\u0001A\u0011AAm\u0011\u001d\u0011I\u0004\u0001C\u0001\u00033DqA!\u0010\u0001\t\u0003\tI\u000eC\u0004\u0003B\u0001!\t!!7\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002Z\"9!\u0011\n\u0001\u0005\u0002\u0005e\u0007b\u0002B'\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005#\u0002A\u0011AAm\u0011\u001d\u0011)\u0006\u0001C\u0001\u00033DqA!\u0017\u0001\t\u0003\tI\u000eC\u0004\u0003^\u0001!\t!!7\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002Z\"9!Q\r\u0001\u0005\u0002\u0005e\u0007b\u0002B5\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005[\u0002A\u0011AAm\u0011\u001d\u0011\t\b\u0001C\u0001\u00033DqA!\u001e\u0001\t\u0003\tI\u000eC\u0004\u0003z\u0001!\t!!7\t\u000f\tu\u0004\u0001\"\u0001\u0002Z\"9!\u0011\u0011\u0001\u0005\u0002\u0005e\u0007b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u00057\u0003A\u0011AAm\u0011\u001d\u0011y\n\u0001C\u0001\u00033DqAa)\u0001\t\u0003\tI\u000eC\u0004\u0003(\u0002!\t!!7\t\u000f\t-\u0006\u0001\"\u0001\u0002Z\"9!q\u0016\u0001\u0005\u0002\u0005e\u0007b\u0002BZ\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005o\u0003A\u0011AAm\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003N\u0002!\tAa4\u0007\te\u0004AI\u001f\u0005\u000b\u0003\u0013\u0001$Q3A\u0005\u0002\u0005-\u0001BCA\u0012a\tE\t\u0015!\u0003\u0002\u000e!Q\u0011Q\u0005\u0019\u0003\u0016\u0004%\t!a\u0003\t\u0015\u0005\u001d\u0002G!E!\u0002\u0013\ti\u0001\u0003\u0006\u0002*A\u0012)\u001a!C\u0001\u0003WA!\"a\r1\u0005#\u0005\u000b\u0011BA\u0017\u0011)\t)\u0004\rBK\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003o\u0001$\u0011#Q\u0001\n\u00055\u0002BB/1\t\u0003\tI\u0004C\u0004\u0002DA\"\t!!\u0012\t\u0013\u0005]\u0003'!A\u0005\u0002\u0005e\u0003\"CA2aE\u0005I\u0011AA3\u0011%\tY\bMI\u0001\n\u0003\t)\u0007C\u0005\u0002~A\n\n\u0011\"\u0001\u0002\u0000!I\u00111\u0011\u0019\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u000b\u0003\u0014\u0011!C!\u0003\u000fC\u0011\"!#1\u0003\u0003%\t!a#\t\u0013\u0005M\u0005'!A\u0005\u0002\u0005U\u0005\"CAQa\u0005\u0005I\u0011IAR\u0011%\t\t\fMA\u0001\n\u0003\t\u0019\fC\u0005\u0002>B\n\t\u0011\"\u0011\u0002@\"I\u0011\u0011\u0019\u0019\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u000b\u0004\u0014\u0011!C!\u0003\u000f<\u0011Ba:\u0001\u0003\u0003EIA!;\u0007\u0011e\u0004\u0011\u0011!E\u0005\u0005WDa!X%\u0005\u0002\te\b\"CAa\u0013\u0006\u0005IQIAb\u0011%\u0011Y0SA\u0001\n\u0003\u0013i\u0010C\u0005\u0004\b%\u000b\n\u0011\"\u0001\u0002\u0000!I1\u0011B%\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0007\u0017I\u0015\u0011!CA\u0007\u001bA\u0011ba\u0007J#\u0003%\t!a \t\u0013\ru\u0011*%A\u0005\u0002\u0005}$AF\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005Q+\u0016AB:feZ,'OC\u0001W\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A-\u0011\u0005i[V\"A*\n\u0005q\u001b&A\u0007\"bg\u0016\u001cE.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001`!\tQ\u0006!\u0001\u0004d_:4\u0017nZ\u000b\u0002EB\u0011!lY\u0005\u0003IN\u0013\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nab\u00195b]:,G.T1oC\u001e,'/F\u0001i!\tQ\u0016.\u0003\u0002k'\nY\u0012IY:ue\u0006\u001cG/U;pi\u0006\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\fqb\u00195b]:,G.T1oC\u001e,'\u000fI\u0001\u0011i\u0016\u001cH/U;pi\u0006\u0004\u0016M]:j]\u001e$\u0012B\u001c;v\u0003\u0017\fy-a5\u0011\u0005=\u0014X\"\u00019\u000b\u0003E\fQa]2bY\u0006L!a\u001d9\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\u001a\u0001\rA\u0019\u0005\u0006m\u001a\u0001\ra^\u0001\bG2LWM\u001c;2!\tA\b'D\u0001\u0001\u0005))6/\u001a:DY&,g\u000e^\n\u0006amt\u00181\u0001\t\u0003_rL!! 9\u0003\r\u0005s\u0017PU3g!\tyw0C\u0002\u0002\u0002A\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002p\u0003\u000bI1!a\u0002q\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011)8/\u001a:\u0016\u0005\u00055\u0001\u0003BA\b\u0003;qA!!\u0005\u0002\u001aA\u0019\u00111\u00039\u000e\u0005\u0005U!bAA\f/\u00061AH]8pizJ1!a\u0007q\u0003\u0019\u0001&/\u001a3fM&!\u0011qDA\u0011\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00049\u0002\u000bU\u001cXM\u001d\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\r|gNZ5h+N,'/\u0006\u0002\u0002.A)q.a\f\u0002\u000e%\u0019\u0011\u0011\u00079\u0003\r=\u0003H/[8o\u0003-\u0019wN\u001c4jOV\u001bXM\u001d\u0011\u0002\u001d\r|gNZ5h\u00072LWM\u001c;JI\u0006y1m\u001c8gS\u001e\u001cE.[3oi&#\u0007\u0005F\u0005x\u0003w\ti$a\u0010\u0002B!9\u0011\u0011B\u001dA\u0002\u00055\u0001bBA\u0013s\u0001\u0007\u0011Q\u0002\u0005\n\u0003SI\u0004\u0013!a\u0001\u0003[A\u0011\"!\u000e:!\u0003\u0005\r!!\f\u0002/M\fg.\u001b;ju\u0016$7i\u001c8gS\u001e\u001cE.[3oi&#WCAA$!\u0015y\u0017qFA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002 \u00055\u0013\u0001B2paf$\u0012b^A.\u0003;\ny&!\u0019\t\u0013\u0005%1\b%AA\u0002\u00055\u0001\"CA\u0013wA\u0005\t\u0019AA\u0007\u0011%\tIc\u000fI\u0001\u0002\u0004\ti\u0003C\u0005\u00026m\u0002\n\u00111\u0001\u0002.\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA4U\u0011\ti!!\u001b,\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001eq\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\nyGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005%\u0006BA\u0017\u0003S\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0013\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!$\u0011\u0007=\fy)C\u0002\u0002\u0012B\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a&\u0002\u001eB\u0019q.!'\n\u0007\u0005m\u0005OA\u0002B]fD\u0011\"a(C\u0003\u0003\u0005\r!!$\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000b\u0005\u0004\u0002(\u00065\u0016qS\u0007\u0003\u0003SS1!a+q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA[\u0003w\u00032a\\A\\\u0013\r\tI\f\u001d\u0002\b\u0005>|G.Z1o\u0011%\ty\nRA\u0001\u0002\u0004\t9*\u0001\u0005iCND7i\u001c3f)\t\ti)\u0001\u0005u_N#(/\u001b8h)\t\tI%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\u000bI\rC\u0005\u0002 \u001e\u000b\t\u00111\u0001\u0002\u0018\"1\u0011Q\u001a\u0004A\u0002]\fqa\u00197jK:$(\u0007\u0003\u0004\u0002R\u001a\u0001\ra^\u0001\re\u0006tGm\\7DY&,g\u000e\u001e\u0005\u0007\u0003+4\u0001\u0019A<\u0002'\u0011,g-Y;mi\u000e{gNZ5h\u00072LWM\u001c;\u00021Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\rF\u0001oQ\r9\u0011Q\u001c\t\u0005\u0003?\f\t0\u0004\u0002\u0002b*!\u00111]As\u0003\r\t\u0007/\u001b\u0006\u0005\u0003O\fI/A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0018Q^\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003_\f1a\u001c:h\u0013\u0011\t\u00190!9\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4)\u0007!\ti.\u0001\u000fuKN$Xk]3s\u00072LWM\u001c;JIF+x\u000e^1QCJ\u001c\u0018N\\4)\u0007%\ti.\u0001\u0017uKN$Xk]3s#V|G/\u0019)beNLgnZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\u001a!\"!8\u0002iQ,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1QCJ\u001c\u0018N\\4JI^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\rK\u0002\f\u0003;\f!b\u00195fG.\fVo\u001c;b)5q'\u0011\u0002B\n\u0005+\u00119B!\t\u0003&!9!1\u0002\u0007A\u0002\t5\u0011\u0001D9v_R\fW*\u00198bO\u0016\u0014\bc\u0001.\u0003\u0010%\u0019!\u0011C*\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0005\b\u0003\u0013a\u0001\u0019AA\u0007\u0011\u001d\t)\u0003\u0004a\u0001\u0003\u001bAqA!\u0007\r\u0001\u0004\u0011Y\"A\u0007fqB,7\r^3e\u0005>,h\u000e\u001a\t\u0004_\nu\u0011b\u0001B\u0010a\n!Aj\u001c8h\u0011\u001d\u0011\u0019\u0003\u0004a\u0001\u0003\u001b\u000bQA^1mk\u0016DqAa\n\r\u0001\u0004\t),\u0001\bfqB,7\r\u001e+ie>$H\u000f\\3\u0002kQ,7\u000f^$fi6\u000b\u0007PV1mk\u0016Le.U;pi\u0006<\u0016N\u001c3po^KG\u000f\u001b(p]\u0012+g-Y;miF+x\u000e^1XS:$wn\u001e\u0015\u0004\u001b\u0005u\u0017\u0001\t;fgR\u001cV\r^!oIJ+Wn\u001c<f\t\u00164\u0017-\u001e7u+N,'/U;pi\u0006D3ADAo\u0003e!Xm\u001d;TKR\fe\u000e\u001a*f[>4X-V:feF+x\u000e^1)\u0007=\ti.A\u0010uKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM]\"mS\u0016tG/U;pi\u0006D3\u0001EAo\u0003e!Xm\u001d;Rk>$\u0018mQ8oM&<\u0007K]3dK\u0012,gnY3)\u0007E\ti.\u0001\nuKN$\u0018+^8uCZKw\u000e\\1uS>t\u0007f\u0001\n\u0002^\u0006)C/Z:u#V|G/\u0019,j_2\fG/[8o/&$\b.T1y)\"\u0014x\u000e\u001e;mKRKW.\u001a\u0015\u0004'\u0005u\u0017\u0001\b;fgR,\u0005\u0010]5sKRC'o\u001c;uY\u0016$\u0016.\\3TK:\u001cxN\u001d\u0015\u0004)\u0005u\u0017A\u0006;fgR,\u0005\u0010]5sKF+x\u000e^1TK:\u001cxN]:)\u0007U\ti.\u0001\ruKN$8\t\\5f]RLEMT8u'\u0006t\u0017\u000e^5{K\u0012D3AFAo\u0003}!Xm\u001d;V]&4XM]:bY&$\u0018p\u00144BGRLg/\u001a+f]\u0006tGo\u001d\u0015\u0004/\u0005u\u0017\u0001\b;fgR4%/Z9vK:\u001c\u0017p\u00144BkR|G+\u001e8f#V|G/\u0019\u0015\u00041\u0005u\u0017!\b;fgRLe.Y2uSZ,G+\u001a8b]R\u001c(+Z:fiF+x\u000e^1)\u0007e\ti.A\u0016uKN$\u0018)\u001e;p)VtWMQ1oI^LG\r\u001e5Rk>$\u0018-\u00117m\u0003\n|g/\u001a$bSJd\u0015.\\5uQ\rQ\u0012Q\\\u00011i\u0016\u001cH/Q;u_R+h.\u001a\"b]\u0012<\u0018\u000e\u001a;i#V|G/Y!c_Z,\u0017I\u001c3CK2|wOR1je2KW.\u001b;)\u0007m\ti.A\u0016uKN$\u0018)\u001e;p)VtWMQ1oI^LG\r\u001e5Rk>$\u0018-\u00117m\u0005\u0016dwn\u001e$bSJd\u0015.\\5uQ\ra\u0012Q\\\u0001*i\u0016\u001cH/Q;u_R+h.\u001a\"b]\u0012<\u0018\u000e\u001a;i#V|G/Y'vYRL\u0007\u000f\\3UK:\fg\u000e^:)\u0007u\ti.\u0001\u0015uKN$\u0018)\u001e;p)VtWmV5uQ\u000eC\u0017M\\4j]\u001e\u0014%o\\6feF+x\u000e^1MS6LG\u000fK\u0002\u001f\u0003;\f1\u0006^3ti\u0006+Ho\u001c+v]\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h\u001fJLw-\u001b8bY\u000ec\u0017.\u001a8u#V|G/\u0019\u0015\u0004?\u0005u\u0017A\n;fgR\fU\u000f^8Uk:,w\u000b[3o\u00072LWM\u001c;Ti>\u00048oU3oI&tw\rT8bI\"\u001a\u0001%!8\u0002gQ,7\u000f^!vi>$VO\\3XQ\u0016t7\t\\5f]R,6/Y4f\t\u0016\u001c'/Z1tS:<\u0017I\u001a;feRC'o\u001c;uY\u0016$\u0007fA\u0011\u0002^\u0006\tC/Z:u#V|G/\u0019*fa>\u0014H/\u001b8h\u0007\u0006dGNY1dW\u0016s\u0017M\u00197fI\"\u001a!%!8\u0002_Q,7\u000f^)v_R\f'+\u001a9peRLgnZ\"bY2\u0014\u0017mY6XSRD\u0017i\u0019;jm\u0016\u001cuN\\:v[B$\u0018n\u001c8)\u0007\r\ni.A\nwKJLg-\u001f#z]\u0006l\u0017nY)v_R\f7\u000fF\u0003o\u0005\u0013\u0013Y\tC\u0004\u0003\f\u0011\u0002\rA!\u0004\t\u000f\t5E\u00051\u0001\u0003\u0010\u0006AR\r\u001f9fGR,G-U;pi\u0006\u001chi\u001c:DY&,g\u000e^:\u0011\u0011\u0005=!\u0011SA\u0007\u0005+KAAa%\u0002\"\t\u0019Q*\u00199\u0011\u0007=\u00149*C\u0002\u0003\u001aB\u0014a\u0001R8vE2,\u0017a\r;fgR\fU\u000f^8Uk:LgnZ!mY>\u001c\u0017\r^3t\u0005\u0006tGm^5ei\"\u0004&o\u001c9peRLwN\\1m)>\fVo\u001c;bQ\r)\u0013Q\\\u0001*i\u0016\u001cH/Q;u_R+h.\u001b8h+:d\u0017.\\5uK\u0012\fVo\u001c;b\r>\u0014\u0018\t\u001c7DY&,g\u000e^:)\u0007\u0019\ni.\u0001\u0016uKN$\u0018)\u001e;p)Vt\u0017N\\4V]2LW.\u001b;fIF+x\u000e^1G_J\u001cv.\\3DY&,g\u000e^:)\u0007\u001d\ni.A\u0018uKN$\u0018)\u001e;p)Vt\u0017N\\4V]2LW.\u001b;fIF+x\u000e^1XSRDGj\\<Vg\u0006<Wm\u00117jK:$8\u000fK\u0002)\u0003;\f\u0001\u0006^3ti\u0006+Ho\u001c+v]&tw-\u00168mS6LG/\u001a3Rk>$\u0018mV5uQ2{w/V:bO\u0016D3!KAo\u0003y!Xm\u001d;BkR|G+\u001e8j]\u001eD\u0015M\u001c3mKNTVM]8Rk>$\u0018\rK\u0002+\u0003;\f\u0001\u0005^3ti\u0006+Ho\u001c+v]&twmU8siN\u0014\u00150\u0016;jY&T\u0018\r^5p]\"\u001a1&!8\u0002SQ,7\u000f\u001e)s_\u0012,8-\u001a:JgRC'o\u001c;uY\u0016$w\u000b[3o\t&\u001c8n\u00159bG\u0016L5\u000fT8xQ\ra\u0013Q\\\u0001\u0010[&dG.[:U_B+'oY3oiR!!Q\u0013B`\u0011\u001d\u0011\t-\fa\u0001\u0005+\u000ba!\\5mY&\u001c\u0018AC7fiJL7\rV1hgR1!q\u0019Be\u0005\u0017\u0004\u0002\"a\u0004\u0003\u0012\u00065\u0011Q\u0002\u0005\b\u0003\u0013q\u0003\u0019AA\u0007\u0011\u001d\t)C\fa\u0001\u0003\u001b\t!B\\3x\u001b\u0016$(/[2t+\t\u0011\t\u000e\u0005\u0003\u0003T\n\rXB\u0001Bk\u0015\u0011\u00119N!7\u0002\u000f5,GO]5dg*!!1\u001cBo\u0003\u0019\u0019w.\\7p]*\u0019aKa8\u000b\t\t\u0005\u0018Q^\u0001\u0007CB\f7\r[3\n\t\t\u0015(Q\u001b\u0002\b\u001b\u0016$(/[2t\u0003))6/\u001a:DY&,g\u000e\u001e\t\u0003q&\u001bR!\u0013Bw\u0003\u0007\u0001RBa<\u0003v\u00065\u0011QBA\u0017\u0003[9XB\u0001By\u0015\r\u0011\u0019\u0010]\u0001\beVtG/[7f\u0013\u0011\u00119P!=\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003j\u0006)\u0011\r\u001d9msRIqOa@\u0004\u0002\r\r1Q\u0001\u0005\b\u0003\u0013a\u0005\u0019AA\u0007\u0011\u001d\t)\u0003\u0014a\u0001\u0003\u001bA\u0011\"!\u000bM!\u0003\u0005\r!!\f\t\u0013\u0005UB\n%AA\u0002\u00055\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0010\r]\u0001#B8\u00020\rE\u0001cC8\u0004\u0014\u00055\u0011QBA\u0017\u0003[I1a!\u0006q\u0005\u0019!V\u000f\u001d7fi!A1\u0011D(\u0002\u0002\u0003\u0007q/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7());
    private final AbstractQuotaChannelManager channelManager = (AbstractQuotaChannelManager)EasyMock.createMock(AbstractQuotaChannelManager.class);

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private AbstractQuotaChannelManager channelManager() {
        return this.channelManager;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 600 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7());
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            this.time().sleep(1000L);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolationWithMaxThrottleTime() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 200000.0);
            Assertions.assertEquals((long)ClientQuotaManager$.MODULE$.MaxThrottleTimeMs(), (long)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client2").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertTrue((boolean)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)})).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)throttleTime -> throttleTime == 0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client3"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client4"), (Object)BoxesRunTime.boxToDouble((double)125.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 190.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)310.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testQuotaReportingCallbackEnabled() {
        Metrics metrics = this.newMetrics();
        long x$1 = 30000L;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.eq((long)config.consumptionReportingIntervalMs()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)this.channelManager()));
        EasyMock.verify((Object[])new Object[]{this.channelManager()});
        EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        quotaManager.shutdown();
    }

    @Test
    public void testQuotaReportingCallbackWithActiveConsumption() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        long x$2 = 1000L;
        double x$3 = 100000.0;
        int x$4 = 102400;
        int x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(x$1, x$5, x$6, x$7, x$3, x$2, x$4);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.setEntity(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntityData[]{new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C1")}));
        entryData.setConsumptions(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.ConsumptionData[]{new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(102400.0).setThrottled(false)}));
        ReportQuotaConsumptionRequestData.EntryData entryData2 = new ReportQuotaConsumptionRequestData.EntryData();
        entryData2.setEntity(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntityData[]{new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C2")}));
        entryData2.setConsumptions(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.ConsumptionData[]{new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(160000.0).setThrottled(true)}));
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData2));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.wakeup();
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), Option$.MODULE$.apply((Object)this.channelManager()));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(30000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(70000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(2.147483647E9, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 1000.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 100.0));
            int throttleTime = this.maybeRecord(quotaManager, "", "C2", 80000 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTime > 0 ? 1 : 0) != 0);
            this.throttle(quotaManager, "", "C2", throttleTime, this.callback());
            quotaManager.quotaUsageReportingCallback();
            EasyMock.verify((Object[])new Object[]{this.channelManager()});
            EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<String, Object> expectedQuotasForClients) {
        expectedQuotasForClients.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotaManagerTest.$anonfun$verifyDynamicQuotas$1(quotaManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAutoTuningAllocatesBandwidthProportionalToQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(1400.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)700.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForAllClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForSomeClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsageClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 600.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(600.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 0.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)200.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)100.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsage() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 100.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningHandlesZeroQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(0.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 0.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 600.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningSortsByUtilization() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(500.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)300.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        .colon.colon x$2 = new .colon.colon((Object)((Object)tempLogDir).toString(), (List)Nil$.MODULE$);
        boolean x$3 = true;
        long x$4 = 1000L;
        long x$5 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1();
        double x$6 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6();
        boolean x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7();
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$5, x$1, (Seq)x$2, x$3, x$4, x$6, x$7);
        long x$9 = 300L;
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, x$9, x$10, x$11, x$12, x$13, x$14);
        int x$15 = 2;
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(BrokerBackpressureConfig$.MODULE$.apply$default$1(), BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        int x$18 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        double x$19 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        long x$20 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$21 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$15, x$18, x$16, diskThrottlingConfig, x$19, x$20, x$21);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                String x$5 = "";
                Some x$6 = new Some((Object)activeTenantsManager$1);
                Option x$7 = ClientQuotaManager$.MODULE$.$lessinit$greater$default$6();
                Option x$8 = ClientQuotaManager$.MODULE$.$lessinit$greater$default$8();
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, x$5, x$7, (Option)x$6, x$8);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private final ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyDynamicQuotas$1(ClientQuotaManager quotaManager$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String clientId = (String)x0$1._1();
            Assertions.assertEquals((double)x0$1._2$mcD$sp(), (double)quotaManager$3.dynamicQuota("", clientId).bound(), (double)0.1, (String)new StringBuilder(21).append("Unexpected quota for ").append(clientId).toString());
            return;
        }
        throw new MatchError(null);
    }

    private class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

