/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000192A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!91\u0003\u0001b\u0001\n\u0013!\u0002B\u0002\r\u0001A\u0003%Q\u0003C\u0003\u001a\u0001\u0011\u0005!DA\u000fDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0013\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0007\u0013\tyaA\u0001\u000eCCN,7\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011Q\u0002A\u0001\u0007G>tg-[4\u0016\u0003U\u0001\"!\u0004\f\n\u0005]1!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013a\t;fgR\u0014V-];fgR\u0004VM]2f]R\fw-Z)v_R\fg+[8mCRLwN\u001c\u000b\u00027A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t!QK\\5uQ\t!!\u0005\u0005\u0002$Y5\tAE\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0005\u001dB\u0013a\u00026va&$XM\u001d\u0006\u0003S)\nQA[;oSRT\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u0005\u0011!Vm\u001d;")
public class ClientRequestQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6(), ClientQuotaManagerConfig$.MODULE$.apply$default$7());

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager clientRequestQuotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        clientRequestQuotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", QuotaType.Request$.MODULE$.toString(), ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(4.0)));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(113.0));
            Assertions.assertEquals((int)300, (int)throttleTime, (String)"Should be throttled");
            this.throttle((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientRequestQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientRequestQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(4.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
            Assertions.assertEquals((int)1000, (int)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", ClientRequestQuotaManagerTest.millisToPercent$1(176.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.time().sleep(1000L);
                Assertions.assertEquals((int)1000, (int)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", 0.0));
            });
            this.time().sleep(1000L);
            Assertions.assertEquals((int)0, (int)this.maybeRecord((ClientQuotaManager)clientRequestQuotaManager, "ANONYMOUS", "test-client", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientRequestQuotaManager.shutdown();
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }
}

