/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006!\u0002!\t!\u0015\u0005\u0006[\u0002!\t!\u0015\u0005\u0006]\u0002!\t!\u0015\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006o\u0002!\t\u0001\u001d\u0005\bq\u0002\u0011\r\u0011\"\u0001z\u0011\u001d\t\t\u0001\u0001Q\u0001\niDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002$\u0001!\t!!\u0002\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002\u0006!9\u00111\u0006\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0018\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003g\u0001A\u0011AA\u0003\u0011\u001d\t9\u0004\u0001C\u0001\u0003\u000bAq!a\u000f\u0001\t\u0003\t)\u0001C\u0004\u0002@\u0001!\t!!\u0002\t\r\u0005\r\u0003\u0001\"\u0001R\u0011\u0019\t)\u0005\u0001C\u0001#\"9\u0011q\t\u0001\u0005\u0002\u0005\u0015\u0001bBA&\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0002A\u0011AA\u0003\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003\u000bAa!a\u0016\u0001\t\u0003\u0001\bBBA-\u0001\u0011\u0005\u0001\u000fC\u0004\u0002\\\u0001!\t!!\u0002\t\u000f\u0005}\u0003\u0001\"\u0001\u0002\u0006!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0001BBA4\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002j\u0001!\t\u0001\u001d\u0005\b\u0003W\u0002A\u0011AA\u0003\u0011\u001d\ty\u0007\u0001C\u0001\u0003\u000bAq!a\u001d\u0001\t\u0003\t)A\u0001\fD_:4\u0017nZ!e[&tW*\u00198bO\u0016\u0014H+Z:u\u0015\t9\u0003&\u0001\u0004tKJ4XM\u001d\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011AJ\u0001\u0007Y><w-\u001a:\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003u\n1a\u001c:h\u0013\ty$H\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003UqWm^\"p]\u001aLw-\u00113nS:l\u0015M\\1hKJ$\"a\u0011$\u0011\u0005U\"\u0015BA#'\u0005I\u0019uN\u001c4jO\u0006#W.\u001b8NC:\fw-\u001a:\t\u000b\u001d#\u0001\u0019\u0001%\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%JA\u0004J]R,w-\u001a:\u0002%\t\u0014xn[3sa%s7M]3nK:$\u0018\r\u001c\u000b\u0002%B\u00111K\u001b\b\u0003)\u001et!!\u00163\u000f\u0005Y\u000bgBA,`\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\U\u00051AH]8pizJ\u0011!P\u0005\u0003=r\na!\u00199bG\",\u0017BA\u0015a\u0015\tqF(\u0003\u0002cG\u000611m\\7n_:T!!\u000b1\n\u0005\u00154\u0017aB7fgN\fw-\u001a\u0006\u0003E\u000eL!\u0001[5\u0002E%s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0015\t)g-\u0003\u0002lY\n!\u0012\t\u001c;fe\u000e{gNZ5hgJ+7o\\;sG\u0016T!\u0001[5\u0002#Q|\u0007/[2B\u0013:\u001c'/Z7f]R\fG.\u0001\fdYV\u001cH/\u001a:MS:\\\u0017J\\2sK6,g\u000e^1m\u00035\u0011'o\\6feBbUmZ1dsR\t\u0011\u000f\u0005\u0002sk:\u0011Ak]\u0005\u0003i&\fq#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\n\u0005-4(B\u0001;j\u00031!x\u000e]5d\u00032+w-Y2z\u0003MIgN^1mS\u0012\u0014V-];fgR,%O]8s+\u0005Q\bCA>\u007f\u001b\u0005a(BA?g\u0003!\u0011X-];fgR\u001c\u0018BA@}\u0005!\t\u0005/[#se>\u0014\u0018\u0001F5om\u0006d\u0017\u000e\u001a*fcV,7\u000f^#se>\u0014\b%A\u0015uKN$8i\u001c9z/&$\bn\\;u!J,\u0007O]8dKN\u001cX\r\u001a$pe&s7M]3nK:$\u0018\r\u001c\u000b\u0003\u0003\u000f\u00012!LA\u0005\u0013\r\tYA\f\u0002\u0005+:LG\u000fK\u0002\r\u0003\u001f\u0001B!!\u0005\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0002ba&TA!!\u0007\u0002\u001c\u00059!.\u001e9ji\u0016\u0014(bAA\u000fy\u0005)!.\u001e8ji&!\u0011\u0011EA\n\u0005\u0011!Vm\u001d;\u0002\u0005R,7\u000f^\"paf<\u0016\u000e\u001e5pkR\u0004&/\u001a)s_\u000e,7o]3e\r>\u0014\u0018J\\2sK6,g\u000e^1m/&$\bNT8SKF,Xm\u001d;N_\u0012Lg-[2bi&|g\u000eK\u0002\u000e\u0003\u001f\t\u0011\u000b^3ti\u000e{\u0007/_,ji\"|W\u000f\u001e)sKB\u0013xnY3tg\u0016$gi\u001c:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i\u00072,8\u000f^3s\u0019&t7.\u001b8h\u001d>\u0014V-];fgRlu\u000eZ5gS\u000e\fG/[8og\"\u001aa\"a\u0004\u0002IQ,7\u000f^\"paf<\u0016\u000e\u001e5pkR\u0004&/\u001a9s_\u000e,7o]3e\r>\u0014H*Z4bGfD3aDA\b\u0003\u0005\"Xm\u001d;SK\u0006\u001c8/Z7cY\u0016Len\u0019:f[\u0016tG/\u00197SKN\u0004xN\\:fQ\r\u0001\u0012qB\u0001\u001di\u0016\u001cHOU3bgN,WN\u00197f\u0019\u0016<\u0017mY=SKN\u0004xN\\:fQ\r\t\u0012qB\u0001(i\u0016\u001cHOV1mS\u0012\fG/\u001a*fg>,(oY3OC6,\u0017j]\"veJ,g\u000e\u001e(pI\u0016LE\rK\u0002\u0013\u0003\u001f\t1\u0004^3tiZ\u000bG.\u001b3bi\u0016dun\u001a'fm\u0016d7i\u001c8gS\u001e\u001c\bfA\n\u0002\u0010\u0005yB/Z:u-\u0006d\u0017\u000eZ1uKJ{w\u000e\u001e'pO2+g/\u001a7D_:4\u0017nZ:)\u0007Q\ty!\u0001\rce>\\WM\u001d'pO\u001e,'/M%oGJ,W.\u001a8uC2\f\u0001D\u0019:pW\u0016\u0014Hj\\4hKJ\u0014\u0014J\\2sK6,g\u000e^1m\u0003q\"Xm\u001d;Qe\u0016\u0004(o\\2fgNLen\u0019:f[\u0016tG/\u00197XSRDWK\\1vi\"|'/\u001b>fI\n\u0013xn[3s\u0019><w-\u001a:DQ\u0006tw-Z:)\u0007]\ty!\u0001\u0012uKN$\bK]3qe>\u001cWm]:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i\u001dVdGn\u001d\u0015\u00041\u0005=\u0011A\u000b;fgR\u0004&/\u001a9s_\u000e,7o]%oGJ,W.\u001a8uC2<\u0016\u000e\u001e5M_\u001e<WM]\"iC:<Wm\u001d\u0015\u00043\u0005=\u0011a\n;fgR\u0004&/\u001a9s_\u000e,7o]%oGJ,W.\u001a8uC2<\u0016\u000e\u001e5EkBd\u0017nY1uKND3AGA\b\u0003M\u0011'o\\6fe2{wmZ3sc1+w-Y2z\u00035\u0011'o\\6feJbUmZ1ds\u0006YC/Z:u!J,\u0007O]8dKN\u001cH*Z4bGf<\u0016\u000e\u001e5Ce>\\WM\u001d'pO\u001e,'o\u00115b]\u001e,7\u000fK\u0002\u001e\u0003\u001f\tQ\u0004^3tiB\u0013X\r\u001d:pG\u0016\u001c8\u000fT3hC\u000eLx+\u001b;i\u001dVdGn\u001d\u0015\u0004=\u0005=\u0011A\t;fgR\u0004&/\u001a9s_\u000e,7o\u001d'fO\u0006\u001c\u0017pV5uQ\u0012+\b\u000f\\5dCR,7\u000fK\u0002 \u0003\u001f\t!#\u001e8l]><h.\u00138de\u0016lWM\u001c;bY\u0006iQO\\6o_^tG*Z4bGf\fA\u0006^3tiB\u0013X\r\u001d:pG\u0016\u001c8/\u00138de\u0016lWM\u001c;bY^KG\u000f[+oW:|wO\u001c*fg>,(oY3)\u0007\t\ny!A\u0014uKN$\bK]3qe>\u001cWm]:MK\u001e\f7-_,ji\",fn\u001b8po:\u0014Vm]8ve\u000e,\u0007fA\u0012\u0002\u0010\u00051B/Z:u\u0007>tG/Y5og\u0012+\b\u000f\\5dCR,7\u000fK\u0002%\u0003\u001f\u0001")
public class ConfigAdminManagerTest {
    private final Logger logger = LoggerFactory.getLogger(ConfigAdminManagerTest.class);
    private final ApiError invalidRequestError = new ApiError(Errors.INVALID_REQUEST);

    public Logger logger() {
        return this.logger;
    }

    public ConfigAdminManager newConfigAdminManager(Integer brokerId) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(Predef$.MODULE$.Integer2int(brokerId), null, TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        return new ConfigAdminManager(Predef$.MODULE$.Integer2int(brokerId), new KafkaConfig((Map)config), (ConfigRepository)new MockConfigRepository(), (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource broker0Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource topicAIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource clusterLinkIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("test-link").setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AclFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.TopicFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker0Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource topicALegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public ApiError invalidRequestError() {
        return this.invalidRequestError;
    }

    @Test
    public void testCopyWithoutPreprocessedForIncremental() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed1, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$1(input)));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed2, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$1(input)));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed3, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$1(input)));
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithNoRequestModification() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed1, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$2(input)));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed2, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$2(input)));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed3, (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.dummyClusterLinkConfigFunction$2(input)));
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        String includeAllGroups = new StringOps(Predef$.MODULE$.augmentString("|{\n          |\"groupFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"LITERAL\",\n          |     \"filterType\": \"INCLUDE\"\n          |  }\n          |]}\n          |")).stripMargin();
        String includeAllTopicsFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"LITERAL\",\n          |     \"filterType\": \"INCLUDE\"\n          |  }\n          |]}\n          |")).stripMargin();
        String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n         | \"aclFilters\": [{\n         |  \"resourceFilter\": {\n         |      \"resourceType\": \"any\",\n         |      \"patternType\": \"any\"\n         |    },\n         |  \"accessFilter\": {\n         |     \"operation\": \"any\",\n         |     \"permissionType\": \"any\"\n         |    }\n         |  }]\n         | }")).stripMargin();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{this.clusterLinkIncremental()}).iterator()));
        IncrementalAlterConfigsRequestData actualRequest = manager.maybeModifyIncrementalAlterConfigRequest(request, new IdentityHashMap(), (Function1 & Serializable & scala.Serializable)input -> ConfigAdminManagerTest.clusterLinkConfigFunction$1(input, migrateAllAclsJson, includeAllGroups, includeAllTopicsFilter));
        Assertions.assertEquals((Object)request, (Object)actualRequest);
    }

    @Test
    public void testCopyWithoutPreprocessedForLegacy() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData request = new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testReassembleIncrementalResponse() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData original = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        IncrementalAlterConfigsResponseData persistentResponses1 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)manager.reassembleIncrementalResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        IncrementalAlterConfigsResponseData persistentResponses2 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)manager.reassembleIncrementalResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testReassembleLegacyResponse() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData original = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        AlterConfigsResponseData persistentResponses1 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        AlterConfigsResponseData persistentResponses2 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testValidateResourceNameIsCurrentNodeId() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateResourceNameIsCurrentNodeId("5");
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: ", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("")).getMessage());
        Assertions.assertEquals((Object)"Unexpected broker id, expected 5, but received 3", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("3")).getMessage());
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: e", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("e")).getMessage());
    }

    @Test
    public void testValidateLogLevelConfigs() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")}));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue("")}));
        Assertions.assertEquals((Object)"APPEND operation is not allowed for the BROKER_LOGGER resource", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.APPEND.id()).setValue("TRACE")}))).getMessage());
        Assertions.assertEquals((Object)new StringBuilder(95).append("Cannot set the log level of ").append(this.logger().getName()).append(" to BOGUS as it is not ").append("a supported log level. Valid log levels are ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala()).mkString(", ")).toString(), (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("BOGUS")}))).getMessage());
    }

    @Test
    public void testValidateRootLogLevelConfigs() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(Log4jController$.MODULE$.ROOT_LOGGER()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")}));
        Assertions.assertEquals((Object)new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString(), (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(Log4jController$.MODULE$.ROOT_LOGGER()).setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue("")}))).getMessage());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null).setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(x$1, x$2)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.brokerLogger2Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator())), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithNulls$1(x$3, x$4)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.NONE, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithLoggerChanges$1(x$5, x$6)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Incremental();
        IdentityHashMap output = manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$1(x$7, x$8)), manager.preprocess$default$3());
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$2(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsRequestData.AlterConfigsResource brokerLogger1Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker2Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null)}).iterator()));
    }

    @Test
    public void testPreprocessLegacyWithBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 8")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.broker2Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Legacy();
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Legacy();
        IdentityHashMap output = manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessLegacyWithDuplicates$1(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource unknownIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource unknownLegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource unknown = this.unknownIncremental();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator())), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnknownResource$1(x$9, x$10)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessLegacyWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource unknown = this.unknownLegacy();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator()))));
    }

    @Test
    public void testContainsDuplicates() {
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)Nil$.MODULE$));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)Nil$.MODULE$)))));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))))));
    }

    private static final ClusterLinkConfig dummyClusterLinkConfigFunction$1(String input) {
        return ClusterLinkConfig$.MODULE$.create(Collections.emptyMap(), ClusterLinkConfig$.MODULE$.create$default$2());
    }

    private static final ClusterLinkConfig dummyClusterLinkConfigFunction$2(String input) {
        return ClusterLinkConfig$.MODULE$.create(Collections.emptyMap(), ClusterLinkConfig$.MODULE$.create$default$2());
    }

    private static final ClusterLinkConfig clusterLinkConfigFunction$1(String input, String migrateAllAclsJson$1, String includeAllGroups$1, String includeAllTopicsFilter$1) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("bootstrap.servers", "dummyHost:9092");
        props.put(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        props.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), migrateAllAclsJson$1);
        props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), includeAllGroups$1);
        props.put(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        props.put(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), includeAllTopicsFilter$1);
        return ClusterLinkConfig$.MODULE$.create(props, ClusterLinkConfig$.MODULE$.create$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(ResourceType x$1, String x$2) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithNulls$1(ResourceType x$3, String x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithLoggerChanges$1(ResourceType x$5, String x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithDuplicates$1(ResourceType x$7, String x$8) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testPreprocessIncrementalWithDuplicates$2(IdentityHashMap output$1, IncrementalAlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$1.get(r));
    }

    public static final /* synthetic */ void $anonfun$testPreprocessLegacyWithDuplicates$1(IdentityHashMap output$2, AlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$2.get(r));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnknownResource$1(ResourceType x$9, String x$10) {
        return false;
    }
}

