/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.ConfluentBrokerPlacementConstraintTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\f\u0018\u0005qAQ!\t\u0001\u0005\u0002\tBq\u0001\n\u0001A\u0002\u0013\u0005Q\u0005C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\t\re\u0002\u0001\u0015)\u0003'\u0011\u001dQ\u0004A1A\u0005\u0002mBaa\u0010\u0001!\u0002\u0013a\u0004b\u0002!\u0001\u0005\u0004%\ta\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\t\u0003!\u0019!C\u0001\u0007\"1A\n\u0001Q\u0001\n\u0011CQ!\u0014\u0001\u0005B9CQ!\u0019\u0001\u0005B\tDQa\u001a\u0001\u0005\u0002\tDQ\u0001\u001c\u0001\u0005\u0002\tDQA\u001c\u0001\u0005\u0002\tDQ\u0001\u001d\u0001\u0005\u0002\t<QA]\f\t\u0002M4QAF\f\t\u0002QDQ!\t\n\u0005\u0002aDQ!\u001f\n\u0005\u0002iDq!!\u0007\u0013\t\u0003\tYB\u0001\u0014D_:4G.^3oi\n\u0013xn[3s!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e+fgRT!\u0001G\r\u0002\rM,'O^3s\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003]I!\u0001I\f\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011a\u0004A\u0001\bg\u0016\u0014h/\u001a:t+\u00051\u0003cA\u0014-]5\t\u0001F\u0003\u0002*U\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003-\nQa]2bY\u0006L!!\f\u0015\u0003\u0007M+\u0017\u000f\u0005\u0002\u001f_%\u0011\u0001g\u0006\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHCA\u001a8!\t!T'D\u0001+\u0013\t1$F\u0001\u0003V]&$\bb\u0002\u001d\u0004\u0003\u0003\u0005\rAJ\u0001\u0004q\u0012\n\u0014\u0001C:feZ,'o\u001d\u0011\u0002\u000f\t\u0014xn[3scU\tA\b\u0005\u00025{%\u0011aH\u000b\u0002\u0004\u0013:$\u0018\u0001\u00032s_.,'/\r\u0011\u0002\u000f\t\u0014xn[3se\u0005A!M]8lKJ\u0014\u0004%A\u000bce>\\WM]\"p]N$(/Y5oiZ\u000bG.^3\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\t1\fgn\u001a\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0004TiJLgnZ\u0001\u0017EJ|7.\u001a:D_:\u001cHO]1j]R4\u0016\r\\;fA\u0005)1/\u001a;VaR\u00111g\u0014\u0005\u0006!.\u0001\r!U\u0001\ti\u0016\u001cH/\u00138g_B\u0011!kW\u0007\u0002'*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u001dQW\u000f]5uKJT!\u0001W-\u0002\u000b),h.\u001b;\u000b\u0003i\u000b1a\u001c:h\u0013\ta6K\u0001\u0005UKN$\u0018J\u001c4pQ\tYa\f\u0005\u0002S?&\u0011\u0001m\u0015\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003MB#\u0001\u00043\u0011\u0005I+\u0017B\u00014T\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0010uKN$8I]3bi\u0016$v\u000e]5d/&$\bN\u0011:pW\u0016\u0014h+\u00197vKND#!D5\u0011\u0005IS\u0017BA6T\u0005\u0011!Vm\u001d;\u0002=Q,7\u000f^\"sK\u0006$X\rV8qS\u000e|e/\u001a:sS\u0012,G)\u001a4bk2$\bF\u0001\bj\u00035\"Xm\u001d;EK2,G/\u001b8h)>\u0004\u0018nY\"p]\u001aLw\rR8fg:{GOU3wKJ$Hk\u001c#fM\u0006,H\u000e\u001e\u0015\u0003\u001f%\fQ\u0004^3tiZ\u000bG.\u001b3bi\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e#fM\u0006,H\u000e\u001e\u0015\u0003!%\faeQ8oM2,XM\u001c;Ce>\\WM\u001d)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$H+Z:u!\tq\"c\u0005\u0002\u0013kB\u0011AG^\u0005\u0003o*\u0012a!\u00118z%\u00164G#A:\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0007m\f9\u0002E\u0004}\u0003\u000f\ti!!\u0005\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007fU5\tqPC\u0002\u0002\u0002m\ta\u0001\u0010:p_Rt\u0014bAA\u0003U\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t\u0019Q*\u00199\u000b\u0007\u0005\u0015!\u0006E\u0002}\u0003\u001fI1aSA\u0006!\r)\u00151C\u0005\u0004\u0003+1%AB(cU\u0016\u001cG\u000fC\u0003%)\u0001\u0007a%\u0001\tc_>$8\u000f\u001e:baN+'O^3sgR!\u0011QBA\u000f\u0011\u0015!S\u00031\u0001'\u0001")
public final class ConfluentBrokerPlacementConstraintTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int broker1;
    private final int broker2;
    private final String brokerConstraintValue;

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public String brokerConstraintValue() {
        return this.brokerConstraintValue;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnectOrNull(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)rack.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.TopicPlacementConstraintsProp(), this.brokerConstraintValue());
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicWithBrokerValues() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicOverrideDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingTopicConfigDoesNotRevertToDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateConstraintDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicWithBrokerValues$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicOverrideDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        String overrideConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}]}";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)overrideConstraintValue)}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertNotEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
        Assertions.assertEquals((Object)overrideConstraintValue, (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        AlterConfigOp operation = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ""), AlterConfigOp.OpType.DELETE);
        client.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)operation, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)Defaults$.MODULE$.TopicPlacementConstraints(), (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testValidateConstraintDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        CreateTopicsOptions option = new CreateTopicsOptions().validateOnly(true);
        ConfigEntry constraint = ((Config)client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava(), option).config(topic).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public ConfluentBrokerPlacementConstraintTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.brokerConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}]}";
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicWithBrokerValues$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicOverrideDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1$adapted(AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateConstraintDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1($this, client);
        return BoxedUnit.UNIT;
    }
}

