/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00038\u0001\u0011\u0005a\u0005C\u0003:\u0001\u0011\u0005a\u0005C\u0003<\u0001\u0011\u0005a\u0005C\u0003>\u0001\u0011\u0005a\u0005C\u0003@\u0001\u0011\u0005a\u0005C\u0003B\u0001\u0011\u0005a\u0005C\u0003D\u0001\u0011\u0005a\u0005C\u0003F\u0001\u0011%a\tC\u0003Z\u0001\u0011\u0005aE\u0001\u0013D_:$(o\u001c7mKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014H+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\nm\u0006d\u0017\u000eZ1u_J,\u0012!\t\t\u0003=\tJ!aI\b\u0003A\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u0004\u0013A\t;fgR$UMZ1vYR$v\u000e]5d%\u0016\u001cx.\u001e:dK&\u001b(+\u001a6fGR,G\rF\u0001(!\t1\u0002&\u0003\u0002*/\t!QK\\5uQ\t!1\u0006\u0005\u0002-k5\tQF\u0003\u0002/_\u0005\u0019\u0011\r]5\u000b\u0005A\n\u0014a\u00026va&$XM\u001d\u0006\u0003eM\nQA[;oSRT\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c.\u0005\u0011!Vm\u001d;\u00029Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7f%\u0016TWm\u0019;fI\"\u0012QaK\u0001\u0018i\u0016\u001cH/\u00168l]><hNU3t_V\u00148-\u001a+za\u0016D#AB\u0016\u00021Q,7\u000f\u001e(vY2$v\u000e]5d\u0007>tg-[4WC2,X\r\u000b\u0002\bW\u0005!B/Z:u-\u0006d\u0017\u000e\u001a+pa&\u001c7i\u001c8gS\u001eD#\u0001C\u0016\u0002-Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001c7i\u001c8gS\u001eD#!C\u0016\u0002/Q,7\u000f^%om\u0006d\u0017\u000e\u001a\"s_.,'/\u00128uSRL\bF\u0001\u0006,\u0003m!Xm\u001d;J]Z\fG.\u001b3OK\u001e\fG/\u001b<f\u0005J|7.\u001a:JI\"\u00121bK\u0001\u0016m\u0016\u0014\u0018NZ=M_\u001e\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u00159s\tS+X\u0011\u0015yB\u00021\u0001\"\u0011\u0015IE\u00021\u0001K\u0003E\u0001(/\u001a<DY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0003\u0017Js!\u0001\u0014)\u0011\u00055;R\"\u0001(\u000b\u0005=\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002R/\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tv\u0003C\u0003W\u0019\u0001\u0007!*\u0001\toK^\u001cE.Z1okB\u0004v\u000e\\5ds\")\u0001\f\u0004a\u0001\u0015\u0006)R\r\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8UKb$\u0018!\f;fgR4\u0016\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3D_6\u0004\u0018m\u0019;j_:\u001cF/\u0019;vg\"\u0012Qb\u000b")
public class ControllerConfigurationValidatorTest {
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(true, true);

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (java.util.Map)config)).getMessage());
    }

    private void verifyLogConfigChange(ControllerConfigurationValidator validator, String prevCleanupPolicy, String newCleanupPolicy, String expectedExceptionText) {
        if (expectedExceptionText.isEmpty()) {
            try {
                validator.validateTopicConfigChange((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(validator.tierCleanerFeatureEnabled()))}))).asJava());
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected validation failure", e);
            }
        }
        Assertions.assertEquals((Object)expectedExceptionText, (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> validator.validateTopicConfigChange((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(validator.tierCleanerFeatureEnabled()))}))).asJava())).getMessage());
    }

    @Test
    public void testValidateTopicConfigChangeCompactionStatus() {
        ControllerConfigurationValidator noTiering = new ControllerConfigurationValidator(false, false);
        this.verifyLogConfigChange(noTiering, "compact", "compact", "");
        this.verifyLogConfigChange(noTiering, "compact", "delete", "");
        this.verifyLogConfigChange(noTiering, "compact", "compact,delete", "");
        this.verifyLogConfigChange(noTiering, "delete", "compact", "");
        this.verifyLogConfigChange(noTiering, "delete", "delete", "");
        this.verifyLogConfigChange(noTiering, "delete", "compact,delete", "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact", "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "delete", "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact,delete", "");
        ControllerConfigurationValidator noCleaner = new ControllerConfigurationValidator(true, false);
        this.verifyLogConfigChange(noCleaner, "compact", "compact", "");
        this.verifyLogConfigChange(noCleaner, "compact", "delete", "");
        this.verifyLogConfigChange(noCleaner, "compact", "compact,delete", "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact", "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "delete", "delete", "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact,delete", "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact", "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "delete", "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact,delete", "");
        ControllerConfigurationValidator latest = new ControllerConfigurationValidator(true, true);
        this.verifyLogConfigChange(latest, "compact", "compact", "");
        this.verifyLogConfigChange(latest, "compact", "delete", "");
        this.verifyLogConfigChange(latest, "compact", "compact,delete", "");
        this.verifyLogConfigChange(latest, "delete", "compact", "");
        this.verifyLogConfigChange(latest, "delete", "delete", "");
        this.verifyLogConfigChange(latest, "delete", "compact,delete", "Altering topic configuration from `delete` to `compact` and `delete` is not currently supported.Please set `cleanup.policy` to either `delete` or `compact`.`");
        this.verifyLogConfigChange(latest, "compact,delete", "compact", "");
        this.verifyLogConfigChange(latest, "compact,delete", "delete", "");
        this.verifyLogConfigChange(latest, "compact,delete", "compact,delete", "");
    }
}

