/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.server.AbstractCreateTopicsRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQ!\u0015\u0001\u0005\u0002ICQa\u0016\u0001\u0005\u0002aCQ!\u0018\u0001\u0005\u0002yCQa\u0019\u0001\u0005\u0002\u0011DQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\u0002ADQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\nqDaa \u0001\u0005\n\u0005\u0005\u0001\"CA\u001a\u0001E\u0005I\u0011BA\u001b\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bB\u0011\"!'\u0001#\u0003%I!a'\t\u0013\u0005}\u0005!%A\u0005\n\u0005\u0005\u0006bBAS\u0001\u0011%\u0011q\u0015\u0002\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e+fgRT!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003?\u0005\u00137\u000f\u001e:bGR\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011\u0011\u0004A\u0001\u001ei\u0016\u001cHOV1mS\u0012\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:ugR\u0011\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)\u0005\u0001\u0007\u0011&\u0001\u0004rk>\u0014X/\u001c\t\u0003UEr!aK\u0018\u0011\u00051\u001aS\"A\u0017\u000b\u000592\u0012A\u0002\u001fs_>$h(\u0003\u00021G\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u00014\u0005\u000b\u0003\u0003k\r#\u0005C\u0001\u001cB\u001b\u00059$B\u0001\u001d:\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u001e<\u0003\u0019\u0001\u0018M]1ng*\u0011A(P\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqt(A\u0003kk:LGOC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA#HC\u00051\u0015A\u0001>lC\u0005A\u0015!B6sC\u001a$\b\u0006\u0002\u0002K\u001d>\u0003\"a\u0013'\u000e\u0003eJ!!T\u001d\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001)\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\u000fuKN$XI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;t)\t\t3\u000bC\u0003)\u0007\u0001\u0007\u0011\u0006\u000b\u0003\u0004k\r+FFA#HQ\u0011\u0019!JT(\u0002KQ,7\u000f^\"sK\u0006$X\rV8qS\u000e\u001cx+\u001b;i-\u0016\u0014\u0018p\u00155peR$\u0016.\\3pkR\u001cHCA\u0011Z\u0011\u0015AC\u00011\u0001*Q\u0011!QgQ.-\u0003\u0015CC\u0001\u0002&O\u001f\u0006yB/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f^:\u0015\u0005\u0005z\u0006\"\u0002\u0015\u0006\u0001\u0004I\u0003\u0006B\u00036\u0007\u0006d#!R$)\t\u0015QejT\u0001&i\u0016\u001cH\u000fV3oC:$\b+\u0019:uSRLwN\\!tg&<gn\u001c:WC2LG-\u0019;j_:$\"!I3\t\u000b!2\u0001\u0019A\u0015)\t\u0019)4i\u001a\u0017\u0002\u000b\"\"aA\u0013(P\u0003E!Xm\u001d;O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u0003C-DQ\u0001K\u0004A\u0002%BCaB\u001bD[2\nQ\t\u000b\u0003\b\u0015:{\u0015a\b;fgR\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u-\u0016\u00148/[8ogR\u0011\u0011%\u001d\u0005\u0006Q!\u0001\r!\u000b\u0015\u0005\u0011U\u001a5\u000fL\u0001FQ\u0011A!JT(\u0002GQ,7\u000f^#se>\u00148I]3bi\u0016l\u0015N\u001d:peR{\u0007/[2t%\u0016\fX/Z:ugR\u0011\u0011e\u001e\u0005\u0006Q%\u0001\r!\u000b\u0015\u0005\u0013U\u001a\u0015\u0010\f\u0002F\u000f\"\"\u0011B\u0013(P\u0003Y\u0019'/Z1uK\n\u000b7/[2DYV\u001cH/\u001a:MS:\\GCA\u0011~\u0011\u0015q(\u00021\u0001*\u0003!a\u0017N\\6OC6,\u0017!\u00058fo:+wo\u00117vgR,'\u000fT5oWRQ\u00111AA\r\u00037\t)#a\f\u0011\t\u0005\u0015\u0011QC\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005)\u0011\rZ7j]*!\u0011QBA\b\u0003\u001d\u0019G.[3oiNT1!FA\t\u0015\r\t\u0019bP\u0001\u0007CB\f7\r[3\n\t\u0005]\u0011q\u0001\u0002\u000f\u001d\u0016<8\t\\;ti\u0016\u0014H*\u001b8l\u0011\u0015q8\u00021\u0001*\u0011\u001d\tib\u0003a\u0001\u0003?\t\u0011b\u00197vgR,'/\u00133\u0011\t\t\n\t#K\u0005\u0004\u0003G\u0019#AB(qi&|g\u000eC\u0004\u0002(-\u0001\r!!\u000b\u0002\u000f\r|gNZ5hgB)!&a\u000b*S%\u0019\u0011QF\u001a\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u00022-\u0001\n\u00111\u0001*\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148/A\u000eoK^tUm^\"mkN$XM\u001d'j].$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oQ3!KA\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA#G\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE2sK\u0006$Xm\u00117vgR,'\u000fT5oWN$B\"a\u0014\u0002b\u0005]\u0014\u0011QAC\u0003\u001f\u0003bAKA\u0016S\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\taJ|Go\\2pY*!\u00111LA\b\u0003\u0019\u0019w.\\7p]&!\u0011qLA+\u0005\u0019)%O]8sg\"9\u00111M\u0007A\u0002\u0005\u0015\u0014a\u00048fo\u000ecWo\u001d;fe2Kgn[:\u0011\r\u0005\u001d\u0014\u0011OA\u0002\u001d\u0011\tI'!\u001c\u000f\u00071\nY'C\u0001%\u0013\r\tygI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019(!\u001e\u0003\u0011%#XM]1cY\u0016T1!a\u001c$\u0011\u001d\tI(\u0004a\u0001\u0003w\nAB^1mS\u0012\fG/Z(oYf\u00042AIA?\u0013\r\tyh\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019)\u0004a\u0001\u0003w\nAB^1mS\u0012\fG/\u001a'j].D\u0011\"a\"\u000e!\u0003\u0005\r!!#\u0002\u0013QLW.Z8vi6\u001b\bc\u0001\u0012\u0002\f&\u0019\u0011QR\u0012\u0003\u0007%sG\u000fC\u0005\u0002\u00126\u0001\n\u00111\u0001\u0002\u0014\u0006q!/Z9vKN$h+\u001a:tS>t\u0007c\u0001\u0012\u0002\u0016&\u0019\u0011qS\u0012\u0003\u000bMCwN\u001d;\u00029\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0014\u0016\u0005\u0003\u0013\u000bI$\u0001\u000fde\u0016\fG/Z\"mkN$XM\u001d'j].\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\r&\u0006BAJ\u0003s\tQd]3oI\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d*fcV,7\u000f\u001e\u000b\r\u0003S\u000b),a.\u0002:\u0006m\u0016Q\u0018\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVA-\u0003!\u0011X-];fgR\u001c\u0018\u0002BAZ\u0003[\u0013!d\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+7\u000f]8og\u0016Dq!a\u0019\u0011\u0001\u0004\t)\u0007C\u0004\u0002zA\u0001\r!a\u001f\t\u000f\u0005\r\u0005\u00031\u0001\u0002|!9\u0011q\u0011\tA\u0002\u0005%\u0005bBAI!\u0001\u0007\u00111\u0013")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidCreateTopicsRequests(String quorum) {
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$1 = "topic2";
        Integer x$2 = Predef$.MODULE$.int2Integer(3);
        Integer x$3 = this.topicReq$default$2();
        scala.collection.immutable.Map<String, String> x$4 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        String x$6 = this.topicReq$default$6();
        String x$7 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5, x$6, x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic3", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$8 = "topic4";
        scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$10 = this.topicReq$default$2();
        Integer x$11 = this.topicReq$default$3();
        scala.collection.immutable.Map<String, String> x$12 = this.topicReq$default$4();
        String x$13 = this.topicReq$default$6();
        String x$14 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$8, x$10, x$11, x$12, (scala.collection.immutable.Map<Object, Seq<Object>>)x$9, x$13, x$14), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$15 = "topic5";
        scala.collection.immutable.Map x$16 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        scala.collection.immutable.Map x$17 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        String x$20 = this.topicReq$default$6();
        String x$21 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$15, x$18, x$19, (scala.collection.immutable.Map<String, String>)x$17, (scala.collection.immutable.Map<Object, Seq<Object>>)x$16, x$20, x$21), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$22 = "topic8";
        scala.collection.immutable.Map x$23 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$24 = this.topicReq$default$2();
        Integer x$25 = this.topicReq$default$3();
        scala.collection.immutable.Map<String, String> x$26 = this.topicReq$default$4();
        String x$27 = this.topicReq$default$6();
        String x$28 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic6", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq("topic7", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq(x$22, x$24, x$25, x$26, (scala.collection.immutable.Map<Object, Seq<Object>>)x$23, x$27, x$28), (List)Nil$.MODULE$))), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$29 = "topic11";
        scala.collection.immutable.Map x$30 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$31 = this.topicReq$default$2();
        Integer x$32 = this.topicReq$default$3();
        scala.collection.immutable.Map<String, String> x$33 = this.topicReq$default$4();
        String x$34 = this.topicReq$default$6();
        String x$35 = this.topicReq$default$7();
        .colon.colon x$36 = new .colon.colon((Object)this.topicReq("topic9", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq("topic10", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq(x$29, x$31, x$32, x$33, (scala.collection.immutable.Map<Object, Seq<Object>>)x$30, x$34, x$35), (List)Nil$.MODULE$)));
        boolean x$37 = true;
        Integer x$38 = this.topicsReq$default$2();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$36, x$38, x$37));
        String x$39 = "topic12";
        Integer x$40 = Predef$.MODULE$.int2Integer(-1);
        Integer x$41 = Predef$.MODULE$.int2Integer(-1);
        scala.collection.immutable.Map<String, String> x$42 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$43 = this.topicReq$default$5();
        String x$44 = this.topicReq$default$6();
        String x$45 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$39, x$41, x$40, x$42, x$43, x$44, x$45), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$46 = "topic13";
        Integer x$47 = Predef$.MODULE$.int2Integer(2);
        Integer x$48 = Predef$.MODULE$.int2Integer(-1);
        scala.collection.immutable.Map<String, String> x$49 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$50 = this.topicReq$default$5();
        String x$51 = this.topicReq$default$6();
        String x$52 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$46, x$48, x$47, x$49, x$50, x$51, x$52), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$53 = "topic14";
        Integer x$54 = Predef$.MODULE$.int2Integer(-1);
        Integer x$55 = Predef$.MODULE$.int2Integer(2);
        scala.collection.immutable.Map<String, String> x$56 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$57 = this.topicReq$default$5();
        String x$58 = this.topicReq$default$6();
        String x$59 = this.topicReq$default$7();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$53, x$55, x$54, x$56, x$57, x$58, x$59), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorCreateTopicsRequests(String quorum) {
        String existingTopic = "existing-topic";
        this.createTopic(existingTopic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false);
        String x$1 = "error-replication";
        Integer x$2 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$3 = this.topicReq$default$2();
        scala.collection.immutable.Map<String, String> x$4 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        String x$6 = this.topicReq$default$6();
        String x$7 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5, x$6, x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false);
        String x$8 = "error-config";
        scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}));
        Integer x$10 = this.topicReq$default$2();
        Integer x$11 = this.topicReq$default$3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$12 = this.topicReq$default$5();
        String x$13 = this.topicReq$default$6();
        String x$14 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$8, x$10, x$11, (scala.collection.immutable.Map<String, String>)x$9, x$12, x$13, x$14), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$15 = "error-config-value";
        scala.collection.immutable.Map x$16 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)"invalid-value")}));
        Integer x$17 = this.topicReq$default$2();
        Integer x$18 = this.topicReq$default$3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$19 = this.topicReq$default$5();
        String x$20 = this.topicReq$default$6();
        String x$21 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$15, x$17, x$18, (scala.collection.immutable.Map<String, String>)x$16, x$19, x$20, x$21), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$22 = "error-assignment";
        scala.collection.immutable.Map x$23 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$24 = this.topicReq$default$2();
        Integer x$25 = this.topicReq$default$3();
        scala.collection.immutable.Map<String, String> x$26 = this.topicReq$default$4();
        String x$27 = this.topicReq$default$6();
        String x$28 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$22, x$24, x$25, x$26, (scala.collection.immutable.Map<Object, Seq<Object>>)x$23, x$27, x$28), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false);
        String x$29 = "partial-replication";
        Integer x$30 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$31 = this.topicReq$default$2();
        scala.collection.immutable.Map<String, String> x$32 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$33 = this.topicReq$default$5();
        String x$34 = this.topicReq$default$6();
        String x$35 = this.topicReq$default$7();
        String x$36 = "partial-assignment";
        scala.collection.immutable.Map x$37 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$38 = this.topicReq$default$2();
        Integer x$39 = this.topicReq$default$3();
        scala.collection.immutable.Map<String, String> x$40 = this.topicReq$default$4();
        String x$41 = this.topicReq$default$6();
        String x$42 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq("partial-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)new .colon.colon((Object)this.topicReq(x$29, x$31, x$30, x$32, x$33, x$34, x$35), (List)new .colon.colon((Object)this.topicReq(x$36, x$38, x$39, x$40, (scala.collection.immutable.Map<Object, Seq<Object>>)x$37, x$41, x$42), (List)new .colon.colon((Object)this.topicReq("partial-none", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$))))), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        this.validateTopicExists("partial-none");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testCreateTopicsWithVeryShortTimeouts(String quorum) {
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(1), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-zero", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(0), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-negative", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(-1), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        this.validateTopicExists("error-timeout");
        this.validateTopicExists("error-timeout-zero");
        this.validateTopicExists("error-timeout-negative");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidCreateTopicsRequests(String quorum) {
        String x$1 = "bad-args-topic";
        Integer x$2 = Predef$.MODULE$.int2Integer(10);
        Integer x$3 = Predef$.MODULE$.int2Integer(3);
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map<String, String> x$5 = this.topicReq$default$4();
        String x$6 = this.topicReq$default$6();
        String x$7 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$2, x$3, x$5, (scala.collection.immutable.Map<Object, Seq<Object>>)x$4, x$6, x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$8 = "bad-args-topic";
        Integer x$9 = Predef$.MODULE$.int2Integer(10);
        Integer x$10 = Predef$.MODULE$.int2Integer(3);
        scala.collection.immutable.Map x$11 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map<String, String> x$12 = this.topicReq$default$4();
        String x$13 = this.topicReq$default$6();
        String x$14 = this.topicReq$default$7();
        .colon.colon x$15 = new .colon.colon((Object)this.topicReq(x$8, x$9, x$10, x$12, (scala.collection.immutable.Map<Object, Seq<Object>>)x$11, x$13, x$14), (List)Nil$.MODULE$);
        boolean x$16 = true;
        Integer x$17 = this.topicsReq$default$2();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$15, x$17, x$16), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testTenantPartitionAssignorValidation(String quorum) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable & scala.Serializable)validateOnly -> {
            CreateTopicsRequestTest.$anonfun$testTenantPartitionAssignorValidation$1(this, BoxesRunTime.unboxToBoolean((Object)validateOnly));
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testNotController(String quorum) {
        CreateTopicsRequest req = this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3());
        CreateTopicsResponse response = this.sendCreateTopicRequest(req, this.notControllerSocketServer());
        Assertions.assertEquals((int)1, (Integer)((Integer)response.errorCounts().get(Errors.NOT_CONTROLLER)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testCreateTopicsRequestVersions(String quorum) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.CREATE_TOPICS.oldestVersion()), (int)ApiKeys.CREATE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            String topic = new StringBuilder(6).append("topic_").append(version).toString();
            CreateTopicsRequestData data = new CreateTopicsRequestData();
            data.setTimeoutMs(10000);
            data.setValidateOnly(false);
            data.setTopics(new CreateTopicsRequestData.CreatableTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topicReq(topic, Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5(), this.topicReq$default$6(), this.topicReq$default$7()), (List)Nil$.MODULE$)).asJava()).iterator()));
            CreateTopicsRequest request = new CreateTopicsRequest.Builder(data).build((short)version);
            CreateTopicsResponseData.CreatableTopicResult topicResponse = this.sendCreateTopicRequest(request, this.sendCreateTopicRequest$default$2()).data().topics().find(topic);
            Assertions.assertNotNull((Object)topicResponse);
            Assertions.assertEquals((Object)topic, (Object)topicResponse.name());
            Assertions.assertEquals((short)Errors.NONE.code(), (short)topicResponse.errorCode());
            if (version >= 5) {
                Assertions.assertEquals((int)1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)1, (int)topicResponse.replicationFactor());
                Option config = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicResponse.configs()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestTest.$anonfun$testCreateTopicsRequestVersions$2(x$1)));
                Assertions.assertTrue((boolean)config.isDefined());
                Assertions.assertEquals((Object)"2", (Object)((CreateTopicsResponseData.CreatableTopicConfigs)config.get()).value());
            } else {
                Assertions.assertEquals((int)-1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)-1, (int)topicResponse.replicationFactor());
                Assertions.assertTrue((boolean)topicResponse.configs().isEmpty());
            }
            if (version >= 7) {
                Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
                return;
            }
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorCreateMirrorTopicsRequests(String quorum) {
        String x$1 = "mirror-no-link-name";
        Integer x$2 = Predef$.MODULE$.int2Integer(-1);
        Integer x$3 = Predef$.MODULE$.int2Integer(2);
        String x$4 = "mirror-no-link-name";
        scala.collection.immutable.Map<String, String> x$5 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$6 = this.topicReq$default$5();
        String x$7 = this.topicReq$default$6();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$2, x$3, x$5, x$6, x$7, x$4), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-no-link-name"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$8 = "mirror-empty-link-name";
        Integer x$9 = Predef$.MODULE$.int2Integer(-1);
        Integer x$10 = Predef$.MODULE$.int2Integer(2);
        String x$11 = "";
        String x$12 = "mirror-empty-link-name";
        scala.collection.immutable.Map<String, String> x$13 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$14 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$8, x$9, x$10, x$13, x$14, x$11, x$12), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-empty-link-name"), (Object)this.error(Errors.INVALID_CLUSTER_LINK, this.error$default$2()))}))), false);
        String x$15 = "mirror-assignment";
        Integer x$16 = Predef$.MODULE$.int2Integer(2);
        scala.collection.immutable.Map x$17 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String x$18 = "test-link";
        String x$19 = "mirror-assignment";
        Integer x$20 = this.topicReq$default$2();
        scala.collection.immutable.Map<String, String> x$21 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$15, x$20, x$16, x$21, (scala.collection.immutable.Map<Object, Seq<Object>>)x$17, x$18, x$19), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-assignment"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$22 = "mirror-link-name-not-found";
        Integer x$23 = Predef$.MODULE$.int2Integer(-1);
        Integer x$24 = Predef$.MODULE$.int2Integer(2);
        String x$25 = "doesnt-exist";
        String x$26 = "mirror-link-name-not-found";
        scala.collection.immutable.Map<String, String> x$27 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$28 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$22, x$23, x$24, x$27, x$28, x$25, x$26), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-link-name-not-found"), (Object)this.error(Errors.CLUSTER_LINK_NOT_FOUND, this.error$default$2()))}))), false);
        String x$29 = "mirror-no-mirror-topic";
        Integer x$30 = Predef$.MODULE$.int2Integer(-1);
        Integer x$31 = Predef$.MODULE$.int2Integer(2);
        String x$32 = "test-link";
        scala.collection.immutable.Map<String, String> x$33 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$34 = this.topicReq$default$5();
        String x$35 = this.topicReq$default$7();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$29, x$30, x$31, x$33, x$34, x$32, x$35), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-no-mirror-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String linkName = "test-link";
        this.createBasicClusterLink(linkName);
        if (quorum.equals("kraft")) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.brokers(), this.controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
        String x$36 = "mirror-partitions";
        Integer x$37 = Predef$.MODULE$.int2Integer(10);
        Integer x$38 = Predef$.MODULE$.int2Integer(2);
        String x$40 = "mirror-partitions";
        scala.collection.immutable.Map<String, String> x$41 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$42 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$36, x$37, x$38, x$41, x$42, linkName, x$40), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-partitions"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$43 = "mirror-empty-mirror-topic";
        Integer x$44 = Predef$.MODULE$.int2Integer(-1);
        Integer x$45 = Predef$.MODULE$.int2Integer(2);
        String x$47 = "";
        scala.collection.immutable.Map<String, String> x$48 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$49 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$43, x$44, x$45, x$48, x$49, linkName, x$47), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-empty-mirror-topic"), (Object)this.error(Errors.UNSUPPORTED_VERSION, this.error$default$2()))}))), false);
        String x$50 = "mirror-different-topic";
        Integer x$51 = Predef$.MODULE$.int2Integer(-1);
        Integer x$52 = Predef$.MODULE$.int2Integer(2);
        String x$54 = "another-topic";
        scala.collection.immutable.Map<String, String> x$55 = this.topicReq$default$4();
        scala.collection.immutable.Map<Object, Seq<Object>> x$56 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$50, x$51, x$52, x$55, x$56, linkName, x$54), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mirror-different-topic"), (Object)this.error(Errors.UNSUPPORTED_VERSION, this.error$default$2()))}))), false);
    }

    private void createBasicClusterLink(String linkName) {
        NewClusterLink newClusterLink = this.newNewClusterLink(linkName, (Option<String>)new Some((Object)"cluster-id-1"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4());
        scala.collection.immutable.Map expectedResults = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)Errors.NONE)}));
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)new .colon.colon((Object)newClusterLink, (List)Nil$.MODULE$), false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
    }

    private NewClusterLink newNewClusterLink(String linkName, Option<String> clusterId, scala.collection.immutable.Map<String, String> configs, String bootstrapServers) {
        return new NewClusterLink(linkName, (String)clusterId.orNull(Predef$.MODULE$.$conforms()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)configs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers))).asJava());
    }

    private String newNewClusterLink$default$4() {
        return "localhost:12345";
    }

    private scala.collection.immutable.Map<String, Errors> createClusterLinks(Iterable<NewClusterLink> newClusterLinks, boolean validateOnly, boolean validateLink, int timeoutMs, short requestVersion) {
        java.util.Map tmpResults = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)new KafkaFutureImpl()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.sendCreateClusterLinksRequest(newClusterLinks, validateOnly, validateLink, timeoutMs, requestVersion).complete(tmpResults);
        return ((TraversableOnce)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tmpResults).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            String linkName;
            if (x0$1 != null) {
                linkName = (String)x0$1._1();
                KafkaFutureImpl future = (KafkaFutureImpl)x0$1._2();
                Assertions.assertTrue((boolean)newClusterLinks.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestTest.$anonfun$createClusterLinks$3(linkName, x$2))));
                try {
                    future.get();
                    errors = Errors.NONE;
                }
                catch (ExecutionException executionException) {
                    errors = Errors.forException((Throwable)executionException.getCause());
                }
            } else {
                throw new MatchError(null);
            }
            Errors error = errors;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)error);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private int createClusterLinks$default$4() {
        return 2000;
    }

    private short createClusterLinks$default$5() {
        return ApiKeys.CREATE_CLUSTER_LINKS.latestVersion();
    }

    private CreateClusterLinksResponse sendCreateClusterLinksRequest(Iterable<NewClusterLink> newClusterLinks, boolean validateOnly, boolean validateLink, int timeoutMs, short requestVersion) {
        CreateClusterLinksRequest request = new CreateClusterLinksRequest.Builder(CollectionConverters$.MODULE$.asJavaCollectionConverter(newClusterLinks).asJavaCollection(), validateOnly, validateLink, timeoutMs).build(requestVersion);
        return (CreateClusterLinksResponse)this.connectAndReceive((AbstractRequest)request, this.adminSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(CreateClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ void $anonfun$testTenantPartitionAssignorValidation$1(CreateTopicsRequestTest $this, boolean validateOnly) {
        ObjectRef topicName = ObjectRef.create((Object)"conflicting-args-topic");
        String x$1 = (String)topicName.elem;
        Integer x$2 = Predef$.MODULE$.int2Integer(10);
        Integer x$3 = Predef$.MODULE$.int2Integer(3);
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map<String, String> x$5 = $this.topicReq$default$4();
        String x$6 = $this.topicReq$default$6();
        String x$7 = $this.topicReq$default$7();
        .colon.colon x$8 = new .colon.colon((Object)$this.topicReq(x$1, x$2, x$3, x$5, (scala.collection.immutable.Map<Object, Seq<Object>>)x$4, x$6, x$7), (List)Nil$.MODULE$);
        Integer x$10 = $this.topicsReq$default$2();
        $this.validateErrorCreateTopicsRequests($this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$8, x$10, validateOnly), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)topicName.elem)), (Object)$this.error(Errors.INVALID_REQUEST, $this.error$default$2()))}))), false);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MIN_VALUE, -10, 0})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)invalidPartitionCount -> {
            topicName$1.elem = "invalid-partitions-topic";
            .colon.colon x$11 = new .colon.colon((Object)$this.topicReq((String)topicName$1.elem, Predef$.MODULE$.int2Integer(invalidPartitionCount), Predef$.MODULE$.int2Integer(3), $this.topicReq$default$4(), $this.topicReq$default$5(), $this.topicReq$default$6(), $this.topicReq$default$7()), (List)Nil$.MODULE$);
            Integer x$13 = $this.topicsReq$default$2();
            CreateTopicsRequest request = $this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$11, x$13, validateOnly);
            $this.validateErrorCreateTopicsRequests(request, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)topicName$1.elem)), (Object)$this.error(Errors.INVALID_PARTITIONS, $this.error$default$2()))}))), false);
        });
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MIN_VALUE, -10, 0, $this.brokerCount() + 1})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)invalidReplicationFactor -> {
            topicName$1.elem = "invalid-rf-topic";
            .colon.colon x$14 = new .colon.colon((Object)$this.topicReq((String)topicName$1.elem, Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(invalidReplicationFactor), $this.topicReq$default$4(), $this.topicReq$default$5(), $this.topicReq$default$6(), $this.topicReq$default$7()), (List)Nil$.MODULE$);
            Integer x$16 = $this.topicsReq$default$2();
            CreateTopicsRequest request = $this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$14, x$16, validateOnly);
            $this.validateErrorCreateTopicsRequests(request, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)topicName$1.elem)), (Object)$this.error(Errors.INVALID_REPLICATION_FACTOR, $this.error$default$2()))}))), false);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsRequestVersions$2(CreateTopicsResponseData.CreatableTopicConfigs x$1) {
        String string = x$1.configName();
        String string2 = "min.insync.replicas";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLinks$3(String linkName$1, NewClusterLink x$2) {
        String string = x$2.linkName();
        return !(string != null ? !string.equals(linkName$1) : linkName$1 != null);
    }
}

