/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.cluster.PartitionListener;
import kafka.log.LogOffsetSnapshot;
import kafka.log.MergedLog$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.FetchTxnCommitted$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierFetchDataInfo;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.ReclaimableMemoryRecords;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB$\u0001A\u0003%A\tC\u0004I\u0001\t\u0007I\u0011B%\t\r5\u0003\u0001\u0015!\u0003K\u0011%q\u0005\u00011AA\u0002\u0013%q\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\"I!\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0015\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006U\u0002!\t\u0001\u0018\u0005\u0006_\u0002!\t\u0001\u0018\u0005\u0006i\u0002!\t\u0001\u0018\u0005\u0006m\u0002!\t\u0001\u0018\u0005\u0006q\u0002!\t\u0001\u0018\u0005\u0006u\u0002!\t\u0001\u0018\u0005\u0006y\u0002!\t\u0001\u0018\u0005\u0006}\u0002!\t\u0001\u0018\u0005\u0007\u0003\u0003\u0001A\u0011\u0001/\t\r\u0005\u0015\u0001\u0001\"\u0001]\u0011\u0019\tI\u0001\u0001C\u00019\"1\u0011Q\u0002\u0001\u0005\u0002qCa!!\u0005\u0001\t\u0003a\u0006bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!a\u001b\u0001\t\u0013\ti\u0007C\u0005\u0002H\u0002\t\n\u0011\"\u0003\u0002J\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0002\u0011\t\u0016d\u0017-_3e\r\u0016$8\r\u001b+fgRT!\u0001J\u0013\u0002\rM,'O^3s\u0015\u00051\u0013!B6bM.\f7\u0001A\n\u0003\u0001%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001$\u0003!i\u0017\r\u001f\"zi\u0016\u001cX#A\u001b\u0011\u0005)2\u0014BA\u001c,\u0005\rIe\u000e^\u0001\n[\u0006D()\u001f;fg\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011a(J\u0001\u0006kRLGn]\u0005\u0003\u0001v\u0012\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001E!\t\u0011T)\u0003\u0002GG\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0019I,\u0007\u000f\\5dCF+x\u000e^1\u0016\u0003)\u0003\"AM&\n\u00051\u001b#\u0001\u0004*fa2L7-Y)v_R\f\u0017!\u0004:fa2L7-Y)v_R\f\u0007%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t\u0001\u000b\u0005\u00023#&\u0011!k\t\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\fAC\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:`I\u0015\fHCA+Y!\tQc+\u0003\u0002XW\t!QK\\5u\u0011\u001dI6\"!AA\u0002A\u000b1\u0001\u001f\u00132\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002+\"\u0012QB\u0018\t\u0003?\"l\u0011\u0001\u0019\u0006\u0003C\n\f1!\u00199j\u0015\t\u0019G-A\u0004kkBLG/\u001a:\u000b\u0005\u00154\u0017!\u00026v]&$(\"A4\u0002\u0007=\u0014x-\u0003\u0002jA\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#A\u00047\u0011\u0005}k\u0017B\u00018a\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$X*\u001b=fIRKWM\u001d$fi\u000eD\u0007FA\br!\ty&/\u0003\u0002tA\n!A+Z:u\u0003a!Xm\u001d;US\u0016\u0014h)\u001a;dQ\u0016\u0014X\t_2faRLwN\u001c\u0015\u0003!E\f\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2iQ\t\t\u0012/A\fuKN$hj\u001c;MK\u0006$WM](s\r>dGn\\<fe\"\u0012!#]\u00013i\u0016\u001cHOR8mY><XM\u001d$fi\u000eDG+[7f\u0019\u0006<gj\u001c;SK\u000e|'\u000fZ3e\u0003N\u001cuN\\:v[\u0016\u0014h)\u001a;dQ\"\u00121#]\u0001\u001di\u0016\u001cHoQ8ogVlWM\u001d+jKJ4U\r^2i)&lW\rT1hQ\t!\u0012/\u0001\u0019uKN$Hj\\2bYN+w-\\3oi\u0012+G.\u001a;fI\u00063G/\u001a:EK2\f\u00170\u001a3GKR\u001c\u0007n\u0011:fCRLwN\u001c\u0015\u0003+E\f!\u0003^3ti\u0012Kg/\u001a:hS:<W\t]8dQ\"\u0012a#]\u0001\u001di\u0016\u001cH\u000fR3mCf,G\rT:p\u0005\u0006\u001cX\r\u001a+jKJ,G\rT8hQ\t9\u0012/A\u000fuKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r\u001b)beRLG/[8oQ\tA\u0012/\u0001\u0019uKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r\u001b)beRLG/[8o/\",g\u000e\u0015:v]&tw\rR5tC\ndW\r\u001a\u0015\u00033E\f!\u0005^3ti6K\u00070\u001a3GKR\u001c\u0007\u000eR8fg:{GoQ8na2,G/Z#be2L\bF\u0001\u000er\u0003a\u0011W/\u001b7e\r>dGn\\<fe\u001a+Go\u00195QCJ\fWn\u001d\u000b\u0007\u00033\ty\"a\t\u0011\u0007I\nY\"C\u0002\u0002\u001e\r\u00121BR3uG\"\u0004\u0016M]1ng\"1\u0011\u0011E\u000eA\u0002U\n\u0011B]3qY&\u001c\u0017-\u00133\t\r\u0005\u00152\u00041\u00016\u0003%i\u0017\r_,bSRl5/A\u000bfqB,7\r\u001e*fC\u00124%o\\7SKBd\u0017nY1\u0015\u0013U\u000bY#a\f\u0002F\u0005=\u0003bBA\u00179\u0001\u0007\u0011\u0011D\u0001\fM\u0016$8\r\u001b)be\u0006l7\u000fC\u0004\u00022q\u0001\r!a\r\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA\u001b\u0003\u0003j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0007G>lWn\u001c8\u000b\u0007\u0019\niDC\u0002\u0002@\u0019\fa!\u00199bG\",\u0017\u0002BA\"\u0003o\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\u0005\u001dC\u00041\u0001\u0002J\u0005\u0011b-\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\r\u0011\u00141J\u0005\u0004\u0003\u001b\u001a#A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u000f\u0005EC\u00041\u0001\u0002T\u0005)QM\u001d:peB!\u0011QKA.\u001b\t\t9F\u0003\u0003\u0002Z\u0005]\u0012\u0001\u00039s_R|7m\u001c7\n\t\u0005u\u0013q\u000b\u0002\u0007\u000bJ\u0014xN]:\u0002\u001f\t,\u0018\u000e\u001c3SK\u0006$'+Z:vYR$B!a\u0019\u0002jA\u0019!'!\u001a\n\u0007\u0005\u001d4EA\u0007M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u0005\b\u0003#j\u0002\u0019AA*\u0003e)\u0007\u0010]3di\u001e+G\u000fV5fe\u001a+Go\u00195SKN,H\u000e^:\u0015\u000fU\u000by'a!\u0002>\"9\u0011\u0011\u000f\u0010A\u0002\u0005M\u0014\u0001\u00049f]\u0012Lgn\u001a$fi\u000eD\u0007\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\bM\u0016$8\r[3s\u0015\r\ti(J\u0001\u0005i&,'/\u0003\u0003\u0002\u0002\u0006]$\u0001\u0004)f]\u0012Lgn\u001a$fi\u000eD\u0007bBAC=\u0001\u0007\u0011qQ\u0001\u0018i>\u0004\u0018n\u0019)beRLG/[8o\u000bb\u001cW\r\u001d;j_:\u0004b!!#\u0002\u0010\u0006MUBAAF\u0015\r\tiiK\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u0017\u00131aU3r!\u001dQ\u0013QSAM\u0003?K1!a&,\u0005\u0019!V\u000f\u001d7feA!\u0011QGAN\u0013\u0011\ti*a\u000e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B)!&!)\u0002&&\u0019\u00111U\u0016\u0003\r=\u0003H/[8o!\u0011\t9+a.\u000f\t\u0005%\u00161\u0017\b\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011qV\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013bAA[W\u00059\u0001/Y2lC\u001e,\u0017\u0002BA]\u0003w\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005U6\u0006C\u0005\u0002@z\u0001\n\u00111\u0001\u0002B\u00069!/Z2pe\u0012\u001c\b\u0003BA;\u0003\u0007LA!!2\u0002x\tA\"+Z2mC&l\u0017M\u00197f\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0002G\u0015D\b/Z2u\u000f\u0016$H+[3s\r\u0016$8\r\u001b*fgVdGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001a\u0016\u0005\u0003\u0003\fim\u000b\u0002\u0002PB!\u0011\u0011[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017!C;oG\",7m[3e\u0015\r\tInK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAo\u0003'\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y)\u0007\u0010]3diJ+\u0017\r\u001a$s_6dunY1m\u0019><GcB+\u0002d\u0006\u0015\u0018q\u001f\u0005\u0006\u0005\u0002\u0002\r\u0001\u0012\u0005\b\u0003O\u0004\u0003\u0019AAu\u000391W\r^2i\t\u0006$\u0018-\u00138g_N\u0004b!!#\u0002\u0010\u0006-\b#\u0003\u0016\u0002n\u0006M\u0012\u0011_AP\u0013\r\tyo\u000b\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007I\n\u00190C\u0002\u0002v\u000e\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0002z\u0002\u0002\r!a?\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l!\rQ\u0013Q`\u0005\u0004\u0003\u007f\\#\u0001\u0002'p]\u001e\f!CY;jY\u0012\u0004\u0016M\u001d;ji&|g\u000eR1uCR1\u0011\u0011\nB\u0003\u0005\u001fAqAa\u0002\"\u0001\u0004\u0011I!A\u0004u_BL7-\u00133\u0011\t\u0005U\"1B\u0005\u0005\u0005\u001b\t9D\u0001\u0003Vk&$\u0007b\u0002B\tC\u0001\u0007\u00111`\u0001\fM\u0016$8\r[(gMN,G\u000f")
public class DelayedFetchTest {
    private final int maxBytes;
    private final MockTime mockTime = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
    private BrokerTopicStats brokerTopicStats;

    private int maxBytes() {
        return this.maxBytes;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private void brokerTopicStats_$eq(BrokerTopicStats x$1) {
        this.brokerTopicStats = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.brokerTopicStats_$eq(new BrokerTopicStats());
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerTopicStats() != null) {
            this.brokerTopicStats().close();
        }
    }

    @Test
    public void testMixedTierFetch() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testMixedTierFetch$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
    }

    @Test
    public void testTierFetcherException() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, 2, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
        PartitionFetchMetadata fetchInfoPartition2 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition2.setFetchOffsetMetadata(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition2), (Object)fetchInfoPartition2), (List)Nil$.MODULE$))), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0.topicPartition(), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition2.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)Nil$.MODULE$))), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition2, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)Nil$.MODULE$))), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 fetch results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition0 to return a FencedLeaderException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).error(), (Object)Errors.UNKNOWN_SERVER_ERROR, (String)"Expected topicPartition1 to return a UnknownServerErrorException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition2)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition2 to return a FencedLeaderException as it takes precedence over TierFetcher exceptions");
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, fetchOffset, 0));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.FENCED_LEADER_EPOCH);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString())});
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NOT_LEADER_OR_FOLLOWER);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testFollowerFetchTimeLagNotRecordedAsConsumerFetch() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PartitionFetchMetadata fetchInfo = this.buildPartitionData(topicId, fetchOffset);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true);
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)Nil$.MODULE$), highWatermark);
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Expected tiered fetch result");
        Assertions.assertEquals((int)0, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Follower fetch is not recorded, snapshot size is 0");
    }

    @Test
    public void testConsumerTierFetchTimeLag() {
        int fetchDelta = 3;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, 500L, 1, this.maxBytes(), (FetchIsolation)FetchHighWatermark$.MODULE$, (Option)None$.MODULE$);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true);
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        ReclaimableMemoryRecords records = new ReclaimableMemoryRecords(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5).buffer(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        this.mockTime().sleep(fetchDelta);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), records);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Expected tiered and local fetch result");
        Assertions.assertEquals((int)2, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Expected size of recorded consumer fetch lag snapshot");
        double firstLagTimeMs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).headOption().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)firstLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
        double lastLagTimeMs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).lastOption().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)lastLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
    }

    @Test
    public void testLocalSegmentDeletedAfterDelayedFetchCreation() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, fetchOffset, 0));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDelayedLsoBasedTieredLog() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> leaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicId, fetchOffset, logStartOffset, this.maxBytes(), leaderEpoch, leaderEpoch);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), 0));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, 500L, 1, this.maxBytes(), (FetchIsolation)FetchTxnCommitted$.MODULE$, (Option)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$4(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()), (Object[])new Option[]{new Some((Object)topicIdPartition.topicId()), null});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata updatedOffsetMetadata = new LogOffsetMetadata(505L, 500L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(leaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, updatedOffsetMetadata, updatedOffsetMetadata, updatedOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(leaderEpoch, Predef$.MODULE$.Integer2int(leaderEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(leaderEpoch.get())).setEndOffset(fetchOffset));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testIncrementalFetchPartition() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        TopicIdPartition foo1 = new TopicIdPartition(topicId, 1, "foo");
        int replicaId = 1;
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        IncrementalPartitionFetchMetadata fooFetch1 = new IncrementalPartitionFetchMetadata(foo1, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch1.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0.topicPartition(), (PartitionListener)fooFetch0))).thenAnswer(x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$1(fooFetch0, foo0, x$1)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo1.topicPartition(), (PartitionListener)fooFetch1))).thenAnswer(x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$2(fooFetch1, foo1, foo0, x$2)));
        fooFetch0.maybeRegisterAsListener(0, this.replicaManager());
        fooFetch1.maybeRegisterAsListener(0, this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        Assertions.assertFalse((boolean)fooFetch1.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)fooFetch1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap(Predef$.MODULE$.$conforms()));
            return BoxedUnit.UNIT;
        }, true);
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertFalse((boolean)((Option)fetchResult.elem).isDefined());
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        fooFetch1.onEndOffsetUpdated(foo1.topicPartition(), 10L);
        Assertions.assertFalse((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        Partition fooPartition1 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition1.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition1.topicPartition()).thenReturn((Object)foo1.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo1.topicPartition())).thenReturn((Object)fooPartition1);
        Mockito.when((Object)fooPartition1.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition1.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition1, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLocalLog(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)fooFetch1), (List)Nil$.MODULE$)), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo1.topicPartition(), replicaId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo1})), (Object)((MapLike)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testIncrementalFetchPartitionWhenPruningDisabled() {
        Uuid topicId = Uuid.randomUuid();
        int replicaId = 1;
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0.topicPartition(), (PartitionListener)fooFetch0))).thenAnswer(x$3 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(fooFetch0, foo0, x$3)));
        fooFetch0.maybeRegisterAsListener(0, this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap(Predef$.MODULE$.$conforms()));
            return BoxedUnit.UNIT;
        }, false);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Partition fooPartition0 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition0.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition0.topicPartition()).thenReturn((Object)foo0.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo0.topicPartition())).thenReturn((Object)fooPartition0);
        Mockito.when((Object)fooPartition0.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition0.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition0, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLocalLog(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)Nil$.MODULE$), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo0.topicPartition(), replicaId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0})), (Object)((MapLike)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testMixedFetchDoesNotCompleteEarly() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition localTopicPartition = new TopicIdPartition(topicId, 0, "topic1");
        TopicIdPartition tieredTopicPartition = new TopicIdPartition(topicId, 1, "topic2");
        int replicaId = 1;
        PartitionFetchMetadata localFetchInfo = this.buildPartitionData(topicId, 500L);
        localFetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        PartitionFetchMetadata tierFetchInfo = this.buildPartitionData(topicId, 500L);
        tierFetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{true}));
        Mockito.when((Object)pendingFetch.finish()).thenReturn(new HashMap(), (Object[])new java.util.Map[]{null});
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)localTopicPartition), (Object)localFetchInfo), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tieredTopicPartition), (Object)tierFetchInfo), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)x$4 -> {
            DelayedFetchTest.$anonfun$testMixedFetchDoesNotCompleteEarly$1(x$4);
            return BoxedUnit.UNIT;
        }, true);
        Partition localPartition = (Partition)Mockito.mock(Partition.class);
        Partition tieredPartition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)localPartition.topicId()).thenReturn((Object)new Some((Object)localTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)localTopicPartition.topicId()), null});
        Mockito.when((Object)localPartition.topicPartition()).thenReturn((Object)localTopicPartition.topicPartition(), (Object[])new TopicPartition[]{localTopicPartition.topicPartition(), null});
        Mockito.when((Object)tieredPartition.topicId()).thenReturn((Object)new Some((Object)tieredTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)tieredTopicPartition.topicId()), null});
        Mockito.when((Object)tieredPartition.topicPartition()).thenReturn((Object)tieredTopicPartition.topicPartition(), (Object[])new TopicPartition[]{tieredTopicPartition.topicPartition(), null});
        LogOffsetSnapshot logOffsetSnapshot = new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        Mockito.when((Object)localPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)tieredPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(localTopicPartition.topicPartition())).thenReturn((Object)localPartition, (Object[])new Partition[]{localPartition, null});
        Mockito.when((Object)this.replicaManager().getPartitionOrException(tieredTopicPartition.topicPartition())).thenReturn((Object)tieredPartition, (Object[])new Partition[]{tieredPartition, null});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLocalLog((FetchParams)ArgumentMatchers.eq((Object)fetchParams), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$, (Object[])new Seq[]{null});
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, (long)maxWaitMs, 1, this.maxBytes(), (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
    }

    private void expectReadFromReplica(FetchParams fetchParams, TopicIdPartition topicIdPartition, PartitionFetchMetadata fetchPartitionData, Errors error) {
        Mockito.when((Object)this.replicaManager().readFromLocalLog(fetchParams, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = FetchDataInfo$.MODULE$.Empty();
        None$ x$3 = None$.MODULE$;
        long x$4 = -1L;
        long x$5 = -1L;
        long x$6 = -1L;
        long x$7 = -1L;
        long x$8 = -1L;
        boolean x$9 = false;
        None$ x$10 = None$.MODULE$;
        Option x$11 = LogReadResult$.MODULE$.apply$default$10();
        return new LogReadResult(x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$10, x$9, x$11, (Option)x$1);
    }

    private void expectGetTierFetchResults(PendingFetch pendingFetch, Seq<Tuple2<TopicPartition, Option<Throwable>>> topicPartitionException, ReclaimableMemoryRecords records) {
        java.util.Map results = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitionException.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option exceptionOpt;
            TopicPartition topicPartition;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    topicPartition = (TopicPartition)x0$1._1();
                    exceptionOpt = (Option)x0$1._2();
                    if (topicPartition != null && exceptionOpt != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new TierFetchResult(records, Collections.emptyList(), (Throwable)exceptionOpt.orNull(Predef$.MODULE$.$conforms())));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        Mockito.when((Object)pendingFetch.finish()).thenReturn((Object)results);
    }

    private ReclaimableMemoryRecords expectGetTierFetchResults$default$3() {
        return ReclaimableMemoryRecords.EMPTY;
    }

    private void expectReadFromLocalLog(ReplicaManager replicaManager, Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>> fetchDataInfos, long highWatermark) {
        Seq readResults = (Seq)fetchDataInfos.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                AbstractFetchDataInfo tierFetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
                Option exceptionOpt = (Option)x0$1._3();
                if (tierFetchDataInfo instanceof TierFetchDataInfo) {
                    TierFetchDataInfo tierFetchDataInfo2 = (TierFetchDataInfo)tierFetchDataInfo;
                    if (exceptionOpt != null) {
                        return new Tuple2((Object)tp, (Object)new TierLogReadResult(tierFetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), 0, (Option)None$.MODULE$, (Option)None$.MODULE$, exceptionOpt));
                    }
                }
            }
            if (x0$1 == null) throw new MatchError(x0$1);
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            AbstractFetchDataInfo fetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
            Option exceptionOpt = (Option)x0$1._3();
            if (!(fetchDataInfo instanceof FetchDataInfo)) throw new MatchError(x0$1);
            FetchDataInfo fetchDataInfo2 = (FetchDataInfo)fetchDataInfo;
            if (exceptionOpt == null) throw new MatchError(x0$1);
            return new Tuple2((Object)tp, (Object)new LogReadResult(fetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), (Option)None$.MODULE$, true, (Option)None$.MODULE$, exceptionOpt));
        }, Seq$.MODULE$.canBuildFrom());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)replicaManager.readFromLocalLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)readResults);
    }

    private PartitionFetchMetadata buildPartitionData(Uuid topicId, long fetchOffset) {
        return new FullPartitionFetchMetadata(topicId, fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty(), Optional.empty());
    }

    public static final /* synthetic */ boolean $anonfun$testMixedTierFetch$2(int highWatermark$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$1;
        return bl;
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(int highWatermark$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$2;
        return bl;
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef fetchResultOpt$4) {
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$1(IncrementalPartitionFetchMetadata fooFetch0$1, TopicIdPartition foo0$1, InvocationOnMock x$1) {
        fooFetch0$1.onStartOffsetUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onEndOffsetUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onHighWatermarkUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onLastStableOffsetUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onIsrUpdated(foo0$1.topicPartition(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$2(IncrementalPartitionFetchMetadata fooFetch1$1, TopicIdPartition foo1$1, TopicIdPartition foo0$1, InvocationOnMock x$2) {
        fooFetch1$1.onStartOffsetUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onEndOffsetUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onHighWatermarkUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onLastStableOffsetUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onIsrUpdated(foo0$1.topicPartition(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(IncrementalPartitionFetchMetadata fooFetch0$2, TopicIdPartition foo0$2, InvocationOnMock x$3) {
        fooFetch0$2.onStartOffsetUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onEndOffsetUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onHighWatermarkUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onLastStableOffsetUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onIsrUpdated(foo0$2.topicPartition(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
        return true;
    }

    public static final /* synthetic */ void $anonfun$testMixedFetchDoesNotCompleteEarly$1(Seq x$4) {
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

