/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003\u001f\u0011\u00199\u0003\u0001)A\u0005?!)\u0001\u0006\u0001C\u0001S!)q\u000b\u0001C\u00011\")Q\f\u0001C\u0001=\")1\r\u0001C\u0005I\")\u0011\u000f\u0001C\u0005e\")Q\u0010\u0001C\u0005}\"1Q\u0010\u0001C\u0005\u0003\u0013Aq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002L\u0001!I!!\u0014\u00031\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011q\u0003A\u0001\u000b)&kUiT+U?6\u001bV#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG/A\u0006U\u00136+u*\u0016+`\u001bN\u0003\u0013aH'F'N\u000bu)R*`!J{E)V\"F\t~\u0003VIU0Q\u0003J#\u0016\nV%P\u001d\u0006\u0001S*R*T\u0003\u001e+5k\u0018)S\u001f\u0012+6)\u0012#`!\u0016\u0013v\fU!S)&#\u0016j\u0014(!\u0003i!Xm\u001d;EK2,G/\u001a*fG>\u0014Hm\u001d%baBL8)Y:f)\tQS\u0006\u0005\u0002!W%\u0011A&\t\u0002\u0005+:LG\u000fC\u0003/\r\u0001\u0007q&\u0001\u0004rk>\u0014X/\u001c\t\u0003a]r!!M\u001b\u0011\u0005I\nS\"A\u001a\u000b\u0005Q\"\u0012A\u0002\u001fs_>$h(\u0003\u00027C\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0014\u0005\u000b\u0003\u0007w%S\u0005C\u0001\u001fH\u001b\u0005i$B\u0001 @\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001!B\u0003\u0019\u0001\u0018M]1ng*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!U)A\u0003kk:LGOC\u0001G\u0003\ry'oZ\u0005\u0003\u0011v\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA&NC\u0005a\u0015A\u0001>lC\u0005q\u0015!B6sC\u001a$\b\u0006\u0002\u0004Q)V\u0003\"!\u0015*\u000e\u0003}J!aU \u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001,\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\u0017uKN$XI\u001d:pe^CWM\u001c#fY\u0016$\u0018N\\4SK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$wJ\u001a4tKR$\"AK-\t\u000b9:\u0001\u0019A\u0018)\t\u001dY\u0014j\u0017\u0017\u0003\u00176CCa\u0002)U+\u0006aC/Z:u\u000bJ\u0014xN],iK:$U\r\\3uS:<'+Z2pe\u0012\u001cx+\u001b;i\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u000b\u0003U}CQA\f\u0005A\u0002=BC\u0001C\u001eJC2\u00121*\u0014\u0015\u0005\u0011A#V+A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cX#A3\u0011\t\u00012\u0007nH\u0005\u0003O\u0006\u0012a\u0001V;qY\u0016\u0014\u0004CA5p\u001b\u0005Q'BA6m\u0003\u0019\u0019w.\\7p]*\u00111#\u001c\u0006\u0003]\u0016\u000ba!\u00199bG\",\u0017B\u00019k\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1f\u0019:fCR,G)\u001a7fi\u0016\u0014VmY8sIN\u0014V-];fgR4uN\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0004gf\\\bC\u0001;x\u001b\u0005)(B\u0001<k\u0003!\u0011X-];fgR\u001c\u0018B\u0001=v\u0005Q!U\r\\3uKJ+7m\u001c:egJ+\u0017/^3ti\")!P\u0003a\u0001Q\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u0002?\u000b\u0001\u0004y\u0012AD8gMN,G\u000fV8EK2,G/Z\u0001\u0019g\u0016tG\rR3mKR,'+Z2pe\u0012\u001c(+Z9vKN$HcA@\u0002\u0006A\u0019A/!\u0001\n\u0007\u0005\rQOA\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fgB|gn]3\t\r\u0005\u001d1\u00021\u0001t\u0003\u001d\u0011X-];fgR$Ra`A\u0006\u0003\u001bAa!a\u0002\r\u0001\u0004\u0019\bBBA\b\u0019\u0001\u0007q$\u0001\u0005mK\u0006$WM]%e\u0003-\u0001(o\u001c3vG\u0016$\u0015\r^1\u0015\r\u0005U\u0011\u0011GA$!\u0019\t9\"!\b\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\t\u0013AC2pY2,7\r^5p]&!\u0011qDA\r\u0005\r\u0019V-\u001d\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003!\u0001(o\u001c3vG\u0016\u0014(bAA\u0016Y\u000691\r\\5f]R\u001c\u0018\u0002BA\u0018\u0003K\u0011aBU3d_J$W*\u001a;bI\u0006$\u0018\rC\u0004\u000245\u0001\r!!\u000e\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004R!a\u000e\u0002B!tA!!\u000f\u0002>9\u0019!'a\u000f\n\u0003\tJ1!a\u0010\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0011\u0002F\tA\u0011\n^3sC\ndWMC\u0002\u0002@\u0005Ba!!\u0013\u000e\u0001\u0004y\u0012a\u00068v[6+7o]1hKN\u0004VM\u001d)beRLG/[8o\u0003y1\u0018\r\\5eCR,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$hi\u001c:U_BL7\rF\u0003+\u0003\u001f\n\t\u0006C\u0003{\u001d\u0001\u0007\u0001\u000eC\u0004\u0002T9\u0001\r!!\u0016\u0002'\u0015D\b/Z2uK\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0011\u0007\u0001\n9&C\u0002\u0002Z\u0005\u0012A\u0001T8oO\u0002")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final int TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private int TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteRecordsHappyCase(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)new StringBuilder(34).append("Unexpected lowWatermark received: ").append(partitionResult.lowWatermark()).toString());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidOffset(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, 0L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidTopic(String quorum) {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs(this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        Seq sendfutureList = (Seq)((Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), Seq$.MODULE$.canBuildFrom());
        producer.flush();
        Seq recordMetadataList = (Seq)sendfutureList.map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS), Seq$.MODULE$.canBuildFrom());
        recordMetadataList.foreach((Function1 & Serializable & scala.Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((TraversableLike)this.brokers().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return Option$.MODULE$.option2Iterable(qual$1.getLog(topicPartition, x$2));
        }, Buffer$.MODULE$.canBuildFrom())).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((AbstractLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 1000;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

