/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0006\r\u0001EAQA\u0006\u0001\u0005\u0002]Aq!\u0007\u0001C\u0002\u0013\u0005!\u0004\u0003\u0004.\u0001\u0001\u0006Ia\u0007\u0005\u0006]\u0001!\te\f\u0005\u0006y\u0001!\t%\u0010\u0005\u0006!\u0002!\t!\u0015\u0005\u0006-\u0002!\t!\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u0006?\u0002!I\u0001\u0019\u0005\by\u0002\t\n\u0011\"\u0003~\u0005i!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$H+Z:u\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\r\u0013\t)BBA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u0014\u0001\u0005Q!I]8lKJ$\u0016mZ:\u0016\u0003m\u0001B\u0001H\u0012&K5\tQD\u0003\u0002\u001f?\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003A\u0005\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\u001e\u0005\ri\u0015\r\u001d\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019\u0019FO]5oO\u0006Y!I]8lKJ$\u0016mZ:!\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u00021iA\u0011\u0011GM\u0007\u0002C%\u00111'\t\u0002\u0005+:LG\u000fC\u00036\t\u0001\u0007a'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\u000e\u001e\u000e\u0003aR!!O\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003wa\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\t\u0001d\bC\u0003@\u000b\u0001\u0007\u0001)\u0001\u0005uKN$\u0018J\u001c4p!\t\t%*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011q\tS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0013%\u0001\u0003+fgRLeNZ8)\u0005\u0015i\u0005CA!O\u0013\ty%I\u0001\u0006CK\u001a|'/Z#bG\"\fa\b^3ti\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgRLen\u00197vI&twm\u00117vgR,'/Q;uQ>\u0014\u0018N_3e\u001fB,'/\u0019;j_:\u001cH#\u0001\u0019)\u0005\u0019\u0019\u0006CA!U\u0013\t)&I\u0001\u0003UKN$\u0018A\u0010;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$X\t_2mk\u0012LgnZ\"mkN$XM]!vi\"|'/\u001b>fI>\u0003XM]1uS>t7\u000f\u000b\u0002\b'\u0006QB/Z:u\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR\u0011\u0001G\u0017\u0005\u00067\"\u0001\r\u0001X\u0001#S:\u001cG.\u001e3f\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0016$w\n]3sCRLwN\\:\u0011\u0005Ej\u0016B\u00010\"\u0005\u001d\u0011un\u001c7fC:\f!d]3oi\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$2!\u00197r!\t\u0011'.D\u0001d\u0015\t!W-\u0001\u0005sKF,Xm\u001d;t\u0015\t1w-\u0001\u0004d_6lwN\u001c\u0006\u0003\u001f!T!!\u001b%\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tY7MA\fEKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\u001c\bo\u001c8tK\")Q.\u0003a\u0001]\u00069!/Z9vKN$\bC\u00012p\u0013\t\u00018M\u0001\fEKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u\u0011\u001d\u0011\u0018\u0002%AA\u0002M\f1\u0002Z3ti&t\u0017\r^5p]B\u0019\u0011\u0007\u001e<\n\u0005U\f#AB(qi&|g\u000e\u0005\u0002xu6\t\u0001P\u0003\u0002z\u001d\u00059a.\u001a;x_J\\\u0017BA>y\u00051\u0019vnY6fiN+'O^3s\u0003\u0011\u001aXM\u001c;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T#\u0001@+\u0005M|8FAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0011%\u0001\u0006b]:|G/\u0019;j_:LA!a\u0004\u0002\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    private final scala.collection.immutable.Map<String, String> BrokerTags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}));

    public scala.collection.immutable.Map<String, String> BrokerTags() {
        return this.BrokerTags;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)this.BrokerTags().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(KafkaConfig$.MODULE$.BrokerTagsProp()).append(".").append(name).toString()), (Object)value);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava()));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Test
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(true);
    }

    @Test
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void var2_2;
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            DescribeClusterResponseData.DescribeClusterBroker broker = new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull(Predef$.MODULE$.$conforms()));
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$2(broker, name, value));
            Map map = Implicits$.MODULE$.MapExtensionMethods(this.BrokerTags());
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
        int expectedControllerId = ((KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$3(x$1)))).last()).config().brokerId();
        String expectedClusterId = ((KafkaServer)this.servers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()), Set$.MODULE$.canBuildFrom())).asJava())) : Integer.MIN_VALUE;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, this.sentDescribeClusterRequest$default$2());
            Assertions.assertEquals((int)expectedControllerId, (int)describeClusterResponse.data().controllerId());
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeClusterResponse.data().brokers()).asScala()).toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$2(DescribeClusterResponseData.DescribeClusterBroker broker$1, String name, String value) {
        return broker$1.tags().add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.TagKeyValue().setName(name).setValue(value));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$3(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

