/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler;
import kafka.server.DiskUsageBasedThrottlerTest$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import kafka.utils.TestUtils;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u001e=\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004R\u0001\u0001\u0006IA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\u0019\u0006\u0001)A\u0005\u001d\"9A\u000b\u0001b\u0001\n\u0013i\u0005BB+\u0001A\u0003%a\nC\u0004W\u0001\t\u0007I\u0011B,\t\r\u0019\u0004\u0001\u0015!\u0003Y\u0011\u001d9\u0007A1A\u0005\n5Ca\u0001\u001b\u0001!\u0002\u0013q\u0005bB5\u0001\u0005\u0004%I!\u0014\u0005\u0007U\u0002\u0001\u000b\u0011\u0002(\t\u000f-\u0004!\u0019!C\u0005Y\"1a\u0010\u0001Q\u0001\n5D\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u0013\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003C\u0004\u0001\u0015!\u0003\u0002.!Y\u00111\u001d\u0001A\u0002\u0003\u0007I\u0011BAs\u0011-\tI\u000f\u0001a\u0001\u0002\u0004%I!a;\t\u0017\u0005E\b\u00011A\u0001B\u0003&\u0011q\u001d\u0005\b\u0003g\u0004A\u0011AA@\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003\u007fBqA!\u0006\u0001\t\u0003\ty\bC\u0004\u0003 \u0001!\t!a \t\u000f\t\r\u0002\u0001\"\u0001\u0002\u0000!9!q\u0005\u0001\u0005\u0002\u0005}\u0004b\u0002B\u0016\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0005_\u0001A\u0011AA@\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003\u007fBqAa\u000e\u0001\t\u0003\ty\bC\u0004\u0003<\u0001!\t!a \t\u000f\t}\u0002\u0001\"\u0001\u0002\u0000!9!1\t\u0001\u0005\u0002\u0005}\u0004b\u0002B$\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0005\u0017\u0002A\u0011AA@\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003\u007fBqAa\u0015\u0001\t\u0003\ty\bC\u0004\u0003X\u0001!\t!a \t\u000f\tm\u0003\u0001\"\u0003\u0003^!I!Q\u000e\u0001\u0012\u0002\u0013%!qN\u0004\b\u0003ca\u0004\u0012AA\u001a\r\u0019YD\b#\u0001\u00026!1\u0001J\fC\u0001\u0003o1a!!\u000f/\u0001\u0005m\u0002B\u0002%1\t\u0003\t\u0019\u0005\u0003\u0006\u0002JA\u0012\r\u0011\"\u0015=\u0003\u0017B\u0001\"a\u00151A\u0003%\u0011Q\n\u0005\n\u0003+\u0002$\u0019!C\u0001\u0003/B\u0001\"!\u001c1A\u0003%\u0011\u0011\f\u0005\b\u0003_\u0002D\u0011IA9\u0011\u001d\ti\b\rC!\u0003\u007fBq!!!/\t\u0003\t\u0019\tC\u0005\u0002D:\n\n\u0011\"\u0001\u0002F\"I\u00111\u001c\u0018\u0012\u0002\u0013\u0005\u0011Q\u001c\u0002\u001c\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mKJ$Vm\u001d;\u000b\u0005ur\u0014AB:feZ,'OC\u0001@\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\n\u0005\u0002L\u00015\tA(\u0001\u0006uQJ|Wo\u001a5qkR,\u0012A\u0014\t\u0003\u0007>K!\u0001\u0015#\u0003\t1{gnZ\u0001\fi\"\u0014x.^4iaV$\b%A\u0005uQJ,7\u000f[8mI\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\u0002\u001b1\f'oZ3GS2,7+\u001b>f\u00039a\u0017M]4f\r&dWmU5{K\u0002\nq\u0001\\8h\t&\u00148/F\u0001Y!\rIFLX\u0007\u00025*\u00111\fR\u0001\u000bG>dG.Z2uS>t\u0017BA/[\u0005\r\u0019V-\u001d\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001\\1oO*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u0019\u0019FO]5oO\u0006AAn\\4ESJ\u001c\b%A\teK\u001a\fW\u000f\u001c;U_R\fGNQ=uKN\f!\u0003Z3gCVdG\u000fV8uC2\u0014\u0015\u0010^3tA\u0005\u0011\u0012N\\5uS\u0006dWk]1cY\u0016\u0014\u0015\u0010^3t\u0003MIg.\u001b;jC2,6/\u00192mK\nKH/Z:!\u0003)1\u0017\u000e\\3Ti>\u0014Xm]\u000b\u0002[B\u0019\u0011\f\u00188\u0011\u0005=\\hB\u00019y\u001d\t\thO\u0004\u0002sk6\t1O\u0003\u0002u\u0001\u00061AH]8pizJ\u0011aP\u0005\u0003oz\nQ!\u001e;jYNL!!\u001f>\u0002\u0013Q+7\u000f^+uS2\u001c(BA<?\u0013\taXP\u0001\fEKR,'/\\5oSN$\u0018n\u0019$jY\u0016\u001cFo\u001c:f\u0015\tI(0A\u0006gS2,7\u000b^8sKN\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\u0004A\u00191*!\u0002\n\u0007\u0005\u001dAH\u0001\u0010ESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7j]\u001e\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0005\u0005=\u0001\u0003BA\t\u0003Gi!!a\u0005\u000b\u0007]\f)B\u0003\u0003\u0002\u0018\u0005e\u0011AB2p[6|gNC\u0002@\u00037QA!!\b\u0002 \u00051\u0011\r]1dQ\u0016T!!!\t\u0002\u0007=\u0014x-\u0003\u0003\u0002&\u0005M!\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0005\u00055\u0002cAA\u0018a9\u00111*L\u0001\u001c\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mKJ$Vm\u001d;\u0011\u0005-s3C\u0001\u0018C)\t\t\u0019D\u0001\u0014UKN$\u0018M\u00197f\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mK2K7\u000f^3oKJ\u001cB\u0001\r\"\u0002>A\u00191*a\u0010\n\u0007\u0005\u0005CH\u0001\u0010ESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7f\u0019&\u001cH/\u001a8feR\u0011\u0011Q\t\t\u0004\u0003\u000f\u0002T\"\u0001\u0018\u0002\u0013E,x\u000e^1UsB,WCAA'!\rY\u0015qJ\u0005\u0004\u0003#b$!C)v_R\fG+\u001f9f\u0003)\tXo\u001c;b)f\u0004X\rI\u0001\bG>,h\u000e^3s+\t\tI\u0006\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\r\u0005$x.\\5d\u0015\u0011\t\u0019'!\u001a\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002h\t\fA!\u001e;jY&!\u00111NA/\u0005)\tEo\\7jG2{gnZ\u0001\tG>,h\u000e^3sA\u0005\u0011\u0002.\u00198eY\u0016$\u0015n]6Ta\u0006\u001cW\rT8x)\u0011\t\u0019(!\u001f\u0011\u0007\r\u000b)(C\u0002\u0002x\u0011\u0013A!\u00168ji\"1\u00111\u0010\u001cA\u00029\u000b\u0001dY1qa\u0016$\u0017+^8uC&s')\u001f;fgB+'oU3d\u0003aA\u0017M\u001c3mK\u0012K7o[*qC\u000e,'+Z2pm\u0016\u0014X\r\u001a\u000b\u0003\u0003g\nAbZ3u)\"\u0014x\u000e\u001e;mKJ$\"\"!\"\u0002\f\u00065\u0015QSA]!\rY\u0015qQ\u0005\u0004\u0003\u0013c$a\u0006#jg.,6/Y4f\u0005\u0006\u001cX\r\u001a+ie>$H\u000f\\3s\u0011!y\b\b%AA\u0002\u0005\r\u0001bBA\u0006q\u0001\u0007\u0011q\u0012\t\u0005\u0003#\t\t*\u0003\u0003\u0002\u0014\u0006M!\u0001\u0002+j[\u0016Dq!a&9\u0001\u0004\tI*\u0001\bn_\u000e\\g)\u001b7f'R|'/Z:\u0011\r\u0005m\u0015QUAU\u001d\u0011\ti*!)\u000f\u0007I\fy*C\u0001F\u0013\r\t\u0019\u000bR\u0001\ba\u0006\u001c7.Y4f\u0013\ri\u0016q\u0015\u0006\u0004\u0003G#\u0005\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u0005M&dWMC\u0002\u00024\n\f1A\\5p\u0013\u0011\t9,!,\u0003\u0013\u0019KG.Z*u_J,\u0007\"CA^qA\u0005\t\u0019AA_\u0003-a\u0017n\u001d;f]\u0016\u0014x\n\u001d;\u0011\u000b\r\u000by,!\u0010\n\u0007\u0005\u0005GI\u0001\u0004PaRLwN\\\u0001\u0017O\u0016$H\u000b\u001b:piRdWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0019\u0016\u0005\u0003\u0007\tIm\u000b\u0002\u0002LB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017!C;oG\",7m[3e\u0015\r\t)\u000eR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAm\u0003\u001f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y9W\r\u001e+ie>$H\u000f\\3sI\u0011,g-Y;mi\u0012\"TCAApU\u0011\ti,!3\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001\u0004;ie>$H\u000f\\3s\u001fB$XCAAt!\u0015\u0019\u0015qXAC\u0003A!\bN]8ui2,'o\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002t\u00055\b\"CAx/\u0005\u0005\t\u0019AAt\u0003\rAH%M\u0001\u000ei\"\u0014x\u000e\u001e;mKJ|\u0005\u000f\u001e\u0011\u0002\u000bM,G/\u001e9)\u0007e\t9\u0010\u0005\u0003\u0002z\n\u001dQBAA~\u0015\u0011\ti0a@\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u0002\t\r\u0011a\u00026va&$XM\u001d\u0006\u0005\u0005\u000b\ty\"A\u0003kk:LG/\u0003\u0003\u0003\n\u0005m(A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u001b\u0005\u001f\u0001B!!?\u0003\u0012%!!1CA~\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\tuKN$H)\u001a4bk2$8i\u001c8gS\u001eD3a\u0007B\r!\u0011\tIPa\u0007\n\t\tu\u00111 \u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$8i\u001c8gS\u001e\u0014VM[3diNLE\u000e\\3hC24\u0016\r\\;fg\"\u001aAD!\u0007\u0002?Q,7\u000f^\"p]\u001aLwMU3kK\u000e$8OT3hCRLg/\u001a,bYV,7\u000fK\u0002\u001e\u00053\t\u0011\u0005^3ti\u0016k\u0007\u000f^=M_\u001e$\u0015N]:ESN\f'\r\\3UQJ|G\u000f\u001e7j]\u001eD3A\bB\r\u0003Y!Xm\u001d;MSN$XM\\3s%\u0016<\u0017n\u001d;fe\u0016$\u0007fA\u0010\u0003\u001a\u00051B/Z:u\u0011\u0006tG\r\\3ESN\\7\u000b]1dK2{w\u000fK\u0002!\u00053\t\u0001\u0004^3ti\u000e\u000b\u0007OV1mk\u0016\u001cxJ\u001c'jgR,g.\u001a:tQ\r\t#\u0011D\u0001\u001di\u0016\u001cH\u000fS1oI2,G)[:l'B\f7-\u001a*fG>4XM]3eQ\r\u0011#\u0011D\u0001\u0017i\u0016\u001cH/T5o\t&\u001c8.V:bE2,')\u001f;fg\"\u001a1E!\u0007\u0002+Q,7\u000f^'j]\u0012K7o\u001b+pi\u0006d')\u001f;fg\"\u001aAE!\u0007\u0002'Q,7\u000f\u001e\"bg&\u001cG\u000b\u001b:piRd\u0017N\\4)\u0007\u0015\u0012I\"A\u0014uKN$H\u000b\u001b:pk\u001eD\u0007/\u001e;JgV\u0003H-\u0019;fI\u0012+(/\u001b8h)\"\u0014x\u000e\u001e;mS:<\u0007f\u0001\u0014\u0003\u001a\u0005IB/Z:u\u000b:\f'\r\\3GY\u0006<\u0017j\u001d*fgB,7\r^3eQ\r9#\u0011D\u0001\u0014i\u0016\u001cH\u000fV5nK&\u001b(+Z:qK\u000e$X\r\u001a\u0015\u0004Q\te\u0011A\u000e;fgR$\u0015n]6UQJ|G\u000f\u001e7j]\u001eL5/\u00138eKB,g\u000eZ3oi\u001a\u0013x.\u001c)s_\u0012,8-\u001a\"bG.\u0004(/Z:tkJ,\u0007fA\u0015\u0003\u001a\u0005QB/Z:u\u0003:LH*[:uK:,'/S:UQJ|G\u000f\u001e7fI\"\u001a!F!\u0007\u0002)]LG\u000f\u001b'be\u001e,g)\u001b7f/JLG\u000f^3o)\u0019\t\u0019Ha\u0018\u0003j!9!\u0011M\u0016A\u0002\t\r\u0014!B5o]\u0016\u0014\bCB\"\u0003f9\u000b\u0019(C\u0002\u0003h\u0011\u0013\u0011BR;oGRLwN\\\u0019\t\u0011\t-4\u0006%AA\u00029\u000b\u0001BZ5mKNK'0Z\u0001\u001fo&$\b\u000eT1sO\u00164\u0015\u000e\\3Xe&$H/\u001a8%I\u00164\u0017-\u001e7uII*\"A!\u001d+\u00079\u000bI\r")
public class DiskUsageBasedThrottlerTest {
    private final long throughput;
    private final long threshold;
    private final long largeFileSize;
    private final Seq<String> logDirs = new .colon.colon((Object)"/some/fileA", (List)new .colon.colon((Object)"/some/fileB", (List)Nil$.MODULE$));
    private final long defaultTotalBytes;
    private final long initialUsableBytes;
    private final Seq<TestUtils.DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores = new .colon.colon((Object)new TestUtils.DeterministicFileStore(this.defaultTotalBytes(), this.initialUsableBytes()), (List)new .colon.colon((Object)new TestUtils.DeterministicFileStore(this.defaultTotalBytes(), this.initialUsableBytes()), (List)Nil$.MODULE$));
    private final DiskUsageBasedThrottlingConfig config = DiskUsageBasedThrottlingConfig$.MODULE$.apply(this.threshold(), this.throughput(), this.logDirs(), true, 500L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
    private final MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime = new MockTime();
    private final TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener = new TestableDiskUsageBasedThrottleListener();
    private Option<DiskUsageBasedThrottler> throttlerOpt;

    public static Option<DiskUsageBasedThrottleListener> getThrottler$default$4() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4();
    }

    public static DiskUsageBasedThrottlingConfig getThrottler$default$1() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$1();
    }

    public static DiskUsageBasedThrottler getThrottler(DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig, Time time, Seq<FileStore> seq, Option<DiskUsageBasedThrottleListener> option) {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(diskUsageBasedThrottlingConfig, time, seq, option);
    }

    private long throughput() {
        return this.throughput;
    }

    private long threshold() {
        return this.threshold;
    }

    private long largeFileSize() {
        return this.largeFileSize;
    }

    private Seq<String> logDirs() {
        return this.logDirs;
    }

    private long defaultTotalBytes() {
        return this.defaultTotalBytes;
    }

    private long initialUsableBytes() {
        return this.initialUsableBytes;
    }

    public Seq<TestUtils.DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores;
    }

    private DiskUsageBasedThrottlingConfig config() {
        return this.config;
    }

    public MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime;
    }

    public TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$listener;
    }

    private Option<DiskUsageBasedThrottler> throttlerOpt() {
        return this.throttlerOpt;
    }

    private void throttlerOpt_$eq(Option<DiskUsageBasedThrottler> x$1) {
        this.throttlerOpt = x$1;
    }

    @BeforeEach
    public void setup() {
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)None$.MODULE$);
    }

    @AfterEach
    public void teardown() {
        this.throttlerOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DiskUsageBasedThrottlerTest.$anonfun$teardown$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.throttlerOpt().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.removeDiskThrottlerMetrics();
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultConfig() {
        DiskUsageBasedThrottlingConfig defaultConfig = DiskUsageBasedThrottlingConfig$.MODULE$.apply(DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$2(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertFalse((boolean)defaultConfig.enableDiskBasedThrottling());
        Assertions.assertEquals((long)0x500000000L, (long)defaultConfig.freeDiskThresholdBytes());
        Assertions.assertEquals((long)131072L, (long)defaultConfig.throttledProduceThroughput());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)defaultConfig.logDirs());
    }

    @Test
    public void testConfigRejectsIllegalValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(10L, 42L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testConfigRejectsNegativeValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(-10L, -42L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testEmptyLogDirsDisableThrottling() {
        Nil$ x$1 = Nil$.MODULE$;
        boolean x$2 = true;
        long x$3 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1();
        long x$4 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$2();
        long x$5 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5();
        double x$6 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6();
        boolean x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7();
        DiskUsageBasedThrottlingConfig configWithEmptyLogDirs = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$3, x$4, (Seq)x$1, x$2, x$5, x$6, x$7);
        Assertions.assertFalse((boolean)configWithEmptyLogDirs.enableDiskBasedThrottling());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configWithEmptyLogDirs.logDirs());
    }

    @Test
    public void testListenerRegistered() {
        TestableDiskUsageBasedThrottleListener newListener = new TestableDiskUsageBasedThrottleListener();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertTrue((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertFalse((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
    }

    @Test
    public void testHandleDiskSpaceLow() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceLow(this.throughput());
        Assertions.assertEquals((long)this.throughput(), (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    @Test
    public void testCapValuesOnListeners() {
        TestableDiskUsageBasedThrottleListener produceListener = new TestableDiskUsageBasedThrottleListener();
        TestableDiskUsageBasedThrottleListener followerListener = new TestableDiskUsageBasedThrottleListener(null){
            private final QuotaType quotaType;

            public QuotaType quotaType() {
                return this.quotaType;
            }
            {
                this.quotaType = QuotaType.FollowerReplication$.MODULE$;
            }
        };
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)followerListener);
        Predef$.MODULE$.println((Object)throttler.listenerManager().getListeners());
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testCapValuesOnListeners$1(this, throttler, produceListener, followerListener, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)followerListener);
    }

    @Test
    public void testHandleDiskSpaceRecovered() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceRecovered();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    @Test
    public void testMinDiskUsableBytes() {
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        long previousUsableSpaceBytes = throttler.minDiskUsableBytes();
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskUsableBytes$1(this, throttler, previousUsableSpaceBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testMinDiskTotalBytes() {
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        long existingTotalBytes = throttler.minDiskTotalBytes();
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskTotalBytes$1(throttler, existingTotalBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testBasicThrottling() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testBasicThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
    }

    @Test
    public void testThroughputIsUpdatedDuringThrottling() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testThroughputIsUpdatedDuringThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testEnableFlagIsRespected() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        boolean x$2 = false;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        long x$5 = this.config().copy$default$5();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, x$3, x$4, x$2, x$5, x$6, x$7), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testEnableFlagIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testTimeIsRespected() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$2 = 1000L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        boolean x$5 = this.config().copy$default$4();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, x$3, x$4, x$5, x$2, x$6, x$7), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testTimeIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testDiskThrottlingIsIndependentFromProduceBackpressure() {
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(BrokerBackpressureConfig$.MODULE$.apply$default$1(), BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        DiskUsageBasedThrottlingConfig x$2 = this.config();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        double x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$7();
        ClientQuotaManagerConfig quotaManagerConfig = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$2, x$5, x$6, x$7);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this, quotaManagerConfig){
            private final DiskThrottleListenerManager listenerManager;
            private final /* synthetic */ DiskUsageBasedThrottlerTest $outer;

            public Seq<FileStore> getFileStores() {
                return this.$outer.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(quotaManagerConfig$1, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)$outer.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), "someThread", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private final ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                    }
                };
                manager.registerListener((DiskUsageBasedThrottleListener)$outer.kafka$server$DiskUsageBasedThrottlerTest$$listener());
                this.listenerManager = var3_3;
            }
        };
        clientQuotaManager.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)clientQuotaManager));
        clientQuotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(this, clientQuotaManager, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        clientQuotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
    }

    @Test
    public void testAnyListenerIsThrottled() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testAnyListenerIsThrottled$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
    }

    private void withLargeFileWritten(Function1<Object, BoxedUnit> inner, long fileSize) {
        TestUtils.DeterministicFileStore fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        fileStore.writeLargeFile(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        inner.apply$mcVJ$sp(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        fileStore.deleteLargeFile(fileSize);
    }

    private long withLargeFileWritten$default$2() {
        return this.largeFileSize();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler x$1) {
        x$1.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
    }

    public static final /* synthetic */ void $anonfun$testCapValuesOnListeners$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$1, TestableDiskUsageBasedThrottleListener produceListener$1, TestableDiskUsageBasedThrottleListener followerListener$1, long x$3) {
        throttler$1.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)produceListener$1.counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$1.producerThrottleRate());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)followerListener$1.counter().get());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)throttler$1.followerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskUsableBytes$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$2, long previousUsableSpaceBytes$1, long fileSize) {
        long currentUsableBytes = throttler$2.minDiskUsableBytes();
        Assertions.assertEquals((long)(previousUsableSpaceBytes$1 - fileSize), (long)currentUsableBytes);
        Assertions.assertEquals((long)previousUsableSpaceBytes$1, (long)((TestUtils.DeterministicFileStore)$this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().apply(1)).getUsableSpace());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskTotalBytes$1(DiskUsageBasedThrottler throttler$3, long existingTotalBytes$1, long x$4) {
        long currentTotalBytes = throttler$3.minDiskTotalBytes();
        Assertions.assertEquals((long)existingTotalBytes$1, (long)currentTotalBytes);
    }

    public static final /* synthetic */ void $anonfun$testBasicThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$4, long x$6) {
        throttler$4.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$4.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$4.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testThroughputIsUpdatedDuringThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$5, long x$8) {
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$5.producerThrottleRate());
        long updatedThroughput = 10L * $this.throughput();
        DiskUsageBasedThrottlingConfig qual$1 = throttler$5.getCurrentDiskThrottlingConfig();
        long x$2 = qual$1.copy$default$1();
        Seq x$3 = qual$1.copy$default$3();
        boolean x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        double x$6 = qual$1.copy$default$6();
        boolean x$7 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig updatedConfig = qual$1.copy(x$2, updatedThroughput, x$3, x$4, x$5, x$6, x$7);
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        throttler$5.updateDiskThrottlingConfig(updatedConfig);
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)updatedThroughput, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)updatedThroughput, (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)updatedThroughput, (long)throttler$5.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testEnableFlagIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$6, long x$10) {
        throttler$6.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$6.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$6.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testTimeIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$7, long x$12) {
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$7.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$7.producerThrottleRate());
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(500L);
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$7.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(DiskUsageBasedThrottlerTest $this, ClientQuotaManager clientQuotaManager$1, long x$13) {
        clientQuotaManager$1.updateBrokerQuotaLimit($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)clientQuotaManager$1.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testAnyListenerIsThrottled$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$8, long x$15) {
        throttler$8.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertTrue((boolean)throttler$8.listenerManager().anyListenerIsThrottled());
    }

    public DiskUsageBasedThrottlerTest() {
        this.throughput = 65536L;
        this.threshold = 0x140000000L;
        this.largeFileSize = 0x300000000L;
        this.defaultTotalBytes = 0x500000000L;
        this.initialUsableBytes = 0x3C0000000L;
    }

    public static class TestableDiskUsageBasedThrottleListener
    implements DiskUsageBasedThrottleListener {
        private final QuotaType quotaType;
        private final AtomicLong counter;
        private final AtomicReference<Option<Object>> lastSignalledQuotaOptRef;

        public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
            return this.lastSignalledQuotaOptRef;
        }

        public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
            this.lastSignalledQuotaOptRef = x$1;
        }

        public QuotaType quotaType() {
            return this.quotaType;
        }

        public AtomicLong counter() {
            return this.counter;
        }

        public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
            this.counter().set(cappedQuotaInBytesPerSec);
        }

        public void handleDiskSpaceRecovered() {
            this.counter().set(Long.MAX_VALUE);
        }

        public TestableDiskUsageBasedThrottleListener() {
            DiskUsageBasedThrottleListener.$init$((DiskUsageBasedThrottleListener)this);
            this.quotaType = QuotaType.Produce$.MODULE$;
            this.counter = new AtomicLong(Long.MAX_VALUE);
        }
    }
}

