/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.admin.BrokerMetadata;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicDurabilityAuditConfig;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicLoginContext;
import kafka.server.DynamicLoginManager;
import kafka.server.DynamicThreadPool;
import kafka.server.DynamicTransactionCoordinator;
import kafka.server.DynamicZkControllerConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.server.TestQuotaCallback;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011CQa\u0012\u0001\u0005\u0002!CQ!\u0017\u0001\u0005\u0002!CQA\u0018\u0001\u0005\u0002!CQ\u0001\u0019\u0001\u0005\u0002!CQA\u0019\u0001\u0005\u0002!CQ\u0001\u001a\u0001\u0005\u0002!CQA\u001a\u0001\u0005\u0002!CQ\u0001\u001b\u0001\u0005\u0002!CQA\u001b\u0001\u0005\u0002!CQ\u0001\u001c\u0001\u0005\u0002!CQA\u001c\u0001\u0005\u0002!CQ\u0001\u001d\u0001\u0005\u0002!CQA\u001d\u0001\u0005\u0002!CQ\u0001\u001e\u0001\u0005\u0002!CQA\u001e\u0001\u0005\u0002!CQ\u0001\u001f\u0001\u0005\u0002!CQA\u001f\u0001\u0005\u0002!CQ\u0001 \u0001\u0005\u0002!CQA \u0001\u0005\u0002!Ca!!\u0001\u0001\t\u0003A\u0005BBA\u0003\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002\n\u0001!\t\u0001\u0013\u0005\u0007\u0003\u001b\u0001A\u0011\u0001%\t\r\u0005E\u0001\u0001\"\u0001I\u0011\u0019\t)\u0002\u0001C\u0001\u0011\"1\u0011\u0011\u0004\u0001\u0005\u0002!Cq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002^\u0001!I!a\u0018\t\r\u0005=\u0005\u0001\"\u0001I\u0011\u0019\t\u0019\n\u0001C\u0001\u0011\"1\u0011q\u0013\u0001\u0005\u0002!Ca!a'\u0001\t\u0003A\u0005BBAP\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002$\u0002!\t\u0001\u0013\u0005\u0007\u0003O\u0003A\u0011\u0001%\t\r\u0005-\u0006\u0001\"\u0001I\u0011\u0019\ty\u000b\u0001C\u0001\u0011\"1\u00111\u0017\u0001\u0005\u0002!Ca!a.\u0001\t\u0003A\u0005BBA^\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002@\u0002!\t\u0001\u0013\u0005\u0007\u0003\u0007\u0004A\u0011\u0001%\t\r\u0005\u001d\u0007\u0001\"\u0001I\u0011\u0019\tY\r\u0001C\u0001\u0011\"1\u0011q\u001a\u0001\u0005\u0002!Ca!a5\u0001\t\u0003A\u0005bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\u0007\u0003G\u0004A\u0011\u0001%\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u00111 \u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005O\u0011q\u0003R=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e$Vm\u001d;\u000b\u0005aJ\u0014AB:feZ,'OC\u0001;\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\t\u0005\u0002G\u00015\tq'\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005I\u0005C\u0001 K\u0013\tYuH\u0001\u0003V]&$\bF\u0001\u0002N!\tqu+D\u0001P\u0015\t\u0001\u0016+A\u0002ba&T!AU*\u0002\u000f),\b/\u001b;fe*\u0011A+V\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002-\u0006\u0019qN]4\n\u0005a{%!C!gi\u0016\u0014X)Y2i\u0003A!Xm\u001d;D_:4\u0017nZ+qI\u0006$X\r\u000b\u0002\u00047B\u0011a\nX\u0005\u0003;>\u0013A\u0001V3ti\u0006!C/Z:u)J\fgn]1di&|gNV3sE>\u001c\u0018\u000e^=D_:4\u0017nZ+qI\u0006$X\r\u000b\u0002\u00057\u0006yC/Z:u)J\fgn]1di&|g\u000eT8hO&twMV3sE>\u001c\u0018\u000e^=D_:4\u0017n\u001a,bY&$\u0017\r^5p]\"\u0012QaW\u0001\u001ai\u0016\u001cH\u000fR;sC\nLG.\u001b;z\u0003V$\u0017\u000e^\"p]\u001aLw\r\u000b\u0002\u00077\u0006\u0011D/Z:u)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;D_:4\u0017nZ+qI\u0006$X\r\u000b\u0002\b7\u0006\u0019C/Z:u\u000b2Lw-\u001b2mK\u000e{g\u000e\u001e:pY2,'o]\"p]\u001aLw-\u00169eCR,\u0007F\u0001\u0005\\\u0003\u001d\"Xm\u001d;FY&<\u0017N\u00197f\u0007>tGO]8mY\u0016\u00148oQ8oM&<g+\u00197jI\u0006$\u0018n\u001c8)\u0005%Y\u0016A\n;fgR,e.\u00192mK\u0012+g-Y;miVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012!bW\u0001\u001ci\u0016\u001cH/\u00169eCR,G)\u001f8b[&\u001cG\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005-Y\u0016A\n;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bnU8nK&sg/\u00197jI\u000e{gNZ5hg\"\u0012AbW\u00014i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016D#!D.\u00029Q,7\u000f\u001e*fG>tg-[4ve\u0006\u0014G.\u001a,bY&$\u0017\r^5p]\"\u0012abW\u0001\u0014i\u0016\u001cHoU3dkJLG/_\"p]\u001aLwm\u001d\u0015\u0003\u001fm\u000b1\u0003^3ti\u000e{gN\\3di&|g.U;pi\u0006D#\u0001E.\u0002EQ,7\u000f^*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8UQJ|G\u000f\u001e7fe\u000e{gNZ5hQ\t\t2,\u0001\u0016uKN$H+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0007>tg-[4)\u0005IY\u0016a\u0005;fgR$\u0016.\u001a:UCN\\7oQ8oM&<\u0007FA\n\\\u0003M!Xm\u001d;CC2\fgnY3s\u0007>tg-[4tQ\t!2,A\u0012uKN$()\u00197b]\u000e,'OV1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8)\u0005UY\u0016a\n;fgR\u0014\u0015\r\\1oG\u0016\u0014(+Z2p]\u001aLw-\u001e:f\u001d\u0016<\u0017\r^5wKRC'o\u001c;uY\u0016D#AF.\u0002/Q,7\u000f^\"p]:,7\r^5p]J\u000bG/Z)v_R\f\u0007FA\f\\\u0003q!Xm\u001d;D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018M\u00127p_JD#\u0001G.\u0002'Q,7\u000f^)v_R\fW*\u001e7uSBd\u0017.\u001a:)\u0005eY\u0016\u0001\u0006;fgR,6/\u001a:Rk>$\u0018m]#oC\ndW\r\u000b\u0002\u001b7\u00061B/Z:u\tft\u0017-\\5d#V|G/Y#oC\ndW\r\u000b\u0002\u001c7\u0006\u0011b/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f)%I\u0015\u0011EA\u001e\u0003\u001f\nI\u0006C\u0004\u0002$q\u0001\r!!\n\u0002\t9\fW.\u001a\t\u0005\u0003O\t)D\u0004\u0003\u0002*\u0005E\u0002cAA\u0016\u007f5\u0011\u0011Q\u0006\u0006\u0004\u0003_Y\u0014A\u0002\u001fs_>$h(C\u0002\u00024}\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001c\u0003s\u0011aa\u0015;sS:<'bAA\u001a\u007f!9\u0011Q\b\u000fA\u0002\u0005}\u0012!\u0002<bYV,\u0007\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\r=\u0013'.Z2u\u0011\u001d\t\t\u0006\ba\u0001\u0003'\nq\u0002]3s\u0005J|7.\u001a:D_:4\u0017n\u001a\t\u0004}\u0005U\u0013bAA,\u007f\t9!i\\8mK\u0006t\u0007bBA.9\u0001\u0007\u00111K\u0001\u000eKb\u0004Xm\u0019;GC&dWO]3\u0002GY,'/\u001b4z\u0007>tg-[4Va\u0012\fG/Z,ji\"LeN^1mS\u0012\u001cuN\u001c4jORI\u0011*!\u0019\u0002l\u0005m\u00141\u0012\u0005\b\u0003Gj\u0002\u0019AA3\u0003\u0019\u0019wN\u001c4jOB\u0019a)a\u001a\n\u0007\u0005%tGA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBA7;\u0001\u0007\u0011qN\u0001\n_JLw\r\u0015:paN\u0004B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0005\u0003k\n9%\u0001\u0003vi&d\u0017\u0002BA=\u0003g\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\ti(\ba\u0001\u0003\u007f\n!B^1mS\u0012\u0004&o\u001c9t!!\t\t)a\"\u0002&\u0005\u0015RBAAB\u0015\r\t)iP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAE\u0003\u0007\u00131!T1q\u0011\u001d\ti)\ba\u0001\u0003\u007f\nA\"\u001b8wC2LG\r\u0015:paN\fA\u0004^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7M]=qi&|g\u000e\u000b\u0002\u001f7\u0006)C/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001cw\u000eZ3s'\u0016\u001c'/\u001a;DQ\u0006tw-\u001a\u0015\u0003?m\u000b\u0011\u0004^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c4jO\"\u0012\u0001eW\u0001\u0015i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s\u0007>tg-[4)\u0005\u0005Z\u0016\u0001\u0006;fgRDE\u000f\u001e9TKJ4XM]\"p]\u001aLw\r\u000b\u0002#7\u0006aA/Z:u'ftwN\\=ng\"\u00121eW\u00012i\u0016\u001cH\u000fR=oC6L7mQ8oM&<\u0017J\\5uS\u0006d\u0017N_1uS>tw+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0018J\u001c.LQ\t!3,\u0001\u001auKN$8i\u001c8gS\u001e,(/\u001a3J]N$\u0018M\\2f\u0013:LG/[1mSj,GmV5uQ\u0012Kh.Y7jG\u000e{gNZ5hQ\t)3,A\u0013uKN$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014h)\u001a;dQ6\u000b\u0007PQ=uKN\u001c\u0005.\u00198hK\"\u0012aeW\u0001 i\u0016\u001cH\u000fR=oC6L7\r\u0015:pIV\u001cWM]!dWN|e/\u001a:sS\u0012,\u0007FA\u0014\\\u0003Q\"Xm\u001d;SKBd\u0017nY1NC:\fw-\u001a:US\u0016\u0014X*\u0019=QCJ$\u0018\u000e^5p]\u001a+Go\u00195CsR,7o\u0014<feJLG-\u001a\u0015\u0003Qm\u000bQ\u0004^3ti&k\u0007O]8qKJ\u001cuN\u001c4jON\f%/\u001a*f[>4X\r\u001a\u0015\u0003Sm\u000bA\u0003^3ti\u000ec\u0017.\u001a8u\u0015\u0006\f7oQ8oM&<\u0007F\u0001\u0016\\\u0003U!Xm\u001d;M_\u001eLgnQ8oM&<7\t[1oO\u0016D#aK.\u0002cQ,7\u000f^*bg2\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8XSRD\u0007K]3gSb,Gm\u0011:fI\u0016tG/[1mg\"\u0012AfW\u00014i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\",f\u000e\u001d:fM&DX\rZ\"sK\u0012,g\u000e^5bYND#!L.\u0002]Q,7\u000f^*bg2\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8XSRD7\u000b[1sK\u0012T\u0015-Y:D_:4\u0017n\u001a\u0015\u0003]m\u000ba\u0003^3ti:+woU1tY\u000e\u0013X\rZ3oi&\fGn\u001d\u0015\u0003_m\u000b\u0001D^3sS\u001aL8I]3eK:$\u0018.\u00197S_R\fG/[8o)\u0015I\u00151\\Ap\u0011\u001d\ti\u000e\ra\u0001\u0003K\ta\"^:fe:\fW.Z\"p]\u001aLw\rC\u0004\u0002bB\u0002\r!!\n\u0002\u001dA\f7o]<pe\u0012\u001cuN\u001c4jO\u0006YC/Z:u\r&dWMQ1tK\u0012dunZ5o\u001d>$\b*\u00198eY\u0016$\u0017i\u001d#z]\u0006l\u0017nY\"p]\u001aLw\r\u000b\u000227\u0006Q2.\u00194lCB\u0013x\u000e]:XSRDG)\u001f8b[&\u001cGj\\4j]RA\u0011qNAv\u0003[\fy\u000fC\u0004\u0002^J\u0002\r!!\n\t\u000f\u0005\u0005(\u00071\u0001\u0002&!I\u0011\u0011\u001f\u001a\u0011\u0002\u0003\u0007\u00111_\u0001\u000fa2,x-\u001b8Qe\u00164\u0017\u000e_3t!\u0019\t\t)!>\u0002&%!\u0011q_AB\u0005\r\u0019V\r^\u0001%W\u000647.\u0019)s_B\u001cx+\u001b;i\tft\u0017-\\5d\u0019><\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q \u0016\u0005\u0003g\fyp\u000b\u0002\u0003\u0002A!!1\u0001B\u0007\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011!C;oG\",7m[3e\u0015\r\u0011YaP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\b\u0005\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005\u001a'/Z1uK.\u000bgm[1D_:4\u0017nZ,ji\"$\u0015P\\1nS\u000edunZ5o)\u0011\u0011)B!\t\u0011\u000fy\u00129\"!\u001a\u0003\u001c%\u0019!\u0011D \u0003\rQ+\b\u000f\\33!\r1%QD\u0005\u0004\u0005?9$a\u0005#z]\u0006l\u0017n\u0019'pO&tW*\u00198bO\u0016\u0014\bb\u0002B\u0012i\u0001\u0007\u0011qN\u0001\u0006aJ|\u0007o]\u0001\u0011m\u0016\u0014\u0018NZ=De\u0016$WM\u001c;jC2$r!\u0013B\u0015\u0005g\u00119\u0004C\u0004\u0003,U\u0002\rA!\f\u0002\u000f\r|g\u000e^3yiB\u0019aIa\f\n\u0007\tErGA\nEs:\fW.[2M_\u001eLgnQ8oi\u0016DH\u000fC\u0004\u00036U\u0002\r!!\n\u0002\u0011U\u001cXM\u001d8b[\u0016DqA!\u000f6\u0001\u0004\t)#\u0001\u0005qCN\u001cxo\u001c:e\u0001")
public class DynamicBrokerConfigTest {
    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testTransactionVerbosityConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "1");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)config.confluentConfig().transactionLoggingVerbosity());
        ((TransactionCoordinator)Mockito.verify((Object)txnCoordinatorMock)).setLoggingVerbosity(1);
    }

    @Test
    public void testTransactionLoggingVerbosityConfigValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "-11");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
    }

    @Test
    public void testDurabilityAuditConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)"PeriodicalAudit,ChecksumAudit", (Object)config.confluentConfig().auditConfigChecks());
        KafkaBroker kafkaBrokerMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DynamicDurabilityAuditConfig dynamicDurabilityAuditConfig = new DynamicDurabilityAuditConfig(kafkaBrokerMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicDurabilityAuditConfig);
        Properties props = new Properties();
        props.put("confluent.durability.audit.checks", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((Object)"", (Object)config.confluentConfig().auditConfigChecks());
    }

    @Test
    public void testTierPartitionStateMetadataSnapshotConfigUpdate() {
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.enable", Boolean.toString(true), true, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.enable", Boolean.toString(true), false, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.enable", Boolean.toString(false), true, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.enable", Boolean.toString(false), false, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.interval.ms", Long.toString(Duration.ofHours(1L).toMillis()), true, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.interval.ms", Long.toString(Duration.ofHours(1L).toMillis()), false, false);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.interval.ms", "-1", true, true);
        this.verifyConfigUpdate("confluent.tier.metadata.snapshots.interval.ms", "-1", false, true);
    }

    @Test
    public void testEligibleControllersConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)scala.collection.Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)None$.MODULE$), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$), (List)Nil$.MODULE$)));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
        Mockito.reset((Object[])new KafkaController[]{controllerMock});
        Assertions.assertEquals((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)config.confluentConfig().eligibleControllers());
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)scala.collection.Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)scala.collection.Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
    }

    @Test
    public void testEligibleControllersConfigValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)None$.MODULE$), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$), (List)Nil$.MODULE$)));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0,1");
        config.dynamicConfig().validate(props, false);
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        props.put("confluent.eligible.controllers", "1,2,3");
        config.dynamicConfig().validate(props, false);
        props.put("confluent.eligible.controllers", "2,3");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().validate(props, false);
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        int x$12 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn((Object)Iterable$.MODULE$.empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(LogConfig$.MODULE$.apply());
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Map validProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        Map securityPropsWithoutListenerPrefix = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)securityPropsWithoutListenerPrefix);
        Map nonDynamicProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)nonDynamicProps);
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        Map excludedTopicConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Map$.MODULE$.empty();
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        Set invalidReconfigurableProps = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(validReconfigurableProps));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testSegmentDeletionThrottlerConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "100", true, false);
    }

    @Test
    public void testTierDeletedPartitionsCoordinatorConfig() {
        ((IterableLike)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), KafkaConfig$.MODULE$.TierTopicDeleteMaxInprogressPartitionsProp(), KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp()}))).foreach((Function1 & Serializable & scala.Serializable)config -> {
            DynamicBrokerConfigTest.$anonfun$testTierDeletedPartitionsCoordinatorConfig$1(this, config);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTierTasksConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", false, false);
    }

    @Test
    public void testBalancerConfigs() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", "200", false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", Boolean.toString(true), false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", "PAUSED", false, true);
    }

    @Test
    public void testBalancerValidateReconfiguration() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("confluent.balancer.throttle.bytes.per.second", "200");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        new DynamicBalancerConfig((KafkaBroker)kafkaServer).validateReconfiguration(newConfig);
    }

    @Test
    public void testBalancerReconfigureNegativeThrottle() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_AUTO_THROTTLE.toString(), false, false);
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_MIN.toString(), false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    @Test
    public void testConnectionRateQuotaFloor() {
        String listenerMaxConnectionCreationFloorProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "30", false, false);
    }

    @Test
    public void testQuotaMultiplier() {
        String produceMultiplierProp = "confluent.quota.tenant.produce.multiplier";
        this.verifyConfigUpdate(produceMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(produceMultiplierProp, "2.0", false, false);
        String fetchMultiplierProp = "confluent.quota.tenant.fetch.multiplier";
        this.verifyConfigUpdate(fetchMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "2.0", false, false);
        this.verifyConfigUpdate(produceMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(fetchMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(produceMultiplierProp, "1.0", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "1.0", true, false);
    }

    @Test
    public void testUserQuotasEnable() {
        this.verifyConfigUpdate("confluent.quota.tenant.user.quotas.enable", Boolean.toString(true), false, false);
    }

    @Test
    public void testDynamicQuotaEnable() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(true), false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(false), false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, Map<String, String> validProps, Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = props.put(k, v);
            return object;
        });
        invalidProps.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            Object object = props.put(k, v);
            return object;
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2()));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2())));
    }

    @Test
    public void testAuthorizerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext x$1, java.util.List<AclBinding> x$2, Optional<String> x$3) {
                return super.createAcls(x$1, x$2, x$3);
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext x$1, java.util.List<AclBindingFilter> x$2, Optional<String> x$3) {
                return super.deleteAcls(x$1, x$2, x$3);
            }

            public int aclCount() {
                return super.aclCount();
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
                return super.authorizeByResourceType(x$1, x$2, x$3);
            }

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava();
            }

            public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        Assertions.assertThrows(Throwable.class, () -> kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer));
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testHttpServerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1
        implements KafkaHttpServer,
        Reconfigurable {
            private volatile String foobar;

            public boolean isNew() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStarting() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isRunning() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStopping() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isTerminated() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isFailed() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void start() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void stop() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public Optional<Throwable> getError() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStarted() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStarted(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStopped() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStopped(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public String foobar() {
                return this.foobar;
            }

            public void foobar_$eq(String x$1) {
                this.foobar = x$1;
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo.bar"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.foobar_$eq(configs.get("foo.bar").toString());
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(DynamicBrokerConfigTest $outer) {
                this.foobar = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1 httpServer = new Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.httpServer()).thenReturn((Object)new Some((Object)httpServer));
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("foo.bar", "fozbaz");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"fozbaz", (Object)httpServer.foobar());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testConfiguredInstanceInitializedWithDynamicConfig() {
        String quotaProp = "quota";
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(quotaProp, "static_quota");
        props.put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestQuotaCallback.class.getName());
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties updatedProps = new Properties();
        updatedProps.put(quotaProp, "dynamic_quota");
        config.dynamicConfig().updateDefaultConfig(updatedProps, config.dynamicConfig().updateDefaultConfig$default$2());
        ClientQuotaCallback quotaCallback = (ClientQuotaCallback)config.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class);
        Assertions.assertEquals((Object)"dynamic_quota", (Object)((TestQuotaCallback)quotaCallback).defaultQuota());
    }

    @Test
    public void testReplicaManagerFetchMaxBytesChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "2048");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048), config.values().get(KafkaConfig$.MODULE$.FetchMaxBytes()));
    }

    @Test
    public void testDynamicProducerAcksOverride() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.ProducerMinAcksProp(), "0");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.ProducerMinAcksProp(), "-1");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToShort((short)-1), config.values().get(KafkaConfig$.MODULE$.ProducerMinAcksProp()));
    }

    @Test
    public void testReplicaManagerTierMaxPartitionFetchBytesOverride() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "1024000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "2048000");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048000), config.values().get(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)Defaults$.MODULE$.MessageMaxBytes(), (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientJaasConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("sasl.jaas.config"));
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("listener.name.sasl_ssl.sasl.jaas.config"));
        Assertions.assertTrue((boolean)var3_3.isClientSaslJaasConfig("test.dynamic.login.sasl.jaas.config"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoginConfigChange() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        DynamicLoginContext context = (DynamicLoginContext)var3_3.reconfigurableContexts().head();
        HashMap<String, String> oldConfigs = new HashMap<String, String>();
        HashMap<String, String> newConfigs = new HashMap<String, String>();
        oldConfigs.put("test.dynamic.login.username", "alice");
        oldConfigs.put("test.dynamic.login.password", "alice-password");
        newConfigs.put("test.dynamic.login.username", "alice");
        newConfigs.put("test.dynamic.login.password", "alice-password");
        Assertions.assertFalse((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertFalse((boolean)context.needsReconfigure(Collections.emptyMap(), Collections.emptyMap()));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.emptyMap(), newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.emptyMap()));
        newConfigs.put("test.dynamic.login.password", "alice-new-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        newConfigs.put("test.dynamic.login.username", "bob");
        newConfigs.put("test.dynamic.login.password", "bob-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.singletonMap("test.dynamic.login.username", "alice")));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.singletonMap("test.dynamic.login.username", "alice"), newConfigs));
    }

    @Test
    public void testSaslCredentialRotationWithPrefixedCredentials() {
        this.verifyCredentialRotation("test.dynamic.login.username", "test.dynamic.login.password");
    }

    @Test
    public void testSaslCredentialRotationWithUnprefixedCredentials() {
        this.verifyCredentialRotation("login.username", "login.password");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSaslCredentialRotationWithSharedJaasConfig() {
        void var7_7;
        void var6_6;
        String usernameConfig = "login.username";
        String passwordConfig = "login.password";
        Set pluginPrefixes = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test.plugin1.", "test.plugin2."}));
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, (Set<String>)pluginPrefixes);
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var6_6;
        void dynamicLogin2 = var7_7;
        Set credentialConfigs = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)dynamicLogin2.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)2, (int)dynamicLogin2.reconfigurableContexts().size());
        scala.collection.mutable.Set contexts = dynamicLogin2.reconfigurableContexts();
        Assertions.assertEquals((Object)pluginPrefixes, (Object)((TraversableOnce)contexts.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.prefix(), Set$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)pluginPrefixes.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(16).append((String)x$4).append("sasl.jaas.config").toString(), scala.collection.Set$.MODULE$.canBuildFrom()), (Object)contexts.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.saslJaasConfigName(), Set$.MODULE$.canBuildFrom()));
        contexts.foreach((Function1 & Serializable & scala.Serializable)context -> {
            DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(this, credentialConfigs, context);
            return BoxedUnit.UNIT;
        });
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$2((KafkaConfig)config2, dynamicProps);
        contexts.foreach((Function1 & Serializable & scala.Serializable)context -> {
            this.verifyCredential(context, "alice", "alice-new-password");
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(this, dynamicProps, usernameConfig, passwordConfig, contexts, (KafkaConfig)config2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewSaslCredentials() {
        void var4_4;
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var3_3;
        void dynamicLogin2 = var4_4;
        this.verifyCredential((DynamicLoginContext)dynamicLogin2.reconfigurableContexts().head(), "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty("test.another.login.security.protocol", "SASL_PLAINTEXT");
        dynamicProps.setProperty("test.another.login.sasl.mechanism", "PLAIN");
        dynamicProps.setProperty("test.another.login.username", "another");
        dynamicProps.setProperty(new StringBuilder(35).append("test.another.login.").append("sasl.jaas.config").toString(), new StringBuilder(64).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"username\" password_config=\"password\";").toString());
        dynamicProps.setProperty(new StringBuilder(52).append("test.another.login.").append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        dynamicProps.setProperty("test.another.login.password", "another-password");
        DynamicBrokerConfigTest.updateConfig$3((KafkaConfig)config2, dynamicProps);
        Assertions.assertEquals((int)2, (int)dynamicLogin2.reconfigurableContexts().size());
        DynamicLoginContext oldContext = (DynamicLoginContext)((IterableLike)dynamicLogin2.reconfigurableContexts().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$1(x$8)))).head();
        this.verifyCredential(oldContext, "alice", "alice-password");
        DynamicLoginContext newContext = (DynamicLoginContext)((IterableLike)dynamicLogin2.reconfigurableContexts().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$2(x$9)))).head();
        this.verifyCredential(newContext, "another", "another-password");
        dynamicProps.remove("test.another.login.password");
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$3((KafkaConfig)config2, dynamicProps)), ClassTag$.MODULE$.apply(ConfigException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCredentialRotation(String usernameConfig, String passwordConfig) {
        void var6_6;
        void var5_5;
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty("test.static.login.security.protocol", "SASL_SSL");
        props.setProperty("test.static.login.sasl.mechanism", "PLAIN");
        props.setProperty(new StringBuilder(34).append("test.static.login.").append("sasl.jaas.config").toString(), new StringBuilder(55).append(PlainLoginModule.class.getName()).append(" required username=\"static\" password=\"static-password\";").toString());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var5_5;
        void dynamicLogin2 = var6_6;
        Set credentialConfigs = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)dynamicLogin2.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)1, (int)dynamicLogin2.reconfigurableContexts().size());
        DynamicLoginContext context = (DynamicLoginContext)dynamicLogin2.reconfigurableContexts().head();
        Assertions.assertEquals((Object)"test.dynamic.login.", (Object)context.prefix());
        Assertions.assertEquals((Object)"test.dynamic.login.sasl.jaas.config", (Object)context.saslJaasConfigName());
        Assertions.assertEquals((Object)credentialConfigs, (Object)context.dynamicConfigs());
        this.verifyCredential(context, "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$4((KafkaConfig)config2, dynamicProps);
        this.verifyCredential(context, "alice", "alice-new-password");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$verifyCredentialRotation$1(this, dynamicProps, usernameConfig, passwordConfig, context, (KafkaConfig)config2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFileBasedLoginNotHandledAsDynamicConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty(new StringBuilder(35).append("test.dynamic.login.").append("sasl.jaas.config").toString(), new StringBuilder(50).append(DynamicPlainLoginModule.class.getName()).append(" required credentials_path=\"/tmp/credentials.txt\";").toString());
        props.setProperty(new StringBuilder(52).append("test.dynamic.login.").append("sasl.login.callback.handler.class").toString(), FileBasedDynamicPlainLoginCallbackHandler.class.getName());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertEquals((Object)scala.collection.Set$.MODULE$.empty(), (Object)var3_3.reconfigurableContexts());
    }

    private Properties kafkaPropsWithDynamicLogin(String usernameConfig, String passwordConfig, Set<String> pluginPrefixes) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
        props.setProperty(usernameConfig, "alice");
        props.setProperty(passwordConfig, "alice-password");
        pluginPrefixes.foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            props.setProperty(new StringBuilder(17).append((String)prefix).append("security.protocol").toString(), "SASL_SSL");
            props.setProperty(new StringBuilder(14).append((String)prefix).append("sasl.mechanism").toString(), "PLAIN");
            props.setProperty(new StringBuilder(16).append((String)prefix).append("sasl.jaas.config").toString(), new StringBuilder(48).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"").append(usernameConfig).append("\" password_config=\"").append(passwordConfig).append("\";").toString());
            return props.setProperty(new StringBuilder(33).append((String)prefix).append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        });
        return props;
    }

    private Set<String> kafkaPropsWithDynamicLogin$default$3() {
        return (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test.dynamic.login."}));
    }

    private Tuple2<KafkaConfig, DynamicLoginManager> createKafkaConfigWithDynamicLogin(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        config.dynamicConfig().initialize((Option)new Some((Object)zkClient));
        return new Tuple2((Object)config, (Object)config.dynamicConfig().dynamicLoginManager());
    }

    private void verifyCredential(DynamicLoginContext context, String username, String password) {
        Assertions.assertEquals((Object)new DynamicPlainCredential(username, password.toCharArray()), (Object)context.loginManager().subject().getPrivateCredentials().iterator().next());
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new Reconfigurable(null, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(null, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    public static final /* synthetic */ void $anonfun$testTierDeletedPartitionsCoordinatorConfig$1(DynamicBrokerConfigTest $this, String config) {
        $this.verifyConfigUpdate(config, "-1", true, true);
        $this.verifyConfigUpdate(config, "-1", false, true);
        $this.verifyConfigUpdate(config, "0", true, true);
        $this.verifyConfigUpdate(config, "0", false, true);
        $this.verifyConfigUpdate(config, "10000", false, false);
        $this.verifyConfigUpdate(config, "20000", true, false);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$5, Properties props$3) {
        if (perBrokerConfig$1) {
            config$5.dynamicConfig().updateBrokerConfig(0, config$5.dynamicConfig().toPersistentProps(props$3, perBrokerConfig$1), config$5.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$5.dynamicConfig().updateDefaultConfig(props$3, config$5.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$6, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$6.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$6, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$6.originals().get(name));
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(DynamicBrokerConfigTest $this, Set credentialConfigs$1, DynamicLoginContext context) {
        Assertions.assertEquals((Object)credentialConfigs$1, (Object)context.dynamicConfigs());
        $this.verifyCredential(context, "alice", "alice-password");
    }

    private static final void updateConfig$2(KafkaConfig config$7, Properties dynamicProps$1) {
        config$7.dynamicConfig().updateBrokerConfig(0, config$7.dynamicConfig().toPersistentProps(dynamicProps$1, true), config$7.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(DynamicBrokerConfigTest $this, Properties dynamicProps$1, String usernameConfig$1, String passwordConfig$1, scala.collection.mutable.Set contexts$1, KafkaConfig config$7, int x$6) {
        dynamicProps$1.setProperty(usernameConfig$1, "bob");
        dynamicProps$1.setProperty(passwordConfig$1, "bob-password");
        DynamicBrokerConfigTest.updateConfig$2(config$7, dynamicProps$1);
        contexts$1.foreach((Function1 & Serializable & scala.Serializable)context -> {
            $this.verifyCredential(context, "bob", "bob-password");
            return BoxedUnit.UNIT;
        });
    }

    private static final void updateConfig$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().updateBrokerConfig(0, config$8.dynamicConfig().toPersistentProps(dynamicProps$2, true), config$8.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$1(DynamicLoginContext x$8) {
        String string = x$8.saslJaasConfigName();
        String string2 = "test.dynamic.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$2(DynamicLoginContext x$9) {
        String string = x$9.saslJaasConfigName();
        String string2 = "test.another.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testNewSaslCredentials$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().validate(dynamicProps$2, true);
    }

    private static final void updateConfig$4(KafkaConfig config$9, Properties dynamicProps$3) {
        config$9.dynamicConfig().updateBrokerConfig(0, config$9.dynamicConfig().toPersistentProps(dynamicProps$3, true), config$9.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyCredentialRotation$1(DynamicBrokerConfigTest $this, Properties dynamicProps$3, String usernameConfig$2, String passwordConfig$2, DynamicLoginContext context$1, KafkaConfig config$9, int x$11) {
        dynamicProps$3.setProperty(usernameConfig$2, "bob");
        dynamicProps$3.setProperty(passwordConfig$2, "bob-password");
        DynamicBrokerConfigTest.updateConfig$4(config$9, dynamicProps$3);
        $this.verifyCredential(context$1, "bob", "bob-password");
    }
}

