/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import kafka.common.RequestAndCompletionHandler;
import kafka.server.DynamicQuotaPublishingRequestThread;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019)\u0005\u0001)A\u0005u!9a\t\u0001b\u0001\n\u00139\u0005B\u0002(\u0001A\u0003%\u0001\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00021\t\u000f\u0019\u0004!\u0019!C\u0005O\"1Q\u000e\u0001Q\u0001\n!DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\")!\u0010\u0001C\u0005w\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\b\u0001\t\u0003\t\t\u0001C\u0004\u0002$\u0001!\t!!\u0001\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011Q\u000f\u0001\u0005\u0002\u0005\u0005\u0001bBA=\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003{\u0002A\u0011AA\u0001\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0003Aq!!\"\u0001\t\u0003\t\t\u0001C\u0004\u0002\n\u0002!\t!!\u0001\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m%A\b#z]\u0006l\u0017nY)v_R\f7\t[1o]\u0016dW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003Q\u0002\"!M\u001b\n\u0005Y\u0012#!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\u0005Q\u0004CA\u001eD\u001b\u0005a$BA\u001f?\u0003\u001d\u0019G.[3oiNT!!J \u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0005\u0003\tr\u0012QBT3uo>\u00148n\u00117jK:$\u0018A\u00048fi^|'o[\"mS\u0016tG\u000fI\u0001\u000fW\u000647.Y*dQ\u0016$W\u000f\\3s+\u0005A\u0005CA%M\u001b\u0005Q%BA&%\u0003\u0015)H/\u001b7t\u0013\ti%J\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u001f-\fgm[1TG\",G-\u001e7fe\u0002\nqA\u0019:pW\u0016\u0014\u0018'F\u0001R!\t\u0011V+D\u0001T\u0015\t!f(\u0001\u0004d_6lwN\\\u0005\u0003-N\u0013AAT8eK\u0006A!M]8lKJ\f\u0004%\u0001\u0005ce>\\WM]%e+\u0005Q\u0006CA\u0015\\\u0013\ta&FA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\tQLW.Z\u000b\u0002AB\u0011\u0011mY\u0007\u0002E*\u00111jU\u0005\u0003I\n\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005A\u0007CA5l\u001b\u0005Q'B\u00014T\u0013\ta'NA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naC]3q_J$\u0018N\\4SKF,Xm\u001d;UQJ,\u0017\rZ\u000b\u0002aB\u0011\u0011']\u0005\u0003e\n\u0012!\u0005R=oC6L7-U;pi\u0006\u0014V\r]8si&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017a\u0006:fa>\u0014H/\u001b8h%\u0016\fX/Z:u)\"\u0014X-\u00193!\u0003]\u0001XO\u00197jg\"Lgn\u001a*fcV,7\u000f\u001e+ie\u0016\fG-F\u0001w!\t\tt/\u0003\u0002yE\t\u0019C)\u001f8b[&\u001c\u0017+^8uCB+(\r\\5tQ&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017\u0001\u00079vE2L7\u000f[5oOJ+\u0017/^3tiRC'/Z1eA\u000511m\u001c8gS\u001e,\u0012\u0001 \t\u0003cuL!A \u0012\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001.i\u0016\u001cHoR3oKJ\fG/Z#naRLX*\u00199XQ\u0016tgj\u001c*fcV,7\u000f^:PkR\u001cH/\u00198eS:<GCAA\u0002!\rI\u0013QA\u0005\u0004\u0003\u000fQ#\u0001B+oSRD3!FA\u0006!\u0011\ti!a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\t1!\u00199j\u0015\u0011\t)\"a\u0006\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011D!\u0002\u000b),h.\u001b;\n\t\u0005u\u0011q\u0002\u0002\u0005)\u0016\u001cH/A\u0015uKN$x)\u001a8fe\u0006$X-\u00128uef<\u0016\u000e\u001e5pkR\f5\r^5wK\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004-\u0005-\u0011A\u0007;fgR<UM\\3sCR,wJ\\3SKB|'\u000f^#oiJL\bfA\f\u0002\f\u0005y1M]3bi\u0016,e\u000e\u001e:z\t\u0006$\u0018\r\u0006\u0007\u0002,\u0005}\u0012\u0011LA/\u0003C\nY\u0007\u0005\u0003\u0002.\u0005eb\u0002BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M2+A\u0004nKN\u001c\u0018mZ3\n\t\u0005]\u0012\u0011G\u0001\"%\u0016\u0004xN\u001d;Rk>$\u0018mQ8ogVl\u0007\u000f^5p]J+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003w\tiDA\u0005F]R\u0014\u0018\u0010R1uC*!\u0011qGA\u0019\u0011\u001d\t\t\u0005\u0007a\u0001\u0003\u0007\n!\"\u001a8uSRLH+\u001f9f!\u0011\t)%a\u0015\u000f\t\u0005\u001d\u0013q\n\t\u0004\u0003\u0013RSBAA&\u0015\r\tiEJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E#&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\n9F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#R\u0003bBA.1\u0001\u0007\u00111I\u0001\u000bK:$\u0018\u000e^=OC6,\u0007bBA01\u0001\u0007\u00111I\u0001\ncV|G/\u0019+za\u0016Dq!a\u0019\u0019\u0001\u0004\t)'A\u0003vg\u0006<W\rE\u0002*\u0003OJ1!!\u001b+\u0005\u0019!u.\u001e2mK\"9\u0011Q\u000e\rA\u0002\u0005=\u0014!\u0003;ie>$H\u000f\\3e!\rI\u0013\u0011O\u0005\u0004\u0003gR#a\u0002\"p_2,\u0017M\\\u0001.i\u0016\u001cHoR3oKJ\fG/\u001a+x_J+\u0007o\u001c:u\u000b:$(/_,ji\"\u001c\u0016-\\3D_>\u0014H-\u001b8bi>\u0014\bfA\r\u0002\f\u00059D/Z:u\u000f\u0016tWM]1uK6+H\u000e^5qY\u0016\u0014V\r]8si\u0016sGO]=XSRDG)\u001b4gKJ,g\u000e^\"p_J$\u0017N\\1u_JD3AGA\u0006\u0003m!Xm\u001d;HK:,'/\u0019;f\u001f:,\u0007+\u001e2mSNDWI\u001c;ss\"\u001a1$a\u0003\u0002SQ,7\u000f^$f]\u0016\u0014\u0018\r^3Uo>\u0004VO\u00197jg\",e\u000e\u001e:z/&$\bnU1nK\n\u0013xn[3sQ\ra\u00121B\u00010i\u0016\u001cHoR3oKJ\fG/\u001a+x_B+(\r\\5tQ\u0016sGO]=XSRDG)\u001b4gKJ,g\u000e\u001e\"s_.,'o\u001d\u0015\u0004;\u0005-\u0011\u0001\u000e;fgR<UM\\3sCR,W*\u001e7uSBdW\rU;cY&\u001c\b.\u00128uef<\u0016\u000e\u001e5ES\u001a4WM]3oi\n\u0013xn[3sg\"\u001aa$a\u0003\u0002G\u001d,g.\u001a:bi\u0016l\u0005+\u001e2mSNDWI\u001c;sS\u0016\u001cx+\u001b;i\u001d\n\u0013xn[3sgR1\u00111AAI\u0003+Ca!a% \u0001\u0004Q\u0016A\u00038v[\u0016sGO]5fg\"1\u0011qS\u0010A\u0002i\u000b!B\\;n\u0005J|7.\u001a:t\u0003m\u0019'/Z1uKB+(\r\\5tQF+x\u000e^1F]R\u0014\u0018\u0010R1uCRQ\u0011QTAU\u0003W\u000bi+a,\u0011\t\u0005}\u0015Q\u0015\b\u0005\u0003_\t\t+\u0003\u0003\u0002$\u0006E\u0012!\b)vE2L7\u000f[)v_R\fG+\u0019:hKR\u0014V-];fgR$\u0015\r^1\n\t\u0005m\u0012q\u0015\u0006\u0005\u0003G\u000b\t\u0004C\u0004\u0002B\u0001\u0002\r!a\u0011\t\u000f\u0005m\u0003\u00051\u0001\u0002D!9\u0011q\f\u0011A\u0002\u0005\r\u0003bBAYA\u0001\u0007\u0011QM\u0001\u0006cV|G/\u0019")
public class DynamicQuotaChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final KafkaScheduler kafkaScheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
    private final Node broker1 = new Node(1, "host", 10);
    private final int brokerId;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final DynamicQuotaReportingRequestThread reportingRequestThread = new DynamicQuotaReportingRequestThread(this.config(), this.metrics(), this.metadataCache(), this.networkClient(), this.kafkaScheduler(), (Time)this.time());
    private final DynamicQuotaPublishingRequestThread publishingRequestThread = new DynamicQuotaPublishingRequestThread(this.config(), this.metrics(), this.metadataCache(), this.networkClient(), this.kafkaScheduler(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private KafkaScheduler kafkaScheduler() {
        return this.kafkaScheduler;
    }

    private Node broker1() {
        return this.broker1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private DynamicQuotaReportingRequestThread reportingRequestThread() {
        return this.reportingRequestThread;
    }

    private DynamicQuotaPublishingRequestThread publishingRequestThread() {
        return this.publishingRequestThread;
    }

    private KafkaConfig config() {
        return KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    }

    @Test
    public void testGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
        Assertions.assertTrue((boolean)this.publishingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateEntryWithoutActiveCoordinator() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData = this.createEntryData("type", "name", "type1", 1.0, false);
        this.reportingRequestThread().addEntryForNode((Object)entryData);
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateOneReportEntry() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData = this.createEntryData("type", "name", "type1", 1.0, false);
        this.reportingRequestThread().addEntryForNode((Object)entryData);
        Iterable requests = this.reportingRequestThread().generateRequests();
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((Object)this.broker1(), (Object)((RequestAndCompletionHandler)requests.head()).destination());
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntryData[]{entryData}));
        data.setBrokerId(this.brokerId());
        Assertions.assertEquals((Object)((ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build()), (Object)((ReportQuotaConsumptionRequest.Builder)((RequestAndCompletionHandler)requests.head()).request()).build());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    private ReportQuotaConsumptionRequestData.EntryData createEntryData(String entityType, String entityName, String quotaType, double usage, boolean throttled) {
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(quotaType).setUsage(usage).setThrottled(throttled));
        return entryData;
    }

    @Test
    public void testGenerateTwoReportEntryWithSameCoordinator() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData1 = this.createEntryData("entityType1", "entityName1", "quotaType1", 1.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData2 = this.createEntryData("entityType2", "entityName2", "quotaType2", 2.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData1);
        this.reportingRequestThread().addEntryForNode((Object)entryData2);
        Iterable requests = this.reportingRequestThread().generateRequests();
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((Object)this.broker1(), (Object)((RequestAndCompletionHandler)requests.head()).destination());
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntryData[]{entryData1, entryData2}));
        data.setBrokerId(this.brokerId());
        Assertions.assertEquals((Object)((ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build()), (Object)((ReportQuotaConsumptionRequest.Builder)((RequestAndCompletionHandler)requests.head()).request()).build());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateMultipleReportEntryWithDifferentCoordinator() {
        Node broker2 = new Node(2, "host2", 10);
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).times(2);
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)broker2)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData1 = this.createEntryData("entityType", "entityName", "quotaType1", 1.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData2 = this.createEntryData("entityType", "entityName", "quotaType1", 3.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData1);
        this.reportingRequestThread().addEntryForNode((Object)entryData2);
        ReportQuotaConsumptionRequestData.EntryData entryData3 = this.createEntryData("entityType", "entityName2", "quotaType2", 4.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData4 = this.createEntryData("entityType", "entityName3", "quotaType2", 5.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData3);
        this.reportingRequestThread().addEntryForNode((Object)entryData4);
        Iterable requests = this.reportingRequestThread().generateRequests();
        Assertions.assertEquals((int)2, (int)requests.size());
        Assertions.assertEquals((Object)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.broker1(), broker2}))), (Object)((TraversableOnce)requests.map((Function1 & Serializable & scala.Serializable)requestHandler -> requestHandler.destination(), Iterable$.MODULE$.canBuildFrom())).toSet());
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntryData[]{entryData1, entryData2}));
        data.setBrokerId(this.brokerId());
        ReportQuotaConsumptionRequest expectedBroker1Request = (ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build();
        ReportQuotaConsumptionRequestData data2 = new ReportQuotaConsumptionRequestData();
        data2.setEntries(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntryData[]{entryData3, entryData4}));
        data2.setBrokerId(this.brokerId());
        ReportQuotaConsumptionRequest expectedBroker2Request = (ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data2).build();
        Assertions.assertEquals((Object)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReportQuotaConsumptionRequest[]{expectedBroker1Request, expectedBroker2Request}))), (Object)((TraversableOnce)requests.map((Function1 & Serializable & scala.Serializable)requestHandler -> (ReportQuotaConsumptionRequest)((ReportQuotaConsumptionRequest.Builder)requestHandler.request()).build(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateOnePublishEntry() {
        this.generateMPublishEntriesWithNBrokers(1, 1);
    }

    @Test
    public void testGenerateTwoPublishEntryWithSameBroker() {
        this.generateMPublishEntriesWithNBrokers(2, 1);
    }

    @Test
    public void testGenerateTwoPublishEntryWithDifferentBrokers() {
        this.generateMPublishEntriesWithNBrokers(2, 2);
    }

    @Test
    public void testGenerateMultiplePublishEntryWithDifferentBrokers() {
        this.generateMPublishEntriesWithNBrokers(3, 2);
    }

    private void generateMPublishEntriesWithNBrokers(int numEntries, int numBrokers) {
        ArrayBuffer nodes = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBrokers).foreach((Function1 & Serializable & scala.Serializable)i -> DynamicQuotaChannelManagerTest.$anonfun$generateMPublishEntriesWithNBrokers$1(this, nodes, numEntries, numBrokers, BoxesRunTime.unboxToInt((Object)i)));
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        Map entryDataMap = Map$.MODULE$.empty().withDefaultValue((Object)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            int brokerId = (j - 1) % numBrokers + 1;
            PublishQuotaTargetRequestData.EntryData entry = this.createPublishQuotaEntryData("entityType", new StringBuilder(10).append("entityName").append(brokerId).toString(), new StringBuilder(9).append("quotaType").append(j).toString(), j);
            entryDataMap.update((Object)BoxesRunTime.boxToInteger((int)brokerId), ((SeqLike)entryDataMap.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).$plus$colon((Object)entry, ListBuffer$.MODULE$.canBuildFrom()));
            this.publishingRequestThread().addEntryForNode((Object)entry, (Option)new Some(nodes.apply(brokerId - 1)));
        });
        Iterable requests = this.publishingRequestThread().generateRequests();
        Assertions.assertEquals((int)numBrokers, (int)requests.size());
        Assertions.assertEquals((Object)nodes, (Object)requests.map((Function1 & Serializable & scala.Serializable)requestHandler -> requestHandler.destination(), Iterable$.MODULE$.canBuildFrom()));
        ObjectRef expectedRequests = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        entryDataMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicQuotaChannelManagerTest.$anonfun$generateMPublishEntriesWithNBrokers$4(expectedRequests, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)expectedRequests.elem), (Object)((TraversableOnce)requests.map((Function1 & Serializable & scala.Serializable)requestHandler -> (PublishQuotaTargetRequest)((PublishQuotaTargetRequest.Builder)requestHandler.request()).build(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertTrue((boolean)this.publishingRequestThread().generateRequests().isEmpty());
    }

    private PublishQuotaTargetRequestData.EntryData createPublishQuotaEntryData(String entityType, String entityName, String quotaType, double quota) {
        PublishQuotaTargetRequestData.EntryData entryData = new PublishQuotaTargetRequestData.EntryData();
        entryData.entity().add(new PublishQuotaTargetRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        entryData.quotas().add(new PublishQuotaTargetRequestData.QuotaData().setQuotaType(quotaType).setQuota(quota));
        return entryData;
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$generateMPublishEntriesWithNBrokers$1(DynamicQuotaChannelManagerTest $this, ArrayBuffer nodes$1, int numEntries$1, int numBrokers$1, int i) {
        Node node = new Node(i, new StringBuilder(4).append("host").append(i).toString(), 10);
        nodes$1.$plus$eq((Object)node);
        return EasyMock.expect((Object)$this.metadataCache().getAliveBrokerNode(i, $this.config().interBrokerListenerName())).andReturn((Object)new Some((Object)node)).times(numEntries$1 / numBrokers$1 + numEntries$1 % numBrokers$1);
    }

    public static final /* synthetic */ void $anonfun$generateMPublishEntriesWithNBrokers$4(ObjectRef expectedRequests$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ListBuffer entryData = (ListBuffer)x0$1._2();
            PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)entryData.reverse()).asJava());
            PublishQuotaTargetRequest expectedBrokerIRequest = (PublishQuotaTargetRequest)new PublishQuotaTargetRequest.Builder(data).build();
            expectedRequests$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)expectedRequests$1.elem).$plus((Object)expectedBrokerIRequest);
            return;
        }
        throw new MatchError(null);
    }

    public DynamicQuotaChannelManagerTest() {
        this.brokerId = 1;
        this.reportingRequestThread().started_$eq(true);
        this.publishingRequestThread().started_$eq(true);
    }
}

