/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.PartitionListener;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d4A\u0001F\u000b\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003B\u0002\u001a\u0001A\u0003%q\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\t\ra\u0002\u0001\u0015!\u00036\u0011\u001dI\u0004A1A\u0005\u0002iBaA\u0010\u0001!\u0002\u0013Y\u0004bB \u0001\u0005\u0004%\t\u0001\u0011\u0005\u0007\t\u0002\u0001\u000b\u0011B!\t\u000b\u0015\u0003A\u0011\u0001$\t\u000bU\u0003A\u0011\u0001$\t\u000b]\u0003A\u0011\u0001$\t\u000be\u0003A\u0011\u0001$\t\u000bm\u0003A\u0011\u0001$\t\u000bu\u0003A\u0011\u0001$\t\u000b}\u0003A\u0011\u0001$\t\u000b\u0005\u0004A\u0011\u0001$\t\u000b\r\u0004A\u0011\u0001$\t\u000b\u0015\u0004A\u0011\u0001$\u0003K%s7M]3nK:$\u0018\r\u001c)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1UKN$(B\u0001\f\u0018\u0003\u0019\u0019XM\u001d<fe*\t\u0001$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002+\u0005\u0011A\u000f]\u000b\u0002OA\u0011\u0001\u0006M\u0007\u0002S)\u0011!fK\u0001\u0007G>lWn\u001c8\u000b\u0005aa#BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!M\u0015\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u000fQ|\u0007/[2JIV\tQ\u0007\u0005\u0002)m%\u0011q'\u000b\u0002\u0005+VLG-\u0001\u0005u_BL7-\u00133!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001<!\t!C(\u0003\u0002>+\t\t\u0013J\\2sK6,g\u000e^1m!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t\u0011\t\u0005\u0002%\u0005&\u00111)\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0005;fgRLe.\u001b;jC2\u001cF/\u0019;f)\u00059\u0005C\u0001\u000fI\u0013\tIUD\u0001\u0003V]&$\bF\u0001\u0006L!\ta5+D\u0001N\u0015\tqu*A\u0002ba&T!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!KL\u0001\u0006UVt\u0017\u000e^\u0005\u0003)6\u0013A\u0001V3ti\u0006YB/Z:u\u001b\u0006L(-\u001a*fO&\u001cH/\u001a:Bg2K7\u000f^3oKJD#aC&\u0002\u0013Q,7\u000f^\"m_N,\u0007F\u0001\u0007L\u0003]!Xm\u001d;Va\u0012\fG/\u001a*fcV,7\u000f\u001e)be\u0006l7\u000f\u000b\u0002\u000e\u0017\u0006qA/Z:u\u0013N\u001c\u0015-^4iiV\u0003\bF\u0001\bL\u0003m!Xm\u001d;NCf\u0014W-\u00169eCR,'+Z:q_:\u001cX\rR1uC\"\u0012qbS\u00017i\u0016\u001cH/\u00138de\u0016lWM\u001c;bYB\u000b'\u000f^5uS>tg)\u001a;dQ6+G/\u00193bi\u0006,\u0015/^1mg\u0006sG\rS1tQ\u000e{G-\u001a\u0015\u0003!-\u000b1\u0004^3ti6\u000b\u0017PY3SKN|GN^3V].twn\u001e8OC6,\u0007FA\tL\u0003)!Xm\u001d;FcV\fGn\u001d\u0015\u0003%-\u000b\u0011\u0004^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8DC\u000eDWmU5{K\"\u00121c\u0013")
public class IncrementalPartitionFetchMetadataTest {
    private final TopicPartition tp = new TopicPartition("foo", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private final IncrementalPartitionFetchMetadata partition = new IncrementalPartitionFetchMetadata(this.tp().topic(), this.topicId(), this.tp().partition());
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);

    public TopicPartition tp() {
        return this.tp;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public IncrementalPartitionFetchMetadata partition() {
        return this.partition;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Test
    public void testInitialState() {
        Assertions.assertEquals((long)-1L, (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)-1L, (long)this.partition().startOffset());
        Assertions.assertEquals((int)-1, (int)this.partition().maxBytes());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().currentLeaderEpoch());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().lastFetchedEpoch());
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
    }

    @Test
    public void testMaybeRegisterAsListener() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).maybeAddListener(this.tp(), (PartitionListener)this.partition());
    }

    @Test
    public void testClose() {
        this.partition().close();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        this.partition().close();
        this.partition().close();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).removeListener(this.tp(), (PartitionListener)this.partition());
    }

    @Test
    public void testUpdateRequestParams() {
        FetchResponseData.PartitionData fetchResponse = new FetchResponseData.PartitionData();
        FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setFetchOffset(-1L).setLogStartOffset(-1L).setPartitionMaxBytes(-1).setCurrentLeaderEpoch(-1).setLastFetchedEpoch(-1);
        this.updateAndVerify$1(fetchPartition.duplicate().setFetchOffset(20L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLogStartOffset(10L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setPartitionMaxBytes(200), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setCurrentLeaderEpoch(1), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLastFetchedEpoch(2), fetchResponse);
    }

    @Test
    public void testIsCaughtUp() {
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        this.partition().onStartOffsetUpdated(this.tp(), 0L);
        this.partition().onEndOffsetUpdated(this.tp(), 0L);
        this.partition().onHighWatermarkUpdated(this.tp(), 0L);
        this.partition().onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})));
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().updateRequestParams(new FetchRequestData.FetchPartition().setFetchOffset(0L));
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onEndOffsetUpdated(this.tp(), 10L);
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true);
        this.partition().updateRequestParams(new FetchRequestData.FetchPartition().setFetchOffset(10L));
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onHighWatermarkUpdated(this.tp(), 10L);
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(10L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onStartOffsetUpdated(this.tp(), 5L);
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(5L).setHighWatermark(10L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})));
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onFailed(this.tp());
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
    }

    @Test
    public void testMaybeUpdateResponseData() {
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        Assertions.assertFalse((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(100L, null)})), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(10).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(-1)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(-1).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(10)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
    }

    @Test
    public void testIncrementalPartitionFetchMetadataEqualsAndHashCode() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic";
        int partition = 0;
        IncrementalPartitionFetchMetadata cachedPartitionWithIdAndName = new IncrementalPartitionFetchMetadata(topicName, topicId, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithIdAndNoName = new IncrementalPartitionFetchMetadata(null, topicId, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithDifferentIdAndName = new IncrementalPartitionFetchMetadata(topicName, Uuid.randomUuid(), partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithZeroIdAndName = new IncrementalPartitionFetchMetadata(topicName, Uuid.ZERO_UUID, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithZeroIdAndOtherName = new IncrementalPartitionFetchMetadata("otherTopic", Uuid.ZERO_UUID, partition);
        Assertions.assertTrue((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithIdAndNoName));
        Assertions.assertEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithIdAndNoName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithDifferentIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertTrue((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithIdAndName));
        Assertions.assertEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithDifferentIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithZeroIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndOtherName));
        Assertions.assertNotEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndOtherName.hashCode());
        Assertions.assertTrue((boolean)cachedPartitionWithZeroIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
    }

    @Test
    public void testMaybeResolveUnknownName() {
        IncrementalPartitionFetchMetadata namedPartition = new IncrementalPartitionFetchMetadata("topic", Uuid.randomUuid(), 0);
        IncrementalPartitionFetchMetadata nullNamePartition1 = new IncrementalPartitionFetchMetadata(null, Uuid.randomUuid(), 0);
        IncrementalPartitionFetchMetadata nullNamePartition2 = new IncrementalPartitionFetchMetadata(null, Uuid.randomUuid(), 0);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)namedPartition.topicId()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nullNamePartition1.topicId()), (Object)"bar")}))).asJava();
        namedPartition.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"topic", (Object)namedPartition.topic());
        nullNamePartition1.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"bar", (Object)nullNamePartition1.topic());
        nullNamePartition2.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals(null, (Object)nullNamePartition2.topic());
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)this.partition().equals((Object)this.partition()));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata(this.tp().topic(), this.topicId(), this.tp().partition())));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata("bar", this.topicId(), 0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchSessionCacheSize() {
        FetchSessionCache cache = new FetchSessionCache(3, 1000L);
        CompletableFuture.runAsync(() -> {
            IncrementalPartitionFetchMetadataTest.createSessions$1(cache, 1, 1000);
            IncrementalPartitionFetchMetadataTest.removeSessions$1(cache, 501, 1000);
        });
        CompletableFuture.runAsync(() -> {
            IncrementalPartitionFetchMetadataTest.createSessions$1(cache, 1001, 2000);
            IncrementalPartitionFetchMetadataTest.removeSessions$1(cache, 1501, 2000);
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!IncrementalPartitionFetchMetadataTest.$anonfun$testFetchSessionCacheSize$5(cache)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)IncrementalPartitionFetchMetadataTest.$anonfun$testFetchSessionCacheSize$6(cache));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)1000L, (long)cache.totalPartitions());
    }

    private final void updateAndVerify$1(FetchRequestData.FetchPartition fetchPartition, FetchResponseData.PartitionData fetchResponse$1) {
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        this.partition().updateRequestParams(fetchPartition);
        Assertions.assertEquals((long)fetchPartition.fetchOffset(), (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)fetchPartition.logStartOffset(), (long)this.partition().startOffset());
        Assertions.assertEquals((int)fetchPartition.partitionMaxBytes(), (int)this.partition().maxBytes());
        Assertions.assertEquals((int)fetchPartition.currentLeaderEpoch(), (Integer)this.partition().currentLeaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Assertions.assertEquals((int)fetchPartition.lastFetchedEpoch(), (Integer)this.partition().lastFetchedEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Assertions.assertTrue((boolean)this.partition().fetchMetadataUpdated());
        this.partition().maybeUpdateResponseData(fetchResponse$1, true);
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
    }

    private static final FetchSession newSession$1(int id) {
        ImplicitLinkedHashCollection partitionMap = new ImplicitLinkedHashCollection();
        partitionMap.add((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata("topic", Uuid.randomUuid(), 0));
        return new FetchSession(id, false, partitionMap, true, 0L, 0L, 0);
    }

    private static final void createSessions$1(FetchSessionCache cache, int start, int finish) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(start), finish).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> cache.touch(IncrementalPartitionFetchMetadataTest.newSession$1(i), 0L));
    }

    private static final void removeSessions$1(FetchSessionCache cache, int start, int finish) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(start), finish).foreach((Function1 & Serializable & scala.Serializable)i -> cache.remove((FetchSession)cache.get(BoxesRunTime.unboxToInt((Object)i)).get()));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchSessionCacheSize$5(FetchSessionCache cache$5) {
        return cache$5.size() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testFetchSessionCacheSize$6(FetchSessionCache cache$5) {
        return new StringBuilder(66).append("cache size should match the number of new sessions. current size: ").append(cache$5.size()).toString();
    }
}

