/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.BrokerServer$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000b\u0016\u0001iA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\ts\u0001\u0011\t\u0011)A\u0005O!A!\b\u0001BA\u0002\u0013\u00051\b\u0003\u0005@\u0001\t\u0005\r\u0011\"\u0001A\u0011!1\u0005A!A!B\u0013a\u0004\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u0011E\u0003!\u0011!Q\u0001\n%C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\ts\u0002\u0011\t\u0011)A\u0005)\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005y\"Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005m\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001e\u0001\u0011)\u0019!C\u0001\u0003?A!\"!\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002|\u0001!\t%! \t\u000f\u0005}\u0004\u0001\"\u0001\u0002~\tI2JU1giF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0012\u000e\u0003UI!\u0001J\u000b\u0003)E+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0003\u001d\u00022\u0001K\u0016.\u001b\u0005I#B\u0001\u0016\u0018\u0003\u0011\u0011\u0018M\u001a;\n\u00051J#\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s!\tqs'D\u00010\u0015\t\u0001\u0014'\u0001\u0004d_6lwN\u001c\u0006\u0003-IR!\u0001G\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003q=\u0012A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0013\u0001E2p]R\u0014x\u000e\u001c7feN+'O^3s+\u0005a\u0004C\u0001\u0012>\u0013\tqTC\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006!2m\u001c8ue>dG.\u001a:TKJ4XM]0%KF$\"!\u0011#\u0011\u0005q\u0011\u0015BA\"\u001e\u0005\u0011)f.\u001b;\t\u000f\u0015#\u0011\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\u0002#\r|g\u000e\u001e:pY2,'oU3sm\u0016\u0014\b%A\u0006nKR\fG-\u0019;b\t&\u0014X#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015AA5p\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\t\u0019KG.Z\u0001\r[\u0016$\u0018\rZ1uC\u0012K'\u000fI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\u0005!\u0006cA+[96\taK\u0003\u0002X1\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ek\u0015\u0001B;uS2L!a\u0017,\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003^=\u00024W\"\u0001-\n\u0005}C&aA'baB\u0011\u0011\rZ\u0007\u0002E*\u00111-T\u0001\u0005Y\u0006tw-\u0003\u0002fE\n9\u0011J\u001c;fO\u0016\u0014\bCA4w\u001d\tA7O\u0004\u0002je:\u0011!.\u001d\b\u0003WBt!\u0001\\8\u000e\u00035T!A\\\r\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014B\u0001\u001b6\u0013\tA2'\u0003\u0002+e%\u0011A/^\u0001\u000b%\u00064GoQ8oM&<'B\u0001\u00163\u0013\t9\bPA\u0006BI\u0012\u0014Xm]:Ta\u0016\u001c'B\u0001;v\u0003u\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016\u0004\u0013!C2mkN$XM]%e+\u0005a\bcA?\u0002\u00049\u0011ap \t\u0003YvI1!!\u0001\u001e\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A\u000f\u0002\u0015\rdWo\u001d;fe&#\u0007%A\u0002m_\u001e,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0018\u0003\u0015)H/\u001b7t\u0013\u0011\tI\"a\u0005\u0003\u000f1{wmZ5oO\u0006!An\\4!\u000311\u0017-\u001e7u\u0011\u0006tG\r\\3s+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9#M\u0001\u0006M\u0006,H\u000e^\u0005\u0005\u0003W\t)C\u0001\u0007GCVdG\u000fS1oI2,'/A\u0007gCVdG\u000fS1oI2,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@\u0005\u0005\u0003C\u0001\u0012\u0001\u0011\u0015)\u0003\u00031\u0001(\u0011\u0015Q\u0004\u00031\u0001=\u0011\u00159\u0005\u00031\u0001J\u0011\u0015\u0011\u0006\u00031\u0001U\u0011\u0015Q\b\u00031\u0001}\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u001fAq!!\b\u0011\u0001\u0004\t\t#\u0001\u0007de\u0016\fG/\u001a\"s_.,'\u000f\u0006\u0006\u0002H\u00055\u0013qKA4\u0003c\u00022AIA%\u0013\r\tY%\u0006\u0002\f\u0017\u000647.\u0019\"s_.,'\u000fC\u0004\u0002PE\u0001\r!!\u0015\u0002\r\r|gNZ5h!\r\u0011\u00131K\u0005\u0004\u0003+*\"aC&bM.\f7i\u001c8gS\u001eD\u0011\"!\u0017\u0012!\u0003\u0005\r!a\u0017\u0002\tQLW.\u001a\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)!\u0011QCA1\u0015\t\u0001$'\u0003\u0003\u0002f\u0005}#\u0001\u0002+j[\u0016D\u0011\"!\u001b\u0012!\u0003\u0005\r!a\u001b\u0002\u000fM$\u0018M\u001d;vaB\u0019A$!\u001c\n\u0007\u0005=TDA\u0004C_>dW-\u00198\t\u0013\u0005M\u0014\u0003%AA\u0002\u0005U\u0014\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\u0011a\u0012q\u000f?\n\u0007\u0005eTD\u0001\u0004PaRLwN\\\u0001\tg\",H\u000fZ8x]R\t\u0011)A\tsKN$\u0018M\u001d;D_:$(o\u001c7mKJ\u0004")
public class KRaftQuorumImplementation
implements QuorumImplementation {
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private ControllerServer controllerServer;
    private final File metadataDir;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final String clusterId;
    private final Logging log;
    private final FaultHandler faultHandler;

    @Override
    public Time createBroker$default$2() {
        return QuorumImplementation.createBroker$default$2$(this);
    }

    @Override
    public boolean createBroker$default$3() {
        return QuorumImplementation.createBroker$default$3$(this);
    }

    @Override
    public Option<String> createBroker$default$4() {
        return QuorumImplementation.createBroker$default$4$(this);
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public ControllerServer controllerServer() {
        return this.controllerServer;
    }

    public void controllerServer_$eq(ControllerServer x$1) {
        this.controllerServer = x$1;
    }

    public File metadataDir() {
        return this.metadataDir;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Logging log() {
        return this.log;
    }

    public FaultHandler faultHandler() {
        return this.faultHandler;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        Metrics metrics = Server$.MODULE$.initializeMetrics(config, time, this.clusterId());
        BrokerServer broker = new BrokerServer(config, new MetaProperties(this.clusterId(), config.nodeId()), this.raftManager(), (Option)None$.MODULE$, time, metrics, BrokerServerMetrics$.MODULE$.apply(metrics), (Option)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("Broker%02d_")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.nodeId())}))), (Seq)Nil$.MODULE$, this.controllerQuorumVotersFuture(), this.faultHandler(), this.faultHandler(), this.faultHandler(), BrokerServer$.MODULE$.$lessinit$greater$default$14());
        if (startup) {
            broker.startup();
        }
        return broker;
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this.log(), CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerServer().shutdown(), this.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    public void restartController() {
        int prevPort = ((RaftConfig.InetAddressSpec)this.controllerQuorumVotersFuture().get().get((Object)BoxesRunTime.boxToInteger((int)1000))).address.getPort();
        this.log().info((Function0 & Serializable & scala.Serializable)() -> "Restarting the KRaft-based controller");
        this.controllerServer().shutdown();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.controllerServer().config().originals());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(prevPort).toString());
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append("1000@localhost:").append(prevPort).toString());
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Setting KRaft-based controller port to ").append(prevPort).append(" as part of restart").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        ControllerServer newControllerServer = new ControllerServer(this.controllerServer().metaProperties(), config, this.raftManager(), this.controllerServer().clusterBalanceManager(), Time.SYSTEM, new Metrics(), this.controllerServer().controllerMetrics(), this.controllerServer().threadNamePrefix(), this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema(), this.controllerServer().raftApiVersions(), this.controllerServer().bootstrapMetadata(), this.controllerServer().metadataFaultHandler(), this.controllerServer().fatalFaultHandler(), this.controllerServer().multiTenantMetadata());
        this.controllerServer_$eq(newControllerServer);
        newControllerServer.startup();
    }

    public KRaftQuorumImplementation(KafkaRaftManager<ApiMessageAndVersion> raftManager, ControllerServer controllerServer, File metadataDir, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, String clusterId, Logging log, FaultHandler faultHandler) {
        this.raftManager = raftManager;
        this.controllerServer = controllerServer;
        this.metadataDir = metadataDir;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.clusterId = clusterId;
        this.log = log;
        this.faultHandler = faultHandler;
    }
}

