/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.server.RequestLocal;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!9\u0001\u0004\u0001b\u0001\n\u0003I\u0002BB\u0014\u0001A\u0003%!\u0004C\u0003)\u0001\u0011\u0005\u0011\u0006C\u00039\u0001\u0011%\u0011\bC\u0003E\u0001\u0011%\u0011HA\fLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0005\u0002\tQLW.Z\u000b\u00025A\u00111$J\u0007\u00029)\u0011QDH\u0001\u0006kRLGn\u001d\u0006\u0003?\u0001\naaY8n[>t'BA\u0006\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019b\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002#Q,7\u000f^#oO&tW-T3ue&\u001c7\u000fF\u0001+!\ty1&\u0003\u0002-!\t!QK\\5uQ\t!a\u0006\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003k\r\nQA[;oSRL!a\u000e\u0019\u0003\tQ+7\u000f^\u0001\u000fe\u0016\u001cW-\u001b<f%\u0016\fX/Z:u)\u0005Q\u0004CA\u001eB\u001d\tat(D\u0001>\u0015\tq$\"A\u0004oKR<xN]6\n\u0005\u0001k\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003\u0005\u000e\u0013qAU3rk\u0016\u001cHO\u0003\u0002A{\u0005\u0001\"-^5mIR+7\u000f\u001e*fcV,7\u000f\u001e")
public class KafkaRequestHandlerTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testEngineMetrics() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        Thread thread = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            this.receiveRequest();
        });
        thread.start();
        thread.join();
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread));
        ((List)threadLocalCountersForAllThreads.get(thread)).forEach(counter -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        Assertions.assertEquals((Object)counter.threadGroupType, (Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
                        metricComponentType2 = counter.metricComponentType;
                        metricComponentType = ThreadLocalCounters.MetricComponentType.ENGINE;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                Assertions.assertEquals((long)1L, (long)counter.numSuccessOps);
            }
        });
    }

    private RequestChannel.Request receiveRequest() {
        Meter aggregateIdleMeter = (Meter)Mockito.mock(Meter.class);
        RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, "cluster", 0, aggregateIdleMeter, new AtomicInteger(1), requestChannel, apiHandler, (Time)this.time());
        RequestChannel.Request request = this.buildTestRequest();
        Mockito.when((Object)requestChannel.receiveRequest(0L)).thenReturn((Object)request);
        handler.poll(0);
        ((ApiRequestHandler)Mockito.verify((Object)apiHandler)).handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        return request;
    }

    private RequestChannel.Request buildTestRequest() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 1379);
        RequestContext requestContext = new RequestContext(requestHeader, "connectionId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        ByteBuffer buffer = ((MetadataRequest)MetadataRequest.Builder.allTopics().build()).serialize();
        RequestChannel.Metrics requestMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(0, requestContext, this.time().nanoseconds(), MemoryPool.NONE, buffer, requestMetrics, (Option)None$.MODULE$, RequestChannel.Request$.MODULE$.$lessinit$greater$default$8(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$9(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$10());
    }
}

