/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.server.KraftInternalAdmin;
import kafka.server.KraftInternalAdmin$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A\u0001E\t\u0003-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rE\u0002\u0001\u0015!\u0003/\u0011\u001d\u0011\u0004A1A\u0005\nMBaa\u000e\u0001!\u0002\u0013!\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002&\u0001\t\u0003I\u0004\"\u0002'\u0001\t\u0003I\u0004\"\u0002(\u0001\t\u0003I\u0004\"\u0002)\u0001\t\u0003I\u0004\"\u0002*\u0001\t\u0003I\u0004\"\u0002+\u0001\t\u0003I\u0004\"\u0002,\u0001\t\u00139&AF&sC\u001a$\u0018J\u001c;fe:\fG.\u00113nS:$Vm\u001d;\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011#A\u0005u_BL7MT1nKV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\u001bKb\u0004Xm\u0019;fI:+XNY3s\u001f\u001a\u0004\u0016M\u001d;ji&|gn]\u000b\u0002]A\u0011\u0001dL\u0005\u0003ae\u00111!\u00138u\u0003m)\u0007\u0010]3di\u0016$g*^7cKJ|e\rU1si&$\u0018n\u001c8tA\u000511m\u001c8gS\u001e,\u0012\u0001\u000e\t\u0003AUJ!AN\t\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0015\"Xm\u001d;E_:{GoQ1mY\u000e\u0013X-\u0019;f)>\u0004\u0018nY%g)>\u0004\u0018nY#ySN$8\u000fF\u0001;!\tA2(\u0003\u0002=3\t!QK\\5uQ\tAa\b\u0005\u0002@\u00116\t\u0001I\u0003\u0002B\u0005\u0006\u0019\u0011\r]5\u000b\u0005\r#\u0015a\u00026va&$XM\u001d\u0006\u0003\u000b\u001a\u000bQA[;oSRT\u0011aR\u0001\u0004_J<\u0017BA%A\u0005\u0011!Vm\u001d;\u0002\u001fQ,7\u000f\u001e+pa&\u001c7I]3bi\u0016D#!\u0003 \u0002KQ,7\u000f\u001e+f[B|'/\u0019:jYf|U\u000f^(g'ft7-T3uC\u0012\fG/Y\"bG\",\u0007F\u0001\u0006?\u0003i!Xm\u001d;PkR|emU=oG6+G/\u00193bi\u0006\u001c\u0015m\u00195fQ\tYa(\u0001\u000buKN$H+[7f_V$X\t_2faRLwN\u001c\u0015\u0003\u0019y\nA\u0003^3tiVs7N\\8x]\u0016C8-\u001a9uS>t\u0007FA\u0007?\u0003Y!Xm\u001d;De\u0016\fG/\u001a+pa&\u001c'+Z9vKN$\bF\u0001\b?\u0003M\u0019'/Z1uKR{\u0007/[2SKN\u0004xN\\:f)\rA6M\u001c\t\u00033\u0006l\u0011A\u0017\u0006\u00037r\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003;z\u000baaY8n[>t'B\u0001\u000b`\u0015\t\u0001g)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Ej\u0013Ac\u0011:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,\u0007\"B\u0011\u0010\u0001\u0004!\u0007CA3m\u001d\t1'\u000e\u0005\u0002h35\t\u0001N\u0003\u0002j+\u00051AH]8pizJ!a[\r\u0002\rA\u0013X\rZ3g\u0013\tQSN\u0003\u0002l3!)qn\u0004a\u0001a\u0006)QM\u001d:peB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fX\u0001\taJ|Go\\2pY&\u0011QO\u001d\u0002\u0007\u000bJ\u0014xN]:")
public final class KraftInternalAdminTest {
    private final String kafka$server$KraftInternalAdminTest$$topicName;
    private final int expectedNumberOfPartitions;
    private final KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);

    public String kafka$server$KraftInternalAdminTest$$topicName() {
        return this.kafka$server$KraftInternalAdminTest$$topicName;
    }

    private int expectedNumberOfPartitions() {
        return this.expectedNumberOfPartitions;
    }

    private KafkaConfig config() {
        return this.config;
    }

    @Test
    public void testDoNotCallCreateTopicIfTopicExists() {
        int incorrectNumberOfPartitions = this.expectedNumberOfPartitions() + 1;
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.expectedNumberOfPartitions())));
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), incorrectNumberOfPartitions, (short)1, new Properties()));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTopicCreate() {
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.NONE));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTemporarilyOutOfSyncMetadataCache() {
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.expectedNumberOfPartitions())));
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.TOPIC_ALREADY_EXISTS));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testOutOfSyncMetadataCache() {
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.TOPIC_ALREADY_EXISTS));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTimeoutException() {
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
                ((ControllerRequestCompletionHandler)invocation.getArgument(1)).onTimeout();
            }
        });
        Assertions.assertThrows(TimeoutException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
    }

    @Test
    public void testUnknownException() {
        BrokerToControllerChannelManager channel = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.NOT_CONTROLLER));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertThrows(NotControllerException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicRequest() {
        void var2_2;
        short expectedReplicationFactor = 3;
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "1234");
        properties.put("retention.bytes", "43");
        properties.put("unclean.leader.election.enable", "false");
        int timeoutMs = 5000;
        CreateTopicsRequest request = (CreateTopicsRequest)KraftInternalAdmin$.MODULE$.createTopicRequest(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), expectedReplicationFactor, (Properties)var2_2, timeoutMs).build();
        Assertions.assertEquals((int)timeoutMs, (int)request.data().timeoutMs());
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)request.data().topics().valuesList().get(0);
        Assertions.assertEquals((Object)this.kafka$server$KraftInternalAdminTest$$topicName(), (Object)creatableTopic.name());
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)creatableTopic.numPartitions());
        Assertions.assertEquals((short)expectedReplicationFactor, (short)creatableTopic.replicationFactor());
        Assertions.assertEquals((int)var2_2.size(), (int)creatableTopic.configs().size());
        ((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)var2_2).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            KraftInternalAdminTest.$anonfun$testCreateTopicRequest$2(creatableTopic, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public CreateTopicsResponse kafka$server$KraftInternalAdminTest$$createTopicResponse(String topicName, Errors error) {
        CreateTopicsResponseData.CreatableTopicResultCollection topics = new CreateTopicsResponseData.CreatableTopicResultCollection(1);
        topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()).setErrorMessage(error.message()));
        CreateTopicsResponseData data = new CreateTopicsResponseData().setTopics(topics);
        return new CreateTopicsResponse(data);
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicRequest$2(CreateTopicsRequestData.CreatableTopic creatableTopic$1, Tuple2 x$1) {
        if (x$1 != null) {
            String key = (String)x$1._1();
            Assertions.assertEquals((Object)((String)x$1._2()), (Object)creatableTopic$1.configs().find(key).value());
            return;
        }
        throw new MatchError(null);
    }

    public KraftInternalAdminTest() {
        this.kafka$server$KraftInternalAdminTest$$topicName = "topicName";
        this.expectedNumberOfPartitions = 10;
    }
}

