/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.AlterLeadershipPriorityRequestData;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityRequest;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001\u0002\u0017.\u0001IBQa\u000e\u0001\u0005\u0002aBqA\u000f\u0001A\u0002\u0013\u00051\bC\u0004J\u0001\u0001\u0007I\u0011\u0001&\t\rM\u0003\u0001\u0015)\u0003=\u0011\u001d!\u0006A1A\u0005\u0002UCaA\u0018\u0001!\u0002\u00131\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007I\u0002\u0001\u000b\u0011B1\t\u000f\u0015\u0004!\u0019!C\u0001A\"1a\r\u0001Q\u0001\n\u0005Dqa\u001a\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004i\u0001\u0001\u0006I!\u0019\u0005\u0006S\u0002!\tE\u001b\u0005\u0006w\u0002!\t\u0005 \u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\f\u0001\t\u0003\t\u0019\u0003C\u0004\u00022\u0001!\t!a\t\t\u000f\u0005U\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\b\u0001\u0005\u0002\u0005\r\u0002bBA\u001f\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u0003\u0002A\u0011AA\u0012\u0011\u001d\t)\u0005\u0001C\u0001\u0003GAq!!\u0013\u0001\t\u0003\t\u0019\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007\"\u0003B\f\u0001E\u0005I\u0011\u0002B\r\u0011%\u0011y\u0003AI\u0001\n\u0013\u0011\t\u0004C\u0005\u00036\u0001\t\n\u0011\"\u0003\u00038!I!1\b\u0001\u0012\u0002\u0013%!Q\b\u0005\n\u0005\u0003\u0002\u0011\u0013!C\u0005\u0005\u0007B\u0011Ba\u0012\u0001#\u0003%IA!\u0013\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!1\u000f\u0001\u0005\n\tU\u0004\"\u0003B>\u0001E\u0005I\u0011\u0002B\u001f\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fB\u0011B!\"\u0001#\u0003%IA!\u0010\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BN\u0001\u0011%!Q\u0014\u0005\b\u0005K\u0003A\u0011\u0002BT\u0011%\u0011\t\rAI\u0001\n\u0013\u0011\u0019E\u0001\fMK\u0006$WM]:iSB\u0004&/[8sSRLH+Z:u\u0015\tqs&\u0001\u0004tKJ4XM\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!T'D\u0001.\u0013\t1TFA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u00025\u0001\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\u0005a\u0004CA\u001fH\u001b\u0005q$BA A\u0003\u0015\tG-\\5o\u0015\t\t%)A\u0004dY&,g\u000e^:\u000b\u0005A\u001a%B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001eL!\u0001\u0013 \u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002L#B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n!QK\\5u\u0011\u001d\u00116!!AA\u0002q\n1\u0001\u001f\u00132\u00031\tG-\\5o\u00072LWM\u001c;!\u0003%!x\u000e]5d\u001d\u0006lW-F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003mC:<'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013aa\u0015;sS:<\u0017A\u0003;pa&\u001cg*Y7fA\u0005\u0011\u0001\u000fM\u000b\u0002CB\u0011AJY\u0005\u0003G6\u00131!\u00138u\u0003\r\u0001\b\u0007I\u0001\u0003aF\n1\u0001]\u0019!\u0003\t\u0001('A\u0002qe\u0001\nQa]3u+B$\"aS6\t\u000b1l\u0001\u0019A7\u0002\u0011Q,7\u000f^%oM>\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0007\u0005\u0004\u0018N\u0003\u0002sg\u00069!.\u001e9ji\u0016\u0014(B\u0001;F\u0003\u0015QWO\\5u\u0013\t1xN\u0001\u0005UKN$\u0018J\u001c4pQ\ti\u0001\u0010\u0005\u0002os&\u0011!p\u001c\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003u\u0004RA`A\u0007\u0003'q1a`A\u0005\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003c\u00051AH]8pizJ\u0011AT\u0005\u0004\u0003\u0017i\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0002TKFT1!a\u0003N!\r!\u0014QC\u0005\u0004\u0003/i#aC&bM.\f7i\u001c8gS\u001e\fAb\u0019:fCR,7i\u001c8gS\u001e$B!a\u0005\u0002\u001e!1\u0011qD\bA\u0002\u0005\faA\\8eK&#\u0017!\n;fgR\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018pV5uQR{\u0007/[2t)\u0005Y\u0005f\u0001\t\u0002(A\u0019a.!\u000b\n\u0007\u0005-rN\u0001\u0003UKN$\u0018!\r;fgR\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018pV5uQ\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0004#\u0005\u001d\u0012A\r;fgR\u001cuN\u001c;s_2dWM\u001d$bS2|g/\u001a:J[6,G-[1uK2L\u0018I\u001a;fe\u0012+Wn\u001c;f\u0005J|7.\u001a:)\u0007I\t9#A\u000euKN$\u0018\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f\u0015\u0004'\u0005\u001d\u0012\u0001\f;fgR\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u00180\u0012=dK\u0016$7/T1y\u0005J|7.\u001a:tQ\r!\u0012qE\u0001\u001fi\u0016\u001cH/\u00117uKJdU-\u00193feND\u0017\u000e]%eK6\u0004x\u000e^3oG\u0016D3!FA\u0014\u0003a\"Xm\u001d;BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5us\"\u000bg\u000e\u001a7fg:{GoQ8oiJ|G\u000e\\3s\u000bb\u001cW\r\u001d;j_:D3AFA\u0014\u0003e\"Xm\u001d;BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5us\"\u000bg\u000e\u001a7fg&sg/\u00197jIJ+\u0017/^3ti\u0016C8-\u001a9uS>t\u0007fA\f\u0002(\u0005YD/Z:u\t\u0016\u001c8M]5cK2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f%b]\u0012dWm\u001d(pi\u000e{g\u000e\u001e:pY2,'/\u0012=dKB$\u0018n\u001c8)\u0007a\t9#\u0001\u0013de\u0016\fG/\u001a\"s_.,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5usJ+7/\u001e7u)!\t\t&a\u001f\u0002\u0000\u0005e\u0005\u0003BA*\u0003krA!!\u0016\u0002p9!\u0011qKA5\u001d\u0011\tI&!\u001a\u000f\t\u0005m\u00131\r\b\u0005\u0003;\n\tG\u0004\u0003\u0002\u0002\u0005}\u0013\"\u0001$\n\u0005\u0011+\u0015B\u0001\u0019D\u0013\r\t9GQ\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0014QN\u0001\b[\u0016\u001c8/Y4f\u0015\r\t9GQ\u0005\u0005\u0003c\n\u0019(A\u0012BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5usJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005-\u0014QN\u0005\u0005\u0003o\nIH\u0001\u0010Ce>\\WM\u001d'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif\u0014Vm];mi*!\u0011\u0011OA:\u0011\u0019\ti(\u0007a\u0001C\u0006A!M]8lKJLE\rC\u0004\u0002\u0002f\u0001\r!a!\u0002-1,\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/_#ok6\u0004B!!\"\u0002\u0014:!\u0011qQAH\u001d\u0011\tI)!$\u000f\t\u0005e\u00131R\u0005\u0003\u0003\nK!a\u0010!\n\u0007\u0005Ee(\u0001\u0010Ce>\\WM\u001d'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif\u0014Vm];mi&!\u0011QSAL\u0005YaU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=F]Vl'bAAI}!9\u00111T\rA\u0002\u0005u\u0015!B3se>\u0014\b\u0003BAP\u0003Kk!!!)\u000b\t\u0005\r\u0016QN\u0001\taJ|Go\\2pY&!\u0011qUAQ\u0005\u0019)%O]8sg\u0006Ar-\u001a;MK\u0006$WM]:iSB\u0004&/[8sSRLX*\u00199\u0016\u0005\u00055\u0006cBAX\u0003o\u000b\u0017Q\u0018\b\u0005\u0003c\u000b\u0019\fE\u0002\u0002\u00025K1!!.N\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XA^\u0005\ri\u0015\r\u001d\u0006\u0004\u0003kk\u0005CBAX\u0003\u007f\u000b\u0019-\u0003\u0003\u0002B\u0006m&aA*fiB!\u0011qVAc\u0013\ri\u00161X\u0001&C2$XM\u001d'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif\fe\u000eZ$fiJ+7\u000f]8og\u0016$b\"a3\u0002X\u0006u\u0017\u0011]Az\u0003{\u00149\u0001\u0005\u0003\u0002N\u0006MWBAAh\u0015\u0011\t\t.!\u001c\u0002\u0011I,\u0017/^3tiNLA!!6\u0002P\ny\u0012\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f*fgB|gn]3\t\u0013\u0005e7\u0004%AA\u0002\u0005m\u0017!\u00032s_.,'/\u00133t!\u0011q\u0018QB1\t\u0013\u0005}7\u0004%AA\u0002\u0005\r\u0017A\u0002:fCN|g\u000eC\u0005\u0002dn\u0001\n\u00111\u0001\u0002f\u0006)\u0002O]5pe&$\u0018p\u00149fe\u0006$\u0018n\u001c8F]Vl\u0007\u0003BAt\u0003[tA!a\"\u0002j&\u0019\u00111\u001e \u00027\u0005cG/\u001a:MK\u0006$WM]:iSB\u0004&/[8sSRL8\u000b]3d\u0013\u0011\ty/!=\u0003+A\u0013\u0018n\u001c:jif|\u0005/\u001a:bi&|g.\u00128v[*\u0019\u00111\u001e \t\u0013\u0005U8\u0004%AA\u0002\u0005]\u0018!\u00024pe\u000e,\u0007c\u0001'\u0002z&\u0019\u00111`'\u0003\u000f\t{w\u000e\\3b]\"I\u0011q`\u000e\u0011\u0002\u0003\u0007!\u0011A\u0001\bm\u0016\u00148/[8o!\ra%1A\u0005\u0004\u0005\u000bi%!B*i_J$\b\"\u0003B\u00057A\u0005\t\u0019\u0001B\u0006\u00031\u0019xnY6fiN+'O^3s!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t_\u00059a.\u001a;x_J\\\u0017\u0002\u0002B\u000b\u0005\u001f\u0011AbU8dW\u0016$8+\u001a:wKJ\fq&\u00197uKJdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=B]\u0012<U\r\u001e*fgB|gn]3%I\u00164\u0017-\u001e7uIE*\"Aa\u0007+\t\u0005m'QD\u0016\u0003\u0005?\u0001BA!\t\u0003,5\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0005v]\u000eDWmY6fI*\u0019!\u0011F'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003.\t\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0013\r\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/_!oI\u001e+GOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0007\u0016\u0005\u0003\u0007\u0014i\"A\u0018bYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5us\u0006sGmR3u%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003:)\"\u0011Q\u001dB\u000f\u0003=\nG\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u00180\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yD\u000b\u0003\u0002x\nu\u0011aL1mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z\u0003:$w)\u001a;SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012*TC\u0001B#U\u0011\u0011\tA!\b\u0002_\u0005dG/\u001a:MK\u0006$WM]:iSB\u0004&/[8sSRL\u0018I\u001c3HKR\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t-#\u0006\u0002B\u0006\u0005;\t1b\u0019:fCR,Gk\u001c9jGR91J!\u0015\u0003Z\tm\u0003B\u0002\u001e#\u0001\u0004\u0011\u0019\u0006E\u0002>\u0005+J1Aa\u0016?\u0005\u0015\tE-\\5o\u0011\u0019!&\u00051\u0001\u0002D\"9!Q\f\u0012A\u0002\t}\u0013a\u0004;pa&\u001c\u0017i]:jO:lWM\u001c;\u0011\u000f\t\u0005$1N1\u0003n5\u0011!1\r\u0006\u0005\u0005K\u00129'A\u0005j[6,H/\u00192mK*\u0019!\u0011N'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\n\r\u0004#\u0002B1\u0005_\n\u0017\u0002\u0002B9\u0005G\u0012A\u0001T5ti\u0006aA-Z7pi\u0016\u0014%o\\6feR)1Ja\u001e\u0003z!1\u0011QP\u0012A\u0002\u0005D\u0011\"!>$!\u0003\u0005\r!a>\u0002-\u0011,Wn\u001c;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:p[>$XM\u0011:pW\u0016\u0014H#B&\u0003\u0002\n\r\u0005BBA?K\u0001\u0007\u0011\rC\u0005\u0002v\u0016\u0002\n\u00111\u0001\u0002x\u00069\u0002O]8n_R,'I]8lKJ$C-\u001a4bk2$HEM\u0001\"m\u0006d\u0017\u000eZ1uK:{G*Z1eKJ\u001cxJ\u001c#f[>$X\r\u001a\"s_.,'o\u001d\u000b\u0006\u0017\n-%Q\u0012\u0005\u0007)\u001e\u0002\r!a1\t\u000f\t=u\u00051\u0001\u0003\u0012\u0006\u0001B-Z7pi\u0016$'I]8lKJLEm\u001d\t\u0006\u0003_\u000by,Y\u0001'm\u0006d\u0017\u000eZ1uK2+\u0017\rZ3sgB\u0013Xm]3oi>s\u0007K]8n_R,GM\u0011:pW\u0016\u0014H#B&\u0003\u0018\ne\u0005B\u0002+)\u0001\u0004\t\u0019\r\u0003\u0004\u0002~!\u0002\r!Y\u0001#m\u0006d\u0017\u000eZ1uK2+\u0017\rZ3sgB\u0013Xm]3oi>s\u0017\t\u001c7Ce>\\WM]:\u0015\u000b-\u0013yJ!)\t\rQK\u0003\u0019AAb\u0011\u0019\u0011\u0019+\u000ba\u0001C\u0006ya.^7cKJ|eM\u0011:pW\u0016\u00148/A\u0007dQ\u0016\u001c7NU3ta>t7/\u001a\u000b\b\u0017\n%&\u0011\u0017B_\u0011\u001d\u0011YK\u000ba\u0001\u0005[\u000bq\"\u001a=qK\u000e$X\r\u001a*fgVdGo\u001d\t\u0006}\n=\u0016\u0011K\u0005\u0005\u0005c\n\t\u0002C\u0004\u00034*\u0002\rA!.\u0002\u001d\u0005\u001cG/^1m%\u0016\u001c\bo\u001c8tKB!!q\u0017B]\u001b\t\t\u0019(\u0003\u0003\u0003<\u0006M$aI!mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\n\u0005\u007fS\u0003\u0013!a\u0001\u0005\u0003\t\u0011\"\u001a:s_J\u001cu\u000eZ3\u0002/\rDWmY6SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001a\u0004")
public class LeadershipPriorityTest
extends BaseRequestTest {
    private ConfluentAdmin adminClient = null;
    private final String topicName;
    private final int p0;
    private final int p1;
    private final int p2;

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(ConfluentAdmin x$1) {
        this.adminClient = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int p0() {
        return this.p0;
    }

    public int p1() {
        return this.p1;
    }

    public int p2() {
        return this.p2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p0())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p1())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p2())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic((Admin)this.adminClient(), this.topicName(), (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)package$.MODULE$.Range().apply(0, this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.createConfig(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private KafkaConfig createConfig(int nodeId) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.AlterLeadershipPriorityMaxDemotedBrokersProp(), "2");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    @Test
    public void testAlterLeadershipPriorityWithTopics() {
        this.demoteBroker(0, this.demoteBroker$default$2());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        this.promoteBroker(0, this.promoteBroker$default$2());
        this.validateLeadersPresentOnPromotedBroker(this.topicName(), 0);
        this.demoteBroker(0, this.demoteBroker$default$2());
        this.demoteBroker(1, this.demoteBroker$default$2());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        this.demoteBroker(2, true);
        this.validateLeadersPresentOnAllBrokers(this.topicName(), 3);
    }

    @Test
    public void testAlterLeadershipPriorityWithControllerFailover() {
        this.demoteBroker(0, this.demoteBroker$default$2());
        KafkaServer controller = this.getController();
        controller.shutdown();
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        controller.startup();
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), controller.config().brokerId());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailoverImmediatelyAfterDemoteBroker() {
        this.killAllBrokers();
        this.zkClient().setLeadershipPriorityState((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.adminClientConfig().put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(this.servers(), this.listenerName()));
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 2);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 1);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testAlterLeadershipPriority() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getLeadershipPriorityMap());
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        String x$2 = "reason";
        boolean x$3 = true;
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$4 = this.alterLeadershipPriorityAndGetResponse$default$3();
        short x$5 = this.alterLeadershipPriorityAndGetResponse$default$5();
        SocketServer x$6 = this.alterLeadershipPriorityAndGetResponse$default$6();
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)x$1, x$2, x$4, x$3, x$5, x$6).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        String x$8 = "reason";
        boolean x$9 = true;
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$10 = this.alterLeadershipPriorityAndGetResponse$default$3();
        short x$11 = this.alterLeadershipPriorityAndGetResponse$default$5();
        SocketServer x$12 = this.alterLeadershipPriorityAndGetResponse$default$6();
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(2, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)x$7, x$8, x$10, x$9, x$11, x$12).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        Seq x$13 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        String x$14 = "reason2";
        boolean x$15 = true;
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$16 = this.alterLeadershipPriorityAndGetResponse$default$3();
        short x$17 = this.alterLeadershipPriorityAndGetResponse$default$5();
        SocketServer x$18 = this.alterLeadershipPriorityAndGetResponse$default$6();
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(2, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)x$13, x$14, x$16, x$15, x$17, x$18).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason", "reason2"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(3, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, true, this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason", "reason2"})))})), this.getLeadershipPriorityMap());
    }

    @Test
    public void testAlterLeadershipPriorityExceedsMaxBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)Nil$.MODULE$, this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), Errors.DEMOTION_LIMIT_REACHED.code());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, true, this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)Nil$.MODULE$, this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), Errors.DEMOTION_LIMIT_REACHED.code());
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        String x$2 = "reason";
        short x$3 = 0;
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$4 = this.alterLeadershipPriorityAndGetResponse$default$3();
        boolean x$5 = this.alterLeadershipPriorityAndGetResponse$default$4();
        SocketServer x$6 = this.alterLeadershipPriorityAndGetResponse$default$6();
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(2, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$))), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)x$1, x$2, x$4, x$5, x$3, x$6).data(), this.checkResponse$default$3());
    }

    @Test
    public void testAlterLeadershipIdempotence() {
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
    }

    @Test
    public void testAlterLeadershipPriorityHandlesNotControllerException() {
        SocketServer x$1 = this.notControllerSocketServer();
        Seq<Object> x$2 = this.alterLeadershipPriorityAndGetResponse$default$1();
        String x$3 = this.alterLeadershipPriorityAndGetResponse$default$2();
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$4 = this.alterLeadershipPriorityAndGetResponse$default$3();
        boolean x$5 = this.alterLeadershipPriorityAndGetResponse$default$4();
        short x$6 = this.alterLeadershipPriorityAndGetResponse$default$5();
        AlterLeadershipPriorityResponse response = this.alterLeadershipPriorityAndGetResponse(x$2, x$3, x$4, x$5, x$6, x$1);
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    @Test
    public void testAlterLeadershipPriorityHandlesInvalidRequestException() {
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)this.alterLeadershipPriorityAndGetResponse(this.alterLeadershipPriorityAndGetResponse$default$1(), this.alterLeadershipPriorityAndGetResponse$default$2(), this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4(), this.alterLeadershipPriorityAndGetResponse$default$5(), this.alterLeadershipPriorityAndGetResponse$default$6()).data().errorCode());
    }

    @Test
    public void testDescribeLeadershipPriorityHandlesNotControllerException() {
        DescribeLeadershipPriorityRequest request = (DescribeLeadershipPriorityRequest)new DescribeLeadershipPriorityRequest.Builder().build();
        DescribeLeadershipPriorityResponse response = (DescribeLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    private AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult createBrokerLeadershipPriorityResult(int brokerId, BrokerLeadershipPriorityResult.LeadershipPriorityEnum leadershipPriorityEnum, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        String msg = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? "" : error.message();
        return new AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult().setBrokerId(brokerId).setLeadershipPriority(leadershipPriorityEnum.id()).setErrorCode(error.code()).setErrorMessage(msg);
    }

    private scala.collection.immutable.Map<Object, scala.collection.immutable.Set<String>> getLeadershipPriorityMap() {
        DescribeLeadershipPriorityRequest request = (DescribeLeadershipPriorityRequest)new DescribeLeadershipPriorityRequest.Builder().build();
        DescribeLeadershipPriorityResponse response = (DescribeLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        response.data().demotedBrokers().forEach(demotedBroker -> {
            scala.collection.mutable.Set reasons = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            demotedBroker.reasons().forEach(reason -> reasons.add((Object)reason.reason()));
            result.put((Object)BoxesRunTime.boxToInteger((int)demotedBroker.brokerId()), (Object)reasons.toSet());
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private AlterLeadershipPriorityResponse alterLeadershipPriorityAndGetResponse(Seq<Object> brokerIds, String reason, AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum, boolean force, short version, SocketServer socketServer) {
        AlterLeadershipPriorityRequest request = new AlterLeadershipPriorityRequest.Builder(new AlterLeadershipPriorityRequestData().setBrokerIds((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)x), Seq$.MODULE$.canBuildFrom())).asJava()).setReason(reason).setPriorityOperationCode(priorityOperationEnum.id()).setForce(force)).build(version);
        return (AlterLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Seq<Object> alterLeadershipPriorityAndGetResponse$default$1() {
        return Nil$.MODULE$;
    }

    private String alterLeadershipPriorityAndGetResponse$default$2() {
        return "";
    }

    private AlterLeadershipPrioritySpec.PriorityOperationEnum alterLeadershipPriorityAndGetResponse$default$3() {
        return AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE;
    }

    private boolean alterLeadershipPriorityAndGetResponse$default$4() {
        return false;
    }

    private short alterLeadershipPriorityAndGetResponse$default$5() {
        return ApiKeys.ALTER_LEADERSHIP_PRIORITY.latestVersion();
    }

    private SocketServer alterLeadershipPriorityAndGetResponse$default$6() {
        return this.controllerSocketServer();
    }

    private void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = x0$1._1$mcI$sp();
            List value = (List)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)value.map((Function1 & Serializable & scala.Serializable)x -> LeadershipPriorityTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    private void demoteBroker(int brokerId, boolean force) {
        this.adminClient().alterLeadershipPriority(new AlterLeadershipPrioritySpec((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE, "testing", force), new AlterLeadershipPriorityOptions()).all().get();
    }

    private boolean demoteBroker$default$2() {
        return false;
    }

    private void promoteBroker(int brokerId, boolean force) {
        this.adminClient().alterLeadershipPriority(new AlterLeadershipPrioritySpec((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, "testing", force), new AlterLeadershipPriorityOptions()).all().get();
    }

    private boolean promoteBroker$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void validateNoLeadersOnDemotedBrokers(String topicName, scala.collection.immutable.Set<Object> demotedBrokerIds) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$1(this, topicName, demotedBrokerIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnPromotedBroker(String topicName, int brokerId) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$1(this, topicName, brokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnAllBrokers(String topicName, int numberOfBrokers) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$1(this, topicName, numberOfBrokers)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$3(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void checkResponse(List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult> expectedResults, AlterLeadershipPriorityResponseData actualResponse, short errorCode) {
        Assertions.assertEquals((short)errorCode, (short)actualResponse.errorCode());
        Assertions.assertEquals((int)expectedResults.size(), (int)actualResponse.brokerLeadershipPriorityResults().size());
        expectedResults.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)expectedResults.apply(i), actualResponse.brokerLeadershipPriorityResults().get(i)));
    }

    private short checkResponse$default$3() {
        return Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(TopicPartitionInfo p) {
        return p.leader().id() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(LeadershipPriorityTest $this) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList($this.topicName())).topicNameValues().get($this.topicName())).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(LeadershipPriorityTest $this) {
        return new StringBuilder(45).append("Topic ").append($this.topicName()).append(" does not have all leaders on broker 2.").toString();
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$2(scala.collection.immutable.Set demotedBrokerIds$1, TopicPartitionInfo p) {
        return !demotedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$1(LeadershipPriorityTest $this, String topicName$1, scala.collection.immutable.Set demotedBrokerIds$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$1)).topicNameValues().get(topicName$1)).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$2(demotedBrokerIds$1, p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateNoLeadersOnDemotedBrokers$4(String topicName$1) {
        return new StringBuilder(38).append("Topic ").append(topicName$1).append(" has a demoted broker as leader.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$2(int brokerId$1, TopicPartitionInfo p) {
        return p.leader().id() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$3(boolean x, boolean y) {
        return x || y;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$1(LeadershipPriorityTest $this, String topicName$2, int brokerId$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$2)).topicNameValues().get(topicName$2)).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$2(brokerId$1, p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnPromotedBroker$4(String topicName$2) {
        return new StringBuilder(41).append("Topic ").append(topicName$2).append(" has no leaders on promoted broker.").toString();
    }

    public static final /* synthetic */ int $anonfun$validateLeadersPresentOnAllBrokers$2(TopicPartitionInfo p) {
        return p.leader().id();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnAllBrokers$1(LeadershipPriorityTest $this, String topicName$3, int numberOfBrokers$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$2(p)), Buffer$.MODULE$.canBuildFrom())).toSet().size() == numberOfBrokers$1;
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnAllBrokers$3(String topicName$3) {
        return new StringBuilder(44).append("Topic ").append(topicName$3).append(" does not have leaders on all brokers.").toString();
    }

    public LeadershipPriorityTest() {
        this.topicName = "topic";
        this.p0 = 0;
        this.p1 = 1;
        this.p2 = 2;
    }
}

