/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogManager;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019A\u0004\u0001)A\u0005[!)\u0011\b\u0001C\u0001u!)A\n\u0001C\u0001u!)a\n\u0001C\u0001u!)\u0001\u000b\u0001C\u0001#\")!\u000e\u0001C\u0001u!)A\u000e\u0001C\u0001u!1a\u000e\u0001Q\u0005\n=D\u0001\"!\n\u0001A\u0013%\u0011q\u0005\u0005\u0007\u0003k\u0001A\u0011\u0001\u001e\t\r\u0005e\u0002\u0001\"\u0001;\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAaA\u001c\u0001\u0005\n\u0005U#A\u0006'jgR|eMZ:fiN\u0014V-];fgR$Vm\u001d;\u000b\u0005Q)\u0012AB:feZ,'OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\n\n\u0005q\u0019\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003\u0015!x\u000e]5d+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\nAA[1wC&\u0011\u0011\u0006\n\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001.!\tqc'D\u00010\u0015\t\u0001\u0014'\u0001\u0004d_6lwN\u001c\u0006\u0003-IR!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO&\u0011qg\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001,i\u0016\u001cH\u000fT5ti>3gm]3ugJ+\u0017/^3ti\u001a{'OT8o)&,'/\u001a3QCJ$\u0018\u000e^5p]R\t1\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\bF\u0001\u0004C!\t\u0019%*D\u0001E\u0015\t)e)A\u0002ba&T!a\u0012%\u0002\u000f),\b/\u001b;fe*\u0011\u0011\nN\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\u0012\u0013A\u0001V3ti\u0006IB/Z:u\u0019&\u001cHo\u00144gg\u0016$8/\u0012:s_J\u001cu\u000eZ3tQ\t9!)\u0001\u0015uKN$H*[:u\u001f\u001a47/\u001a;t\u001b\u0006DH+[7f'R\fW\u000e](mI\u0016\u001cHOV3sg&|g\u000e\u000b\u0002\t\u0005\u0006Y\u0012m]:feR\u0014Vm\u001d9p]N,WI\u001d:pe\u001a{'/\u00129pG\"$Ba\u000f*[?\")1+\u0003a\u0001)\u0006)QM\u001d:peB\u0011Q\u000bW\u0007\u0002-*\u0011qkL\u0001\taJ|Go\\2pY&\u0011\u0011L\u0016\u0002\u0007\u000bJ\u0014xN]:\t\u000bmK\u0001\u0019\u0001/\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"\u0001P/\n\u0005yk$aA%oi\")\u0001-\u0003a\u0001C\u0006\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i!\r\u0011WmZ\u0007\u0002G*\u0011AMJ\u0001\u0005kRLG.\u0003\u0002gG\nAq\n\u001d;j_:\fG\u000e\u0005\u0002$Q&\u0011\u0011\u000e\n\u0002\b\u0013:$XmZ3s\u0003\u001d#Xm\u001d;MSN$xJ\u001a4tKR\u001c(+Z9vKN$H)\u001e:j]\u001e\u0004\u0016M\u001d;ji&|gNU3d_Z,'/_!gi\u0016\u0014XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t\u0007F\u0001\u0006C\u0003i!Xm\u001d;DkJ\u0014XM\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8oQ\tY!)A\u0006tK:$'+Z9vKN$Hc\u00029\u0002\u000e\u0005E\u00111\u0004\t\u0004c\u0006\u001dab\u0001:\u0002\u00029\u00111O \b\u0003ivt!!\u001e?\u000f\u0005Y\\hBA<{\u001b\u0005A(BA=\u0018\u0003\u0019a$o\\8u}%\tQ'\u0003\u00024i%\u0011aCM\u0005\u0003aEJ!a`\u0018\u0002\u000f5,7o]1hK&!\u00111AA\u0003\u0003]a\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0002\u0000_%!\u0011\u0011BA\u0006\u0005qa\u0015n\u001d;PM\u001a\u001cX\r^:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TA!a\u0001\u0002\u0006!1\u0011q\u0002\u0007A\u0002q\u000b\u0001b]3sm\u0016\u0014\u0018\n\u001a\u0005\b\u0003'a\u0001\u0019AA\u000b\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002=\u0003/I1!!\u0007>\u0005\u0011auN\\4\t\u000f\u0005uA\u00021\u0001\u0002 \u00059a/\u001a:tS>t\u0007c\u0001\u001f\u0002\"%\u0019\u00111E\u001f\u0003\u000bMCwN\u001d;\u0002'\u0019,Go\u00195PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0015\u0011\u0005%\u0012qFA\u0019\u0003g\u0001b\u0001PA\u0016\u0003+a\u0016bAA\u0017{\t1A+\u001e9mKJBa!a\u0004\u000e\u0001\u0004a\u0006bBA\n\u001b\u0001\u0007\u0011Q\u0003\u0005\b\u0003;i\u0001\u0019AA\u0010\u0003}!Xm\u001d;SKN\u0004xN\\:f\u0013:\u001cG.\u001e3fg2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0003\u001d\t\u000bQ\u0007^3tiJ+7\u000f]8og\u0016$UMZ1vYR|eMZ:fi\u0006sG\rT3bI\u0016\u0014X\t]8dQ\u001a{'/\u00117m-\u0016\u00148/[8og\"\u0012qBQ\u0001\u0014CN\u001cXM\u001d;SKN\u0004xN\\:f\u000bJ\u0014xN\u001d\u000b\bw\u0005\u0005\u00131IA#\u0011\u0015\u0019\u0006\u00031\u0001U\u0011\u0015Y\u0006\u00031\u0001]\u0011\u001d\t9\u0005\u0005a\u0001\u0003\u0013\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyeL\u0001\te\u0016\fX/Z:ug&!\u00111KA'\u0005Ia\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;\u0015\r\u0005]\u0013QLA1!\u0011\tY%!\u0017\n\t\u0005m\u0013Q\n\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\u0007\u0003?\n\u0002\u0019\u0001/\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!a\u0012\u0012\u0001\u0004\tI\u0005")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListOffsetsRequestForNonTieredPartition() {
        String topicName = "test-topic";
        Properties props = new Properties();
        props.put("segment.bytes", "16384");
        props.put("retention.bytes", "-1");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), topicName, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        LogManager qual$1 = ((KafkaServer)this.serverForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 180000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testListOffsetsRequestForNonTieredPartition$1(log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestForNonTieredPartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        log.maybeIncrementHighWatermark(new LogOffsetMetadata(log.logStartOffset() + 100L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        log.maybeIncrementLogStartOffset(log.logStartOffset() + 100L, (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log, (short)0);
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testListOffsetsMaxTimeStampOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$5)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$6))).get());
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(leader, x$7))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$8))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(leader, x$9))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendRequest(serverId, request).topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$10))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$11))).get();
    }

    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple2.mcJI.sp(-1L, partitionData.leaderEpoch());
            }
            return new Tuple2.mcJI.sp(Predef$.MODULE$.Long2long((Long)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.oldStyleOffsets()).asScala()).head()), partitionData.leaderEpoch());
        }
        return new Tuple2.mcJI.sp(partitionData.offset(), partitionData.leaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10000L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10001L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.partition(), firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.servers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -3L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestForNonTieredPartition$1(AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testListOffsetsRequestForNonTieredPartition$2() {
        return "Timeout waiting for all records to be produced";
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    private final void sendListOffsetsRequestAndValidateResponse$1(Errors error, Errors debugRequestError, int brokerId, String topic$1, TopicPartition partition$1) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ver -> {
            int currentLeaderEpoch = ver >= 4 ? 0 : -1;
            java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(topic$1).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partition$1.partition()).setTimestamp(-2L).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
            ListOffsetsRequest consumerRequest = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, consumerRequest);
            ListOffsetsRequest replicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, replicaRequest);
            ListOffsetsRequest debugReplicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(debugRequestError, brokerId, debugReplicaRequest);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(int leader$2, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$8) {
        return x$8.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(int leader$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$10) {
        String string = x$10.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$11) {
        return x$11.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, 0L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$2, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$2.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$2, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$2, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

