/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.SegmentDeletion$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C!+!)a\u0005\u0001C\u0001O!)!\u000b\u0001C\u0001'\")\u0001\f\u0001C\u00013\n)C*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)&,'/\u001a3QCJ$\u0018\u000e^5p]R+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001d=i\u0011aB\u0005\u0003!\u001d\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"A\u0004\u0001\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0011)f.\u001b;\t\u000bu\u0011\u0001\u0019\u0001\u0010\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!Q\u000f^5m\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0015uKN$H*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u\r>\u0014H+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0002\u0017Q!)\u0011f\u0001a\u0001U\u00051\u0011/^8sk6\u0004\"a\u000b\u001a\u000f\u00051\u0002\u0004CA\u0017\u0019\u001b\u0005q#BA\u0018\f\u0003\u0019a$o\\8u}%\u0011\u0011\u0007G\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u000221!\"1A\u000e#F!\t9$)D\u00019\u0015\tI$(\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tYD(\u0001\u0004qCJ\fWn\u001d\u0006\u0003{y\nqA[;qSR,'O\u0003\u0002@\u0001\u0006)!.\u001e8ji*\t\u0011)A\u0002pe\u001eL!a\u0011\u001d\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t1\u0005*I\u0001H\u0003\tQ8.I\u0001J\u0003\u0015Y'/\u00194uQ\u0011\u00191j\u0014)\u0011\u00051kU\"\u0001\u001e\n\u00059S$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005\t\u0016\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006IC/Z:u\u0019&\u001cHo\u00144gKN$8OU3rk\u0016\u001cHOU3ukJt7OU3ti>\u0014X\rU8j]R$\"A\u0006+\t\u000b%\"\u0001\u0019\u0001\u0016)\t\u00111DI\u0016\u0017\u0003\r\"CC\u0001B&P!\u00061b-\u001a;dQ>3gm]3ug\u001a{'OU3qY&\u001c\u0017\r\u0006\u0004[K*dgn\u001d\t\u00037\u000el\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003?\u0002\faaY8n[>t'B\u0001\u0006b\u0015\t\u0011\u0007)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Ir\u00131\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016DQAZ\u0003A\u0002\u001d\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003/!L!!\u001b\r\u0003\u0007%sG\u000fC\u0003l\u000b\u0001\u0007!&A\u0005u_BL7MT1nK\")Q.\u0002a\u0001O\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\u0006_\u0016\u0001\r\u0001]\u0001\ni&lWm\u001d;b[B\u0004\"aF9\n\u0005ID\"\u0001\u0002'p]\u001eDQ\u0001^\u0003A\u0002U\fqA^3sg&|g\u000e\u0005\u0002\u0018m&\u0011q\u000f\u0007\u0002\u0006'\"|'\u000f\u001e")
public class ListOffsetsRequestTieredPartitionTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsRequestForTieredPartition(String quorum) {
        String topicName = "tiered-topic";
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "16384");
        props.put("confluent.tier.local.hotset.bytes", "16384");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("retention.bytes", "-1");
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(topicPartition);
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topicName, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        LogManager qual$1 = this.brokerWithId(leaderId).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 180000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffsetsRequestForTieredPartition$1(log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffsetsRequestForTieredPartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        log.maybeIncrementHighWatermark(new LogOffsetMetadata(log.logStartOffset() + 100L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        log.maybeIncrementLogStartOffset(log.logStartOffset() + 100L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log, (short)0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffestsRequestReturnsRestorePoint(String quorum) {
        String topicName = "test-topic";
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "16384");
        props.put("confluent.tier.local.hotset.bytes", "1");
        props.put("confluent.tier.local.hotset.ms", "1");
        props.put("retention.bytes", "-1");
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(topicPartition);
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topicName, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 180000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$1(this, numMessages, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 180000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$3(this, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 180000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$7(this, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsResponse latestVersionResponse = this.fetchOffsetsForReplica(leaderId, topicName, 0, -10000L, ApiKeys.LIST_OFFSETS.latestVersion());
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(latestVersionResponse.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$9(topicName, x$2))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$10(x$3))).get();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)this.leaderLog$1(leaderId, topicPartition).activeSegment().baseOffset(), (long)partitionResponse.offset());
        Assertions.assertEquals((Object)CoreUtils$.MODULE$.toKafkaUUID((UUID)this.leaderLog$1(leaderId, topicPartition).tieredLogSegments().toList().lastOption().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.metadata().objectId()).get()), (Object)partitionResponse.followerRestorePointObjectId());
        Assertions.assertEquals((int)-1, (int)partitionResponse.followerRestorePointEpoch());
        ListOffsetsResponse oldStyleResponse = this.fetchOffsetsForReplica(leaderId, topicName, 0, -10000L, (short)5);
        ListOffsetsResponseData.ListOffsetsPartitionResponse oldStylePartitionResponse = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(oldStyleResponse.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$12(topicName, x$5))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$13(x$6))).get();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)oldStylePartitionResponse.errorCode());
        Assertions.assertEquals((long)this.leaderLog$1(leaderId, topicPartition).activeSegment().baseOffset(), (long)oldStylePartitionResponse.offset());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)oldStylePartitionResponse.followerRestorePointObjectId());
    }

    public ListOffsetsResponse fetchOffsetsForReplica(int brokerId, String topicName, int partition, long timestamp, short version) {
        ListOffsetsRequestData.ListOffsetsPartition partitionRequest = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partition).setTimestamp(timestamp).setCurrentLeaderEpoch(0);
        ListOffsetsRequestData.ListOffsetsTopic topicRequest = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicName).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)partitionRequest, (List)Nil$.MODULE$)).asJava());
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)version, (int)brokerId).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicRequest, (List)Nil$.MODULE$)).asJava()).build();
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestForTieredPartition$1(AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1 && log$1.tieredLogSegments().nonEmpty() && log$1.localLogSegments().size() < log$1.numberOfSegments();
    }

    public static final /* synthetic */ String $anonfun$testListOffsetsRequestForTieredPartition$2() {
        return "Timeout waiting for some segments to tier and be deleted from local disk";
    }

    private final AbstractLog leaderLog$1(int leaderId$1, TopicPartition topicPartition$1) {
        LogManager qual$1 = this.brokerWithId(leaderId$1).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(topicPartition$1, x$2).get();
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$1(ListOffsetsRequestTieredPartitionTest $this, int numMessages$2, int leaderId$1, TopicPartition topicPartition$1) {
        return $this.leaderLog$1(leaderId$1, topicPartition$1).highWatermark() >= (long)numMessages$2;
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$2() {
        return "Timeout waiting for the HWM to advance";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$3(ListOffsetsRequestTieredPartitionTest $this, int leaderId$1, TopicPartition topicPartition$1) {
        long activeSegmentBaseOffset = $this.leaderLog$1(leaderId$1, topicPartition$1).activeSegment().baseOffset();
        return BoxesRunTime.equals((Object)$this.leaderLog$1(leaderId$1, topicPartition$1).tieredLogSegments().toList().lastOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.nextOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0), (Object)BoxesRunTime.boxToLong((long)activeSegmentBaseOffset));
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$6() {
        return "Timeout waiting for all segments to tier";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$7(ListOffsetsRequestTieredPartitionTest $this, int leaderId$1, TopicPartition topicPartition$1) {
        $this.leaderLog$1(leaderId$1, topicPartition$1).deleteOldSegments(Integer.MAX_VALUE);
        return $this.leaderLog$1(leaderId$1, topicPartition$1).localLogStartOffset() == $this.leaderLog$1(leaderId$1, topicPartition$1).activeSegment().baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$8() {
        return "Timeout waiting for all tiered segments to be deleted from the local log";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$9(String topicName$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$2) {
        String string = x$2.name();
        return !(string != null ? !string.equals(topicName$1) : topicName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$10(ListOffsetsResponseData.ListOffsetsPartitionResponse x$3) {
        return x$3.partitionIndex() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$12(String topicName$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        return !(string != null ? !string.equals(topicName$1) : topicName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$13(ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == 0;
    }

    public ListOffsetsRequestTieredPartitionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
    }
}

