/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.MaybeResolvedTimestampAndOffset;
import kafka.common.TierUnfetchedTimestampAndOffset;
import kafka.log.AbstractLog;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005B\u0015BQ\u0001\f\u0001\u0005R5BQa\u000f\u0001\u0005\u0002qBQ\u0001\u001c\u0001\u0005\u00025DQa\u001d\u0001\u0005\u0002QDQ!\u001f\u0001\u0005\u0002iDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0003 \u0001!IA!\t\t\u000f\t]\u0002\u0001\"\u0003\u0003:\tiAj\\4PM\u001a\u001cX\r\u001e+fgRT!\u0001G\r\u0002\rM,'O^3s\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003]I!\u0001I\f\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0012\u0011\u0005y\u0001\u0011a\u00032s_.,'oQ8v]R,\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0004\u0013:$\u0018a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tq\u0013\u0007\u0005\u0002(_%\u0011\u0001\u0007\u000b\u0002\u0005+:LG\u000fC\u00033\u0007\u0001\u00071'A\u0003qe>\u00048\u000f\u0005\u00025s5\tQG\u0003\u00027o\u0005!Q\u000f^5m\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\u0015A\u0013x\u000e]3si&,7/A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5d)\tqS\bC\u0003?\t\u0001\u0007q(\u0001\u0004rk>\u0014X/\u001c\t\u0003\u0001\u001es!!Q#\u0011\u0005\tCS\"A\"\u000b\u0005\u0011[\u0012A\u0002\u001fs_>$h(\u0003\u0002GQ\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0005\u0006\u000b\u0003\u0005\u0017fS\u0006C\u0001'X\u001b\u0005i%B\u0001(P\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001)R\u0003\u0019\u0001\u0018M]1ng*\u0011!kU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!V+A\u0003kk:LGOC\u0001W\u0003\ry'oZ\u0005\u000316\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA.^C\u0005a\u0016A\u0001>lC\u0005q\u0016!B6sC\u001a$\bF\u0001\u0003a!\t\t'-D\u0001P\u0013\t\u0019wJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001B3iUB\u0011qEZ\u0005\u0003O\"\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005I\u0017!\u0006'jgR|eMZ:fiN\u0014V-];fgR\u0004c\u000bM\u0011\u0002W\u0006\u0001\u0011\u0001\t;fgR<U\r^(gMN,Go]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIN$\"A\f8\t\u000by*\u0001\u0019A )\t\u0015Y\u0015\f\u001d\u0017\u00037vC#!\u00021)\t\u0015)\u0007N[\u00017i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9BMR,'\u000f\u0016:v]\u000e\fG/\u001a\u000b\u0003]UDQA\u0010\u0004A\u0002}BCAB&Zo2\u00121,\u0018\u0015\u0003\r\u0001\f\u0001\t^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B4uN]'bqRKW.Z:uC6\u0004x+\u001b;i+:|'\u000fZ3sK\u0012$\u0016.\\3ti\u0006l\u0007o\u001d\u000b\u0003]mDQAP\u0004A\u0002}BCaB&Z{2\u00121,\u0018\u0015\u0003\u000f\u0001\fa\u0004^3ti\u001e+Go\u00144gg\u0016$8OQ3g_J,G*\u0019;fgR$\u0016.\\3\u0015\u00079\n\u0019\u0001C\u0003?\u0011\u0001\u0007q\bK\u0003\t\u0017f\u000b9\u0001\f\u0002\\;\"\u0012\u0001\u0002Y\u0001\u0018i\u0016\u001cH/R7qifdunZ:HKR|eMZ:fiN$2ALA\b\u0011\u0015q\u0014\u00021\u0001@Q\u0015I1*WA\nY\tYV\f\u000b\u0002\nA\u0006)D/Z:u\r\u0016$8\r[(gMN,GOQ=US6,7\u000f^1na\u001a{'/T1y)&lWm\u001d;b[B<\u0016\u000e\u001e5F[B$\u0018\u0010T8h)\rq\u00131\u0004\u0005\u0006})\u0001\ra\u0010\u0015\u0006\u0015-K\u0016q\u0004\u0017\u00037vC#A\u00031\u0002/Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u001d><Hc\u0001\u0018\u0002(!)ah\u0003a\u0001\u007f!*1bS-\u0002,1\u00121,\u0018\u0015\u0003\u0017\u0001DSaC3\u00022)\f#!a\r\u000211,w-Y2z\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X-\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,Gc\u0001\u0018\u0002:!)a\b\u0004a\u0001\u007f!*AbS-\u0002>1\u00121,\u0018\u0015\u0003\u0019\u0001DS\u0001D3\u00022)\fQ\u0006^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:CK\u001a|'/Z,ji\"\u001c\u0005.\u00198hS:<7+Z4nK:$8+\u001b>f)\rq\u0013q\t\u0005\u0006}5\u0001\ra\u0010\u0015\u0006\u001b-K\u00161\n\u0017\u00037vC#!\u00041\u0002UQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8ugR\u0019a&a\u0015\t\u000byr\u0001\u0019A )\u000b9Y\u0015,a\u0016-\u0005mk\u0006F\u0001\ba\u0003\u0019\u0011'o\\6feV\u0011\u0011q\f\t\u0004=\u0005\u0005\u0014bAA2/\tY1*\u00194lC\n\u0013xn[3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$H\u0003BA5\u0003\u007f\u0002B!a\u001b\u0002|5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t\u0019(!\u001e\u0002\r\r|W.\\8o\u0015\rQ\u0012q\u000f\u0006\u0004\u0003s*\u0016AB1qC\u000eDW-\u0003\u0003\u0002~\u00055$a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007bBAA!\u0001\u0007\u00111Q\u0001\be\u0016\fX/Z:u!\u0011\tY'!\"\n\t\u0005\u001d\u0015Q\u000e\u0002\u0013\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH/\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR!\u0011QRAJ!\u0011\tY'a$\n\t\u0005E\u0015Q\u000e\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000f\u0005\u0005\u0015\u00031\u0001\u0002\u0016B!\u00111NAL\u0013\u0011\tI*!\u001c\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\u0002!\t,\u0018\u000e\u001c3UCJ<W\r\u001e+j[\u0016\u001cH\u0003CAP\u0003/\f\u0019/!<\u0011\r\u0005\u0005\u00161VAY\u001d\u0011\t\u0019+a*\u000f\u0007\t\u000b)+C\u0001*\u0013\r\tI\u000bK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\t1K7\u000f\u001e\u0006\u0004\u0003SC\u0003\u0003BAZ\u0003#tA!!.\u0002L:!\u0011qWAd\u001d\u0011\tI,!2\u000f\t\u0005m\u00161\u0019\b\u0005\u0003{\u000b\tMD\u0002C\u0003\u007fK\u0011AV\u0005\u0004\u0003s*\u0016b\u0001\u000e\u0002x%!\u00111OA;\u0013\u0011\tI-!\u001d\u0002\u000f5,7o]1hK&!\u0011QZAh\u0003Ya\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;ECR\f'\u0002BAe\u0003cJA!a5\u0002V\n\u0001B*[:u\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019\u0006\u0005\u0003\u001b\fy\rC\u0004\u0002ZJ\u0001\r!a7\u0002\u0005Q\u0004\b\u0003BAo\u0003?l!!!\u001d\n\t\u0005\u0005\u0018\u0011\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)O\u0005a\u0001\u0003O\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u001d\nI/C\u0002\u0002l\"\u0012A\u0001T8oO\"1\u0011q\u001e\nA\u0002\u0019\nQ\"\\1y\u001dVlwJ\u001a4tKR\u001c\u0018!\u00044j]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002v\n\r!Q\u0004\t\u0005\u0003o\fiP\u0004\u0003\u00026\u0006e\u0018\u0002BA~\u0003\u001f\fq\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005}(\u0011\u0001\u0002\u001d\u0019&\u001cHo\u00144gg\u0016$8\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\u0015\u0011\tY0a4\t\u000f\t\u00151\u00031\u0001\u0003\b\u00051Ao\u001c9jGN\u0004bA!\u0003\u0003\u0014\t]QB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u000f5,H/\u00192mK*\u0019!\u0011\u0003\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0016\t-!A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002x\ne\u0011\u0002\u0002B\u000e\u0005\u0003\u0011\u0001\u0004T5ti>3gm]3ugR{\u0007/[2SKN\u0004xN\\:f\u0011\u001d\tIn\u0005a\u0001\u00037\fAc\u0019:fCR,Gk\u001c9jG\u0006sGmR3u\u0019><GC\u0002B\u0012\u0005_\u0011\u0019\u0004\u0005\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011I#G\u0001\u0004Y><\u0017\u0002\u0002B\u0017\u0005O\u00111\"\u00112tiJ\f7\r\u001e'pO\"1!\u0011\u0007\u000bA\u0002}\nQ\u0001^8qS\u000eDqA!\u000e\u0015\u0001\u0004\tY.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u00021\u0005\u001c8/\u001a:u)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fF\u0004/\u0005w\u0011yEa\u0015\t\u000f\tuR\u00031\u0001\u0003@\u0005\u0011B/[7fgR\fW\u000e]!oI>3gm]3u!\u00159#\u0011\tB#\u0013\r\u0011\u0019\u0005\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\u001d#1J\u0007\u0003\u0005\u0013R1!a\u001d\u001a\u0013\u0011\u0011iE!\u0013\u0003?5\u000b\u0017PY3SKN|GN^3e)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0003RU\u0001\r!a:\u0002#\u0015D\b/Z2uK\u0012$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003VU\u0001\r!a:\u0002\u001d\u0015D\b/Z2uK\u0012|eMZ:fi\":\u0001A!\u0017\u0003f\t\u001d\u0004\u0003\u0002B.\u0005Cj!A!\u0018\u000b\u0007\t}\u0013+A\u0002ba&LAAa\u0019\u0003^\t9A+[7f_V$\u0018!\u0002<bYV,gDA\u0001-\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)firstOffset, 19L, 19L);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)secondOffset, -1L, 0L);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L})).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, 6L, 5L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala()).head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, -1L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeNow$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeEarliestTime$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)new Iterable<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public GenericCompanion<Iterable> companion() {
                return Iterable.companion$((Iterable)this);
            }

            public Iterable<LogSegment> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public Iterable<LogSegment> thisCollection() {
                return IterableLike.thisCollection$((IterableLike)this);
            }

            public Iterable toCollection(Object repr) {
                return IterableLike.toCollection$((IterableLike)this, (Object)repr);
            }

            public <U> void foreach(Function1<LogSegment, U> f) {
                IterableLike.foreach$((IterableLike)this, f);
            }

            public boolean forall(Function1<LogSegment, Object> p) {
                return IterableLike.forall$((IterableLike)this, p);
            }

            public boolean exists(Function1<LogSegment, Object> p) {
                return IterableLike.exists$((IterableLike)this, p);
            }

            public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                return IterableLike.find$((IterableLike)this, p);
            }

            public boolean isEmpty() {
                return IterableLike.isEmpty$((IterableLike)this);
            }

            public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableLike.foldRight$((IterableLike)this, z, op);
            }

            public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                return (B)IterableLike.reduceRight$((IterableLike)this, op);
            }

            public Iterable<LogSegment> toIterable() {
                return IterableLike.toIterable$((IterableLike)this);
            }

            public Iterator<LogSegment> toIterator() {
                return IterableLike.toIterator$((IterableLike)this);
            }

            public Object head() {
                return IterableLike.head$((IterableLike)this);
            }

            public Object slice(int from, int until) {
                return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
            }

            public Object take(int n) {
                return IterableLike.take$((IterableLike)this, (int)n);
            }

            public Object drop(int n) {
                return IterableLike.drop$((IterableLike)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
            }

            public Iterator<Iterable<LogSegment>> grouped(int size) {
                return IterableLike.grouped$((IterableLike)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size) {
                return IterableLike.sliding$((IterableLike)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
            }

            public Object takeRight(int n) {
                return IterableLike.takeRight$((IterableLike)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableLike.dropRight$((IterableLike)this, (int)n);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
            }

            public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.zip$((IterableLike)this, that, bf);
            }

            public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
            }

            public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
            }

            public <B> boolean sameElements(GenIterable<B> that) {
                return IterableLike.sameElements$((IterableLike)this, that);
            }

            public Stream<LogSegment> toStream() {
                return IterableLike.toStream$((IterableLike)this);
            }

            public boolean canEqual(Object that) {
                return IterableLike.canEqual$((IterableLike)this, (Object)that);
            }

            public IterableView<LogSegment, Iterable<LogSegment>> view() {
                return IterableLike.view$((IterableLike)this);
            }

            public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                return IterableLike.view$((IterableLike)this, (int)from, (int)until);
            }

            public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, Iterable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$((TraversableLike)this);
            }

            public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                return TraversableLike.parCombiner$((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.map$((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$((TraversableLike)this, (Function1)p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
            }

            public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                return TraversableLike.partition$((TraversableLike)this, p);
            }

            public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                return TraversableLike.groupBy$((TraversableLike)this, f);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
            }

            public Option<LogSegment> headOption() {
                return TraversableLike.headOption$((TraversableLike)this);
            }

            public Object tail() {
                return TraversableLike.tail$((TraversableLike)this);
            }

            public Object last() {
                return TraversableLike.last$((TraversableLike)this);
            }

            public Option<LogSegment> lastOption() {
                return TraversableLike.lastOption$((TraversableLike)this);
            }

            public Object init() {
                return TraversableLike.init$((TraversableLike)this);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                return TraversableLike.span$((TraversableLike)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                return TraversableLike.splitAt$((TraversableLike)this, (int)n);
            }

            public Iterator<Iterable<LogSegment>> tails() {
                return TraversableLike.tails$((TraversableLike)this);
            }

            public Iterator<Iterable<LogSegment>> inits() {
                return TraversableLike.inits$((TraversableLike)this);
            }

            public Traversable<LogSegment> toTraversable() {
                return TraversableLike.toTraversable$((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                return (Col)TraversableLike.to$((TraversableLike)this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$((TraversableLike)this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$((TraversableLike)this);
            }

            public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                return TraversableLike.withFilter$((TraversableLike)this, p);
            }

            public Parallel par() {
                return Parallelizable.par$((Parallelizable)this);
            }

            public List<LogSegment> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<LogSegment, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<LogSegment> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Seq<LogSegment> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<LogSegment> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<LogSegment> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return new .colon.colon((Object)this.logSegment$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Parallelizable.$init$((Parallelizable)this);
                TraversableLike.$init$((TraversableLike)this);
                GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                GenTraversable.$init$((GenTraversable)this);
                Traversable.$init$((Traversable)this);
                GenIterable.$init$((GenIterable)this);
                IterableLike.$init$((IterableLike)this);
                Iterable.$init$((Iterable)this);
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$2))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$3))).get();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$createTopicAndGetLog$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private void assertTimestampAndOffset(Option<MaybeResolvedTimestampAndOffset> timestampAndOffset, long expectedTimestamp, long expectedOffset) {
        MaybeResolvedTimestampAndOffset maybeResolvedTimestampAndOffset = (MaybeResolvedTimestampAndOffset)timestampAndOffset.get();
        if (maybeResolvedTimestampAndOffset instanceof FetchedTimestampAndOffset) {
            FetchedTimestampAndOffset fetchedTimestampAndOffset = (FetchedTimestampAndOffset)maybeResolvedTimestampAndOffset;
            Assertions.assertEquals((long)expectedOffset, (long)fetchedTimestampAndOffset.offset());
            Assertions.assertEquals((long)expectedTimestamp, (long)fetchedTimestampAndOffset.timestamp());
            return;
        }
        if (maybeResolvedTimestampAndOffset instanceof TierUnfetchedTimestampAndOffset) {
            throw new AssertionError((Object)"unexpected ListOffset result from the tier portion of the log");
        }
        throw new AssertionError((Object)"unexpected ListOffset result from max timestamp query");
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(AbstractLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(AbstractLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$2) {
        String string = x$2.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$3) {
        return x$3.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

