/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dq!\u0002\u000e\u001c\u0011\u0003\u0001c!\u0002\u0012\u001c\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"\u0002\u0017\u0002\t\u0003i\u0003\"B\u001e\u0002\t\u0003i\u0003\"\u0002\u001f\u0002\t\u0003i\u0003\"B\u001f\u0002\t\u0003qd\u0001\u0002\u0012\u001c\u0001MCQAK\u0004\u0005\u0002QCqAV\u0004C\u0002\u0013\u0005q\u000b\u0003\u0004\\\u000f\u0001\u0006I\u0001\u0017\u0005\u00069\u001e!\t!\u0018\u0005\u0006o\u001e!\t\u0001\u001f\u0005\u0006{\u001e!\tA \u0005\b\u0003\u000f9A\u0011AA\u0005\u0011\u001d\t\u0019b\u0002C\u0005\u0003+Aq!!$\b\t\u0003\ty\tC\u0004\u0002\u001a\u001e!\t!a'\t\u000f\u0005\u0015v\u0001\"\u0001\u0002(\"9\u0011\u0011W\u0004\u0005\u0002\u0005M\u0006bBA_\u000f\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0017<A\u0011AAg\u0011\u001d\tIn\u0002C\u0001\u00037Dq!!:\b\t\u0003\t9\u000fC\u0004\u0002r\u001e!\t!a=\t\u000f\t\rq\u0001\"\u0001\u0002t\u0006\tR*\u001a;bI\u0006$\u0018mQ1dQ\u0016$Vm\u001d;\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!I\u0001\u000e\u0003m\u0011\u0011#T3uC\u0012\fG/Y\"bG\",G+Z:u'\t\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\nqB_6DC\u000eDW\r\u0015:pm&$WM\u001d\u000b\u0002]A\u0019qF\u000e\u001d\u000e\u0003AR!!\r\u001a\u0002\rM$(/Z1n\u0015\t\u0019D'\u0001\u0003vi&d'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oA\u0012aa\u0015;sK\u0006l\u0007CA\u0011:\u0013\tQ4DA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000eG\u0006\u001c\u0007.\u001a)s_ZLG-\u001a:\u000215,H\u000e^5UK:\fg\u000e^\"bG\",\u0007K]8wS\u0012,'/A\u0006va\u0012\fG/Z\"bG\",GcA C\tB\u0011Q\u0005Q\u0005\u0003\u0003\u001a\u0012A!\u00168ji\")1I\u0002a\u0001q\u0005)1-Y2iK\")QI\u0002a\u0001\r\u00069!/Z9vKN$\bCA$R\u001b\u0005A%BA%K\u0003!\u0011X-];fgR\u001c(BA&M\u0003\u0019\u0019w.\\7p]*\u0011a$\u0014\u0006\u0003\u001d>\u000ba!\u00199bG\",'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u0011\n)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$8CA\u0004%)\u0005)\u0006CA\u0011\b\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003a\u0003\"!J-\n\u0005i3#\u0001\u0002'p]\u001e\fAB\u0019:pW\u0016\u0014X\t]8dQ\u0002\n\u0011eZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1O_:,\u00050[:uS:<Gk\u001c9jGN$\"a\u00100\t\u000b\r[\u0001\u0019\u0001\u001d)\t-\u0001G.\u001c\t\u0003C*l\u0011A\u0019\u0006\u0003G\u0012\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003K\u001a\fa\u0001]1sC6\u001c(BA4i\u0003\u001dQW\u000f]5uKJT!![(\u0002\u000b),h.\u001b;\n\u0005-\u0014'\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u00018\"\u0003mBCa\u00039ukB\u0011\u0011O]\u0007\u0002I&\u00111\u000f\u001a\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013A^\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b)\ty\u0014\u0010C\u0003D\u0019\u0001\u0007\u0001\b\u000b\u0003\rA2\\H&\u00018)\t1\u0001H/^\u0001,O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mKR\u0011qh \u0005\u0006\u00076\u0001\r\u0001\u000f\u0015\u0006\u001b\u0001d\u00171\u0001\u0017\u0002]\"\"Q\u0002\u001d;v\u0003U:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MSN$XM\\3s\u001d>$\u0018I^1jY\u0006\u0014G.Z(o\u0019\u0016\fG-\u001a:\u0015\u0007}\nY\u0001C\u0003D\u001d\u0001\u0007\u0001\bK\u0003\u000fA2\fy\u0001L\u0001oQ\u0011q\u0001\u000f^;\u0002qY,'/\u001b4z)>\u0004\u0018nY'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u001fJ,e\u000e\u001a9pS:$hj\u001c;Bm\u0006LG.\u00192mKRyq(a\u0006\u0002\u001a\u0005\r\u0012qLA8\u0003g\n\u0019\tC\u0003D\u001f\u0001\u0007\u0001\bC\u0004\u0002\u001c=\u0001\r!!\b\u0002+5,G/\u00193bi\u0006\u001c\u0015m\u00195f\u0005J|7.\u001a:JIB\u0019Q%a\b\n\u0007\u0005\u0005bEA\u0002J]RDq!!\n\u0010\u0001\u0004\t9#A\u0004ce>\\WM]:\u0011\r\u0005%\u0012qFA\u001a\u001b\t\tYCC\u0002\u0002.\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\u000b\u0003\u0007M+\u0017\u000f\u0005\u0003\u00026\u0005ec\u0002BA\u001c\u0003'rA!!\u000f\u0002P9!\u00111HA'\u001d\u0011\ti$a\u0013\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0016B\u0001(P\u0013\tqR*\u0003\u0002L\u0019&\u0019\u0011\u0011\u000b&\u0002\u000f5,7o]1hK&!\u0011QKA,\u0003e)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR$\u0015\r^1\u000b\u0007\u0005E#*\u0003\u0003\u0002\\\u0005u#\u0001F+qI\u0006$X-T3uC\u0012\fG/\u0019\"s_.,'O\u0003\u0003\u0002V\u0005]\u0003bBA1\u001f\u0001\u0007\u00111M\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e&\u0002\u000f9,Go^8sW&!\u0011QNA4\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\t\th\u0004a\u0001\u0003;\ta\u0001\\3bI\u0016\u0014\bbBA;\u001f\u0001\u0007\u0011qO\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! K\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAA\u0003w\u0012a!\u0012:s_J\u001c\bbBAC\u001f\u0001\u0007\u0011qQ\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148\u000fE\u0002&\u0003\u0013K1!a#'\u0005\u001d\u0011un\u001c7fC:\f1eZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKBd\u0017nY1O_R\fe/Y5mC\ndW\rF\u0002@\u0003#CQa\u0011\tA\u0002aBS\u0001\u00051m\u0003+c\u0013A\u001c\u0015\u0005!A$X/A\u0010hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC&\u001b(OT8u\u0003Z\f\u0017\u000e\\1cY\u0016$2aPAO\u0011\u0015\u0019\u0015\u00031\u00019Q\u0015\t\u0002\r\\AQY\u0005q\u0007\u0006B\tqiV\f\u0001gZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1XSRDgj\u001c8TkB\u0004xN\u001d;fIN+7-\u001e:jif\u0004&o\u001c;pG>dGcA \u0002*\")1I\u0005a\u0001q!*!\u0003\u00197\u0002.2\na\u000e\u000b\u0003\u0013aR,\u0018AL4fi\u0006c\u0017N^3Ce>\\WM]:TQ>,H\u000e\u001a(pi\n+W*\u001e;bi\u0016$')_+qI\u0006$XmQ1dQ\u0016$2aPA[\u0011\u0015\u00195\u00031\u00019Q\u0015\u0019\u0002\r\\A]Y\u0005q\u0007\u0006B\nqiV\fAcZ3u\u00032dGk\u001c9jGN\u0014\u0015\u0010V3oC:$HcA \u0002B\")1\t\u0006a\u0001q!*A\u0003\u00197\u0002F2\u0012\u0011qY\u0011\u0002y!\"A\u0003\u001d;v\u0003U:W\r^!mYR{\u0007/[2t\u0005f$VM\\1oiNCw.\u001e7e\r\u0006LG.\u00134DC\u000eDW-S:O_RlU\u000f\u001c;j)\u0016t\u0017M\u001c;\u0015\u0007}\ny\rC\u0003D+\u0001\u0007\u0001\bK\u0003\u0016A2\f\u0019\u000e\f\u0002\u0002V\u0006\nA\u0006\u000b\u0003\u0016aR,\u0018\u0001I4fi\u0006c\u0017N^3s\u0005J|7.\u001a:t'\"|W\u000f\u001c3SKR,(O\u001c+bON$2aPAo\u0011\u0015\u0019e\u00031\u00019Q\u00151\u0002\r\\AqY\t\t)\u000e\u000b\u0003\u0017aR,\u0018!\u000b;fgR<U\r^\"mkN$XM]'fi\u0006$\u0017\r^1XSRDwJ\u001a4mS:,'+\u001a9mS\u000e\f7\u000fF\u0002@\u0003SDQaQ\fA\u0002aBSa\u00061m\u0003[d#!!6)\t]\u0001H/^\u0001\u0013i\u0016\u001cH/S:Ce>\\WM\u001d$f]\u000e,G\rF\u0001@Q\rA\u0012q\u001f\t\u0005\u0003s\fy0\u0004\u0002\u0002|*\u0019\u0011Q 4\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\u0002\u0005m(\u0001\u0002+fgR\f\u0001\u0005^3ti&\u001b(I]8lKJLenQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001a\u0011$a>")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache metadataCache, UpdateMetadataRequest updateMetadataRequest) {
        MetadataCacheTest$.MODULE$.updateCache(metadataCache, updateMetadataRequest);
    }

    public static Stream<MetadataCache> multiTenantCacheProvider() {
        return MetadataCacheTest$.MODULE$.multiTenantCacheProvider();
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)})), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isrNodes()).asScala()).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isrNodes()).asScala()).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isrNodes()).asScala()).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isrNodes()).asScala()).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"multiTenantCacheProvider"})
    public void getAllTopicsByTenant(MetadataCache cache) {
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getAllTopicsByTenant$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
        int numTenants = 10;
        int numTopics = 10;
        int numPartitions = 10;
        ListBuffer partitionStates = new ListBuffer();
        HashMap topicIds = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)topic -> {
            String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
            topicIds.put(topicName, Uuid.randomUuid());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> partitionStates.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{MetadataCacheTest.createPartition$1(topicName, part, controllerEpoch, zkVersion)})));
        }));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)numTopics, (int)topicNames.size());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)topic -> {
                String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
            });
        });
        ListBuffer partitionStates2 = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> {
            String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(numTopics).toString();
            topicIds.put(topicName, Uuid.randomUuid());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> partitionStates2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{MetadataCacheTest.createPartition$1(topicName, part, controllerEpoch, zkVersion)})));
        });
        UpdateMetadataRequest updateMetadataRequest2 = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)partitionStates2).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)(numTopics + 1), (int)topicNames.size());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)topic -> {
                String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                Assertions.assertTrue((boolean)topicIds.containsKey(topicName));
                Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
            });
        });
        ListBuffer partitionStates3 = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> {
            String topicName = new StringBuilder(11).append("lkc-").append(tenant).append("_topic2").toString();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> partitionStates3.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{MetadataCacheTest.createPartition$1(topicName, part, controllerEpoch, zkVersion).setLeader(LeaderAndIsr$.MODULE$.LeaderDuringDelete())})));
        });
        UpdateMetadataRequest updateMetadataRequest3 = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)partitionStates3).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)numTopics, (int)topicNames.size());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)topic -> {
                if (topic != 2) {
                    String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                    topicIds.put(topicName, Uuid.randomUuid());
                    Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
                }
            });
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void getAllTopicsByTenantShouldFailIfCacheIsNotMultiTenant(MetadataCache cache) {
        Assertions.assertTrue((boolean)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> cache.getAllTopics((Option)new Some((Object)"foo")))).getMessage().startsWith("Multi-tenant getAllTopics but metadataCache is not multitenant"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void getAliverBrokersShouldReturnTags(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliverBrokersShouldReturnTags$1(securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
        HashMap topicIds = new HashMap();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Iterable liveBrokers = cache.getAliveBrokers();
        Assertions.assertEquals((Object)((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), IndexedSeq$.MODULE$.canBuildFrom())).toSet(), (Object)((TraversableOnce)liveBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
        liveBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataCacheTest.$anonfun$getAliverBrokersShouldReturnTags$4(cache, listenerName, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack(null).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> offline = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092);
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())).toSeq());
    }

    @Test
    public void testIsBrokerFenced() {
        KRaftMetadataCache metadataCache = MetadataCache$.MODULE$.kRaftMetadataCache(0);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, x$8 -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply());
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply());
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        KRaftMetadataCache metadataCache = MetadataCache$.MODULE$.kRaftMetadataCache(0);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, x$9 -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply());
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply());
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$4) {
        return x$4.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    private static final Seq endpoints$3(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAllTopicsByTenant$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(MetadataCacheTest.endpoints$3(brokerId)).asJava()).setRack("rack1");
    }

    private static final UpdateMetadataRequestData.UpdateMetadataPartitionState createPartition$1(String topicName, int partition, int controllerEpoch$1, int zkVersion$1) {
        return new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partition).setControllerEpoch(controllerEpoch$1).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})).setZkVersion(zkVersion$1).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}));
    }

    private static final scala.collection.immutable.Map tags$1(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.cell"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.broker"), (Object)Integer.toString(brokerId))}));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliverBrokersShouldReturnTags$1(SecurityProtocol securityProtocol$1, ListenerName listenerName$2, int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(new StringBuilder(5).append("host-").append(brokerId).toString()).setPort(9092).setSecurityProtocol(securityProtocol$1.id).setListener(listenerName$2.value()), (List)Nil$.MODULE$)).asJava()).setTags(UpdateMetadataRequest.brokerTagCollectionFromTagMap((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)MetadataCacheTest.tags$1(brokerId)).asJava())));
    }

    public static final /* synthetic */ void $anonfun$getAliverBrokersShouldReturnTags$4(MetadataCache cache$5, ListenerName listenerName$2, BrokerMetadata broker) {
        Option node = cache$5.getAliveBrokerNode(broker.id(), listenerName$2);
        Assertions.assertEquals((Object)MetadataCacheTest.tags$1(broker.id()), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfluentNode.tags((Node)((Node)node.get()))).asScala());
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

