/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayDeque;
import java.util.Iterator;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.MockBrokerToControllerChannelManager$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tq\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u00115\u0003!\u0011!Q\u0001\n)C\u0001B\u0014\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0015\")\u0001\u000b\u0001C\u0001#\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006B\u00024\u0001A\u0003%1\fC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003m\u0001\u0011\u0005\u0003\u000eC\u0003n\u0001\u0011\u0005c\u000e\u0003\u0004E\u0001\u0011\u0005\u0013Q\u0004\u0005\t\u0003K\u0001A\u0011A\u000e\u0002(!1\u0011q\u0007\u0001\u0005\u0002!Da!!\u000f\u0001\t\u0003Iu!CA\u001e7\u0005\u0005\t\u0012AA\u001f\r!Q2$!A\t\u0002\u0005}\u0002B\u0002)\u0016\t\u0003\t\t\u0005C\u0005\u0002DU\t\n\u0011\"\u0001\u0002F!I\u00111L\u000b\u0012\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003C*\u0012\u0013!C\u0001\u0003;\u0012A%T8dW\n\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0006\u00039u\taa]3sm\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA\u0013&D\u0001\u001c\u0013\tQ3D\u0001\u0011Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018AB2mS\u0016tG/F\u0001.!\tqc'D\u00010\u0015\t\u0001\u0014'A\u0004dY&,g\u000e^:\u000b\u0005y\u0011$BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001eL!aN\u0018\u0003\u00155{7m[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002\tQLW.\u001a\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{u\tQ!\u001e;jYNL!a\u0010\u001f\u0003\u00115{7m\u001b+j[\u0016\facY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\t\u0003Q\tK!aQ\u000e\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fQcY8oiJ|G\u000e\\3s\u0003BLg+\u001a:tS>t7\u000f\u0005\u0002/\r&\u0011qi\f\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0006q!/\u001a;ssRKW.Z8vi6\u001bX#\u0001&\u0011\u0005\tZ\u0015B\u0001'$\u0005\rIe\u000e^\u0001\u0010e\u0016$(/\u001f+j[\u0016|W\u000f^'tA\u0005\u0001\"/Z9vKN$H+[7f_V$Xj]\u0001\u0012e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0013A\u0002\u001fj]&$h\bF\u0004S'R+fk\u0016-\u0011\u0005!\u0002\u0001\"B\u0016\u000b\u0001\u0004i\u0003\"B\u001d\u000b\u0001\u0004Q\u0004\"\u0002!\u000b\u0001\u0004\t\u0005b\u0002#\u000b!\u0003\u0005\r!\u0012\u0005\b\u0011*\u0001\n\u00111\u0001K\u0011\u001dq%\u0002%AA\u0002)\u000b1\"\u001e8tK:$\u0018+^3vKV\t1\fE\u0002]C\u000el\u0011!\u0018\u0006\u0003=~\u000bA!\u001e;jY*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012^\u0005)\t%O]1z\t\u0016\fX/\u001a\t\u0003Q\u0011L!!Z\u000e\u00037\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM])vKV,\u0017\n^3n\u00031)hn]3oiF+X-^3!\u0003\u0015\u0019H/\u0019:u)\u0005I\u0007C\u0001\u0012k\u0013\tY7E\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005S>\f\u0019\u0002C\u0003q\u001f\u0001\u0007\u0011/A\u0004sKF,Xm\u001d;1\u0007I\f\t\u0001E\u0002twzt!\u0001^=\u000e\u0003UT!A^<\u0002\u0011I,\u0017/^3tiNT!\u0001_\u0019\u0002\r\r|W.\\8o\u0013\tQX/A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\taXPA\u0004Ck&dG-\u001a:\u000b\u0005i,\bcA@\u0002\u00021\u0001AaCA\u0002_\u0006\u0005\t\u0011!B\u0001\u0003\u000b\u00111a\u0018\u00132#\u0011\t9!!\u0004\u0011\u0007\t\nI!C\u0002\u0002\f\r\u0012qAT8uQ&tw\rE\u0002u\u0003\u001fI1!!\u0005v\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bbBA\u000b\u001f\u0001\u0007\u0011qC\u0001\tG\u0006dGNY1dWB\u0019\u0001&!\u0007\n\u0007\u0005m1D\u0001\u0012D_:$(o\u001c7mKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u000b\u0003\u0003?\u0001BAIA\u0011\u000b&\u0019\u00111E\u0012\u0003\r=\u0003H/[8o\u00039A\u0017M\u001c3mKJ+7\u000f]8og\u0016$B!!\u000b\u00026Q\u0019\u0011.a\u000b\t\u000f\u00055\u0012\u00031\u0001\u00020\u0005A!/Z:q_:\u001cX\rE\u0002/\u0003cI1!a\r0\u00059\u0019E.[3oiJ+7\u000f]8og\u0016DQ\u0001]\tA\u0002\r\fA\u0001]8mY\u0006\u0019\u0002/\u001a8eS:<'+Z9vKN$8i\\;oi\u0006!Sj\\2l\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002)+M\u0011Q#\t\u000b\u0003\u0003{\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA$U\r)\u0015\u0011J\u0016\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0005v]\u000eDWmY6fI*\u0019\u0011QK\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005=#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u0018+\u0007)\u000bI%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e")
public class MockBrokerToControllerChannelManager
implements BrokerToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ArrayDeque<BrokerToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$4();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private ArrayDeque<BrokerToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Option<NodeApiVersions> controllerApiVersions() {
        return new Some((Object)this.controllerApiVersions);
    }

    public void handleResponse(BrokerToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<BrokerToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            BrokerToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.get();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public int pendingRequestCount() {
        return this.unsentQueue().size();
    }

    public MockBrokerToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ArrayDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

