/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001C\u0005\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C\u0001/!)1\u0006\u0001C\u0001/!)Q\u0006\u0001C\u0001/!)q\u0006\u0001C\u0005a!)\u0011\f\u0001C\u00055\")Q\u000e\u0001C\u0005]\n\u0001sJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H+Z:u\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\n\u0013\t\u0011\u0012BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0011\u0001\u0005\u0019C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i\u000bJ\u0014xN]\"pI\u0016\u001cH#\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002%K\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0014(\u0003\u0015QWO\\5u\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0005)\u0016\u001cH/A\u001auKN$xJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eDw\u000b[3o!\u0006\u0014H/\u001b;j_:,f\u000eZ3s%\u0016\u001cwN^3ss\"\u00121aH\u0001\u001bi\u0016\u001cHoQ;se\u0016tG/\u00129pG\"4\u0016\r\\5eCRLwN\u001c\u0015\u0003\t}\t\u0011e\u001c4gg\u0016$hi\u001c:MK\u0006$WM\u001d+pa&\u001c7i\u001c7mK\u000e$\u0018n\u001c8G_J$B!\r'S/B\u0011!'\u0013\b\u0003g\u0019s!\u0001N\"\u000f\u0005U\u0002eB\u0001\u001c?\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;\u001b\u00051AH]8pizJ\u0011\u0001K\u0005\u0003{\u001d\na!\u00199bG\",\u0017B\u0001\u0007@\u0015\tit%\u0003\u0002B\u0005\u000611m\\7n_:T!\u0001D \n\u0005\u0011+\u0015aB7fgN\fw-\u001a\u0006\u0003\u0003\nK!a\u0012%\u0002?=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0002E\u000b&\u0011!j\u0013\u0002\u001f\u001f\u001a47/\u001a;G_JdU-\u00193feR{\u0007/[2D_2dWm\u0019;j_:T!a\u0012%\t\u000b5+\u0001\u0019\u0001(\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011q\nU\u0007\u0002\u000b&\u0011\u0011+\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015\u0019V\u00011\u0001U\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0005e)\u0016B\u0001,\u001b\u0005\rIe\u000e\u001e\u0005\u00061\u0016\u0001\r\u0001V\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.A\nbgN,'\u000f\u001e*fgB|gn]3FeJ|'\u000f\u0006\u0003\u00197\u000e,\u0007\"\u0002/\u0007\u0001\u0004i\u0016!B3se>\u0014\bC\u00010b\u001b\u0005y&B\u00011F\u0003!\u0001(o\u001c;pG>d\u0017B\u00012`\u0005\u0019)%O]8sg\")AM\u0002a\u0001)\u0006A!M]8lKJLE\rC\u0003g\r\u0001\u0007q-A\u0004sKF,Xm\u001d;\u0011\u0005!\\W\"A5\u000b\u0005),\u0015\u0001\u0003:fcV,7\u000f^:\n\u00051L'\u0001H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f^\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000fF\u0002peN\u0004\"\u0001\u001b9\n\u0005EL'!H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3\t\u000b\u0011<\u0001\u0019\u0001+\t\u000b\u0019<\u0001\u0019A4")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    @Test
    public void testOffsetsForLeaderEpochErrorCodes() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(partition, 0, -1);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
    }

    @Test
    public void testOffsetsForLeaderEpochWhenPartitionUnderRecovery() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(topicPartition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochWhenPartitionUnderRecovery$2(x$5)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$6))).get());
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(topicPartition, 0, -1);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.serverForId(leader).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERING);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, leader, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.serverForId(leader).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERED);
        this.assertResponseError(Errors.NONE, leader, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection offsetForLeaderTopicCollectionFor(TopicPartition topicPartition, int leaderEpoch, int currentLeaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection((Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter(new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(leaderEpoch).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$).iterator()).asJava());
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.data().topics().size(), (int)response.data().topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)offsetForLeaderTopic -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(request, error, offsetForLeaderTopic);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        return (OffsetsForLeaderEpochResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetsForLeaderEpochResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochWhenPartitionUnderRecovery$2(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(topicPartition$1, 0, Predef$.MODULE$.Integer2int(currentLeaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1))));
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, OffsetForLeaderEpochResponseData.EpochEndOffset offsetForLeaderPartition) {
        Assertions.assertEquals((short)error$1.code(), (short)offsetForLeaderPartition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(OffsetsForLeaderEpochRequest request$1, Errors error$1, OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult offsetForLeaderTopic) {
        Assertions.assertEquals((int)request$1.data().topics().find(offsetForLeaderTopic.topic()).partitions().size(), (int)offsetForLeaderTopic.partitions().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)offsetForLeaderPartition -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$2(error$1, offsetForLeaderPartition);
            return BoxedUnit.UNIT;
        });
    }
}

