/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.controller.ClusterBalanceManager;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.ControllerServer;
import kafka.server.ControllerServer$;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t%h!B\u001e=\u0003\u0003\t\u0005\"\u0002(\u0001\t\u0003y\u0005b\u0002*\u0001\u0005\u0004%\ta\u0015\u0005\u0007/\u0002\u0001\u000b\u0011\u0002+\t\u000fa\u0003!\u0019!C\u0001'\"1\u0011\f\u0001Q\u0001\nQCqA\u0017\u0001C\u0002\u0013\u00051\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0016\u0005\u00069\u0002!\t\"\u0018\u0005\u0006I\u0002!\t\"\u001a\u0005\u0006k\u0002!\tB\u001e\u0005\b\u0003\u0017\u0001A\u0011CA\u0007\u0011-\tY\u0002\u0001a\u0001\u0002\u0004%I!!\b\t\u0017\u0005M\u0002\u00011AA\u0002\u0013%\u0011Q\u0007\u0005\f\u0003\u0003\u0002\u0001\u0019!A!B\u0013\ty\u0002C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fB1\"a\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011q\u000b\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002Z!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003k\u0002A\u0011AA:\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0015\u0001\u0005\u0002\u0005u\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\u0007\u0003c\u0003A\u0011A*\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"9\u0011Q\u001a\u0001\u0005\u0002\u0005U\u0006bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u00033\u0004A\u0011AA:\u0011\u001d\tY\u000e\u0001C\u0001\u0003;D\u0011\"!9\u0001\u0005\u0004%\t!a9\t\u0011\u0005E\b\u0001)A\u0005\u0003KD\u0011\"a=\u0001\u0001\u0004%\t!!>\t\u0013\t\u0015\u0001\u00011A\u0005\u0002\t\u001d\u0001\u0002\u0003B\u0006\u0001\u0001\u0006K!a>\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!1\u0004\u0001\u0005\u0002\tu\u0001\"\u0003B$\u0001E\u0005I\u0011\u0001B%\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003h!9!1\u000e\u0001\u0005\u0002\u0005M\u0004b\u0002B7\u0001\u0011\u0005\u00111\u000f\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqA!%\u0001\t\u0013\tI\bC\u0004\u0003\u0014\u0002!\t!a\u001d\t\u000f\tu\u0005\u0001\"\u0001\u0003 \u001e9!Q\u0018\u001f\t\u0002\t}fAB\u001e=\u0011\u0003\u0011\t\r\u0003\u0004Ok\u0011\u0005!1\u0019\u0005\n\u0005\u000b,$\u0019!C\u0001\u0005\u000fD\u0001Ba56A\u0003%!\u0011\u001a\u0005\b\u0005+,D\u0011AA:\u0011\u001d\u0011y.\u000eC\u0001\u0003g\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0015\tid(\u0001\u0004tKJ4XM\u001d\u0006\u0002\u007f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013'\u000e\u0003)S!a\u0013 \u0002\u000bU$\u0018\u000e\\:\n\u00055S%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0003\"!\u0015\u0001\u000e\u0003q\n1C_6D_:tWm\u0019;j_:$\u0016.\\3pkR,\u0012\u0001\u0016\t\u0003\u0007VK!A\u0016#\u0003\u0007%sG/\u0001\u000b{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000fI\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkR\f\u0011C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0003UQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiN\faC_6NCbLeN\u00127jO\"$(+Z9vKN$8\u000fI\u0001\u000eu.\f5\r\\:F]\u0006\u0014G.\u001a3\u0016\u0003y\u00032aQ0b\u0013\t\u0001GI\u0001\u0004PaRLwN\u001c\t\u0003\u0007\nL!a\u0019#\u0003\u000f\t{w\u000e\\3b]\u0006\u00113m\u001c8ue>dG.\u001a:MSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012A\u001a\t\u0003ONl\u0011\u0001\u001b\u0006\u0003S*\fA!Y;uQ*\u00111\u000e\\\u0001\tg\u0016\u001cWO]5us*\u0011QN\\\u0001\u0007G>lWn\u001c8\u000b\u0005}z'B\u00019r\u0003\u0019\t\u0007/Y2iK*\t!/A\u0002pe\u001eL!\u0001\u001e5\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0003]\u00042\u0001_>~\u001b\u0005I(B\u0001>E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003yf\u00141aU3r!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]V\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019Q.!\u0006\u000b\u0005ur\u0017\u0002BA\r\u0003'\u0011q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\ti\u0016\u001cH/\u00138g_V\u0011\u0011q\u0004\t\u0005\u0003C\ty#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\r\t\u0007/\u001b\u0006\u0005\u0003S\tY#A\u0004kkBLG/\u001a:\u000b\u0007\u00055\u0012/A\u0003kk:LG/\u0003\u0003\u00022\u0005\r\"\u0001\u0003+fgRLeNZ8\u0002\u0019Q,7\u000f^%oM>|F%Z9\u0015\t\u0005]\u0012Q\b\t\u0004\u0007\u0006e\u0012bAA\u001e\t\n!QK\\5u\u0011%\ty$DA\u0001\u0002\u0004\ty\"A\u0002yIE\n\u0011\u0002^3ti&sgm\u001c\u0011\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]V\u0011\u0011q\t\t\u0004#\u0006%\u0013bAA&y\t!\u0012+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\f!#[7qY\u0016lWM\u001c;bi&|gn\u0018\u0013fcR!\u0011qGA)\u0011%\ty\u0004EA\u0001\u0002\u0004\t9%A\bj[BdW-\\3oi\u0006$\u0018n\u001c8!\u0003A\u0011wn\u001c;tiJ\f\u0007OU3d_J$7/\u0006\u0002\u0002ZA1\u00111LA1\u0003Kj!!!\u0018\u000b\u0007\u0005}\u00130A\u0004nkR\f'\r\\3\n\t\u0005\r\u0014Q\f\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\b\u0003BA\t\u0003OJA!!\u001b\u0002\u0014\t!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\f\u0011CY8piN$(/\u00199SK\u000e|'\u000fZ:!\u0003-I7o\u0013*bMR$Vm\u001d;\u0015\u0003\u0005\fQb\u00195fG.L5OW&UKN$HCAA\u001c\u0003A\u0019\u0007.Z2l\u0013N\\%+\u00194u)\u0016\u001cH/\u0001\u0003bgj[GCAA>!\r\t\u0016QP\u0005\u0004\u0003\u007fb$!\b.p_.+W\r]3s#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002\u000f\u0005\u001c8JU1giR\u0011\u0011Q\u0011\t\u0004#\u0006\u001d\u0015bAAEy\tI2JU1giF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003%Qxn\\6fKB,'/\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016z\n!A_6\n\t\u0005e\u00151\u0013\u0002\u0012\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u0014\u0018\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u0005}\u0005\u0003BAI\u0003CKA!a)\u0002\u0014\ni1*\u00194lCj[7\t\\5f]R\faB_6DY&,g\u000e^(s\u001dVdG.A\u0007bI6LgNW6DY&,g\u000e^\u000b\u0003\u0003W\u0003B!!%\u0002.&!\u0011qVAJ\u00055\tE-\\5o5.\u001cE.[3oi\u00061!p\u001b)peR\f\u0011B_6D_:tWm\u0019;\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u000ftA!a/\u0002DB\u0019\u0011Q\u0018#\u000e\u0005\u0005}&bAAa\u0001\u00061AH]8pizJ1!!2E\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011ZAf\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0019#\u0002\u001fi\\7i\u001c8oK\u000e$xJ\u001d(vY2\f\u0001cY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0016\u0005\u0005M\u0007cA)\u0002V&\u0019\u0011q\u001b\u001f\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018a\u0006:fgR\f'\u000f^\"p]R\u0014x\u000e\u001c7feN+'O^3s\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u0003?\u0004B\u0001_>\u0002T\u0006aa-Y;mi\"\u000bg\u000e\u001a7feV\u0011\u0011Q\u001d\t\u0005\u0003O\fi/\u0004\u0002\u0002j*!\u00111^A\u000b\u0003\u00151\u0017-\u001e7u\u0013\u0011\ty/!;\u0003!5{7m\u001b$bk2$\b*\u00198eY\u0016\u0014\u0018!\u00044bk2$\b*\u00198eY\u0016\u0014\b%A\u000bdYV\u001cH/\u001a:CC2\fgnY3NC:\fw-\u001a:\u0016\u0005\u0005]\b\u0003B\"`\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007ft\u0014AC2p]R\u0014x\u000e\u001c7fe&!!1AA\u007f\u0005U\u0019E.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\f\u0011d\u00197vgR,'OQ1mC:\u001cW-T1oC\u001e,'o\u0018\u0013fcR!\u0011q\u0007B\u0005\u0011%\tyDJA\u0001\u0002\u0004\t90\u0001\fdYV\u001cH/\u001a:CC2\fgnY3NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0011\t9D!\u0005\t\u000f\u0005m\u0001\u00061\u0001\u0002 !\u001a\u0001F!\u0006\u0011\t\u0005\u0005\"qC\u0005\u0005\u00053\t\u0019C\u0001\u0006CK\u001a|'/Z#bG\"\fAb\u0019:fCR,'I]8lKJ$\"Ba\b\u0003&\t=\"Q\bB!!\r\t&\u0011E\u0005\u0004\u0005Ga$aC&bM.\f'I]8lKJDqAa\n*\u0001\u0004\u0011I#\u0001\u0004d_:4\u0017n\u001a\t\u0004#\n-\u0012b\u0001B\u0017y\tY1*\u00194lC\u000e{gNZ5h\u0011%\u0011\t$\u000bI\u0001\u0002\u0004\u0011\u0019$\u0001\u0003uS6,\u0007\u0003\u0002B\u001b\u0005si!Aa\u000e\u000b\u0005-c\u0017\u0002\u0002B\u001e\u0005o\u0011A\u0001V5nK\"A!qH\u0015\u0011\u0002\u0003\u0007\u0011-A\u0004ti\u0006\u0014H/\u001e9\t\u0013\t\r\u0013\u0006%AA\u0002\t\u0015\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\u0011\u0019u,a.\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uII*\"Aa\u0013+\t\tM\"QJ\u0016\u0003\u0005\u001f\u0002BA!\u0015\u0003\\5\u0011!1\u000b\u0006\u0005\u0005+\u00129&A\u0005v]\u000eDWmY6fI*\u0019!\u0011\f#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\tM#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000612M]3bi\u0016\u0014%o\\6fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003d)\u001a\u0011M!\u0014\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!\u001b+\t\t\u0015#QJ\u0001\u0012g\",H\u000fZ8x]j{wnS3fa\u0016\u0014\u0018aF:ikR$wn\u001e8L%\u00064GoQ8oiJ|G\u000e\\3s\u0003E1wN]7bi\u0012K'/Z2u_JLWm\u001d\u000b\u0007\u0003o\u0011\u0019H!!\t\u000f\tUt\u00061\u0001\u0003x\u0005YA-\u001b:fGR|'/[3t!\u0019\u0011IHa \u000286\u0011!1\u0010\u0006\u0004\u0005{J\u0018!C5n[V$\u0018M\u00197f\u0013\ra(1\u0010\u0005\b\u0005\u0007{\u0003\u0019\u0001BC\u00039iW\r^1Qe>\u0004XM\u001d;jKN\u00042!\u0015BD\u0013\r\u0011I\t\u0010\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u00039qWm^&SC\u001a$\u0018+^8sk6$B!!\"\u0003\u0010\"9\u00111\u0004\u0019A\u0002\u0005}\u0011A\u00058foj{wnS3fa\u0016\u0014\u0018+^8sk6\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004e\t]\u0005\u0003BA\u0011\u00053KAAa'\u0002$\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001,GJ,\u0017\r^3[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)>$&/[4hKJ\u001cVm]:j_:,\u0005\u0010]5ssR!!\u0011\u0015BV!\u0011\u0011\u0019Ka*\u000e\u0005\t\u0015&bAAF_&!!\u0011\u0016BS\u0005%Qvn\\&fKB,'\u000fC\u0004\u0003.N\u0002\rA!)\u0002\u0013i|wnS3fa\u0016\u0014\bf\u0002\u0001\u00032\n]&\u0011\u0018\t\u0005\u0003C\u0011\u0019,\u0003\u0003\u00036\u0006\r\"a\u0001+bO\u0006)a/\u00197vK\u0006\u0012!1X\u0001\fS:$Xm\u001a:bi&|g.A\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\u0004\"!U\u001b\u0014\u0005U\u0012EC\u0001B`\u0003eQ6n\u00117jK:$XI^3oiRC'/Z1e'V4g-\u001b=\u0016\u0005\t%\u0007\u0003\u0002Bf\u0005#l!A!4\u000b\t\t=\u00171A\u0001\u0005Y\u0006tw-\u0003\u0003\u0002J\n5\u0017A\u0007.l\u00072LWM\u001c;Fm\u0016tG\u000f\u00165sK\u0006$7+\u001e4gSb\u0004\u0013AC:fiV\u00038\t\\1tg\"\u001a\u0011H!7\u0011\t\u0005\u0005\"1\\\u0005\u0005\u0005;\f\u0019CA\u0005CK\u001a|'/Z!mY\u0006iA/Z1s\t><hn\u00117bgND3A\u000fBr!\u0011\t\tC!:\n\t\t\u001d\u00181\u0005\u0002\t\u0003\u001a$XM]!mY\u0002")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords;
    private final MockFaultHandler faultHandler;
    private Option<ClusterBalanceManager> clusterBalanceManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latest();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public void restartControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    public void clusterBalanceManager_$eq(Option<ClusterBalanceManager> x$1) {
        this.clusterBalanceManager = x$1;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, this.metadataVersion(), false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        Metrics controllerMetrics = new Metrics();
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        if (!props.containsKey(KafkaConfig$.MODULE$.ControllerListenerNamesProp())) {
            String proto = this.controllerListenerSecurityProtocol().toString();
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        }
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        String threadNamePrefix = new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString();
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)MetadataRecordSerde.INSTANCE, new TopicPartition(KafkaRaftServer$.MODULE$.MetadataTopic(), 0), KafkaRaftServer$.MODULE$.MetadataTopicId(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            this.clusterBalanceManager_$eq((Option<ClusterBalanceManager>)Option$.MODULE$.apply((Object)ClusterBalanceManager.clusterBalanceManager((KafkaConfig)config)));
            controllerServer.elem = new ControllerServer(metaProperties, config, (RaftManager)raftManager, this.clusterBalanceManager(), Time.SYSTEM, controllerMetrics, (ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), Time.SYSTEM, controllerMetrics), Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture, KafkaRaftServer$.MODULE$.configSchema(), raftManager.apiVersions(), BootstrapMetadata.fromVersion((MetadataVersion)this.metadataVersion(), (String)"test harness"), (FaultHandler)this.faultHandler(), (FaultHandler)this.faultHandler(), ControllerServer$.MODULE$.$lessinit$greater$default$15());
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
            raftManager.startup();
        }
        catch (Throwable e2) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raftManager.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            this.clusterBalanceManager().foreach((Function1 & Serializable & scala.Serializable)c -> {
                QuorumTestHarness.$anonfun$newKRaftQuorum$5(this, c);
                return BoxedUnit.UNIT;
            });
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw e2;
        }
        return new KRaftQuorumImplementation((KafkaRaftManager<ApiMessageAndVersion>)raftManager, (ControllerServer)controllerServer.elem, metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        this.clusterBalanceManager().foreach((Function1 & Serializable & scala.Serializable)c -> {
            QuorumTestHarness.$anonfun$tearDown$1(this, c);
            return BoxedUnit.UNIT;
        });
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$newKRaftQuorum$5(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onLeaderUpdate(LeaderAndEpoch.UNKNOWN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.shutdown(), (Logging)$this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onLeaderUpdate(LeaderAndEpoch.UNKNOWN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.shutdown(), (Logging)$this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.faultHandler = new MockFaultHandler("quorumTestHarnessFaultHandler");
        this.clusterBalanceManager = Option$.MODULE$.empty();
    }
}

