/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.Fetching$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004F\u0001\u0001\u0006IA\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0003:\u0011\u00199\u0005\u0001)A\u0005u!9\u0001\n\u0001b\u0001\n\u0013I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011B(\t\r\u0001\u0004\u0001\u0015!\u0003Q\u0011\u001d\t\u0007A1A\u0005\n\tDa\u0001\u001a\u0001!\u0002\u0013\u0019\u0007bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B4\t\u000f-\u0004!\u0019!C\u0005Y\"1\u0001\u000f\u0001Q\u0001\n5Dq!\u001d\u0001C\u0002\u0013%!\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011B:\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\b\t\u000f\u00055\u0002\u0001\"\u0003\u00020!I\u00111\n\u0001\u0012\u0002\u0013%\u0011Q\n\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t\u0019\t\u0001C\u0001\u0003KBq!a\"\u0001\t\u0003\t)\u0007C\u0004\u0002\f\u0002!I!!$\t\u000f\u0005m\u0006\u0001\"\u0001\u0002f!9\u0011q\u0018\u0001\u0005\u0002\u0005\u0015\u0004bBAb\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003\u000f\u0004A\u0011AA3\u0011\u001d\tY\r\u0001C\u0001\u0003KBq!a4\u0001\t\u0003\t)\u0007C\u0004\u0002T\u0002!\t!!\u001a\t\u000f\u0005]\u0007\u0001\"\u0001\u0002f!9\u00111\u001c\u0001\u0005\u0002\u0005\u0015\u0004bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0005u\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193UKN$(BA\u0015+\u0003\u0019\u0019XM\u001d<fe*\t1&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002mA\u0011q\u0007A\u0007\u0002Q\u0005!A/\r91+\u0005Q\u0004CA\u001eD\u001b\u0005a$BA\u001f?\u0003\u0019\u0019w.\\7p]*\u00111f\u0010\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Ey\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u0002;2aB\u0002\u0013\u0001\u0002;2aF\nQ\u0001^\u0019qc\u0001\nq\u0001^8qS\u000eLE-F\u0001K!\tY4*\u0003\u0002My\t!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013\u0001\u0003;pa&\u001c\u0017\nZ:\u0016\u0003A\u0003B!\u0015,Y\u00156\t!K\u0003\u0002T)\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003+B\n!bY8mY\u0016\u001cG/[8o\u0013\t9&KA\u0002NCB\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t1\fgn\u001a\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&L\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\n!\u0002^8qS\u000et\u0015-\\3t+\u0005\u0019\u0007\u0003B)W\u0015b\u000b1\u0002^8qS\u000et\u0015-\\3tA\u00051A/\u001b32aB*\u0012a\u001a\t\u0003w!L!!\u001b\u001f\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017a\u0002;jIF\u0002\b\u0007I\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\u0012!\u001c\t\u0003o9L!a\u001c\u0015\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005y\u0001/\u0019:uSRLwN\\*uCR,7/F\u0001t!\r!x/_\u0007\u0002k*\u0011a\u000fX\u0001\u0005kRLG.\u0003\u0002yk\n!A*[:u!\rQ\u0018\u0011\u0001\b\u0003wzl\u0011\u0001 \u0006\u0003{r\nq!\\3tg\u0006<W-\u0003\u0002\u0000y\u0006IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0013\u0011\t\u0019!!\u0002\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*\u0011q\u0010`\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002\nQ#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014q\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003/\t\tBA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0002-U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",WCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013Q\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002*\u0005\r\"a\u0004.l\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005\t\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0015\r\u0005E\u0012qGA!!\r9\u00141G\u0005\u0004\u0003kA#!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"9\u0011\u0011\b\fA\u0002\u0005m\u0012a\u00034fi\u000eDwJ\u001a4tKR\u00042aLA\u001f\u0013\r\ty\u0004\r\u0002\u0005\u0019>tw\rC\u0005\u0002DY\u0001\n\u00111\u0001\u0002F\u0005YA.Z1eKJ,\u0005o\\2i!\ry\u0013qI\u0005\u0004\u0003\u0013\u0002$aA%oi\u0006Y\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3%I\u00164\u0017-\u001e7uII*\"!a\u0014+\t\u0005\u0015\u0013\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\f\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a3\u000f[8vY\u0012tu\u000e^!eIB\u000b'\u000f^5uS>t\u0017J\u001a$viV\u0014X\rT8h\u0013Ntu\u000e\u001e#fM&tW\r\u001a\u000b\u0003\u0003O\u00022aLA5\u0013\r\tY\u0007\r\u0002\u0005+:LG\u000fK\u0002\u0019\u0003_\u0002B!!\u001d\u0002\u00005\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0002ba&TA!!\u001f\u0002|\u00059!.\u001e9ji\u0016\u0014(bAA?\u0003\u0006)!.\u001e8ji&!\u0011\u0011QA:\u0005\u0011!Vm\u001d;\u0002YMDw.\u001e7e+B$\u0017\r^3MK\u0006$WM]#q_\u000eD\u0017I\u001a;fe\u001a+gnY3e\u000bB|7\r[#se>\u0014\bfA\r\u0002p\u000513\u000f[8vY\u0012\u0014V\r\u001d7bG\u0016\u001cUO\u001d:f]Rdun\u001a#je^CWM\\\"bk\u001eDG/\u00169)\u0007i\ty'A\fn_\u000e\\g)\u001a;dQ\u001a\u0013x.\\\"veJ,g\u000e\u001e'pORa\u0011qMAH\u0003'\u000bi*a*\u00022\"1\u0011\u0011S\u000eA\u0002\u001d\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\u0005U5\u00041\u0001\u0002\u0018\u0006Y!/Z9vKN$H)\u0019;b!\r9\u0014\u0011T\u0005\u0004\u00037C#A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u000f\u0005}5\u00041\u0001\u0002\"\u000611m\u001c8gS\u001e\u00042aNAR\u0013\r\t)\u000b\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u0002*n\u0001\r!a+\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019q'!,\n\u0007\u0005=\u0006F\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0005M6\u00041\u0001\u00026\u0006a!/Z:q_:\u001cX\rR1uCB\u0019q'a.\n\u0007\u0005e\u0006F\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0017AI5tgV,7/\u00129pG\"\u0014V-];fgR4%o\\7M_\u000e\fGNU3qY&\u001c\u0017\rK\u0002\u001d\u0003_\nQHZ3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'o\u00155pk2$\u0007*\u00198eY\u0016,\u0005pY3qi&|gN\u0012:p[\u001e+G\u000fT8dC2\u0014V\r\u001d7jG\u0006D3!HA8\u0003u\u0019\bn\\;mIR\u0013XO\\2bi\u0016$vNU3qY&\u001c\u0017m\u00144gg\u0016$\bf\u0001\u0010\u0002p\u0005i3\u000f[8vY\u0012$&/\u001e8dCR,Gk\\#oI>3gm]3u\u001f\u001ad\u0015M]4fgR\u001cu.\\7p]\u0016\u0003xn\u00195)\u0007}\ty'A!tQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_&s\u0017\u000e^5bY\u001a+Go\u00195PM\u001a\u001cX\r^%g%\u0016\u0004H.[2b%\u0016$XO\u001d8t+:$WMZ5oK\u0012|eMZ:fi\"\u001a\u0001%a\u001c\u0002WMDw.\u001e7e!>dG.\u00138eK\u001aLg.\u001b;fYfLeMU3qY&\u001c\u0017MT8u\u0003Z\f\u0017\u000e\\1cY\u0016D3!IA8\u0003\u0019\u001a\bn\\;mI\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ>sG.\u001f\u0015\u0004E\u0005=\u0014\u0001H:i_VdGMR3uG\"|e.\u001a*fa2L7-Y!u\u0003RKW.\u001a\u0015\u0004G\u0005=\u0014!L:i_VdGMR3uG\"tuN\u001c#fY\u0006LX\rZ!oI:{g\u000e\u0016:v]\u000e\fG/\u001b8h%\u0016\u0004H.[2bg\"\u001aA%a\u001c\u0002\tM$XO\u0019\u000b\r\u0003O\n\u0019/a=\u0002x\u0006m(1\u0002\u0005\b\u0003K,\u0003\u0019AAt\u0003\u001dawn\u001a+2aB\u0002B!!;\u0002p6\u0011\u00111\u001e\u0006\u0004\u0003[T\u0013a\u00017pO&!\u0011\u0011_Av\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005UX\u00051\u0001\u0002h\u00069An\\4UcA\f\u0004bBA}K\u0001\u0007\u0011q]\u0001\nMV$XO]3M_\u001eDq!!@&\u0001\u0004\ty0A\u0005qCJ$\u0018\u000e^5p]B!!\u0011\u0001B\u0004\u001b\t\u0011\u0019AC\u0002\u0003\u0006)\nqa\u00197vgR,'/\u0003\u0003\u0003\n\t\r!!\u0003)beRLG/[8o\u0011\u001d\tI+\na\u0001\u0003W\u000bQc\u001d;vE^KG\u000f\u001b$fi\u000eDW*Z:tC\u001e,7\u000f\u0006\b\u0002h\tE!1\u0003B\u000b\u0005/\u0011IBa\u0007\t\u000f\u0005\u0015h\u00051\u0001\u0002h\"9\u0011Q\u001f\u0014A\u0002\u0005\u001d\bbBA}M\u0001\u0007\u0011q\u001d\u0005\b\u0003{4\u0003\u0019AA\u0000\u0011\u001d\tIK\na\u0001\u0003WCqA!\b'\u0001\u0004\u0011y\"\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB1!\u0011\u0005B\u0014\u0005Wi!Aa\t\u000b\u0007\t\u0015\u0012)A\u0004n_\u000e\\\u0017\u000e^8\n\t\t%\"1\u0005\u0002\u000f\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s!\u001dy#Q\u0006B\u0019\u0003OJ1Aa\f1\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u00034\tU\"\u0011H\u0007\u0002)&\u0019!q\u0007+\u0003\u0007M+\u0017\u000f\u0005\u00040\u0005w9\u0017QW\u0005\u0004\u0005{\u0001$A\u0002+va2,'\u0007")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final Uuid topicId = Uuid.randomUuid();
    private final scala.collection.immutable.Map<String, Uuid> topicIds = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId())}));
    private final scala.collection.immutable.Map<Uuid, String> topicNames = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicId()), (Object)"topic1")}));
    private final TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId(), this.t1p0());
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$)).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicIds()).asJava()).build();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latest(), BrokerFeatures$.MODULE$.createEmpty(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private scala.collection.immutable.Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private TopicIdPartition tid1p0() {
        return this.tid1p0;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(long fetchOffset, int leaderEpoch) {
        Some x$1 = new Some((Object)this.topicId());
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState((Option)x$1, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$2() {
        return 1;
    }

    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata fencedRequestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), Optional.empty());
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch - 1))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch())));
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty());
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        thread.doWork();
        Assertions.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty());
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    private void mockFetchFromCurrentLog(TopicIdPartition topicIdPartition, PartitionFetchMetadata requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        ArgumentMatcher<Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>> argumentMatcher = new ArgumentMatcher<Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>>(null, topicIdPartition, requestData){
            private final TopicIdPartition topicIdPartition$1;
            private final PartitionFetchMetadata requestData$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean matches(Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> argument) {
                Option option = package$.MODULE$.$plus$colon().unapply(argument);
                if (option.isEmpty()) return false;
                Tuple2 tuple2 = (Tuple2)((Tuple2)option.get())._1();
                Seq seq = (Seq)((Tuple2)option.get())._2();
                if (tuple2 == null) return false;
                TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                PartitionFetchMetadata partitionData = (PartitionFetchMetadata)tuple2._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return false;
                if (some.get() == null) return false;
                if (((SeqLike)some.get()).lengthCompare(0) != 0) return false;
                TopicIdPartition topicIdPartition = tp;
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                if (topicIdPartition == null) {
                    if (topicIdPartition2 != null) {
                        return false;
                    }
                } else if (!topicIdPartition.equals(topicIdPartition2)) return false;
                Uuid uuid = partitionData.topicId();
                Uuid uuid2 = this.requestData$1.topicId();
                if (uuid == null) {
                    if (uuid2 != null) {
                        return false;
                    }
                } else if (!uuid.equals(uuid2)) return false;
                if (partitionData.fetchOffset() != this.requestData$1.fetchOffset()) return false;
                Optional optional = partitionData.currentLeaderEpoch();
                Optional optional2 = this.requestData$1.currentLeaderEpoch();
                if (optional == null) {
                    if (optional2 != null) {
                        return false;
                    }
                } else if (!((Object)optional).equals(optional2)) return false;
                Optional optional3 = partitionData.lastFetchedEpoch();
                Optional optional4 = this.requestData$1.lastFetchedEpoch();
                if (optional3 == null) {
                    if (optional4 != null) {
                        return false;
                    }
                } else if (!((Object)optional3).equals(optional4)) return false;
                if (partitionData.startOffset() != this.requestData$1.startOffset()) return false;
                if (partitionData.maxBytes() != this.requestData$1.maxBytes()) return false;
                return true;
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.requestData$1 = requestData$1;
            }
        };
        FetchParams expectedFetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), Request$.MODULE$.FutureLocalReplicaId(), 0L, 0, Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes()), (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.eq((Object)expectedFetchParams), (Seq)ArgumentMatchers.argThat((ArgumentMatcher)argumentMatcher), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicIdPartition, responseData, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, null, null).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpochT1p1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1))}))), (Object)result, (String)"results from leader epoch request should have offset from local replica");
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionId = 0;
        int leaderEpoch = 2;
        int leo = 13;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenThrow(new Throwable[]{new KafkaStorageException()});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, null, null).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpoch))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()))}))), (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        ArgumentCaptor truncateCaptureT1p0 = ArgumentCaptor.forClass(Long.TYPE);
        ArgumentCaptor truncateCaptureT1p1 = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog logT1p0 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog logT1p1 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLogT1p0 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLogT1p1 = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p1.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLogT1p0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLogT1p1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLogT1p0.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p0LEO));
        Mockito.when((Object)futureLogT1p1.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p1LEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partitionT1p0)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.capture()), ArgumentMatchers.anyBoolean());
        ((Partition)Mockito.verify((Object)partitionT1p1)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2))));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 1).setEndOffset((long)replicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2)));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 2).setEndOffset((long)replicaEpochEndOffset));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)), (String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getAllValues()).toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(initialFetchOffset, this.initialFetchState$default$2()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()), (String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET");
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(futureReplicaLeaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback, x$3);
            return BoxedUnit.UNIT;
        });
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((int)0, (int)truncated.getAllValues().size());
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition)).lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false);
        ((Partition)Mockito.verify((Object)partition)).truncateTo((long)futureReplicaLEO, true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var14_14;
        void var13_13;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8()))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var13_13;
        void partitionsWithError2 = var14_14;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get()).fetchRequest();
        Assertions.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assertions.assertEquals((int)0, (int)request.minBytes());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var29_29;
        void var28_28;
        void var22_22;
        void var21_21;
        void var15_15;
        void var14_14;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int startOffset = 123;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var14_14;
        void partitionsWithError2 = var15_15;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get();
        Assertions.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest.fetchRequest().build()).fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8()))})));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Map partitionsWithError22 = resultWithPartitions2.partitionsWithError();
        void fetchRequest2Opt2 = var21_21;
        void partitionsWithError23 = var22_22;
        Assertions.assertTrue((boolean)fetchRequest2Opt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)fetchRequest2Opt2.get();
        Assertions.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError23.nonEmpty());
        Seq fetchInfos2 = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.fetchRequest().build()).fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos2.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos2.head())._1()).topicPartition(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8()))})));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Map partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        void fetchRequest3Opt2 = var28_28;
        void partitionsWithError32 = var29_29;
        Assertions.assertTrue((boolean)fetchRequest3Opt2.isEmpty(), (String)"Expected no fetch requests since all partitions are delayed");
        Assertions.assertFalse((boolean)partitionsWithError32.nonEmpty());
    }

    public void stub(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager) {
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)logT1p0));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)logT1p0);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.localLog(this.t1p1())).thenReturn((Object)new Some((Object)logT1p1));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)logT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p1())).thenReturn((Object)new Some((Object)partition));
    }

    public void stubWithFetchMessages(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager, ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$10 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicIdPartition topicIdPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$2) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(ArgumentCaptor responseCallback$1, InvocationOnMock x$3) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(ArgumentCaptor responseCallback$2, InvocationOnMock x$10) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Nil$.MODULE$);
    }

    public ReplicaAlterLogDirsThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

