/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.FollowerFetchThrottler;
import kafka.server.FollowerThrottler;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaFetcherThreadTest$Quota$1$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestBuilder;
import kafka.server.Truncating$;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEg\u0001\u0002\"D\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004a\u0001\u0001\u0006I!\u0016\u0005\bC\u0002\u0011\r\u0011\"\u0003U\u0011\u0019\u0011\u0007\u0001)A\u0005+\"91\r\u0001b\u0001\n\u0013!\u0006B\u00023\u0001A\u0003%Q\u000bC\u0004f\u0001\t\u0007I\u0011\u00034\t\r5\u0004\u0001\u0015!\u0003h\u0011\u001dq\u0007A1A\u0005\u0012=Daa\u001d\u0001!\u0002\u0013\u0001\bb\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007s\u0002\u0001\u000b\u0011\u0002<\t\u000fi\u0004!\u0019!C\u0005k\"11\u0010\u0001Q\u0001\nYDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA \u0001\u0001\u0006I!a\b\t\u0013\u0005\u0005\u0003A1A\u0005\n\u0005\r\u0003\u0002CA)\u0001\u0001\u0006I!!\u0012\t\u0013\u0005M\u0003\u00011A\u0005\n\u0005U\u0003\"CA2\u0001\u0001\u0007I\u0011BA3\u0011!\t\t\b\u0001Q!\n\u0005]\u0003bBA:\u0001\u0011%\u0011Q\u000f\u0005\n\u00037\u0003\u0011\u0013!C\u0005\u0003;Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002N\u0002!\t\"a4\t\u0013\tu\u0001!%A\u0005\u0012\t}\u0001\"\u0003B\u0012\u0001E\u0005I\u0011\u0003B\u0013\u0011\u001d\u0011I\u0003\u0001C\t\u0005WA\u0011B!%\u0001#\u0003%\tBa\b\t\u0013\tM\u0005!%A\u0005\u0012\tU\u0005\"\u0003BM\u0001E\u0005I\u0011\u0003BK\u0011\u001d\u0011Y\n\u0001C\u0001\u0003kCqA!*\u0001\t\u0003\t)\fC\u0004\u0003*\u0002!\tAa+\t\u000f\t\u001d\u0007\u0001\"\u0001\u00026\"9!1\u001a\u0001\u0005\u0002\u0005U\u0006b\u0002Bh\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0005'\u0004A\u0011\u0003Bk\u0011%\u0011Y\u000fAI\u0001\n#\ti\nC\u0004\u0003n\u0002!\tBa<\t\u000f\rU\u0001\u0001\"\u0001\u0004\u0018!I1\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u0011Q\u0014\u0005\b\u0007G\u0001A\u0011AA[\u0011\u001d\u00199\u0003\u0001C\u0001\u0003kCqaa\u000b\u0001\t\u0003\t)\fC\u0004\u00040\u0001!\t!!.\t\u000f\rM\u0002\u0001\"\u0001\u00026\"91q\u0007\u0001\u0005\u0002\u0005U\u0006bBB\u001e\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0007\u007f\u0001A\u0011AA[\u0011\u001d\u0019\u0019\u0005\u0001C\u0001\u0003kCqaa\u0012\u0001\t\u0003\t)\fC\u0004\u0004L\u0001!\t!!.\t\u000f\r=\u0003\u0001\"\u0001\u00026\"911\u000b\u0001\u0005\u0002\u0005U\u0006bBB,\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u00077\u0002A\u0011AA[\u0011\u001d\u0019y\u0006\u0001C\u0005\u0007CBqaa\u0018\u0001\t\u0013\u0019y\tC\u0004\u0004(\u0002!Ia!+\t\u000f\r=\u0006\u0001\"\u0001\u00042\"91Q\u001a\u0001\u0005\n\r='\u0001\u0007*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\rV3ti*\u0011A)R\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A)\u0011\u0005I\u0003Q\"A\"\u0002\tQ\f\u0004\u000fM\u000b\u0002+B\u0011aKX\u0007\u0002/*\u0011\u0001,W\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019S&BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001eL!aX,\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)A/\r91A\u0005!A/\r92\u0003\u0015!\u0018\u0007]\u0019!\u0003\u0011!(\u0007]\u0019\u0002\u000bQ\u0014\u0004/\r\u0011\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\u000b\u000691\r\\;ti\u0016\u0014\u0018B\u00017j\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fqB\u0019:pW\u0016\u0014XI\u001c3Q_&tG\u000fI\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\u0012\u0001\u001d\t\u0003%FL!A]\"\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005AAo\u001c9jG&#\u0017'F\u0001w!\t1v/\u0003\u0002y/\n!Q+^5e\u0003%!x\u000e]5d\u0013\u0012\f\u0004%\u0001\u0005u_BL7-\u001333\u0003%!x\u000e]5d\u0013\u0012\u0014\u0004%\u0001\u0005u_BL7-\u00133t+\u0005q\bCB@\u0002\u0006\u0005%a/\u0004\u0002\u0002\u0002)\u0019\u00111A&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0005\u0005!aA'baB!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tiA\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\nq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003?\u0001b!!\t\u0002(\u0005-RBAA\u0012\u0015\u0011\t)#!\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\t\u0019C\u0001\u0003MSN$\b\u0003BA\u0017\u0003sqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0016aB7fgN\fw-Z\u0005\u0005\u0003o\t\t$A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0017\u0002BA\u001e\u0003{\u0011A$\u00169eCR,W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u00028\u0005E\u0012\u0001\u00059beRLG/[8o'R\fG/Z:!\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013X\u0003!\u0011X-];fgR\u001c\u0018\u0002BA(\u0003\u0013\u0012Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH/\u0001\fva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;!\u00035iW\r^1eCR\f7)Y2iKV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\"\u0002\u00115,G/\u00193bi\u0006LA!!\u0019\u0002\\\ty!l['fi\u0006$\u0017\r^1DC\u000eDW-A\tnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z0%KF$B!a\u001a\u0002nA\u0019!*!\u001b\n\u0007\u0005-4J\u0001\u0003V]&$\b\"CA8/\u0005\u0005\t\u0019AA,\u0003\rAH%M\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EIg.\u001b;jC24U\r^2i'R\fG/\u001a\u000b\t\u0003o\ni(a\"\u0002\u0012B\u0019!+!\u001f\n\u0007\u0005m4IA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016Dq!a \u001a\u0001\u0004\t\t)A\u0004u_BL7-\u00133\u0011\t)\u000b\u0019I^\u0005\u0004\u0003\u000b[%AB(qi&|g\u000eC\u0004\u0002\nf\u0001\r!a#\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0004\u0015\u00065\u0015bAAH\u0017\n!Aj\u001c8h\u0011%\t\u0019*\u0007I\u0001\u0002\u0004\t)*A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001&\u0002\u0018&\u0019\u0011\u0011T&\u0003\u0007%sG/A\u000ej]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003?SC!!&\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002..\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0004dY\u0016\fg.\u001e9\u0015\u0005\u0005\u001d\u0004fA\u000e\u0002:B!\u00111XAe\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017aA1qS*!\u00111YAc\u0003\u001dQW\u000f]5uKJT1!a2]\u0003\u0015QWO\\5u\u0013\u0011\tY-!0\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017AG2sK\u0006$XMU3n_R,G*Z1eKJ,e\u000e\u001a)pS:$HCDAi\u0003/\f\t/a;\u0002v\u0006}(\u0011\u0003\t\u0004%\u0006M\u0017bAAk\u0007\n!\"+Z7pi\u0016dU-\u00193fe\u0016sG\rU8j]RDq!!7\u001d\u0001\u0004\tY.\u0001\u0007ce>\\WM]\"p]\u001aLw\rE\u0002S\u0003;L1!a8D\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u0005\rH\u00041\u0001\u0002f\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0007I\u000b9/C\u0002\u0002j\u000e\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0002nr\u0001\r!a<\u0002\u000bE,x\u000e^1\u0011\u0007I\u000b\t0C\u0002\u0002t\u000e\u0013ABU3qY&\u001c\u0017-U;pi\u0006Dq!a>\u001d\u0001\u0004\tI0\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rE\u0002S\u0003wL1!!@D\u00051\u0011En\\2lS:<7+\u001a8e\u0011%\u0011\t\u0001\bI\u0001\u0002\u0004\u0011\u0019!A\u0007m_\u001e\u001cuN\u001c;fqR|\u0005\u000f\u001e\t\u0006\u0015\u0006\r%Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1B,\u0002\u000bU$\u0018\u000e\\:\n\t\t=!\u0011\u0002\u0002\u000b\u0019><7i\u001c8uKb$\b\"\u0003B\n9A\u0005\t\u0019\u0001B\u000b\u0003\u001d!\u0018.\\3PaR\u0004RASAB\u0005/\u0001BAa\u0002\u0003\u001a%!!1\u0004B\u0005\u0005\u0011!\u0016.\\3\u0002I\r\u0014X-\u0019;f%\u0016lw\u000e^3MK\u0006$WM]#oIB{\u0017N\u001c;%I\u00164\u0017-\u001e7uIU*\"A!\t+\t\t\r\u0011\u0011U\u0001%GJ,\u0017\r^3SK6|G/\u001a'fC\u0012,'/\u00128e!>Lg\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!q\u0005\u0016\u0005\u0005+\t\t+\u0001\u000ede\u0016\fG/\u001a*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0006\u0010\u0003.\tM\"1\nB(\u0005'\u0012)Fa\u0016\u0003Z\t\u001d$1\u000eB7\u0005_\u0012)Ia\"\u0003\u000eB\u0019!Ka\f\n\u0007\tE2I\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0005ky\u0002\u0019\u0001B\u001c\u0003\u0011q\u0017-\\3\u0011\t\te\"q\t\b\u0005\u0005w\u0011\u0019\u0005E\u0002\u0003>-k!Aa\u0010\u000b\u0007\t\u0005s)\u0001\u0004=e>|GOP\u0005\u0004\u0005\u000bZ\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\t%#b\u0001B#\u0017\"9!QJ\u0010A\u0002\u0005U\u0015!\u00034fi\u000eDWM]%e\u0011\u0019\u0011\tf\ba\u0001O\u0006a1o\\;sG\u0016\u0014%o\\6fe\"9\u0011\u0011\\\u0010A\u0002\u0005m\u0007\"\u00028 \u0001\u0004\u0001\bbBAr?\u0001\u0007\u0011Q\u001d\u0005\b\u00057z\u0002\u0019\u0001B/\u0003\u001diW\r\u001e:jGN\u0004BAa\u0018\u0003d5\u0011!\u0011\r\u0006\u0004\u00057:\u0016\u0002\u0002B3\u0005C\u0012q!T3ue&\u001c7\u000fC\u0004\u0003j}\u0001\rAa\u0006\u0002\tQLW.\u001a\u0005\b\u0003[|\u0002\u0019AAx\u0011\u001d\t9p\ba\u0001\u0003sDqA!\u001d \u0001\u0004\u0011\u0019(\u0001\tuS\u0016\u00148\u000b^1uK\u001a+Go\u00195feB)!*a!\u0003vA!!q\u000fBA\u001b\t\u0011IH\u0003\u0003\u0003|\tu\u0014a\u00024fi\u000eDWM\u001d\u0006\u0004\u0005\u007f*\u0015\u0001\u0002;jKJLAAa!\u0003z\t\u0001B+[3s'R\fG/\u001a$fi\u000eDWM\u001d\u0005\n\u0005\u0003y\u0002\u0013!a\u0001\u0005\u0007A\u0011B!# !\u0003\u0005\rAa#\u0002#\u0019,Go\u00195CC\u000e\\wJ\u001a4Ng>\u0003H\u000fE\u0003K\u0003\u0007\u000bY\tC\u0005\u0003\u0010~\u0001\n\u00111\u0001\u0003\f\u0006!b-\u001a;dQ\n\u000b7m[(gM6\u001bX*\u0019=PaR\fQe\u0019:fCR,'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$C-\u001a4bk2$H%\r\u001a\u0002K\r\u0014X-\u0019;f%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193%I\u00164\u0017-\u001e7uIE\u001aTC\u0001BLU\u0011\u0011Y)!)\u0002K\r\u0014X-\u0019;f%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193%I\u00164\u0017-\u001e7uIE\"\u0014\u0001K:i_VdGmU3oI2\u000bG/Z:u%\u0016\fX/Z:u-\u0016\u00148/[8og\nKH)\u001a4bk2$\bfA\u0012\u0003 B!\u00111\u0018BQ\u0013\u0011\u0011\u0019+!0\u0003\tQ+7\u000f^\u0001?i\u0016\u001cHOR3uG\"dU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;JM2\u000b7\u000f^#q_\u000eDG)\u001a4j]\u0016$gi\u001c:T_6,\u0007+\u0019:uSRLwN\\:)\u0007\u0011\u0012y*A\u000bbgN,'\u000f\u001e)beRLG/[8o'R\fG/Z:\u0015\u0015\u0005\u001d$Q\u0016B[\u0005\u007f\u0013\u0019\rC\u0004\u0003|\u0015\u0002\rAa,\u0011\u0007I\u0013\t,C\u0002\u00034\u000e\u0013Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0004\u00038\u0016\u0002\rA!/\u0002+MDw.\u001e7e\u0005\u0016\u0014V-\u00193z\r>\u0014h)\u001a;dQB\u0019!Ja/\n\u0007\tu6JA\u0004C_>dW-\u00198\t\u000f\t\u0005W\u00051\u0001\u0003:\u0006)2\u000f[8vY\u0012\u0014U\r\u0016:v]\u000e\fG/\u001b8h\u0019><\u0007b\u0002BcK\u0001\u0007!\u0011X\u0001\u0010g\"|W\u000f\u001c3CK\u0012+G.Y=fI\u0006)3\u000f[8vY\u0012D\u0015M\u001c3mK\u0016C8-\u001a9uS>tgI]8n\u00052|7m[5oON+g\u000e\u001a\u0015\u0004M\t}\u0015aQ:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007n\u00148ms&3G*Z1eKJ,\u0005o\\2i\u0017:|wO\u001c+p\u0005>$\b.\u00132qeYB3a\nBP\u0003a\u001a\bn\\;mI:{GOR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007nV5uQR\u0013XO\\2bi\u0016|eNR3uG\"D3\u0001\u000bBP\u0003\t2XM]5gs\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQR1\u0011q\rBl\u0005ODqA!7*\u0001\u0004\u0011Y.A\u0002jEB\u0004BA!8\u0003d6\u0011!q\u001c\u0006\u00041\n\u0005(B\u0001#Z\u0013\u0011\u0011)Oa8\u0003\u001f5+G/\u00193bi\u00064VM]:j_:D\u0011B!;*!\u0003\u0005\r!!&\u0002\u001f\u0015\u0004xn\u00195GKR\u001c\u0007nQ8v]R\fAF^3sS\u001aLh)\u001a;dQ2+\u0017\rZ3s\u000bB|7\r[(o\r&\u00148\u000f\u001e$fi\u000eDG\u0005Z3gCVdG\u000f\n\u001a\u00025Y,'/\u001b4z\u001f\u001a47/\u001a;SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8\u0015\u0011\u0005\u001d$\u0011\u001fBz\u0007\u000bAqA!7,\u0001\u0004\u0011Y\u000eC\u0004\u0003v.\u0002\rAa>\u00027=4gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u!\u0011\u0011IPa@\u000f\t\u0005\u001d#1`\u0005\u0005\u0005{\fI%\u0001\u000fPM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\n\t\r\u000511\u0001\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\u0011i0!\u0013\t\u000f\r\u001d1\u00061\u0001\u0004\n\u0005\u0011B.[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u!\u0011\u0019Ya!\u0005\u000f\t\u0005\u001d3QB\u0005\u0005\u0007\u001f\tI%\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$\u0018\u0002BB\u0001\u0007'QAaa\u0004\u0002J\u0005Ib/\u001a:jMfl\u0015M]6SKBd\u0017nY1UQJ|G\u000f\u001e7f)\u0019\t9g!\u0007\u0004\u001e!911\u0004\u0017A\u0002\u0005\u0015\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0005\n\u0007?a\u0003\u0013!a\u0001\u0003+\u000bQ\u0001^5nKN\f1E^3sS\u001aLX*\u0019:l%\u0016\u0004H.[2b)\"\u0014x\u000e\u001e;mK\u0012\"WMZ1vYR$#'A\u000ftQ>,H\u000e\u001a+ie>$H\u000f\\3G_2dwn^3s%\u0016\u0004H.[2bQ\rq#qT\u0001!i\u0016\u001cHOR8mY><XM]%t)\"\u0014x\u000e\u001e;mK\u0012|e\u000eT8x\t&\u001c8\u000eK\u00020\u0005?\u000bAg\u001d5pk2$GK];oG\u0006$X\rV8PM\u001a\u001cX\r^*qK\u000eLg-[3e\u0013:,\u0005o\\2i\u001f\u001a47/\u001a;SKN\u0004xN\\:fQ\r\u0001$qT\u0001Ng\"|W\u000f\u001c3UeVt7-\u0019;f)>|eMZ:fiN\u0003XmY5gS\u0016$\u0017J\\#q_\u000eDwJ\u001a4tKR\u0014Vm\u001d9p]N,\u0017J\u001a$pY2|w/\u001a:ICNtu.T8sK\u0016\u0003xn\u00195tQ\r\t$qT\u0001Kg\"|W\u000f\u001c3GKR\u001c\u0007\u000eT3bI\u0016\u0014X\t]8dQN+7m\u001c8e)&lW-\u00134MK\u0006$WM\u001d*fa2LWm],ji\",\u0005o\\2i\u001d>$8J\\8x]R{gi\u001c7m_^,'\u000fK\u00023\u0005?\u000b\u0011i\u001d5pk2$GK];oG\u0006$X-\u00134MK\u0006$WM\u001d*fa2LWm],ji\"$\u0015N^3sO&tw-\u00129pG\"tu\u000e^&o_^tGk\u001c$pY2|w/\u001a:)\u0007M\u0012y*A\u001atQ>,H\u000eZ+tK2+\u0017\rZ3s\u000b:$wJ\u001a4tKRLe-\u00138uKJ\u0014%o\\6feZ+'o]5p]\n+Gn\\<3a!\u001aAGa(\u0002\u0001NDw.\u001e7e)J,hnY1uKR{\u0017J\\5uS\u0006dg)\u001a;dQ>3gm]3u\u0013\u001adU-\u00193feJ+G/\u001e:ogVsG-\u001a4j]\u0016$wJ\u001a4tKRD3!\u000eBP\u0003E\u001a\bn\\;mIB{G\u000e\\%oI\u00164\u0017N\\5uK2L\u0018J\u001a'fC\u0012,'OU3ukJt7/\u00118z\u000bb\u001cW\r\u001d;j_:D3A\u000eBP\u0003-\u001a\bn\\;mI6{g/\u001a)beRLG/[8og>+Ho\u00144UeVt7-\u0019;j]\u001edunZ*uCR,\u0007fA\u001c\u0003 \u0006A4\u000f[8vY\u00124\u0015\u000e\u001c;feB\u000b'\u000f^5uS>t7/T1eK2+\u0017\rZ3s\tV\u0014\u0018N\\4MK\u0006$WM]#q_\u000eD'+Z9vKN$\bf\u0001\u001d\u0003 \u0006A5\u000f[8vY\u0012\u001c\u0015\r^2i\u000bb\u001cW\r\u001d;j_:4%o\\7CY>\u001c7.\u001b8h'\u0016tGm\u00165f]NCW\u000f\u001e;j]\u001e$un\u001e8SKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0015\u0004s\t}\u0015AJ:i_VdG-\u00169eCR,'+Z1tg&<g.\\3oi\nKH/Z:J]6+GO]5dg\"\u001a!Ha(\u0002\rNDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014V-Y:tS\u001etW.\u001a8u\u0005f$Xm]%o\u001b\u0016$(/[2t/\",gNT8SK\u0006\u001c8/[4o[\u0016tGo]%o!J|wM]3tg\"\u001a1Ha(\u0002\u001dQ,7\u000f\u001e\"vS2$g)\u001a;dQ\"\u001aAHa(\u0002C9,wo\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d)beRLG/[8o%\u0016\u001cX\u000f\u001c;\u0015\u0011\r\r4QQBE\u0007\u0017\u0003Ba!\u001a\u0004\u00009!1qMB>\u001d\u0011\u0019Ig!\u001f\u000f\t\r-4q\u000f\b\u0005\u0007[\u001a)H\u0004\u0003\u0004p\rMd\u0002\u0002B\u001f\u0007cJ\u0011!X\u0005\u00037rK!A\u0012.\n\u0005aK\u0016bAA\u001a/&!1QPA\u0019\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\r\u000551\u0011\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\u0019i(!\r\t\r\r\u001dU\b1\u0001V\u0003\t!\b\u000fC\u0004\u0002\u0014v\u0002\r!!&\t\u000f\r5U\b1\u0001\u0002\f\u0006IQM\u001c3PM\u001a\u001cX\r\u001e\u000b\u000b\u0007G\u001a\tja%\u0004$\u000e\u0015\u0006BBBD}\u0001\u0007Q\u000bC\u0004\u0004\u0016z\u0002\raa&\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\re5qT\u0007\u0003\u00077S1a!(X\u0003!\u0001(o\u001c;pG>d\u0017\u0002BBQ\u00077\u0013a!\u0012:s_J\u001c\bbBAJ}\u0001\u0007\u0011Q\u0013\u0005\b\u0007\u001bs\u0004\u0019AAF\u0003y\t7o]3siB\u0013xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b/\",g\u000e\u0006\u0003\u0002h\r-\u0006bBBW\u007f\u0001\u0007!\u0011X\u0001\u000eSN\u0014V-Y:tS\u001et\u0017N\\4\u0002\tM$XO\u0019\u000b\t\u0003O\u001a\u0019l!0\u0004@\"91Q\u0017!A\u0002\r]\u0016!\u00039beRLG/[8o!\rA7\u0011X\u0005\u0004\u0007wK'!\u0003)beRLG/[8o\u0011\u001d\u0019Y\u0002\u0011a\u0001\u0003KDqa!1A\u0001\u0004\u0019\u0019-A\u0002m_\u001e\u0004Ba!2\u0004J6\u00111q\u0019\u0006\u0004\u0007\u0003,\u0015\u0002BBf\u0007\u000f\u00141\"\u00112tiJ\f7\r\u001e'pO\u0006a2.\u00194lC\u000e{gNZ5h\u001d>$&/\u001e8dCR,wJ\u001c$fi\u000eDWCAAn\u0001")
public class ReplicaFetcherThreadTest {
    private final TopicPartition kafka$server$ReplicaFetcherThreadTest$$t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic2").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$))).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicIds()).asJava()).build();
    private ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latest(), BrokerFeatures$.MODULE$.createEmpty(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());

    public TopicPartition kafka$server$ReplicaFetcherThreadTest$$t1p0() {
        return this.kafka$server$ReplicaFetcherThreadTest$$t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(ZkMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    public RemoteLeaderEndPoint createRemoteLeaderEndPoint(KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Option<Time> timeOpt) {
        LogContext logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogContext());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(brokerConfig, (Function0 & Serializable & scala.Serializable)() -> brokerConfig.interBrokerProtocolVersion());
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        return new RemoteLeaderEndPoint(logContext.logPrefix(), leaderEndpointBlockingSend, fetchSessionHandler, (RequestBuilder)requestBuilder, (FollowerThrottler)throttler, brokerConfig, replicaMgr, quota, (Function0 & Serializable & scala.Serializable)() -> brokerConfig.interBrokerProtocolVersion());
    }

    public Option<LogContext> createRemoteLeaderEndPoint$default$5() {
        return None$.MODULE$;
    }

    public Option<Time> createRemoteLeaderEndPoint$default$6() {
        return None$.MODULE$;
    }

    public ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<TierStateFetcher> tierStateFetcher, Option<LogContext> logContextOpt, Option<Object> fetchBackOffMsOpt, Option<Object> fetchBackOffMsMaxOpt) {
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(brokerConfig, replicaMgr, quota, leaderEndpointBlockingSend, logContextOpt, (Option<Time>)new Some((Object)time));
        Function0 & Serializable & scala.Serializable x$11 = (Function0 & Serializable & scala.Serializable)() -> brokerConfig.interBrokerProtocolVersion();
        Map x$12 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
        return new ReplicaFetcherThread(name, fetcherId, (LeaderEndPoint)leader, brokerConfig, failedPartitions, replicaMgr, quota, logContextOpt, x$12, fetchBackOffMsOpt, fetchBackOffMsMaxOpt, (Function0)x$11);
    }

    public Option<LogContext> createReplicaFetcherThread$default$12() {
        return None$.MODULE$;
    }

    public Option<Object> createReplicaFetcherThread$default$13() {
        return None$.MODULE$;
    }

    public Option<Object> createReplicaFetcherThread$default$14() {
        return None$.MODULE$;
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, new MockBlockingSender((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava(), this.brokerEndPoint(), (Time)new SystemTime()), (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(), (short)config.interBrokerProtocolVersion().fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)config.interBrokerProtocolVersion().offsetForLeaderEpochRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)config.interBrokerProtocolVersion().listOffsetRequestVersion());
    }

    @Test
    public void testFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, this.initialFetchState$default$3()))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)3))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        new .colon.colon((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        String x$1 = "bob";
        int x$2 = 0;
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        None$ x$7 = None$.MODULE$;
        Metrics x$8 = new Metrics();
        SystemTime x$9 = new SystemTime();
        Option<LogContext> x$12 = this.createReplicaFetcherThread$default$12();
        Option<Object> x$13 = this.createReplicaFetcherThread$default$13();
        Option<Object> x$14 = this.createReplicaFetcherThread$default$14();
        Map result = this.createReplicaFetcherThread(x$1, x$2, x$3, config, x$5, replicaManager, x$8, (Time)x$9, null, mockBlockingSend, (Option<TierStateFetcher>)x$7, x$12, x$13, x$14).leader().fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLeaderEpoch(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBothIbp26() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.IBP_2_6_IV0, this.verifyFetchLeaderEpochOnFirstFetch$default$2());
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.latest(), 0);
    }

    public void verifyFetchLeaderEpochOnFirstFetch(MetadataVersion ibp, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metadataCache_$eq(new ZkMetadataCache(0, ibp, BrokerFeatures$.MODULE$.createEmpty(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4()));
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(config, replicaManager, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, mockNetwork, this.createRemoteLeaderEndPoint$default$5(), this.createRemoteLeaderEndPoint$default$6());
        String x$1 = "bob";
        int x$2 = 0;
        FailedPartitions x$5 = this.failedPartitions();
        QuotaFactory.UnboundedQuota$ x$7 = QuotaFactory.UnboundedQuota$.MODULE$;
        Function0 & Serializable & scala.Serializable x$8 = (Function0 & Serializable & scala.Serializable)() -> config.interBrokerProtocolVersion();
        Option x$9 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$8();
        Map x$10 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
        Option x$11 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
        Option x$12 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
        ReplicaFetcherThread thread = new ReplicaFetcherThread(x$1, x$2, (LeaderEndPoint)leader, config, x$5, replicaManager, (ReplicaQuota)x$7, x$9, x$10, x$11, x$12, (Function0)x$8);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        if (epochFetchCount > 0) {
            ListOffsetsRequestData.ListOffsetsTopic topic = (ListOffsetsRequestData.ListOffsetsTopic)Mockito.mock(ListOffsetsRequestData.ListOffsetsTopic.class);
            ListOffsetsRequest.Builder listOffsetsRequest = leader.requestBuilder().buildListOffsetRequest(topic);
            this.verifyOffsetRequestVersion(ibp, (OffsetsForLeaderEpochRequest.Builder)mockNetwork.lastUsedOffsetsForLeaderEpochRequest().get(), listOffsetsRequest);
        }
    }

    public int verifyFetchLeaderEpochOnFirstFetch$default$2() {
        return 1;
    }

    public void verifyOffsetRequestVersion(MetadataVersion ibp, OffsetsForLeaderEpochRequest.Builder offsetForLeaderEpochRequest, ListOffsetsRequest.Builder listOffsetsRequest) {
        MetadataVersion metadataVersion = ibp;
        MetadataVersion metadataVersion2 = MetadataVersion.IBP_2_6_IV0;
        if (!(metadataVersion != null ? !metadataVersion.equals(metadataVersion2) : metadataVersion2 != null)) {
            Assertions.assertEquals((int)3, (int)offsetForLeaderEpochRequest.oldestAllowedVersion());
            Assertions.assertEquals((int)3, (int)offsetForLeaderEpochRequest.latestAllowedVersion());
            Assertions.assertEquals((int)0, (int)listOffsetsRequest.oldestAllowedVersion());
            Assertions.assertEquals((int)5, (int)listOffsetsRequest.latestAllowedVersion());
            return;
        }
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)offsetForLeaderEpochRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)offsetForLeaderEpochRequest.latestAllowedVersion());
        Assertions.assertEquals((int)0, (int)listOffsetsRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)listOffsetsRequest.latestAllowedVersion());
    }

    public void verifyMarkReplicaThrottle(ReplicaManager replicaManager, int times) {
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)times))).markFollowerReplicaThrottle();
    }

    public int verifyMarkReplicaThrottle$default$2() {
        return 1;
    }

    @Test
    public void shouldThrottleFollowerReplica() {
        LazyRef Quota$module = new LazyRef();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_6_IV0.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(0).setLeaderEpoch(leaderEpoch).setEndOffset(100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(1).setLeaderEpoch(leaderEpoch).setEndOffset(1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), this.Quota$2(Quota$module), mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p1()}))), (Object)mockNetwork.lastFetchRequest().map((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(x$1.fetchData().keySet()).asScala()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        this.verifyMarkReplicaThrottle(replicaManager, 1);
    }

    @Test
    public void testFollowerIsThrottledOnLowDisk() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isThrottled((TopicPartition)ArgumentMatchers.any(TopicPartition.class)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AtomicReference<Some> retVal = new AtomicReference<Some>(new Some((Object)BoxesRunTime.boxToLong((long)42L)));
        Mockito.when((Object)quotaManager.lastSignalledQuotaOptRef()).thenReturn(retVal, (Object[])new AtomicReference[]{retVal, retVal, null});
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(leaderEpoch).setEndOffset(100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(leaderEpoch).setEndOffset(1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("audi", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quotaManager, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId1()), 0L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId1()), 0L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0))}));
        thread.leader().buildFetch(partitionMap);
        DiskUsageBasedThrottler$.MODULE$.registerListener((DiskUsageBasedThrottleListener)quotaManager);
        thread.leader().buildFetch(partitionMap);
        DiskUsageBasedThrottler$.MODULE$.deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
        thread.leader().buildFetch(partitionMap);
        this.verifyMarkReplicaThrottle(replicaManager, 4);
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 1)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 3)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpochAtLeader, 202L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)), (String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 4, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.fetchCount());
        java.util.Map nextOffsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertTrue((mockNetwork.lastUsedOffsetForLeaderEpochVersion() >= 3 ? 1 : 0) != 0, (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)102)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)101)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$2 -> (Option)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(new LogContext(), mockNetwork.brokerEndPoint().id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(config, (Function0 & Serializable & scala.Serializable)() -> config.interBrokerProtocolVersion());
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint("", (BlockingSend)mockNetwork, fetchSessionHandler, (RequestBuilder)requestBuilder, (FollowerThrottler)throttler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable & scala.Serializable)() -> config.interBrokerProtocolVersion());
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, leader, config, replicaManager, quota){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
            {
                String x$1 = "bob";
                int x$2 = 0;
                FailedPartitions x$5 = $outer.failedPartitions();
                scala.Serializable x$8 = new scala.Serializable(null, config$2){
                    public static final long serialVersionUID = 0L;
                    private final KafkaConfig config$2;

                    public final MetadataVersion apply() {
                        return this.config$2.interBrokerProtocolVersion();
                    }
                    {
                        this.config$2 = config$2;
                    }
                };
                Option x$9 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$8();
                Map x$10 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
                Option x$11 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
                Option x$12 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
                super(x$1, x$2, (LeaderEndPoint)leader$1, config$2, x$5, replicaManager$1, (ReplicaQuota)quota$1, x$9, x$10, x$11, x$12, (Function0)x$8);
            }
        };
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, this.initialFetchState$default$3()))})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = new Some((Object)BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 140 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 141 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)new StringBuilder(57).append("Expected to truncate to offset 129 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = None$.MODULE$;
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)new StringBuilder(57).append("Expected to truncate to offset 119 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), -1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), -1, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.lastUsedOffsetForLeaderEpochVersion(), (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)155)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)143)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialFetchOffset));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialFetchOffset, this.initialFetchState$default$3()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWatermark = 100;
        int initialLeo = 300;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)highWatermark));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLeo));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, (Option<LogContext>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)100L)), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        int[] expectedBackoffTimes = new int[]{100, 200, 400, 800};
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            thread.doWork();
            Assertions.assertEquals((long)expectedBackoffTimes[x], (long)((DelayedItem)((PartitionFetchState)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).get()).delay().get()).delayMs());
        });
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        offsetsReply.put(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 156L));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 4;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.state()));
        thread.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(0L, false);
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(5)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)initialLEO));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 5, 49L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$12(), this.createReplicaFetcherThread$default$13(), this.createReplicaFetcherThread$default$14());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, this.initialFetchState$default$3()))})));
        TopicPartition partitionThatBecameLeader = this.kafka$server$ReplicaFetcherThreadTest$$t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        String x$1 = "bob";
        int x$2 = 0;
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        None$ x$7 = None$.MODULE$;
        Metrics x$8 = new Metrics();
        SystemTime x$9 = new SystemTime();
        Option<LogContext> x$12 = this.createReplicaFetcherThread$default$12();
        Option<Object> x$13 = this.createReplicaFetcherThread$default$13();
        Option<Object> x$14 = this.createReplicaFetcherThread$default$14();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread(x$1, x$2, x$3, config, x$5, replicaManager, x$8, (Time)x$9, null, mockBlockingSend, (Option<TierStateFetcher>)x$7, x$12, x$13, x$14);
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBuildFetch() {
        void var31_31;
        void var23_23;
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.kafka$server$ReplicaFetcherThreadTest$$t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(config, replicaManager, replicaQuota, mockBlockingSend, this.createRemoteLeaderEndPoint$default$5(), this.createRemoteLeaderEndPoint$default$6());
        String x$1 = "bob";
        int x$2 = 0;
        FailedPartitions x$5 = this.failedPartitions();
        Function0 & Serializable & scala.Serializable x$8 = (Function0 & Serializable & scala.Serializable)() -> config.interBrokerProtocolVersion();
        Option x$9 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$8();
        Map x$10 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
        Option x$11 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
        Option x$12 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
        ReplicaFetcherThread thread = new ReplicaFetcherThread(x$1, x$2, (LeaderEndPoint)leader, config, x$5, replicaManager, replicaQuota, x$9, x$10, x$11, x$12, (Function0)x$8);
        int leaderEpoch = 1;
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId2()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8()))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Assertions.assertTrue((boolean)var23_23.isDefined());
        FetchRequest.Builder fetchRequestBuilder = ((AbstractFetcherThread.ReplicaFetch)var23_23.get()).fetchRequest();
        Map partitionDataMap = (Map)partitionMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState state = (PartitionFetchState)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter(partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData);
        leader.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        Map partitionMap2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)newTopicId), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, PartitionFetchState$.MODULE$.apply$default$8()))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch(partitionMap2);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt2 = (Option)resultWithPartitions2.result();
        Map partitionDataMap2 = (Map)((TraversableLike)partitionMap2.drop(1)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            PartitionFetchState state = (PartitionFetchState)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)var31_31.isDefined());
        FetchRequest.Builder fetchRequestBuilder2 = ((AbstractFetcherThread.ReplicaFetch)var31_31.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter(partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        String x$1 = "bob";
        int x$2 = 0;
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        Metrics x$7 = new Metrics();
        SystemTime x$8 = new SystemTime();
        None$ x$10 = None$.MODULE$;
        Option<LogContext> x$12 = this.createReplicaFetcherThread$default$12();
        Option<Object> x$13 = this.createReplicaFetcherThread$default$13();
        Option<Object> x$14 = this.createReplicaFetcherThread$default$14();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread(x$1, x$2, x$3, config, x$5, replicaManager, x$7, (Time)x$8, replicaQuota, mockBlockingSend, (Option<TierStateFetcher>)x$10, x$12, x$13, x$14);
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))});
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 0L, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, AbstractLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.getLinkedLeaderEpoch()).thenReturn((Object)None$.MODULE$);
    }

    private KafkaConfig kafkaConfigNoTruncateOnFetch() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_6_IV0.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString());
    }

    private final /* synthetic */ ReplicaFetcherThreadTest$Quota$1$ Quota$lzycompute$1(LazyRef Quota$module$1) {
        synchronized (Quota$module$1) {
            ReplicaFetcherThreadTest$Quota$1$ replicaFetcherThreadTest$Quota$1$ = Quota$module$1.initialized() ? (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.value() : (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.initialize((Object)new ReplicaFetcherThreadTest$Quota$1$(this));
            return replicaFetcherThreadTest$Quota$1$;
        }
    }

    private final ReplicaFetcherThreadTest$Quota$1$ Quota$2(LazyRef Quota$module$1) {
        if (Quota$module$1.initialized()) {
            return (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.value();
        }
        return this.Quota$lzycompute$1(Quota$module$1);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public ReplicaFetcherThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

