/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.cluster.PartitionTest$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractLogReadResult;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.TierReplicaComponents;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004I\u0001\u0001\u0006Ia\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\t\u0006\u0001)A\u0005\u0017\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u00021\u0001A\u0003%A\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r!\u0004\u0001\u0015!\u0003d\u0011\u001dI\u0007A1A\u0005\u0002)Daa\u001c\u0001!\u0002\u0013Y\u0007b\u00029\u0001\u0005\u0004%\tA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u000fI\u0004!\u0019!C\u0001g\"1q\u000f\u0001Q\u0001\nQDq\u0001\u001f\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u0002>\t\u0013\u0005M\u0001A1A\u0005\u0002\u0005U\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0006\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005U\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0006\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005\u0015\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\n\t\u0017\u0005]\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0003\tI\u0006C\u0006\u0002f\u0001\u0001\r\u0011!Q!\n\u0005m\u0002bCA4\u0001\u0001\u0007\t\u0019!C\u0001\u0003SB1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002t!Y\u0011q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA6\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a%\u0001\t\u0003\tY\bC\u0004\u0002\u0018\u0002!\t!a\u001f\t\u000f\u0005m\u0005\u0001\"\u0001\u0002|!9\u0011q\u0014\u0001\u0005\u0002\u0005m\u0004bBAR\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003O\u0003A\u0011AA>\u0011\u001d\tY\u000b\u0001C\u0001\u0003[C\u0011\"a2\u0001#\u0003%\t!!3\t\u0013\u0005}\u0007!%A\u0005\u0002\u0005\u0005\bbBAs\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003_\u0004A\u0011AAy\u0011\u001d\tI\u0010\u0001C\u0005\u0003wD\u0011B!\b\u0001#\u0003%I!!9\u00031I+\u0007\u000f\\5dC6\u000bg.Y4feF+x\u000e^1t)\u0016\u001cHO\u0003\u0002/_\u000511/\u001a:wKJT\u0011\u0001M\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0002\"\u0001\u0010\u0001\u000e\u00035\nqaY8oM&<7/F\u0001@!\r\u00015)R\u0007\u0002\u0003*\u0011!)N\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\r\u0019V-\u001d\t\u0003y\u0019K!aR\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tG>tg-[4tA\u0005!A/[7f+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(0\u0003\u0015)H/\u001b7t\u0013\t\u0001VJ\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0016\t\u0003+zk\u0011A\u0016\u0006\u0003%^S!\u0001W-\u0002\r\r|W.\\8o\u0015\t\u0001$L\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<\u0017BA0W\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0007e\u0016\u001cwN\u001d3\u0016\u0003\r\u0004\"\u0001\u001a4\u000e\u0003\u0015T!!Y,\n\u0005\u001d,'\u0001D*j[BdWMU3d_J$\u0017a\u0002:fG>\u0014H\rI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ocU\t1\u000e\u0005\u0002m[6\tq+\u0003\u0002o/\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\\u0019!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0014\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012\u0001\u001e\t\u0003YVL!A^,\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005AAo\u001c9jG&#7/F\u0001{!\u0019Y\u0018\u0011AA\u0003i6\tAP\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005\ri\u0015\r\u001d\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002@\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\tIA\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\n\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c82+\t\t9\u0002E\u0002m\u00033I1!a\u0007X\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]F\u0002\u0013!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oe\u0005\u0011Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u001a!\u0003%1W\r^2i\u0013:4w.\u0006\u0002\u0002(A!\u0001iQA\u0015!\u001d!\u00141FA\f\u0003_I1!!\f6\u0005\u0019!V\u000f\u001d7feA\u0019A(!\r\n\u0007\u0005MRF\u0001\u000eGk2d\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018-\u0001\u0006gKR\u001c\u0007.\u00138g_\u0002\nA\"];pi\u0006l\u0015M\\1hKJ,\"!a\u000f\u0011\t\u0005u\u0012\u0011\u000b\b\u0005\u0003\u007f\tiE\u0004\u0003\u0002B\u0005-c\u0002BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0013'\u0001\u0004=e>|GOP\u0005\u0002a%\u0011afL\u0005\u0004\u0003\u001fj\u0013\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA*\u0003+\u0012Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA([\u0005\u0001\u0012/^8uC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u00037\n\t\u0007E\u00025\u0003;J1!a\u00186\u0005\u0011)f.\u001b;\t\u0013\u0005\r\u0014$!AA\u0002\u0005m\u0012a\u0001=%c\u0005i\u0011/^8uC6\u000bg.Y4fe\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002lA\u0019A(!\u001c\n\u0007\u0005=TF\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u00037\n)\bC\u0005\u0002dq\t\t\u00111\u0001\u0002l\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0016tQ>,H\u000eZ#yG2,H-Z*vEN,\u0017/^3oiRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\u0005m\u0003f\u0001\u0010\u0002\u0000A!\u0011\u0011QAH\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aA1qS*!\u0011\u0011RAF\u0003\u001dQW\u000f]5uKJT1!!$]\u0003\u0015QWO\\5u\u0013\u0011\t\t*a!\u0003\tQ+7\u000f^\u0001:g\"|W\u000f\u001c3HKRtu.T3tg\u0006<Wm]%g#V|G/Y:Fq\u000e,W\rZ3e\u001f:\u001cVOY:fcV,g\u000e\u001e)beRLG/[8og\"\u001aq$a \u0002EMDw.\u001e7e\u000f\u0016$(i\u001c;i\u001b\u0016\u001c8/Y4fg&3\u0017+^8uCN\fE\u000e\\8xQ\r\u0001\u0013qP\u0001%g\"|W\u000f\u001c3J]\u000edW\u000fZ3J]NKhn\u0019+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\"\u001a\u0011%a \u0002]MDw.\u001e7e\u0013:\u001cG.\u001e3f)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001chi\u001c:D_:\u001cX/\\3s\r\u0016$8\r\u001b\u0015\u0004E\u0005}\u0014a\f;fgR\u001cu.\u001c9mKR,\u0017J\u001c#fY\u0006LX\r\u001a$fi\u000eDw+\u001b;i%\u0016\u0004H.[2b)\"\u0014x\u000e\u001e;mS:<\u0007fA\u0012\u0002\u0000\u00059C/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ\u000e{gn];nKJ4U\r^2iQ\r!\u0013qP\u0001\u000bg\u0016$X\u000b]'pG.\u001cH\u0003CA.\u0003_\u000bY,!0\t\u000f\u0005\rR\u00051\u0001\u00022B!\u0001iQAZ!\u001d!\u00141FA\f\u0003k\u00032\u0001PA\\\u0013\r\tI,\f\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\"9\u0011-\nI\u0001\u0002\u0004\u0019\u0007\"CA`KA\u0005\t\u0019AAa\u0003I\u0011w\u000e\u001e5SKBd\u0017nY1t\u0013:\u001c\u0016P\\2\u0011\u0007Q\n\u0019-C\u0002\u0002FV\u0012qAQ8pY\u0016\fg.\u0001\u000btKR,\u0006/T8dWN$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017T3aYAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAmk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002d*\"\u0011\u0011YAg\u0003!!X-\u0019:E_^t\u0007f\u0001\u0015\u0002jB!\u0011\u0011QAv\u0013\u0011\ti/a!\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!C7pG.\fVo\u001c;b)\t\t\u0019\u0010E\u0002=\u0003kL1!a>.\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003A\u0011X-\u00193Ge>lGj\\2bY2{w\r\u0006\u0006\u0002~\n\u001d!\u0011\u0003B\u000b\u00053\u0001B\u0001Q\"\u0002\u0000B9A'a\u000b\u0002\u0018\t\u0005\u0001c\u0001\u001f\u0003\u0004%\u0019!QA\u0017\u0003\u001b1{wMU3bIJ+7/\u001e7u\u0011\u001d\u0011IA\u000ba\u0001\u0005\u0017\t1BZ3uG\"\u0004\u0016M]1ngB\u0019AH!\u0004\n\u0007\t=QFA\u0006GKR\u001c\u0007\u000eU1sC6\u001c\bb\u0002B\nU\u0001\u0007\u0011\u0011W\u0001\u0012e\u0016\fG\rU1si&$\u0018n\u001c8J]\u001a|\u0007b\u0002B\fU\u0001\u0007\u00111_\u0001\u0006cV|G/\u0019\u0005\n\u00057Q\u0003\u0013!a\u0001\u0003\u0003\f\u0011C]3bI\u001a\u0013x.\u001c)ve\u001e\fGo\u001c:z\u0003i\u0011X-\u00193Ge>lGj\\2bY2{w\r\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4());
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(fetchParams, this.fetchInfo(), quota, this.readFromLocalLog$default$4());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4());
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(fetchParams, this.fetchInfo(), quota, this.readFromLocalLog$default$4());
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((long)0L, (long)this.replicaManager().throttledFollowerReplicasRate().count());
        Assertions.assertEquals((long)2L, (long)this.replicaManager().throttledLeaderReplicasRate().count());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4());
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(fetchParams, this.fetchInfo(), quota, this.readFromLocalLog$default$4());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4());
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(fetchParams, this.fetchInfo(), quota, this.readFromLocalLog$default$4());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.consumerFetchParams(PartitionTest$.MODULE$.consumerFetchParams$default$1(), PartitionTest$.MODULE$.consumerFetchParams$default$2(), PartitionTest$.MODULE$.consumerFetchParams$default$3(), PartitionTest$.MODULE$.consumerFetchParams$default$4(), PartitionTest$.MODULE$.consumerFetchParams$default$5());
        scala.collection.immutable.Map fetch = this.readFromLocalLog(fetchParams, this.fetchInfo(), quota, this.readFromLocalLog$default$4()).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records().batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records().batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)this.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)this.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)this.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)this.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    public void setUpMocks(Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), "", QuotaFactory$.MODULE$.instantiate$default$5()));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(leaderBrokerId, ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion(), MetadataCache$.MODULE$.zkMetadataCache$default$3(), MetadataCache$.MODULE$.zkMetadataCache$default$4());
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats x$102 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        Function0 x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        TierReplicaComponents x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$102, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota() {
        void var1_1;
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var1_1;
    }

    private Seq<Tuple2<TopicIdPartition, LogReadResult>> readFromLocalLog(FetchParams fetchParams, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> readPartitionInfo, ReplicaQuota quota, boolean readFromPurgatory) {
        return (Seq)this.replicaManager().readFromLocalLog(fetchParams, readPartitionInfo, quota, readFromPurgatory).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicIdPartition, AbstractLogReadResult>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicIdPartition topicIdPartition = (TopicIdPartition)x1._1();
                    AbstractLogReadResult result = (AbstractLogReadResult)x1._2();
                    if (result instanceof LogReadResult) {
                        LogReadResult logReadResult = (LogReadResult)result;
                        object = new Tuple2((Object)topicIdPartition, (Object)logReadResult);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicIdPartition, AbstractLogReadResult> x1) {
                boolean bl = x1 != null && (AbstractLogReadResult)x1._2() instanceof LogReadResult;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean readFromLocalLog$default$4() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        TopicPartition tp = new TopicPartition("t1", 0);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(this.topicId(), 50L, 0L, 1, Optional.empty(), Optional.empty());
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(50L, 0L, 250));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), 1, 600L, 1, 1000, (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
        TopicIdPartition tidp = new TopicIdPartition(this.topicId(), tp);
        return new DelayedFetch(null, fetchParams, tidp, fetchInfo, replicaManager, brokerTopicStats){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    private final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        TopicIdPartition tidp = new TopicIdPartition(this.topicId(), 0, "t1");
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tidp.topicPartition());
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(this.topicId(), 50L, 0L, 1, Optional.empty(), Optional.empty());
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(50L, 0L, 250));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, 600L, 1, 1000, (FetchIsolation)FetchHighWatermark$.MODULE$, (Option)None$.MODULE$);
        return new DelayedFetch(null, fetchParams, tidp, fetchInfo, replicaManager, brokerTopicStats){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, AbstractLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicIdPartition p = (TopicIdPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), true, bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, LeaderRecoveryState.RECOVERED, Predef$.MODULE$.Set().empty(), (Option)None$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }
}

