/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.ReplicationQuotasTest$ReplicationResults$;
import kafka.server.ReplicationQuotasTest$ReplicationTestSettings$;
import kafka.server.ZkConfigManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r%f\u0001\u0002/^\u0001\tDQa\u001a\u0001\u0005\u0002!DQA\u001b\u0001\u0005\u0002-Dq!\u001f\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B>\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0001\"CA\u0014\u0001\u0001\u0007I\u0011AA\u0015\u0011!\t)\u0004\u0001Q!\n\u0005%\u0001\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\tY\u0005\u0001Q\u0001\n\u0005m\u0002\"CA'\u0001\u0001\u0007I\u0011AA(\u0011%\tI\u0007\u0001a\u0001\n\u0003\tY\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0015BA)\u0011\u001d\t\t\b\u0001C!\u0003gBq!a#\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0016\u0002!\t!a\u001d\t\u000f\u0005e\u0005\u0001\"\u0001\u0002t!9\u0011Q\u0014\u0001\u0005\u0002\u0005M\u0004bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqA!%\u0001\t\u0003\t\u0019\bC\u0004\u0003\u0016\u0002!\t!a\u001d\t\u000f\te\u0005\u0001\"\u0001\u0002t!9!Q\u0014\u0001\u0005\u0002\t}\u0005b\u0002BS\u0001\u0011\u0005\u00111\u000f\u0005\b\u0005S\u0003A\u0011AA:\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005_CqAa-\u0001\t\u0003\u0011)\fC\u0004\u0003H\u0002!\tA!3\t\u000f\t=\u0007\u0001\"\u0003\u0003R\"9!Q\u001c\u0001\u0005\n\t}gA\u0002B.\u0001\u0001\u0013i\u0006\u0003\u0006\u0003`\u0001\u0012)\u001a!C\u0001\u0003\u0017D\u0011B!\u0019!\u0005#\u0005\u000b\u0011\u00027\t\u0015\t\r\u0004E!f\u0001\n\u0003\tY\rC\u0005\u0003f\u0001\u0012\t\u0012)A\u0005Y\"1q\r\tC\u0001\u0005OB\u0011\"a<!\u0003\u0003%\tA!\u001c\t\u0013\u0005m\b%%A\u0005\u0002\u0005u\b\"\u0003B\nAE\u0005I\u0011AA\u007f\u0011%\u0011)\u0003IA\u0001\n\u0003\nI\u0004C\u0005\u0003(\u0001\n\t\u0011\"\u0001\u0002R\"I!\u0011\u0006\u0011\u0002\u0002\u0013\u0005!1\u000f\u0005\n\u0005k\u0001\u0013\u0011!C!\u0005oA\u0011B!\u0012!\u0003\u0003%\tAa\u001e\t\u0013\t-\u0003%!A\u0005B\t5\u0003\"\u0003B(A\u0005\u0005I\u0011\tB)\u0011%\u0011\u0019\u0006IA\u0001\n\u0003\u0012YhB\u0005\u0003f\u0002\t\t\u0011#\u0001\u0003h\u001aI!1\f\u0001\u0002\u0002#\u0005!\u0011\u001e\u0005\u0007OJ\"\tAa>\t\u0013\t=#'!A\u0005F\tE\u0003\"\u0003B}e\u0005\u0005I\u0011\u0011B~\u0011%\u0019\tAMA\u0001\n\u0003\u001b\u0019A\u0002\u0004\u00024\u0002\u0001\u0015Q\u0017\u0005\u000b\u0003\u0013<$Q3A\u0005\u0002\u0005-\u0007\"CAgo\tE\t\u0015!\u0003m\u0011)\tym\u000eBK\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003'<$\u0011#Q\u0001\nQD\u0011\"!68\u0005+\u0007I\u0011\u0001>\t\u0013\u0005]wG!E!\u0002\u0013Y\bBCAmo\tU\r\u0011\"\u0001\u0002\\\"Q\u00111]\u001c\u0003\u0012\u0003\u0006I!!8\t\r\u001d<D\u0011AAs\u0011%\tyoNA\u0001\n\u0003\t\t\u0010C\u0005\u0002|^\n\n\u0011\"\u0001\u0002~\"I!1C\u001c\u0012\u0002\u0013\u0005!Q\u0003\u0005\n\u000539\u0014\u0013!C\u0001\u00057A\u0011Ba\b8#\u0003%\tA!\t\t\u0013\t\u0015r'!A\u0005B\u0005e\u0002\"\u0003B\u0014o\u0005\u0005I\u0011AAi\u0011%\u0011IcNA\u0001\n\u0003\u0011Y\u0003C\u0005\u00036]\n\t\u0011\"\u0011\u00038!I!QI\u001c\u0002\u0002\u0013\u0005!q\t\u0005\n\u0005\u0017:\u0014\u0011!C!\u0005\u001bB\u0011Ba\u00148\u0003\u0003%\tE!\u0015\t\u0013\tMs'!A\u0005B\tUs!CB\t\u0001\u0005\u0005\t\u0012AB\n\r%\t\u0019\fAA\u0001\u0012\u0003\u0019)\u0002\u0003\u0004h\u001f\u0012\u00051Q\u0004\u0005\n\u0005\u001fz\u0015\u0011!C#\u0005#B\u0011B!?P\u0003\u0003%\tia\b\t\u0013\r\u0005q*!A\u0005\u0002\u000e%\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\b\u0007\u0013\u0002A\u0011AB&\u0011%\u0019y\u0006AI\u0001\n\u0003\u0011\t\u0003C\u0005\u0004b\u0001\t\n\u0011\"\u0001\u0003\"!911\r\u0001\u0005\u0002\r\u0015\u0004bBB=\u0001\u0011%11\u0010\u0005\b\u0007\u001f\u0003A\u0011BBI\u0011\u001d\u0019Y\n\u0001C\u0001\u0007;\u0013QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002_?\u000611/\u001a:wKJT\u0011\u0001Y\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\r\u0005\u0002eK6\tQ,\u0003\u0002g;\n\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0007C\u00013\u0001\u00031\u0001XM]2f]R,%O]8s)\ra'o\u001e\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\u0005\u0019>tw\rC\u0003t\u0005\u0001\u0007A/A\u0004qKJ\u001cWM\u001c;\u0011\u00055,\u0018B\u0001<o\u0005\rIe\u000e\u001e\u0005\u0006q\n\u0001\r\u0001\\\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t1\u0010E\u0002nyzL!! 8\u0003\u000b\u0005\u0013(/Y=\u0011\u00055|\u0018bAA\u0001]\n!!)\u001f;f\u0003%i7oZ\u00191a-\u0013\u0005%A\u0004ce>\\WM]:\u0016\u0005\u0005%\u0001CBA\u0006\u00037\t\tC\u0004\u0003\u0002\u000e\u0005]a\u0002BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0011-\u0001\u0004=e>|GOP\u0005\u0002_&\u0019\u0011\u0011\u00048\u0002\u000fA\f7m[1hK&!\u0011QDA\u0010\u0005\r\u0019V-\u001d\u0006\u0004\u00033q\u0007c\u00013\u0002$%\u0019\u0011QE/\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fEJ|7.\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0002cA7\u0002.%\u0019\u0011q\u00068\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g1\u0011\u0011!a\u0001\u0003\u0013\t1\u0001\u001f\u00132\u0003!\u0011'o\\6feN\u0004\u0013!\u0002;pa&\u001cWCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\taJ|G-^2feV\u0011\u0011\u0011\u000b\t\u0007\u0003'\n)g_>\u000e\u0005\u0005U#\u0002BA'\u0003/RA!!\u0017\u0002\\\u000591\r\\5f]R\u001c(b\u00011\u0002^)!\u0011qLA1\u0003\u0019\t\u0007/Y2iK*\u0011\u00111M\u0001\u0004_J<\u0017\u0002BA4\u0003+\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fH\u0003BA\u0016\u0003[B\u0011\"a\r\f\u0003\u0003\u0005\r!!\u0015\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005-\u0002fA\u0007\u0002xA!\u0011\u0011PAD\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014aA1qS*!\u0011\u0011QAB\u0003\u001dQW\u000f]5uKJTA!!\"\u0002b\u0005)!.\u001e8ji&!\u0011\u0011RA>\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0016tQ>,H\u000e\u001a\"p_R\u001cHO]1q)^|'I]8lKJ\u001cx+\u001b;i\u0019\u0016\fG-\u001a:UQJ|G\u000f\u001e7fQ\rq\u0011q\u0012\t\u0005\u0003s\n\t*\u0003\u0003\u0002\u0014\u0006m$\u0001\u0002+fgR\fQf\u001d5pk2$'i\\8ugR\u0014\u0018\r\u001d+x_\n\u0013xn[3sg^KG\u000f\u001b$pY2|w/\u001a:UQJ|G\u000f\u001e7fQ\ry\u0011qR\u0001<g\"|W\u000f\u001c3C_>$8\u000f\u001e:baR;xN\u0011:pW\u0016\u00148oV5uQ\n\u0013xn[3s%\u0016\u0004H.[2bg\u001a{G\u000e\\8xKJ$\u0006N]8ui2,\u0007f\u0001\t\u0002\u0010\u0006I4\u000f[8vY\u0012\u0014un\u001c;tiJ\f\u0007\u000fV<p\u0005J|7.\u001a:t/&$\bN\u0011:pW\u0016\u0014(+\u001a9mS\u000e\f7\u000fT3bI\u0016\u0014H\u000b\u001b:piRdW\rK\u0002\u0012\u0003\u001f\u000b\u0001c\u001d5pk2$W*\u0019;dQF+x\u000e^1\u0015\r\u0005-\u0012Q\u0015B@\u0011\u001d\t9K\u0005a\u0001\u0003S\u000bqB]3qY&\u001c\u0017\r^5p]R+7\u000f\u001e\t\b[\u0006-\u0016q\u0016B-\u0013\r\tiK\u001c\u0002\n\rVt7\r^5p]F\u00022!!-8\u001b\u0005\u0001!a\u0006*fa2L7-\u0019;j_:$Vm\u001d;TKR$\u0018N\\4t'\u001d9\u0014qWA_\u0003\u0007\u00042!\\A]\u0013\r\tYL\u001c\u0002\u0007\u0003:L(+\u001a4\u0011\u00075\fy,C\u0002\u0002B:\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002n\u0003\u000bL1!a2o\u00051\u0019VM]5bY&T\u0018M\u00197f\u00035!\bN]8ui2,')\u001f;fgV\tA.\u0001\buQJ|G\u000f\u001e7f\u0005f$Xm\u001d\u0011\u0002\u00115\u001cxmQ8v]R,\u0012\u0001^\u0001\n[N<7i\\;oi\u0002\n1!\\:h\u0003\u0011i7o\u001a\u0011\u0002\u001dQD'o\u001c;uY\u0016dU-\u00193feV\u0011\u0011Q\u001c\t\u0004[\u0006}\u0017bAAq]\n9!i\\8mK\u0006t\u0017a\u0004;ie>$H\u000f\\3MK\u0006$WM\u001d\u0011\u0015\u0015\u0005=\u0016q]Au\u0003W\fi\u000f\u0003\u0004\u0002J\u0002\u0003\r\u0001\u001c\u0005\u0007\u0003\u001f\u0004\u0005\u0019\u0001;\t\r\u0005U\u0007\t1\u0001|\u0011\u001d\tI\u000e\u0011a\u0001\u0003;\fAaY8qsRQ\u0011qVAz\u0003k\f90!?\t\u0011\u0005%\u0017\t%AA\u00021D\u0001\"a4B!\u0003\u0005\r\u0001\u001e\u0005\t\u0003+\f\u0005\u0013!a\u0001w\"I\u0011\u0011\\!\u0011\u0002\u0003\u0007\u0011Q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyPK\u0002m\u0005\u0003Y#Aa\u0001\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bq\u0017AC1o]>$\u0018\r^5p]&!!\u0011\u0003B\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119BK\u0002u\u0005\u0003\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001e)\u001a1P!\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0005\u0016\u0005\u0003;\u0014\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iCa\r\u0011\u00075\u0014y#C\u0002\u000329\u00141!\u00118z\u0011!\t\u0019\u0004SA\u0001\u0002\u0004!\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\te\u0002C\u0002B\u001e\u0005\u0003\u0012i#\u0004\u0002\u0003>)\u0019!q\b8\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003D\tu\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!8\u0003J!I\u00111\u0007&\u0002\u0002\u0003\u0007!QF\u0001\tQ\u0006\u001c\bnQ8eKR\tA/\u0001\u0005u_N#(/\u001b8h)\t\tY$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003;\u00149\u0006C\u0005\u000245\u000b\t\u00111\u0001\u0003.A\u0019\u0011\u0011\u0017\u0011\u0003%I+\u0007\u000f\\5dCRLwN\u001c*fgVdGo]\n\bA\u0005]\u0016QXAb\u0003=)h\u000e\u001e5s_R$H.\u001a3US6,\u0017\u0001E;oi\"\u0014x\u000e\u001e;mK\u0012$\u0016.\\3!\u00035!\bN]8ui2,G\rV5nK\u0006qA\u000f\u001b:piRdW\r\u001a+j[\u0016\u0004CC\u0002B-\u0005S\u0012Y\u0007\u0003\u0004\u0003`\u0015\u0002\r\u0001\u001c\u0005\u0007\u0005G*\u0003\u0019\u00017\u0015\r\te#q\u000eB9\u0011!\u0011yF\nI\u0001\u0002\u0004a\u0007\u0002\u0003B2MA\u0005\t\u0019\u00017\u0015\t\t5\"Q\u000f\u0005\t\u0003gY\u0013\u0011!a\u0001iR!\u0011Q\u001cB=\u0011%\t\u0019$LA\u0001\u0002\u0004\u0011i\u0003\u0006\u0003\u0002^\nu\u0004\"CA\u001aa\u0005\u0005\t\u0019\u0001B\u0017\u0011\u001d\u0011\tI\u0005a\u0001\u0003;\f!\u0003^3ti2+\u0017\rZ3s)\"\u0014x\u000e\u001e;mK\u0006!#/\u001a9mS\u000e\fG/Z,ji\"\u001cF/\u0019;jGRC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000f\u0006\u0003\u0003Z\t\u001d\u0005b\u0002BE'\u0001\u0007\u0011qV\u0001\tg\u0016$H/\u001b8hg\u0006\u0001%/\u001a9mS\u000e\fG/Z,ji\"$\u0015P\\1nS\u000e$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d+ie>,x\r[!o\u0003NLX.\\3ue&\u001cGk\u001c9pY><\u0017\u0010\u0006\u0003\u0003Z\t=\u0005b\u0002BE)\u0001\u0007\u0011qV\u0001\u001ag\"|W\u000f\u001c3UQJ|G\u000f\u001e7f\u001f2$7+Z4nK:$8\u000fK\u0002\u0016\u0003\u001f\u000b\u0001\u0005^3ti\u001a{G\u000e\\8xKJL5\u000f\u00165s_R$H.\u001a3P]N#\u0018M\u001d;va\"\u001aa#a$\u0002eQ,7\u000f\u001e$pY2|w/\u001a:JgRC'o\u001c;uY\u0016$wJ\\*uCJ$X\u000f],ji\"\u001cE.^:uKJd\u0015N\\6j]\u001eD3aFAH\u0003\t2XM]5gs\u001a{G\u000e\\8xKJL5\u000f\u00165s_R$H.\u001a3P]N#\u0018M\u001d;vaR!\u00111\u0006BQ\u0011\u001d\u0011\u0019\u000b\u0007a\u0001\u0003;\f\u0011c\u00197vgR,'\u000fT5oW\u0016s\u0017M\u00197f\u0003M\"Xm\u001d;G_2dwn^3s\u0007>tg-[4JgVs7\r[1oO\u0016$wJ\\!di&4X\rR5tWRC'o\u001c;uY&tw\rK\u0002\u001a\u0003\u001f\u000bQ\t^3ti\u001a{G\u000e\\8xKJ\u001cuN\u001c4jO&\u001bXK\\2iC:<W\rZ(o\u0003\u000e$\u0018N^3ESN\\G\u000b\u001b:piRd\u0017N\\4XSRD7\t\\;ti\u0016\u0014H*\u001b8lS:<\u0007f\u0001\u000e\u0002\u0010\u0006)d/\u001a:jMf4u\u000e\u001c7po\u0016\u00148i\u001c8gS\u001eL5/\u00168dQ\u0006tw-\u001a3P]\u0006\u001bG/\u001b<f\t&\u001c8\u000e\u00165s_R$H.\u001b8h)\u0011\tYC!-\t\u000f\t\r6\u00041\u0001\u0002^\u0006i3M]3bi\u0016\u0014%o\\6fe^KG\u000f\u001b#jg.,6/Y4f\u0005\u0006\u001cX\r\u001a+ie>$H\u000f\\5oO6\u000b\u0017PY3\u0015\u0011\u0005\u0005\"q\u0017B^\u0005\u000bDaA!/\u001d\u0001\u0004!\u0018\u0001\u00032s_.,'/\u00133\t\u000f\tuF\u00041\u0001\u0003@\u0006YA\u000f\u001b:piRdWm\u00149u!\u0011i'\u0011\u00197\n\u0007\t\rgN\u0001\u0004PaRLwN\u001c\u0005\b\u0005Gc\u0002\u0019AAo\u0003\u001d\tG\r\u001a#bi\u0006$b!a\u000b\u0003L\n5\u0007BBAh;\u0001\u0007A\u000f\u0003\u0004\u0002Vv\u0001\ra_\u0001\u0016o\u0006LGOR8s\u001f\u001a47/\u001a;t)>l\u0015\r^2i)!\tYCa5\u0003X\nm\u0007B\u0002Bk=\u0001\u0007A/\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0007\u00053t\u0002\u0019\u0001;\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0005ss\u0002\u0019\u0001;\u0002\u0013\t\u0014xn[3s\r>\u0014H\u0003BA\u0011\u0005CDaAa9 \u0001\u0004!\u0018AA5e\u0003I\u0011V\r\u001d7jG\u0006$\u0018n\u001c8SKN,H\u000e^:\u0011\u0007\u0005E&gE\u00033\u0005W\f\u0019\r\u0005\u0005\u0003n\nMH\u000e\u001cB-\u001b\t\u0011yOC\u0002\u0003r:\fqA];oi&lW-\u0003\u0003\u0003v\n=(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!q]\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u00053\u0012iPa@\t\r\t}S\u00071\u0001m\u0011\u0019\u0011\u0019'\u000ea\u0001Y\u00069QO\\1qa2LH\u0003BB\u0003\u0007\u001b\u0001R!\u001cBa\u0007\u000f\u0001R!\\B\u0005Y2L1aa\u0003o\u0005\u0019!V\u000f\u001d7fe!I1q\u0002\u001c\u0002\u0002\u0003\u0007!\u0011L\u0001\u0004q\u0012\u0002\u0014a\u0006*fa2L7-\u0019;j_:$Vm\u001d;TKR$\u0018N\\4t!\r\t\tlT\n\u0006\u001f\u000e]\u00111\u0019\t\f\u0005[\u001cI\u0002\u001c;|\u0003;\fy+\u0003\u0003\u0004\u001c\t=(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u001111\u0003\u000b\u000b\u0003_\u001b\tca\t\u0004&\r\u001d\u0002BBAe%\u0002\u0007A\u000e\u0003\u0004\u0002PJ\u0003\r\u0001\u001e\u0005\u0007\u0003+\u0014\u0006\u0019A>\t\u000f\u0005e'\u000b1\u0001\u0002^R!11FB\u001a!\u0015i'\u0011YB\u0017!!i7q\u00067uw\u0006u\u0017bAB\u0019]\n1A+\u001e9mKRB\u0011ba\u0004T\u0003\u0003\u0005\r!a,\u0002\u0005Q\u0004H\u0003BB\u001d\u0007\u000b\u0002Baa\u000f\u0004B5\u00111Q\b\u0006\u0005\u0007\u007f\tY&\u0001\u0004d_6lwN\\\u0005\u0005\u0007\u0007\u001aiD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\r\u001dC\u000b1\u0001u\u0003%\u0001\u0018M\u001d;ji&|g.A\u0007de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u000b\u0003W\u0019iea\u0015\u0004X\rm\u0003bBB(+\u0002\u00071\u0011K\u0001\nEJ|7.\u001a:JIN\u0004R!a\u0003\u0002\u001cQDaa!\u0016V\u0001\u0004a\u0017\u0001\u0003;ie>$H\u000f\\3\t\u0013\reS\u000b%AA\u0002\u0005u\u0017a\b;ie>$H\u000f\\3BY2\u0014%o\\6fe2+\u0017\rZ3s%\u0016\u0004H.[2bg\"I1QL+\u0011\u0002\u0003\u0007\u0011Q\\\u0001\"i\"\u0014x\u000e\u001e;mK\u0006cGN\u0011:pW\u0016\u0014hi\u001c7m_^,'OU3qY&\u001c\u0017m]\u0001\u0018GJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIM\nqc\u0019:fCR,'I]8lKJ\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0002/QD'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7oQ8oM&<G\u0003BB4\u0007k\u0002Ba!\u001b\u0004r9!11NB7!\r\tyA\\\u0005\u0004\u0007_r\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002J\rM$bAB8]\"91q\u000f-A\u0002\u0005u\u0017!G:i_VdG\r\u00165s_R$H.Z!mYJ+\u0007\u000f\\5dCN\fa!\u0019<SCR,GCBB?\u0007\u0007\u001bi\tE\u0002n\u0007\u007fJ1a!!o\u0005\u0019!u.\u001e2mK\"91QQ-A\u0002\r\u001d\u0015a\u0004:fa2L7-\u0019;j_:$\u0016\u0010]3\u0011\u0007\u0011\u001cI)C\u0002\u0004\fv\u0013\u0011\"U;pi\u0006$\u0016\u0010]3\t\u000f\u0005\u0015\u0011\f1\u0001\u0004R\u0005aQ.Z1tkJ,GMU1uKR11QPBJ\u0007/Cqa!&[\u0001\u0004\t\t#\u0001\u0004ce>\\WM\u001d\u0005\b\u00073S\u0006\u0019ABD\u0003\u001d\u0011X\r\u001d+za\u0016\f1d]3u\u0003:$WK\\:fi\u0012Kh.Y7jGRC'o\u001c;uY\u0016\u001cH\u0003CA\u0016\u0007?\u001b\tk!*\t\u000f\u0005\u00151\f1\u0001\u0004R!111U.A\u00021\f1c\u001d;bi&\u001cG\u000b\u001b:piRdWMQ=uKNDaaa*\\\u0001\u0004a\u0017\u0001\u00063z]\u0006l\u0017n\u0019+ie>$H\u000f\\3CsR,7\u000f")
public class ReplicationQuotasTest
extends QuorumTestHarness {
    private volatile ReplicationQuotasTest$ReplicationResults$ ReplicationResults$module;
    private volatile ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings$module;
    private final byte[] msg100KB = new byte[100000];
    private Seq<KafkaServer> brokers = Nil$.MODULE$;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer = null;

    public ReplicationQuotasTest$ReplicationResults$ ReplicationResults() {
        if (this.ReplicationResults$module == null) {
            this.ReplicationResults$lzycompute$1();
        }
        return this.ReplicationResults$module;
    }

    public ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings() {
        if (this.ReplicationTestSettings$module == null) {
            this.ReplicationTestSettings$lzycompute$1();
        }
        return this.ReplicationTestSettings$module;
    }

    public long percentError(int percent, long value) {
        return Math.round((double)(value * (long)percent) / 100.0);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply(this.producer()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers(this.brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), true);
    }

    public void shouldMatchQuota(Function1<ReplicationTestSettings, ReplicationResults> replicationTest, boolean testLeaderThrottle) {
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        long throttle = msgCount * msg.length / expectedDuration;
        if (!testLeaderThrottle) {
            throttle *= 3L;
        }
        ReplicationResults replicationResults = (ReplicationResults)replicationTest.apply((Object)new ReplicationTestSettings(this, throttle, msgCount, msg, testLeaderThrottle));
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)replicationResults.unthrottledTime() < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.unthrottledTime()).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)replicationResults.throttledTime() > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((replicationResults.throttledTime() < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle * 1.1;
        double rateLowerBound = (double)throttle * 0.5;
        double rate = testLeaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public ReplicationResults replicateWithStaticThrottledReplicas(ReplicationTestSettings settings) {
        Range.Inclusive initialBrokers = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105);
        this.createBrokers((Seq<Object>)initialBrokers, settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{108}))), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        this.setAndUnsetDynamicThrottles((Seq<Object>)initialBrokers, settings.throttleBytes(), 100L);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{108, 109})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithStaticThrottledReplicas$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 108);
        long start = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(109), 109), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            void var5_6;
            void var4_5;
            String string;
            ReplicationQuotaManager replicationQuotaManager;
            KafkaServer broker = this.brokerFor(brokerId);
            if (settings.throttleLeader()) {
                replicationQuotaManager = broker.quotaManagers().leader();
                string = "leader";
            } else {
                replicationQuotaManager = broker.quotaManagers().follower();
                string = "follower";
            }
            String string2 = string;
            ReplicationQuotaManager quotaManager = replicationQuotaManager;
            String quotaName = string2;
            void quotaManager2 = var4_5;
            void quotaName2 = var5_6;
            Assertions.assertTrue((boolean)quotaManager2.isThrottled(this.tp(0)), (String)new StringBuilder(33).append("Expected all ").append((String)quotaName2).append(" replicas on broker ").append(brokerId).toString());
        });
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 109);
        long unthrottledTime = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTime = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTime, throttledTime);
    }

    public ReplicationResults replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology(ReplicationTestSettings settings) {
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        if (settings.throttleLeader()) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 100);
        this.waitForOffsetsToMatch(settings.msgCount(), 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertEquals((long)settings.throttleBytes(), (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!settings.throttleLeader()) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTook, throttledTook);
    }

    @Test
    public void shouldThrottleOldSegments() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("log.segment.bytes", Integer.toString(0x100000));
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle)));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new broker");
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerIsThrottledOnStartup() {
        this.verifyFollowerIsThrottledOnStartup(false);
    }

    @Test
    public void testFollowerIsThrottledOnStartupWithClusterLinking() {
        this.verifyFollowerIsThrottledOnStartup(true);
    }

    public void verifyFollowerIsThrottledOnStartup(boolean clusterLinkEnable) {
        byte[] msg = this.msg100KB();
        int msgCount = 20;
        int expectedDuration = 4;
        int multiplier = clusterLinkEnable ? 4 : 2;
        long throttle = msg.length * msgCount / (multiplier * expectedDuration);
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)None$.MODULE$, clusterLinkEnable), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.addData(msgCount, msg);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(101, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable), Seq$.MODULE$.canBuildFrom())));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottling() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(false);
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottlingWithClusterLinking() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(boolean clusterLinkEnable) {
        long throttle = 131072L;
        KafkaServer throttledBroker = this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable);
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)throttledBroker, (List)Nil$.MODULE$));
        AtomicReference<None$> lastUpdatedThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        AtomicReference<None$> lastUpdatedClusterLinkThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> throttledBroker.dynamicConfigManager().shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        throttledBroker.dynamicConfigHandlers_$eq(throttledBroker.dynamicConfigHandlers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2((Object)ConfigType$.MODULE$.Broker(), (Object)new BrokerConfigHandler(null, throttledBroker, lastUpdatedThrottleOptRef, lastUpdatedClusterLinkThrottleOptRef){
            private final AtomicReference lastUpdatedThrottleOptRef$1;
            private final AtomicReference lastUpdatedClusterLinkThrottleOptRef$1;

            public void processConfigChanges(String brokerId, Properties properties) {
                super.processConfigChanges(brokerId, properties);
                this.lastUpdatedThrottleOptRef$1.set(this.quotaManagers().follower().lastSignalledQuotaOptRef().get());
                this.lastUpdatedClusterLinkThrottleOptRef$1.set(this.quotaManagers().clusterLink().lastSignalledQuotaOptRef().get());
            }
            {
                this.lastUpdatedThrottleOptRef$1 = lastUpdatedThrottleOptRef$1;
                this.lastUpdatedClusterLinkThrottleOptRef$1 = lastUpdatedClusterLinkThrottleOptRef$1;
                super(throttledBroker$1.config(), throttledBroker$1.quotaManagers());
            }
        }), (List)Nil$.MODULE$).toMap(Predef$.MODULE$.$conforms())));
        throttledBroker.dynamicConfigManager_$eq(new ZkConfigManager(throttledBroker.zkClient(), throttledBroker.dynamicConfigHandlers()));
        throttledBroker.dynamicConfigManager().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(throttledBroker, throttle)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        lastUpdatedThrottleOptRef.set(None$.MODULE$);
        lastUpdatedClusterLinkThrottleOptRef.set(None$.MODULE$);
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(throttle + 1L)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"*"), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"1000"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Object)"1001"), new Tuple2((Object)KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), (Object)"1002")})));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(lastUpdatedThrottleOptRef)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedThrottleOptRef.get()).get()));
        if (clusterLinkEnable) {
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(lastUpdatedClusterLinkThrottleOptRef)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedClusterLinkThrottleOptRef.get()).get()));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public KafkaServer createBrokerWithDiskUsageBasedThrottlingMaybe(int brokerId, Option<Object> throttleOpt, boolean clusterLinkEnable) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("log.segment.bytes", Integer.toString(0x100000));
        config.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(clusterLinkEnable));
        throttleOpt.foreach((Function1 & Serializable & scala.Serializable)throttle -> ReplicationQuotasTest.$anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(config, BoxesRunTime.unboxToLong((Object)throttle)));
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable & scala.Serializable)x$5 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> (RecordMetadata)x$6.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$8)))).head();
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    public void createBrokers(Seq<Object> brokerIds, long throttle, boolean throttleAllBrokerLeaderReplicas, boolean throttleAllBrokerFollowerReplicas) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> {
            Properties props = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerLeaderReplicas));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerFollowerReplicas));
            this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().leader().upperBound());
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().follower().upperBound());
        });
    }

    public boolean createBrokers$default$3() {
        return false;
    }

    public boolean createBrokers$default$4() {
        return false;
    }

    public String throttledReplicasConfig(boolean shouldThrottleAllReplicas) {
        if (shouldThrottleAllReplicas) {
            return ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue();
        }
        return ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue();
    }

    private double avRate(QuotaType replicationType, Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)brokers.map((Function1 & Serializable & scala.Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$9, replicationType)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setAndUnsetDynamicThrottles(Seq<Object> brokers, long staticThrottleBytes, long dynamicThrottleBytes) {
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes))}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)brokerId -> dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$setAndUnsetDynamicThrottles$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Nil$.MODULE$)));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)brokerId -> staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$setAndUnsetDynamicThrottles$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void ReplicationResults$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationResults$module == null) {
                this.ReplicationResults$module = new ReplicationQuotasTest$ReplicationResults$(this);
            }
            return;
        }
    }

    private final void ReplicationTestSettings$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationTestSettings$module == null) {
                this.ReplicationTestSettings$module = new ReplicationQuotasTest$ReplicationTestSettings$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$replicateWithStaticThrottledReplicas$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$1.msg()));
    }

    public static final /* synthetic */ Future $anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$2, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$2.msg()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(KafkaServer throttledBroker$1, long throttle$1) {
        return BoxesRunTime.unboxToLong((Object)((Option)throttledBroker$1.quotaManagers().follower().lastSignalledQuotaOptRef().get()).get()) == throttle$1;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$3() {
        return "Follower throttle couldn't be applied within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(AtomicReference lastUpdatedThrottleOptRef$1) {
        return ((Option)lastUpdatedThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5() {
        return new StringBuilder(41).append("updateReplicationConfig() incomplete for ").append(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(AtomicReference lastUpdatedClusterLinkThrottleOptRef$1) {
        return ((Option)lastUpdatedClusterLinkThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$7() {
        return "Cluster link throttle not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().leader().upperBound() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$9() {
        return "Leader replication not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().alterLogDirs().upperBound() == 1001L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$11() {
        return "alterLogDirs not updated";
    }

    public static final /* synthetic */ Object $anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(Properties config$1, long throttle) {
        config$1.setProperty(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "16384");
        config$1.setProperty("confluent.backpressure.disk.enable", Boolean.toString(true));
        config$1.setProperty("confluent.backpressure.disk.produce.bytes.per.second", Long.toString(throttle));
        return config$1.setProperty("confluent.backpressure.disk.free.threshold.bytes", Long.toString(Long.MAX_VALUE));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$1, int x$5) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$1));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$8) {
        return x$8.config().brokerId() == id$1;
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$4() {
        return "Dynamically set throttles weren't as expected";
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$8() {
        return "Throttles weren't reverted to the statically set ones as expected";
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }

    public class ReplicationResults
    implements Product,
    scala.Serializable {
        private final long unthrottledTime;
        private final long throttledTime;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public long unthrottledTime() {
            return this.unthrottledTime;
        }

        public long throttledTime() {
            return this.throttledTime;
        }

        public ReplicationResults copy(long unthrottledTime, long throttledTime) {
            return new ReplicationResults(this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer(), unthrottledTime, throttledTime);
        }

        public long copy$default$1() {
            return this.unthrottledTime();
        }

        public long copy$default$2() {
            return this.throttledTime();
        }

        public String productPrefix() {
            return "ReplicationResults";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.unthrottledTime());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.throttledTime());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationResults;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.unthrottledTime())), (int)Statics.longHash((long)this.throttledTime())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof ReplicationResults && ((ReplicationResults)x$1).kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer();
                    if (!bl) break block3;
                    ReplicationResults replicationResults = (ReplicationResults)x$1;
                    if (!(this.unthrottledTime() == replicationResults.unthrottledTime() && this.throttledTime() == replicationResults.throttledTime() && replicationResults.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() {
            return this.$outer;
        }

        public ReplicationResults(ReplicationQuotasTest $outer, long unthrottledTime, long throttledTime) {
            this.unthrottledTime = unthrottledTime;
            this.throttledTime = throttledTime;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReplicationTestSettings
    implements Product,
    scala.Serializable {
        private final long throttleBytes;
        private final int msgCount;
        private final byte[] msg;
        private final boolean throttleLeader;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public long throttleBytes() {
            return this.throttleBytes;
        }

        public int msgCount() {
            return this.msgCount;
        }

        public byte[] msg() {
            return this.msg;
        }

        public boolean throttleLeader() {
            return this.throttleLeader;
        }

        public ReplicationTestSettings copy(long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            return new ReplicationTestSettings(this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer(), throttleBytes, msgCount, msg, throttleLeader);
        }

        public long copy$default$1() {
            return this.throttleBytes();
        }

        public int copy$default$2() {
            return this.msgCount();
        }

        public byte[] copy$default$3() {
            return this.msg();
        }

        public boolean copy$default$4() {
            return this.throttleLeader();
        }

        public String productPrefix() {
            return "ReplicationTestSettings";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.throttleBytes());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.msgCount());
                }
                case 2: {
                    return this.msg();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.throttleLeader());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationTestSettings;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.throttleBytes())), (int)this.msgCount()), (int)Statics.anyHash((Object)this.msg())), (int)(this.throttleLeader() ? 1231 : 1237)), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof ReplicationTestSettings && ((ReplicationTestSettings)x$1).kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer();
                    if (!bl) break block3;
                    ReplicationTestSettings replicationTestSettings = (ReplicationTestSettings)x$1;
                    if (!(this.throttleBytes() == replicationTestSettings.throttleBytes() && this.msgCount() == replicationTestSettings.msgCount() && this.msg() == replicationTestSettings.msg() && this.throttleLeader() == replicationTestSettings.throttleLeader() && replicationTestSettings.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() {
            return this.$outer;
        }

        public ReplicationTestSettings(ReplicationQuotasTest $outer, long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            this.throttleBytes = throttleBytes;
            this.msgCount = msgCount;
            this.msg = msg;
            this.throttleLeader = throttleLeader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

