/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.cluster.Partition;
import kafka.common.EvenClusterLoadPlanBrokerStats;
import kafka.common.EvenClusterLoadPlanDetailedClusterBalanceStats;
import kafka.common.EvenClusterLoadPlanGoalOverview;
import kafka.common.EvenClusterLoadPlanGoalStats;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadPlanInternalBrokerRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalClusterRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalGoalRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalReplicaMovementStats;
import kafka.common.EvenClusterLoadPlanRejectingGoal;
import kafka.common.EvenClusterLoadPlanResources;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.RequestHandlerHelper$;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator$;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u0011\u00199\u0005\u0001)A\u0005\u0003\"9\u0001\n\u0001b\u0001\n\u0003I\u0005B\u0002+\u0001A\u0003%!\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r\u0001\u0004\u0001\u0015!\u0003X\u0011\u001d\t\u0007A1A\u0005\u0002\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0007[\u0002\u0001\u000b\u0011\u00027\t\u000f9\u0004!\u0019!C\u0001_\"1q\u000f\u0001Q\u0001\nADq\u0001\u001f\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002>\t\u0011\u0005\r\u0001A1A\u0005\u0002eDq!!\u0002\u0001A\u0003%!\u0010\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001z\u0011\u001d\tI\u0001\u0001Q\u0001\niDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u00020\u0001!\t!!\u0004\t\u000f\u0005e\u0002\u0001\"\u0001\u0002\u000e!9\u0011Q\b\u0001\u0005\u0002\u00055\u0001bBA!\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u000b\u0002A\u0011AA\u0007\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u001bAq!!\u0014\u0001\t\u0003\ti\u0001C\u0004\u0002R\u0001!\t!!\u0004\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011Q\u000b\u0001\u0005\n\u0005%\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u0003\u000f\u0004A\u0011BAe\u0005a\u0011V-];fgRD\u0015M\u001c3mKJDU\r\u001c9feR+7\u000f\u001e\u0006\u0003K\u0019\naa]3sm\u0016\u0014(\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0004CA\u001a\u0001\u001b\u0005!\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u00159'o\\;q\u0015\tYd%A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018BA\u001f9\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/A\the>,\boQ8pe\u0012Lg.\u0019;pe\u0002\na\u0002\u001e=o\u0007>|'\u000fZ5oCR|'/F\u0001B!\t\u0011U)D\u0001D\u0015\t!%(A\u0006ue\u0006t7/Y2uS>t\u0017B\u0001$D\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\u0018a\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0002\u0015B\u00111*\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0012\nA\u0001\\5oW&\u0011\u0001+T\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002S'\nYA*\u001b8l\u001b\u0006t\u0017mZ3s\u0015\t\u0001V*A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%A\u0012uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014x\n\u001d;\u0016\u0003]\u00032a\u000b-[\u0013\tIFF\u0001\u0004PaRLwN\u001c\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\nA\u0001^5fe&\u0011q\f\u0018\u0002!)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'/\u0001\u0013uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014x\n\u001d;!\u0003\u001d\u0012\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a/\u0002+\t\f7m[;q_\nTWm\u0019;mS\u001a,7-_2mK&\u0011\u0001.\u001a\u0002(\u0005\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0007>|'\u000fZ5oCR|'/\u0001\u0015cC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0016cC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014x\n\u001d;\u0016\u00031\u00042a\u000b-d\u0003-\u0012\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:PaR\u0004\u0013aE9v_R\f7i\\8sI&t\u0017\r^8s\u001fB$X#\u00019\u0011\u0007-B\u0016\u000f\u0005\u0002sk6\t1O\u0003\u0002uu\u0005)\u0011/^8uC&\u0011ao\u001d\u0002\u0011#V|G/Y\"p_J$\u0017N\\1u_J\fA#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:PaR\u0004\u0013a\u00039beRLG/[8o?F*\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{\u001a\nqa\u00197vgR,'/\u0003\u0002\u0000y\nI\u0001+\u0019:uSRLwN\\\u0001\ra\u0006\u0014H/\u001b;j_:|\u0016\u0007I\u0001\fa\u0006\u0014H/\u001b;j_:|&'\u0001\u0007qCJ$\u0018\u000e^5p]~\u0013\u0004%A\u0006qCJ$\u0018\u000e^5p]~\u001b\u0014\u0001\u00049beRLG/[8o?N\u0002\u0013!B:fiV\u0004HCAA\b!\rY\u0013\u0011C\u0005\u0004\u0003'a#\u0001B+oSRD3AFA\f!\u0011\tI\"a\u000b\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t1!\u00199j\u0015\u0011\t\t#a\t\u0002\u000f),\b/\u001b;fe*!\u0011QEA\u0014\u0003\u0015QWO\\5u\u0015\t\tI#A\u0002pe\u001eLA!!\f\u0002\u001c\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0003R,7\u000f\u001e\"bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.Z'b]\u0006<WM]*uCJ$8o\u00165f]\n\u0013xn[3s\u0003N\u001cX/\\3t\u0019\u0016\fG-\u001a:tQ&\u0004\bfA\f\u00024A!\u0011\u0011DA\u001b\u0013\u0011\t9$a\u0007\u0003\tQ+7\u000f^\u0001?i\u0016\u001cHOQ1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'o\u0015;paN<\u0006.\u001a8Ce>\\WM\u001d\"fG>lWm\u001d$pY2|w/\u001a:)\u0007a\t\u0019$A\u001duKN$h+\u00197jI\u0006$X-\u00117uKJ,\u0005p\u00197vg&|gNU3rk\u0016\u001cH\u000f\u00165s_^\u001c\u0018JZ%om\u0006d\u0017\u000e\u001a\"s_.,'/\u00133tQ\rI\u00121G\u0001>i\u0016\u001cHOV1mS\u0012\fG/Z!mi\u0016\u0014X\t_2mkNLwN\u001c*fcV,7\u000f\u001e+ie><8/\u00134J]Z\fG.\u001b3Fq\u000edWo]5p]RK\b/\u001a\u0015\u00045\u0005M\u0012A\u000e;fgR4\u0016\r\\5eCR,\u0017\t\u001c;fe\u0016C8\r\\;tS>t'+Z9vKN$H\u000b\u001b:poNLe-\u00138wC2LGMU3bg>t\u0007fA\u000e\u00024\u0005YC/Z:u-\u0006d\u0017\u000eZ1uKJ+Wn\u001c<bYJ+\u0017/^3tiRC'o\\<t\u0013\u001atuN\u0011:pW\u0016\u00148\u000fK\u0002\u001d\u0003g\t\u0001\b^3tiZ\u000bG.\u001b3bi\u0016\u0014V-\\8wC2\u0014V-];fgR$\u0006N]8xg&3WK\u001c:faJ,7/\u001a8uC\ndWM\u0011:pW\u0016\u00148\u000fK\u0002\u001e\u0003g\tA\u0007^3ti\u000e{gN^3si\u00163XM\\\"mkN$XM\u001d'pC\u0012\u0004F.\u00198J]R,'O\\1m)>\u0014Vm\u001d9p]N,G)\u0019;bQ\rq\u00121G\u0001&I>\u0014%o\\6feN#\u0018\r^:FcV\fGNU3ta>t7/\u001a\"s_.,'o\u0015;biN$b!a\u0004\u0002Z\u0005%\u0004bBA.?\u0001\u0007\u0011QL\u0001\u0003EN\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G2\u0013AB2p[6|g.\u0003\u0003\u0002h\u0005\u0005$AH#wK:\u001cE.^:uKJdu.\u00193QY\u0006t'I]8lKJ\u001cF/\u0019;t\u0011\u001d\tYg\ba\u0001\u0003[\n1A\u001d2t!\u0011\ty'a!\u000f\t\u0005E\u0014qP\u0007\u0003\u0003gRA!!\u001e\u0002x\u00059Q.Z:tC\u001e,'\u0002BA2\u0003sR1aJA>\u0015\u0011\ti(a\n\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t)a\u001d\u0002M\r{W\u000e];uK\u00163XM\\\"mkN$XM\u001d'pC\u0012\u0004F.\u00198SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002\u0006\u0006\u001d%!\u0004)sK\n\u0013xn[3s'R\fGO\u0003\u0003\u0002\u0002\u0006MDCBA\b\u0003\u0017\u000bi\tC\u0004\u0002\\\u0001\u0002\r!!\u0018\t\u000f\u0005-\u0004\u00051\u0001\u0002\u0010B!\u0011qNAI\u0013\u0011\t\u0019*a\"\u0003\u001dA{7\u000f\u001e\"s_.,'o\u0015;bi\u0006\u0001\u0014\r\u001c;fe\n\u0013xn[3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c(+Z9vKN$x+\u001b;i\u0005J|7.\u001a:JIN$B!!'\u0002&B!\u00111TAQ\u001b\t\tiJ\u0003\u0003\u0002 \u0006]\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005\r\u0016Q\u0014\u0002$\u00032$XM\u001d\"s_.,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d\t9+\ta\u0001\u0003S\u000b\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\r\u0005-\u00161XAa\u001d\u0011\ti+a.\u000f\t\u0005=\u0016QW\u0007\u0003\u0003cS1!a-)\u0003\u0019a$o\\8u}%\tQ&C\u0002\u0002:2\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0006}&\u0001\u0002'jgRT1!!/-!\rY\u00131Y\u0005\u0004\u0003\u000bd#aA%oi\u0006\u0019\u0013\r\u001c;fe\n\u0013xn[3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c(+Z9vKN$H\u0003BAM\u0003\u0017Dq!!4#\u0001\u0004\ty-A\u0006fq\u000edWo]5p]>\u0003\bCBAV\u0003w\u000b\t\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\u0011\t\u0019'a6\u000b\u0007\u0015\nI(\u0003\u0003\u0002\\\u0006U'aF!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\(q\u0001")
public class RequestHandlerHelperTest {
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private final ClusterLinkFactory.LinkManager clusterLinkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
    private final Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt = new Some(Mockito.mock(TierDeletedPartitionsCoordinator.class));
    private final BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator = (BackupObjectLifecycleManagerCoordinator)Mockito.mock(BackupObjectLifecycleManagerCoordinator.class);
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt = new Some((Object)this.backupObjectLifecycleManagerCoordinator());
    private final Option<QuotaCoordinator> quotaCoordinatorOpt = new Some(Mockito.mock(QuotaCoordinator.class));
    private final Partition partition_1 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_2 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_3 = (Partition)Mockito.mock(Partition.class);

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt() {
        return this.tierDeletedPartitionsCoordinatorOpt;
    }

    public BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator() {
        return this.backupObjectLifecycleManagerCoordinator;
    }

    public Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt() {
        return this.backupObjectLifecycleManagerCoordinatorOpt;
    }

    public Option<QuotaCoordinator> quotaCoordinatorOpt() {
        return this.quotaCoordinatorOpt;
    }

    public Partition partition_1() {
        return this.partition_1;
    }

    public Partition partition_2() {
        return this.partition_2;
    }

    public Partition partition_3() {
        return this.partition_3;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.partition_1().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_2().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_3().topic()).thenReturn((Object)"blah");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_1().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_2().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1)));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_3().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 2)));
    }

    @Test
    public void testBackupObjectLifecycleManagerStartsWhenBrokerAssumesLeadership() {
        .colon.colon updatedLeaders = new .colon.colon((Object)this.partition_1(), (List)Nil$.MODULE$);
        .colon.colon updatedFollowers = new .colon.colon((Object)this.partition_2(), (List)new .colon.colon((Object)this.partition_3(), (List)Nil$.MODULE$));
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_1().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onResignation(this.partition_3().partitionId());
    }

    @Test
    public void testBackupObjectLifecycleManagerStopsWhenBrokerBecomesFollower() {
        .colon.colon updatedLeaders = new .colon.colon((Object)this.partition_2(), (List)new .colon.colon((Object)this.partition_3(), (List)Nil$.MODULE$));
        .colon.colon updatedFollowers = new .colon.colon((Object)this.partition_1(), (List)Nil$.MODULE$);
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onElection(this.partition_3().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_1().partitionId());
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidBrokerIds() {
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest emptyReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)List$.MODULE$.empty());
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(emptyReq);
        });
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> {
            AlterBrokerReplicaExclusionsRequest unrepresentableBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, -100})));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(unrepresentableBrokersReq);
        });
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest duplicateBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 1})));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(duplicateBrokersReq);
        });
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidExclusionType() {
        ListBuffer exclusionOps = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.SET));
        AlterBrokerReplicaExclusionsRequest validRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(validRequest);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.UNKNOWN));
        AlterBrokerReplicaExclusionsRequest invalidRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(invalidRequest));
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidReason() {
        String chars1028Reason = String.join((CharSequence)"", Collections.nCopies(257, "Test"));
        new .colon.colon((Object)".", (List)new .colon.colon((Object)chars1028Reason, (List)new .colon.colon((Object)"\\", (List)Nil$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)invalidReason -> {
            AlterReplicaExclusionOp op = new AlterReplicaExclusionOp(1, invalidReason, ExclusionOp.OpType.SET);
            return (InvalidBrokerReplicaExclusionException)Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)new .colon.colon((Object)op, (List)Nil$.MODULE$))));
        });
    }

    @Test
    public void testValidateRemovalRequestThrowsIfNoBrokers() {
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.emptySet(), true).build((short)1);
        Assertions.assertThrows(InvalidBrokerRemovalException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    @Test
    public void testValidateRemovalRequestThrowsIfUnrepresentableBrokers() {
        RemoveBrokersRequestData.BrokerId brokerId = new RemoveBrokersRequestData.BrokerId().setBrokerId(-1);
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.singleton(brokerId), true).build((short)1);
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    @Test
    public void testConvertEvenClusterLoadPlanInternalToResponseData() {
        int interBrokerMoves = 15;
        double interBrokerMovesMB = 35.4;
        int leadershipMoves = 2;
        .colon.colon brokersExcludedForLeadership = new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$));
        .colon.colon brokersExcludedForReplicaMove = new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)Nil$.MODULE$));
        .colon.colon newBrokers = new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(6), (List)Nil$.MODULE$));
        .colon.colon deadOrRemovedBrokers = new .colon.colon((Object)Predef$.MODULE$.int2Integer(7), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(8), (List)Nil$.MODULE$));
        int recentWindows = 1;
        double partitionCoveragePercent = 80.5;
        .colon.colon excludedTopics = new .colon.colon((Object)"topic1", (List)Nil$.MODULE$);
        int totalBrokers = 10;
        int totalReplicas = 200;
        int totalTopics = 15;
        double balancednessScoreBefore = 95.1;
        double balancednessScoreAfter = 99.9;
        EvenClusterLoadPlanBrokerStats broker0PreBalance = new EvenClusterLoadPlanBrokerStats(0, "host0", 100.0, 100.0, 50.0, 10000.0, 10000.0, 20000.0, 30000.0, 10, 30);
        EvenClusterLoadPlanBrokerStats broker1PreBalance = new EvenClusterLoadPlanBrokerStats(1, "host1", 101.0, 101.0, 51.0, 10001.0, 10001.0, 20001.0, 30001.0, 11, 31);
        EvenClusterLoadPlanBrokerStats broker0PostBalance = new EvenClusterLoadPlanBrokerStats(0, "host0", 102.0, 102.0, 52.0, 10002.0, 10002.0, 20002.0, 30002.0, 12, 32);
        EvenClusterLoadPlanBrokerStats broker1PostBalance = new EvenClusterLoadPlanBrokerStats(1, "host1", 103.0, 103.0, 53.0, 10003.0, 10003.0, 20003.0, 30003.0, 13, 33);
        .colon.colon clusterLoadPreBalance = new .colon.colon((Object)broker0PreBalance, (List)new .colon.colon((Object)broker1PreBalance, (List)Nil$.MODULE$));
        .colon.colon clusterLoadPostBalance = new .colon.colon((Object)broker0PostBalance, (List)new .colon.colon((Object)broker1PostBalance, (List)Nil$.MODULE$));
        String replicaDistributionGoalName = "ReplicaDistributionGoal";
        String diskCapacityGoalName = "DiskCapacityGoal";
        String networkInboundCapacityGoalName = "NetworkInboundCapacityGoal";
        .colon.colon movementGeneratingGoal = new .colon.colon((Object)replicaDistributionGoalName, (List)Nil$.MODULE$);
        EvenClusterLoadPlanRejectingGoal replicaRejectionGoalDisk = new EvenClusterLoadPlanRejectingGoal(diskCapacityGoalName, 100);
        EvenClusterLoadPlanRejectingGoal replicaRejectionGoalNetworkIn = new EvenClusterLoadPlanRejectingGoal(networkInboundCapacityGoalName, 20);
        .colon.colon replicaGoalOverviewRejectingGoals = new .colon.colon((Object)replicaRejectionGoalDisk, (List)new .colon.colon((Object)replicaRejectionGoalNetworkIn, (List)Nil$.MODULE$));
        String replicaGoalStatus = "FIXED";
        int replicaProposalsGen = 200;
        int replicaProposalsRej = 50;
        int replicaProposalsRejPerc = 25;
        int replicaProposalsAcc = 2;
        boolean replicaPropoalsAccPerc = true;
        int replicaPropoalsMoves = 10;
        int replicaPropoalsSwaps = 12;
        EvenClusterLoadPlanGoalOverview replicaGoalOverview = new EvenClusterLoadPlanGoalOverview(replicaGoalStatus, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaGoalOverviewRejectingGoals).asJava(), replicaProposalsGen, replicaProposalsRej, (double)replicaProposalsRejPerc, replicaProposalsAcc, (double)replicaPropoalsAccPerc, replicaPropoalsMoves, replicaPropoalsSwaps);
        EvenClusterLoadPlanResources clusterResources = new EvenClusterLoadPlanResources(1.0, 2.0, 3.0, 4.0, 5.0, 6, 7, 8);
        EvenClusterLoadPlanGoalStats replicaGoalStats = new EvenClusterLoadPlanGoalStats(replicaDistributionGoalName, clusterResources, clusterResources, clusterResources, clusterResources, replicaGoalOverview);
        .colon.colon goalStats = new .colon.colon((Object)replicaGoalStats, (List)Nil$.MODULE$);
        .colon.colon violatedGoalsBeforeOptimization = new .colon.colon((Object)replicaDistributionGoalName, (List)new .colon.colon((Object)diskCapacityGoalName, (List)new .colon.colon((Object)networkInboundCapacityGoalName, (List)Nil$.MODULE$)));
        .colon.colon violatedGoalsAfterOptimization = new .colon.colon((Object)diskCapacityGoalName, (List)Nil$.MODULE$);
        EvenClusterLoadPlanInternal plan = new EvenClusterLoadPlanInternal(new EvenClusterLoadPlanInternalReplicaMovementStats(interBrokerMoves, interBrokerMovesMB, leadershipMoves), new EvenClusterLoadPlanInternalBrokerRelatedStats((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokersExcludedForLeadership).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokersExcludedForReplicaMove).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newBrokers).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deadOrRemovedBrokers).asJava()), new EvenClusterLoadPlanInternalClusterRelatedStats(recentWindows, partitionCoveragePercent, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)excludedTopics).asJava(), totalBrokers, totalReplicas, totalTopics), new EvenClusterLoadPlanDetailedClusterBalanceStats(balancednessScoreBefore, balancednessScoreAfter, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)clusterLoadPreBalance).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)clusterLoadPostBalance).asJava()), new EvenClusterLoadPlanInternalGoalRelatedStats((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)movementGeneratingGoal).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)goalStats).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)violatedGoalsBeforeOptimization).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)violatedGoalsAfterOptimization).asJava()));
        ComputeEvenClusterLoadPlanResponseData responseData = RequestHandlerHelper$.MODULE$.convertEvenClusterLoadPlanInternalToResponseData(plan);
        Assertions.assertEquals((int)interBrokerMoves, (int)responseData.interBrokerMoves());
        Assertions.assertEquals((double)interBrokerMovesMB, (double)responseData.interBrokerMovesMB());
        Assertions.assertEquals((int)leadershipMoves, (int)responseData.leadershipMoves());
        Assertions.assertEquals((Object)brokersExcludedForLeadership, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.brokersExcludedForLeadership()).asScala());
        Assertions.assertEquals((Object)brokersExcludedForReplicaMove, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.brokersExcludedForReplicaMove()).asScala());
        Assertions.assertEquals((Object)newBrokers, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.newBrokers()).asScala());
        Assertions.assertEquals((Object)deadOrRemovedBrokers, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.deadOrRemovedBrokers()).asScala());
        Assertions.assertEquals((int)recentWindows, (int)responseData.recentWindows());
        Assertions.assertEquals((double)partitionCoveragePercent, (double)responseData.partitionCoveragePercent());
        Assertions.assertEquals((Object)newBrokers, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.newBrokers()).asScala());
        Assertions.assertEquals((Object)deadOrRemovedBrokers, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.deadOrRemovedBrokers()).asScala());
        Assertions.assertEquals((Object)excludedTopics, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(responseData.excludedTopics()).asScala());
        Assertions.assertEquals((int)totalBrokers, (int)responseData.totalBrokers());
        Assertions.assertEquals((int)totalReplicas, (int)responseData.totalReplicas());
        Assertions.assertEquals((int)totalTopics, (int)responseData.totalTopics());
        Assertions.assertEquals((double)balancednessScoreBefore, (double)responseData.balancednessScorePreRebalance());
        Assertions.assertEquals((double)balancednessScoreAfter, (double)responseData.balancednessScorePostRebalance());
        Assertions.assertEquals((int)2, (int)clusterLoadPreBalance.size());
        Assertions.assertEquals((int)2, (int)clusterLoadPostBalance.size());
        this.doBrokerStatsEqualResponseBrokerStats(broker0PreBalance, (ComputeEvenClusterLoadPlanResponseData.PreBrokerStat)responseData.clusterLoadPreRebalance().get(0));
        this.doBrokerStatsEqualResponseBrokerStats(broker1PreBalance, (ComputeEvenClusterLoadPlanResponseData.PreBrokerStat)responseData.clusterLoadPreRebalance().get(1));
        this.doBrokerStatsEqualResponseBrokerStats(broker0PostBalance, (ComputeEvenClusterLoadPlanResponseData.PostBrokerStat)responseData.clusterLoadPostRebalance().get(0));
        this.doBrokerStatsEqualResponseBrokerStats(broker1PostBalance, (ComputeEvenClusterLoadPlanResponseData.PostBrokerStat)responseData.clusterLoadPostRebalance().get(1));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)movementGeneratingGoal).asJava(), (Object)responseData.movementGeneratingGoals());
        Assertions.assertEquals((int)1, (int)responseData.goalStats().size());
        Assertions.assertEquals((Object)replicaDistributionGoalName, (Object)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalName());
        Assertions.assertEquals((int)clusterResources.replicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().replicas());
        Assertions.assertEquals((double)clusterResources.cpuPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().cpuPercent());
        Assertions.assertEquals((double)clusterResources.diskMB(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().diskMB());
        Assertions.assertEquals((double)clusterResources.networkOutboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().networkOutboundKBps());
        Assertions.assertEquals((double)clusterResources.networkInboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().networkInboundKBps());
        Assertions.assertEquals((double)clusterResources.potentialNwOutKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().potentialNwOutKBps());
        Assertions.assertEquals((int)clusterResources.leaderReplicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().leaderReplicas());
        Assertions.assertEquals((int)clusterResources.topicReplicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().topicReplicas());
        Assertions.assertEquals((Object)replicaGoalOverview.goalStatus(), (Object)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().goalStatus());
        Assertions.assertEquals((int)2, (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().size());
        Assertions.assertEquals((Object)((EvenClusterLoadPlanRejectingGoal)replicaGoalOverview.rejectingGoals().get(0)).goalName(), (Object)((ComputeEvenClusterLoadPlanResponseData.RejectingGoal)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().get(0)).goalName());
        Assertions.assertEquals((int)((EvenClusterLoadPlanRejectingGoal)replicaGoalOverview.rejectingGoals().get(0)).proposalsRejected(), (int)((ComputeEvenClusterLoadPlanResponseData.RejectingGoal)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().get(0)).proposalsRejected());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsGenerated(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsGenerated());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsRejected(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsRejected());
        Assertions.assertEquals((double)replicaGoalOverview.proposalsRejectedPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsRejectedPercent());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsAccepted(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsAccepted());
        Assertions.assertEquals((double)replicaGoalOverview.proposalsAcceptedPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsAcceptedPercent());
        Assertions.assertEquals((int)replicaGoalOverview.moves(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().moves());
        Assertions.assertEquals((int)replicaGoalOverview.swaps(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().swaps());
    }

    private void doBrokerStatsEqualResponseBrokerStats(EvenClusterLoadPlanBrokerStats bs, ComputeEvenClusterLoadPlanResponseData.PreBrokerStat rbs) {
        Assertions.assertEquals((int)bs.brokerId(), (int)rbs.brokerId());
        Assertions.assertEquals((Object)bs.host(), (Object)rbs.host());
        Assertions.assertEquals((double)bs.diskMB(), (double)rbs.diskMB());
        Assertions.assertEquals((double)bs.diskPercent(), (double)rbs.diskPercent());
        Assertions.assertEquals((double)bs.cpuPercent(), (double)rbs.cpuPercent());
        Assertions.assertEquals((double)bs.leaderNetworkInKBps(), (double)rbs.leaderNetworkInKBps());
        Assertions.assertEquals((double)bs.followerNetworkInKBps(), (double)rbs.followerNetworkInKBps());
        Assertions.assertEquals((double)bs.networkOutKBps(), (double)rbs.networkOutKBps());
        Assertions.assertEquals((double)bs.potentialNetworkOutKBps(), (double)rbs.potentialNetworkOutKBps());
        Assertions.assertEquals((int)bs.leaders(), (int)rbs.leaders());
        Assertions.assertEquals((int)bs.replicas(), (int)rbs.replicas());
    }

    private void doBrokerStatsEqualResponseBrokerStats(EvenClusterLoadPlanBrokerStats bs, ComputeEvenClusterLoadPlanResponseData.PostBrokerStat rbs) {
        Assertions.assertEquals((int)bs.brokerId(), (int)rbs.brokerId());
        Assertions.assertEquals((Object)bs.host(), (Object)rbs.host());
        Assertions.assertEquals((double)bs.diskMB(), (double)rbs.diskMB());
        Assertions.assertEquals((double)bs.diskPercent(), (double)rbs.diskPercent());
        Assertions.assertEquals((double)bs.cpuPercent(), (double)rbs.cpuPercent());
        Assertions.assertEquals((double)bs.leaderNetworkInKBps(), (double)rbs.leaderNetworkInKBps());
        Assertions.assertEquals((double)bs.followerNetworkInKBps(), (double)rbs.followerNetworkInKBps());
        Assertions.assertEquals((double)bs.networkOutKBps(), (double)rbs.networkOutKBps());
        Assertions.assertEquals((double)bs.potentialNetworkOutKBps(), (double)rbs.potentialNetworkOutKBps());
        Assertions.assertEquals((int)bs.leaders(), (int)rbs.leaders());
        Assertions.assertEquals((int)bs.replicas(), (int)rbs.replicas());
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequestWithBrokerIds(List<Object> brokerIds) {
        return this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)((List)brokerIds.map((Function1 & Serializable & scala.Serializable)x$1 -> RequestHandlerHelperTest.$anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(BoxesRunTime.unboxToInt((Object)x$1)), List$.MODULE$.canBuildFrom())));
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequest(List<AlterReplicaExclusionOp> exclusionOp2) {
        AlterBrokerReplicaExclusionsRequestData requestData = new AlterBrokerReplicaExclusionsRequestData();
        java.util.List exclusions = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)exclusionOp2.map((Function1 & Serializable & scala.Serializable)exclusionOp -> new AlterBrokerReplicaExclusionsRequestData.BrokerExclusion().setBrokerId(exclusionOp.brokerId()).setExclusionOperationCode(exclusionOp.opType().id()).setReason(exclusionOp.reason()), List$.MODULE$.canBuildFrom())).asJava();
        return new AlterBrokerReplicaExclusionsRequest(requestData.setBrokersToExclude(exclusions), ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS.latestVersion());
    }

    public static final /* synthetic */ AlterReplicaExclusionOp $anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(int x$1) {
        return new AlterReplicaExclusionOp(x$1, "reason", ExclusionOp.OpType.SET);
    }
}

