/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0005\u0001)A\u0005m!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0004O\u0001\t\u0007I\u0011\u0001\"\t\r=\u0003\u0001\u0015!\u0003D\u0011\u001d\u0001\u0006A1A\u0005\u0002ECa\u0001\u0017\u0001!\u0002\u0013\u0011\u0006bB-\u0001\u0001\u0004%\tA\u0017\u0005\bE\u0002\u0001\r\u0011\"\u0001d\u0011\u0019I\u0007\u0001)Q\u00057\")!\u000e\u0001C!W\")\u0001\u000f\u0001C!c\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"A\u00111\u001f\u0001!\n\u0013\t)\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003j\u0001!IA!\u0003\t\u000f\t-\u0004\u0001\"\u0003\u0003\n!9!Q\u000e\u0001\u0005\n\t=$AE*feZ,'o\u00155vi\u0012|wO\u001c+fgRT!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R!!\f\u0014\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003_1\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0011\nA\u0001[8tiV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\rM#(/\u001b8h\u0003\u0015Awn\u001d;!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005)1/\u001a8ucU\t1\tE\u0002E\u0017Zj\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005!K\u0015AC2pY2,7\r^5p]*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u000b\n!A*[:u\u0003\u0019\u0019XM\u001c;2A\u0005)1/\u001a8ue\u000511/\u001a8ue\u0001\n\u0001\u0004\u001d:paN$vn\u00115b]\u001e,W\u000b]8o%\u0016\u001cH/\u0019:u+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+;\u0003\u0011)H/\u001b7\n\u0005]#&A\u0003)s_B,'\u000f^5fg\u0006I\u0002O]8qgR{7\t[1oO\u0016,\u0006o\u001c8SKN$\u0018M\u001d;!\u0003-\u0001(/[8s\u0007>tg-[4\u0016\u0003m\u00032\u0001X/`\u001b\u0005I\u0015B\u00010J\u0005\u0019y\u0005\u000f^5p]B\u00111\u0007Y\u0005\u0003C\u0012\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006y\u0001O]5pe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0002eOB\u0011A,Z\u0005\u0003M&\u0013A!\u00168ji\"9\u0001.DA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005a\u0001O]5pe\u000e{gNZ5hA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001m!\rignX\u0007\u0002\u000f&\u0011qn\u0012\u0002\u0004'\u0016\f\u0018!B:fiV\u0003HC\u00013s\u0011\u0015\u0019\b\u00031\u0001u\u0003!!Xm\u001d;J]\u001a|\u0007CA;\u007f\u001b\u00051(BA<y\u0003\r\t\u0007/\u001b\u0006\u0003sj\fqA[;qSR,'O\u0003\u0002|y\u0006)!.\u001e8ji*\tQ0A\u0002pe\u001eL!a <\u0003\u0011Q+7\u000f^%oM>D3\u0001EA\u0002!\r)\u0018QA\u0005\u0004\u0003\u000f1(A\u0003\"fM>\u0014X-R1dQ\u0006\tB/Z:u\u00072,\u0017M\\*ikR$wn\u001e8\u0015\u0007\u0011\fi\u0001C\u0004\u0002\u0010E\u0001\r!!\u0005\u0002\rE,xN];n!\u0011\t\u0019\"!\t\u000f\t\u0005U\u0011Q\u0004\t\u0004\u0003/IUBAA\r\u0015\r\tY\u0002K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}\u0011*\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\u0005\r\"bAA\u0010\u0013\":\u0011#a\n\u00028\u0005e\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\taJ|g/\u001b3fe*\u0019\u0011\u0011\u0007=\u0002\rA\f'/Y7t\u0013\u0011\t)$a\u000b\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\tY$a\u0010\"\u0005\u0005u\u0012A\u0001>lC\t\t\t%A\u0003le\u00064G\u000fK\u0004\u0012\u0003\u000b\ni%a\u0014\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0003\u0003_IA!a\u0013\u00020\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003#\n\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003\r\"Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\\!gi\u0016\u0014h)Y5mK\u0012\u001cF/\u0019:ukB$2\u0001ZA,\u0011\u001d\tyA\u0005a\u0001\u0003#AsAEA\u0014\u0003o\tY\u0006\f\u0003\u0002<\u0005}\u0002f\u0002\n\u0002F\u00055\u0013qJ\u00016i\u0016\u001cHOT8DY\u0016\fgn\u00155vi\u0012|wO\\!gi\u0016\u0014h)Y5mK\u0012\u001cF/\u0019:ukB$U/\u001a+p\u0007>\u0014(/\u001e9u\u0019><7\u000fF\u0002e\u0003GBq!a\u0004\u0014\u0001\u0004\t\t\u0002K\u0004\u0014\u0003O\t9$a\u001a-\u0005\u0005}\u0002fB\n\u0002F\u00055\u0013qJ\u0001#i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tw+\u001b;i5.,f.\u0019<bS2\f'\r\\3\u0015\u0007\u0011\fy\u0007C\u0004\u0002\u0010Q\u0001\r!!\u0005)\u000fQ\t\u0019(!\u001f\u0002|A\u0019Q/!\u001e\n\u0007\u0005]dO\u0001\u0005ESN\f'\r\\3e\u0003\u00151\u0018\r\\;fC\t\ti(\u0001\u0005L\u001b\u0016#\u0016)L\u001a9Q\u001d!\u0012qEA\u001c\u0003\u0003c#!a\u000f)\u000fQ\t)%!\u0014\u0002P\u0005yC/Z:u\u00072,\u0017M\\*ikR$wn\u001e8XSRD7JU1gi\u000e{g\u000e\u001e:pY2,'/\u00168bm\u0006LG.\u00192mKR\u0019A-!#\t\u000f\u0005=Q\u00031\u0001\u0002\u0012!:Q#a\n\u00028\u00055EFAA Q\u001d)\u0012QIA'\u0003\u001fB3!FA:\u0003\u00152XM]5gs\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b/\u0006\u0003\u0002\u0018\u00065Fc\u00013\u0002\u001a\"9\u00111\u0014\fA\u0004\u0005u\u0015!E3yG\u0016\u0004H/[8o\u00072\f7o\u001d+bOB1\u0011qTAS\u0003Sk!!!)\u000b\u0007\u0005\r\u0016*A\u0004sK\u001adWm\u0019;\n\t\u0005\u001d\u0016\u0011\u0015\u0002\t\u00072\f7o\u001d+bOB!\u00111VAW\u0019\u0001!q!a,\u0017\u0005\u0004\t\tLA\u0001F#\u0011\t\u0019,!/\u0011\u0007q\u000b),C\u0002\u00028&\u0013qAT8uQ&tw\r\u0005\u0003\u0002<\u0006\u0015g\u0002BA_\u0003\u0003tA!a\u0006\u0002@&\t!*C\u0002\u0002D&\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002H\u0006%'!C#yG\u0016\u0004H/[8o\u0015\r\t\u0019-S\u0001\fCN\u001cXM\u001d;DCV\u001cX\rF\u0003e\u0003\u001f\fI\u000fC\u0004\u0002R^\u0001\r!a5\u0002\u001b\u0015D\b/Z2uK\u0012\u001cE.Y:ta\u0011\t).!8\u0011\r\u0005M\u0011q[An\u0013\u0011\tI.a\t\u0003\u000b\rc\u0017m]:\u0011\t\u0005-\u0016Q\u001c\u0003\r\u0003?\fy-!A\u0001\u0002\u000b\u0005\u0011\u0011\u001d\u0002\u0004?\u0012\n\u0014\u0003BAZ\u0003G\u00042\u0001XAs\u0013\r\t9/\u0013\u0002\u0004\u0003:L\bbBAv/\u0001\u0007\u0011Q^\u0001\u0002KB!\u00111XAx\u0013\u0011\t\t0!3\u0003\u0013QC'o\\<bE2,\u0017AF5t\u001d>tG)Y3n_:\\\u0015MZ6b)\"\u0014X-\u00193\u0015\t\u0005]\u0018Q \t\u00049\u0006e\u0018bAA~\u0013\n9!i\\8mK\u0006t\u0007bBA\u00001\u0001\u0007!\u0011A\u0001\u0002iB\u0019qGa\u0001\n\u0007\t\u0015\u0001H\u0001\u0004UQJ,\u0017\rZ\u0001\u001dm\u0016\u0014\u0018NZ=O_:$\u0015-Z7p]RC'/Z1egN#\u0018\r^;t)\u0005!\u0017a\u0006;fgR\u001cuN\\:fGV$\u0018N^3TQV$Hm\\<o)\r!'q\u0002\u0005\b\u0003\u001fQ\u0002\u0019AA\tQ\u001dQ\u0012qEA\u001c\u0005'aC!a\u000f\u0002@!:!$!\u0012\u0002N\u0005=\u0013!\u0005;fgR\u0014UmZ5o'\",H\u000fZ8x]R)AMa\u0007\u0003\u001e!9\u0011qB\u000eA\u0002\u0005E\u0001b\u0002B\u00107\u0001\u0007!\u0011E\u0001\u0010]Vl\u0007\n\u001e;q%\u0016\fX/Z:ugB\u0019ALa\t\n\u0007\t\u0015\u0012JA\u0002J]RDsa\u0007B\u0015\u0003s\u0012y\u0003\u0005\u0003\u0002*\t-\u0012\u0002\u0002B\u0017\u0003W\u0011\u0011bQ:w'>,(oY3-\u0011\tE\"Q\u0007B\u001d\u0005{\t#Aa\r\u0002\ti\\G&M\u0011\u0003\u0005o\tAA_6-e\u0005\u0012!1H\u0001\bWJ\fg\r\u001e\u00172C\t\u0011y$A\u0004le\u00064G\u000f\f\u001a)\u000fm\t)%!\u0014\u0002P\u0005YB/Z:u\u0005\u0016<\u0017N\\*ikR$wn\u001e8Xe>tw-\u00129pG\"$2\u0001\u001aB$\u0011\u001d\ty\u0001\ba\u0001\u0003#As\u0001HA\u0014\u0003o\u0011Y\u0005\f\u0003\u0002<\u0005}\u0002f\u0002\u000f\u0002F\u00055\u0013qJ\u0001!i\u0016\u001cHoQ8oiJ|G\u000e\\3s'\",H\u000fZ8x]\u0012+(/\u001b8h'\u0016tG\rF\u0002e\u0005'Bq!a\u0004\u001e\u0001\u0004\t\t\u0002K\u0004\u001e\u0003O\t9Da\u0016-\u0005\u0005m\u0002fB\u000f\u0002F\u00055\u0013qJ\u0001\u0007G>tg-[4\u0016\u0003}\u000baA\u0019:pW\u0016\u0014XC\u0001B2!\r\u0019$QM\u0005\u0004\u0005O\"#aC&bM.\f'I]8lKJ\fab\u001d5vi\u0012|wO\u001c\"s_.,'/A\u0007sKN$\u0018M\u001d;Ce>\\WM]\u0001\u000fe\u0016\u001c'/Z1uK\n\u0013xn[3s)\r!'\u0011\u000f\u0005\b\u0005g\u0012\u0003\u0019AA|\u0003\u001d\u0019H/\u0019:ukBDs\u0001\u0001B<\u0003s\u0012i\bE\u0002v\u0005sJ1Aa\u001fw\u0005\u001d!\u0016.\\3pkRt\u0012\u0001\u0010")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable & scala.Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head(), this.propsToChangeUponRestart())));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ((List)this.sent1().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        producer.elem = this.createProducer$1();
        KafkaConsumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), Seq$.MODULE$.canBuildFrom()));
        ((List)this.sent2().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), Seq$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        if (this.isKRaftTest()) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
            this.shutdownBroker();
            this.shutdownKRaftController();
            this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(CancellationException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        void setHaltProcedure_haltProcedure;
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        Some expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        VolatileObjectRef receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        VolatileBooleanRef hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(statusCode, x$5) -> ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled, receivedStatusCode, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertDoesNotThrow(() -> this.recreateBroker(true));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(hasHaltProcedureCalled, expectedStatusCode, receivedStatusCode)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(expectedStatusCode, hasHaltProcedureCalled, receivedStatusCode));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit$.MODULE$.resetHaltProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    @Disabled(value="KMETA-38")
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                this.assertCause(exceptionClassTag.runtimeClass(), e);
                Assertions.assertEquals((Object)(this.isKRaftTest() ? BrokerState.SHUTTING_DOWN : BrokerState.NOT_RUNNING), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.shutdownBroker();
        }
    }

    private void assertCause(Class<?> expectedClass, Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!expectedClass.isInstance(cause)) continue;
            return;
        }
        Assertions.fail((String)new StringBuilder(43).append("Failed to assert cause of ").append(e).append(", expected cause ").append(expectedClass).toString());
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$6 -> (Thread)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class))))).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.shutdownBroker();
        this.broker().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @CsvSource(value={"zk,1", "zk,2", "kraft,1", "kraft,2"})
    public void testBeginShutdown(String quorum, int numHttpRequests) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdown$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numHttpRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            this.broker().beginShutdown(this.broker().brokerEpoch());
            Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.broker().brokerState(), (String)"broker should only be in shutting down state");
        });
        this.broker().shutdown();
        this.broker().awaitShutdown();
        String string = quorum;
        String string2 = "zk";
        Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState(), (String)"expected broker to be fully shut down");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBeginShutdownWrongEpoch(String quorum) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdownWrongEpoch$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        long wrongBrokerEpoch = this.broker().brokerEpoch() - 1L;
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.broker().beginShutdown(wrongBrokerEpoch), () -> "expected a begin shutdown requests at a different epoch to result in an exception");
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)this.broker().brokerState(), (String)"broker shutdown should not have started");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testControllerShutdownDuringSend(String quorum) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(1).setControllerId(controllerId).setControllerEpoch(1).setBrokerEpoch(0L).addPartitionState(new TopicPartition("topic", 0), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState()).addLiveLeaders(((TraversableOnce)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.node(listenerName), Iterable$.MODULE$.canBuildFrom())).toSet()).addTopicId(this.topic(), Uuid.randomUuid());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            int x$1 = 1;
            Function2 x$3 = qual$1.sendControlMetadataBatch$default$3();
            qual$1.sendControlMetadataBatch(x$1, (ControlMetadataBatch)batch, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.shutdownBroker();
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16);
    }

    private final KafkaConsumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$2();
        Option<String> x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        String x$7 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$8 = TestUtils$.MODULE$.createConsumer$default$5();
        boolean x$9 = TestUtils$.MODULE$.createConsumer$default$6();
        int x$10 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$11 = TestUtils$.MODULE$.createConsumer$default$9();
        Option<Properties> x$12 = TestUtils$.MODULE$.createConsumer$default$10();
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$2, x$11, x$12, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull(Predef$.MODULE$.$conforms())).toString();
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdown$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdownWrongEpoch$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

