/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkClearLinkReference;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019q\u0005\u0001)A\u0005\u0011\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u0002/\u0001A\u0003%\u0011\u000bC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da\u0001\u001c\u0001!\u0002\u0013)\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000fM\u0004!\u0019!C\u0005i\"11\u0010\u0001Q\u0001\nUDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002@\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0006\u0001\u0005\u0002\u00055\u0001bBA\u001b\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u007f\u0001A\u0011AA\u0007\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u001bAq!a\u0012\u0001\t\u0003\ti\u0001C\u0004\u0002L\u0001!\t!!\u0004\t\u000f\u0005=\u0003\u0001\"\u0001\u0002\u000e!9\u00111\u000b\u0001\u0005\u0002\u00055\u0001bBA,\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00037\u0002A\u0011AA\u0007\u0011\u001d\ty\u0006\u0001C\u0001\u0003\u001bAq!a\u0019\u0001\t\u0003\ti\u0001C\u0004\u0002h\u0001!\t!!\u0004\t\u000f\u0005-\u0004\u0001\"\u0001\u0002\u000e!9\u0011q\u000e\u0001\u0005\u0002\u00055\u0001bBA:\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\tY\u000b\u0001C\u0005\u0003[C\u0011\"a8\u0001#\u0003%I!!9\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"I!\u0011\u0001\u0001\u0012\u0002\u0013%\u0011\u0011\u001d\u0002\"\u00072,8\u000f^3s\u0019&t7n\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dKR+7\u000f\u001e\u0006\u0003U-\nA\u0001\\5oW*\u0011A&L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0015\u0002\u00111Lgn\u001b(b[\u0016,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA\u0001\\1oO*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!aS!\u0002\tU$\u0018\u000e\\\u0005\u0003\u001b*\u0013A!V+J\t\u00069A.\u001b8l\u0013\u0012\u0004\u0013!D:pkJ\u001cW\rV8qS\u000eLE-F\u0001R!\t\u0011&,D\u0001T\u0015\t!V+\u0001\u0004d_6lwN\u001c\u0006\u0003]YS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111l\u0015\u0002\u0005+VLG-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#A0\u0011\u0005i\u0002\u0017BA1*\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0003\u0015\u0004\"A\u001a6\u000e\u0003\u001dT!a\u00195\u000b\u0005%,\u0016aB2mS\u0016tGo]\u0005\u0003W\u001e\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\u0004bI6Lg\u000eI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\tq\u000e\u0005\u0002;a&\u0011\u0011/\u000b\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002kB\u0011a/_\u0007\u0002o*\u0011\u00010L\u0001\u0003u.L!A_<\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u001d\u0015D\b/Z2uK\u00124\u0015\u000e\u001c;feV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r1+A\u0002bG2LA!a\u0002\u0002\u0002\tA\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\r&dG/\u001a:\u0002\u001f\u0015D\b/Z2uK\u00124\u0015\u000e\u001c;fe\u0002\nQa]3u+B$\"!a\u0004\u0011\u0007I\n\t\"C\u0002\u0002\u0014M\u0012A!\u00168ji\"\u001a!#a\u0006\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0019\u0011\r]5\u000b\t\u0005\u0005\u00121E\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t)\u0003W\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003S\tYB\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004'\u0005=\u0002\u0003BA\r\u0003cIA!a\r\u0002\u001c\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bi\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t\u000b6\u0004H/\u001f\u0015\u0004)\u0005e\u0002\u0003BA\r\u0003wIA!!\u0010\u0002\u001c\t!A+Z:u\u0003e!Xm\u001d;IC:$G.Z:F[B$\u0018\u0010T8dC2\f5\r\\:)\u0007U\tI$A\u000fuKN$\b*\u00198eY\u0016\u001cHj\\2bY\u0006\u001bGn\u001d+p\u001b&<'/\u0019;fQ\r1\u0012\u0011H\u00010i\u0016\u001cH\u000fS1oI2,7I]3bi\u0016\f5\r\\:SKN,H\u000e\u001e$viV\u0014X\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004/\u0005e\u0012a\f;fgRD\u0015M\u001c3mK\u0012+G.\u001a;f\u0003\u000ed7OU3tk2$h)\u001e;ve\u0016$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007f\u0001\r\u0002:\u0005\u0019D/Z:u\u0011\u0006tG\r\\3EK2,G/Z!dYN\u0014Vm];miJ+7\u000f]8og\u0016\u001cuN\u001c;bS:\u001cX\t_2faRLwN\u001c\u0015\u00043\u0005e\u0012!\b;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m]%t\u001b&\u0014(o\u001c:)\u0007i\tI$\u0001\u0017uKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8s\t&4g-\u001a:f]Rd\u0015N\\6JI\"\u001a1$!\u000f\u0002OQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg&\u001bX*\u001b:s_J,%O]8s%\u0016$(/\u001f\u0015\u00049\u0005e\u0012A\n;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m]%t\u001b&\u0014(o\u001c:FeJ|'oU6ja\"\u001aQ$!\u000f\u0002=Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg:{G/T5se>\u0014\bf\u0001\u0010\u0002:\u0005!C/Z:u\u00072,\u0017M]'jeJ|'\u000fV8qS\u000e\u001cH*\u001b8l\t>,7O\u001c;Fq&\u001cH\u000fK\u0002 \u0003s\t!\u0006^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7oQ8oiJ|G\u000e\\3s\u001b\u0006t\u00170\u00128ue&,7\u000fK\u0002!\u0003s\tQ\u0005^3ti.\u0013\u0018M\u001a;N_\u0012,7\u000b[8vY\u0012\u001cE.Z1s\u0019&t7NU3gKJ,gnY3)\u0007\u0005\nI$\u0001\u0012uKN$(l['pI\u0016\u001c\u0006n\\;mI\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\u0015\u0004E\u0005e\u0012!\u00068fo\u0006cG/\u001a:NSJ\u0014xN]:SKN,H\u000e\u001e\u000b\u0005\u0003w\n\t\tE\u0002g\u0003{J1!a h\u0005I\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\r5\u00051\u0001\u0002\u0006\u00061Ao\u001c9jGN\u0004b!a\"\u0002\u0018\u0006ue\u0002BAE\u0003'sA!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f{\u0013A\u0002\u001fs_>$h(C\u00015\u0013\r\t)jM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI*a'\u0003\u0007M+\u0017OC\u0002\u0002\u0016N\u0002B!a(\u0002(:!\u0011\u0011UAR!\r\tYiM\u0005\u0004\u0003K\u001b\u0014A\u0002)sK\u0012,g-C\u0002E\u0003SS1!!*4\u0003\rrWm^\"mK\u0006\u0014H*\u001b8l%\u00164WM]3oG\u0016<\u0016\u000e\u001e5BkRDwN]5{KJ$\u0002\"a,\u00026\u0006}\u0016Q\u001b\t\u0004u\u0005E\u0016bAAZS\ti2\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\rC\u0004\u00028\u0012\u0002\r!!/\u0002%\r|W\u000e\u001d7fi&|gnQ1mY\n\f7m\u001b\t\u0006e\u0005m\u0016qB\u0005\u0004\u0003{\u001b$!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\t\t\r\na\u0001\u0003\u0007\f!\"Y;uQ>\u0014\u0018N_3s!\u0015\u0011\u0014QYAe\u0013\r\t9m\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bTA!!1\u0002P*\u0011A&V\u0005\u0005\u0003'\fiM\u0001\u0006BkRDwN]5{KJD\u0011\"a6%!\u0003\u0005\r!!7\u0002!Q|\u0007/[2t\u000fJ|W\u000f]:TSj,\u0007c\u0001\u001a\u0002\\&\u0019\u0011Q\\\u001a\u0003\u0007%sG/A\u0017oK^\u001cE.Z1s\u0019&t7NU3gKJ,gnY3XSRD\u0017)\u001e;i_JL'0\u001a:%I\u00164\u0017-\u001e7uIM*\"!a9+\t\u0005e\u0017Q]\u0016\u0003\u0003O\u0004B!!;\u0002t6\u0011\u00111\u001e\u0006\u0005\u0003[\fy/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011_\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002v\u0006-(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)b.Z<DY\u0016\f'\u000fT5oWJ+g-\u001a:f]\u000e,GCBAX\u0003w\fi\u0010C\u0004\u00028\u001a\u0002\r!!/\t\u0013\u0005}h\u0005%AA\u0002\u0005e\u0017A\u0004;pa&\u001cwI]8vaNK'0Z\u0001 ]\u0016<8\t\\3be2Kgn\u001b*fM\u0016\u0014XM\\2fI\u0011,g-Y;mi\u0012\u0012\u0004")
public class ClusterLinkClearLinkReferenceTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
    private final AccessControlEntryFilter expectedFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(CoreUtils$.MODULE$.toKafkaUUID(this.linkId())));

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private AccessControlEntryFilter expectedFilter() {
        return this.expectedFilter;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        this.scheduler().shutdown();
    }

    @Test
    public void testClearMirrorTopicsEmpty() {
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesEmptyLocalAcls() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReferenceWithAuthorizer$default$3();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        ClusterLinkClearLinkReference clusterLinkClearLinkReference = new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        clusterLinkClearLinkReference.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer)).acls(aclBindingFilter);
        Assertions.assertTrue((boolean)clusterLinkClearLinkReference.getUpdatedAcls());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesLocalAclsToMigrate() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBindingWithLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(CoreUtils$.MODULE$.toKafkaUUID(this.linkId()))));
        AclBinding aclBindingWithLinkAndLocal = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)CoreUtils$.MODULE$.toKafkaUUID(this.linkId()), (List)new .colon.colon((Object)Uuid.ZERO_UUID, (List)Nil$.MODULE$))).asJava()));
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBindingWithLink, (List)Nil$.MODULE$)).asJava()).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBindingWithLinkAndLocal, (List)Nil$.MODULE$)).asJava()).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.complete(null);
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBindingWithoutLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        Mockito.when((Object)createAclsResult.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithoutLink), (Object)createAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().createAcls(Collections.singletonList(aclBindingWithoutLink))).thenReturn((Object)createAclsResult);
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBindingWithLink);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn(null);
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithLink.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()))).thenReturn((Object)deleteAclsResult);
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReferenceWithAuthorizer$default$3();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        ClusterLinkClearLinkReference clusterLinkClearLinkReference = new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        clusterLinkClearLinkReference.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer, (VerificationMode)Mockito.times((int)3))).acls(aclBindingFilter);
        ((Admin)Mockito.verify((Object)this.admin())).createAcls(Collections.singletonList(aclBindingWithoutLink));
        ((Admin)Mockito.verify((Object)this.admin())).deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()));
        Assertions.assertTrue((boolean)clusterLinkClearLinkReference.getUpdatedAcls());
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult)).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
    }

    @Test
    public void testHandleCreateAclsResultFutureThrowsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(CoreUtils$.MODULE$.toKafkaUUID(this.linkId()))));
        Mockito.when((Object)createAclsResult.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding), (Object)createAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult));
        ((CreateAclsResult)Mockito.verify((Object)createAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultFutureThrowsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultResponseContainsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBinding);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn((Object)new ApiException((Throwable)new Exception("Internal error")));
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult, (VerificationMode)Mockito.times((int)2))).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        KafkaFuture future = KafkaFuture.completedFuture(null);
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorDifferentLinkId() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorRetry() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        future1.completeExceptionally((Throwable)new TimeoutException());
        AlterMirrorsResult ret1 = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future1)}))).asJava());
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorSkip() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsNotMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
    }

    @Test
    public void testClearMirrorTopicsLinkDoesntExist() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = this.newClearLinkReference$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
    }

    @Test
    public void testClearMirrorTopicsControllerManyEntries() {
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        int topicGroupSize = 2;
        Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkClearLinkReferenceTest.$anonfun$testClearMirrorTopicsControllerManyEntries$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        List topicGroups = topics.grouped(topicGroupSize).toList();
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(0)).size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(1)).size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)topicGroups.apply(2)).size());
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)topics);
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.head())).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.head()).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.head()).last()), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.apply(1))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4()))})));
        Mockito.when((Object)this.metadataManager().clusterLinkTopicState((Set)topicGroups.apply(2))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Map expectedOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(0)).head()), (Object)AlterMirrorOp.CLEAR)}));
        scala.collection.immutable.Map expectedOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)AlterMirrorOp.CLEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)AlterMirrorOp.CLEAR)}));
        AlterMirrorsResult ret1 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(0)).head()), (List)Nil$.MODULE$));
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(1)).head()), (List)new .colon.colon((Object)((String)((TraversableLike)topicGroups.apply(1)).last()), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1);
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)topicGroups.apply(1));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).clusterLinkTopicState((Set)topicGroups.apply(2));
    }

    @Test
    public void testKraftModeShouldClearLinkReference() {
        ClusterLinkMetadataManager kraftMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithKRaftSupport.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{kraftMetadataManager});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
    }

    @Test
    public void testZkModeShouldClearLinkReference() {
        ClusterLinkMetadataManager zkMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
        ClusterLinkData linkDataIsDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsDeleted));
        Assertions.assertTrue((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        ClusterLinkData linkDataIsNotDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsNotDeleted));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
    }

    private AlterMirrorsResult newAlterMirrorsResult(Seq<String> topics) {
        return new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)KafkaFuture.completedFuture(null)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private ClusterLinkClearLinkReference newClearLinkReferenceWithAuthorizer(Function0<BoxedUnit> completionCallback, Option<Authorizer> authorizer, int topicsGroupsSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), authorizer, this.admin(), completionCallback, topicsGroupsSize, 10, 10);
    }

    private ClusterLinkClearLinkReference newClearLinkReference(Function0<BoxedUnit> completionCallback, int topicGroupSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), completionCallback, topicGroupSize, 10, 10);
    }

    private int newClearLinkReferenceWithAuthorizer$default$3() {
        return 10;
    }

    private int newClearLinkReference$default$2() {
        return 10;
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopicsControllerManyEntries$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public ClusterLinkClearLinkReferenceTest() {
        this.linkName = "link-name";
    }
}

