/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FilterJson;
import kafka.server.link.LinkMode;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0005\n\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003BB\u0019\u0001A\u0003%a\u0005C\u00043\u0001\t\u0007I\u0011B\u0013\t\rM\u0002\u0001\u0015!\u0003'\u0011\u001d!\u0004A1A\u0005\nUBa!\u0010\u0001!\u0002\u00131\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002)\u0001\t\u0003y\u0004\"B+\u0001\t\u0003y\u0004\"B,\u0001\t\u0003y\u0004\"B-\u0001\t\u0003y\u0004\"B.\u0001\t\u0003y\u0004\"B/\u0001\t\u0003y\u0004\"B0\u0001\t\u0003y\u0004\"B1\u0001\t\u0003y$!F\"mkN$XM\u001d'j].\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003'Q\tA\u0001\\5oW*\u0011QCF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\n\u0002\u0013\u0005\u001cGNR5mi\u0016\u0014X#\u0001\u0014\u0011\u0005\u001drcB\u0001\u0015-!\tIC$D\u0001+\u0015\tY\u0003$\u0001\u0004=e>|GOP\u0005\u0003[q\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006H\u0001\u000bC\u000edg)\u001b7uKJ\u0004\u0013aC4s_V\u0004h)\u001b7uKJ\fAb\u001a:pkB4\u0015\u000e\u001c;fe\u0002\n1\u0002^8qS\u000e4\u0015\u000e\u001c;feV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!a\f\u001d\u0002\u0019Q|\u0007/[2GS2$XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012\u0001\u0011\t\u00037\u0005K!A\u0011\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011\u0011\u0003\"!\u0012(\u000e\u0003\u0019S!a\u0012%\u0002\u0007\u0005\u0004\u0018N\u0003\u0002J\u0015\u00069!.\u001e9ji\u0016\u0014(BA&M\u0003\u0015QWO\\5u\u0015\u0005i\u0015aA8sO&\u0011qJ\u0012\u0002\n\u0003\u001a$XM]#bG\"\fA\u0003^3ti\u000e{gNZ5h\u0007\u0006$XmZ8sS\u0016\u001c\bFA\u0005S!\t)5+\u0003\u0002U\r\n!A+Z:u\u00031!Xm\u001d;EK\u001a\fW\u000f\u001c;tQ\tQ!+\u0001\nuKN$X*[4sCRLwN\u001c)s_B\u001c\bFA\u0006S\u0003q!Xm\u001d;WC2LGm\u00117vgR,'\u000fT5oWB\u0013XMZ5yKND#\u0001\u0004*\u0002=Q,7\u000f^%om\u0006d\u0017\u000eZ\"mkN$XM\u001d'j].\u0004&/\u001a4jq\u0016\u001c\bFA\u0007S\u0003\u0015\"Xm\u001d;DYV\u001cH/\u001a:MS:\\\u0007K]3gSb\fe\u000eZ!dYNKhnY\"p[\n|7\u000f\u000b\u0002\u000f%\u0006aB/Z:u'\u0006\u001cHNS1bg\u000e{gNZ5h-\u0006d\u0017\u000eZ1uS>t\u0007FA\bS\u00039!Xm\u001d;Kg>tg)\u001b7uKJD#\u0001\u0005*")
public class ClusterLinkConfigTest {
    private final String aclFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n       | \"aclFilters\": [{\n       |  \"resourceFilter\": {\n       |      \"resourceType\": \"any\",\n       |      \"patternType\": \"any\"\n       |    },\n       |  \"accessFilter\": {\n       |     \"operation\": \"any\",\n       |     \"permissionType\": \"any\"\n       |    }\n       |  }]\n       | }")).stripMargin();
    private final String groupFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n       |\"groupFilters\": [\n       |  {\n       |     \"name\": \"*\",\n       |     \"patternType\": \"literal\",\n       |     \"filterType\": \"include\"\n       |  }\n       |]}")).stripMargin();
    private final String topicFilter = this.groupFilter().replaceAll("groupFilters", "topicFilters");

    private String aclFilter() {
        return this.aclFilter;
    }

    private String groupFilter() {
        return this.groupFilter;
    }

    private String topicFilter() {
        return this.topicFilter;
    }

    @AfterEach
    public void tearDown() {
        Configuration.setConfiguration(null);
    }

    @Test
    public void testConfigCategories() {
        Set allProps = ClusterLinkConfig$.MODULE$.configNames().toSet();
        Set replicationProps = ClusterLinkConfig$.MODULE$.ReplicationProps();
        Set migrationProps = ClusterLinkConfig$.MODULE$.PeriodicTaskProps();
        Set linkProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp()}));
        Set reverseConnectionProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp()}));
        Set notCategorizedProps = (Set)allProps.$minus$minus((GenTraversableOnce)replicationProps).$minus$minus((GenTraversableOnce)migrationProps).$minus$minus((GenTraversableOnce)linkProps).$minus$minus((GenTraversableOnce)reverseConnectionProps).$minus$minus((GenTraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(AdminClientConfig.configNames()).asScala()).$minus$minus((GenTraversableOnce)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(AdminClientConfig.configNames()).asScala()).map((Function1 & Serializable & scala.Serializable)configName -> new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append((String)configName).toString(), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)notCategorizedProps);
    }

    @Test
    public void testDefaults() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        Assertions.assertEquals((Object)LinkMode.Destination$.MODULE$, (Object)linkConfig.linkMode());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers(), (Integer)linkConfig.numClusterLinkFetchers());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes(), (Integer)linkConfig.replicaFetchMaxBytes());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs(), (Long)linkConfig.metadataRefreshBackoffMs());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs(), (Long)linkConfig.metadataMaxAgeMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs(), (Integer)linkConfig.reverseConnectionSetupTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs(), (int)linkConfig.retryTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault(), (Integer)linkConfig.consumerOffsetSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault(), (Integer)linkConfig.aclSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault(), (Integer)linkConfig.topicConfigSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault(), (Integer)linkConfig.availabilityCheckMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()));
    }

    @Test
    public void testMigrationProps() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.topicFilter());
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.groupFilter());
        props.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), this.aclFilter());
        ClusterLinkConfig destLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        Assertions.assertTrue((boolean)destLinkConfig.autoMirroringEnable());
        Assertions.assertTrue((boolean)destLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertTrue((boolean)destLinkConfig.aclSyncEnable());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.topicFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.consumerGroupFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.aclFilters());
        props.setProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), LinkMode.Source$.MODULE$.name());
        ClusterLinkConfig sourceLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        Assertions.assertFalse((boolean)sourceLinkConfig.autoMirroringEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.aclSyncEnable());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.topicFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.consumerGroupFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.aclFilters());
    }

    @Test
    public void testValidClusterLinkPrefixes() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "");
        ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "ABYZ.cx-019_");
        ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "...");
        ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "_.-_");
        ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), new StringOps(Predef$.MODULE$.augmentString("0123")).$times(3));
        ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
    }

    @Test
    public void testInvalidClusterLinkPrefixes() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test/link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test:link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\\\link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\nlink_");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\tlink");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), new StringOps(Predef$.MODULE$.augmentString("0123456789_")).$times(30));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
    }

    @Test
    public void testClusterLinkPrefixAndAclSyncCombos() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        props.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        String aclFilter = new StringOps(Predef$.MODULE$.augmentString("{\n         | \"aclFilters\": [{\n         |  \"resourceFilter\": {\n         |      \"resourceType\": \"any\",\n         |      \"patternType\": \"any\"\n         |    },\n         |  \"accessFilter\": {\n         |     \"operation\": \"any\",\n         |     \"permissionType\": \"any\"\n         |    }\n         |  }]\n         | }")).stripMargin();
        props.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        InvalidConfigurationException e = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()));
        Assertions.assertTrue((boolean)e.getMessage().contains("Cluster link prefixing and ACL syncing cannot be enabled at the same time."), (String)new StringBuilder(26).append("Unexpected error message: ").append(e.getMessage()).toString());
        Properties propsTwo = new Properties();
        propsTwo.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        ClusterLinkConfig$.MODULE$.create((Map)propsTwo, ClusterLinkConfig$.MODULE$.create$default$2());
        Properties propsThree = new Properties();
        propsThree.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        propsThree.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        ClusterLinkConfig$.MODULE$.create((Map)propsThree, ClusterLinkConfig$.MODULE$.create$default$2());
    }

    @Test
    public void testSaslJaasConfigValidation() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        Set saslProtocols = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.SASL_PLAINTEXT, SecurityProtocol.SASL_SSL}));
        Set nonSaslProtocols = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}));
        ClusterLinkConfigTest.verifyValidSaslJaasConfig$1(props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "test.LoginModule required;");
        ClusterLinkConfigTest.verifyValidSaslJaasConfig$1(props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "invalid secret");
        ClusterLinkConfigTest.verifyInvalidSaslJaasConfig$1("Invalid JAAS configuration", props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "${secretprovider:test}");
        ClusterLinkConfigTest.verifyInvalidSaslJaasConfig$1("Ensure that config provider list and provider class are configured in the cluster link configuration", props, saslProtocols, nonSaslProtocols);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testJsonFilter() {
        void verifyFilter$1_validFilter;
        void verifyFilter$1_filterConfig;
        void verifyFilter$1_validFilter2;
        void verifyFilter$1_filterConfig2;
        void verifyFilter$1_validFilter3;
        String string = this.groupFilter();
        String verifyFilter$1_filterConfig3 = ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp();
        String verifyFilter$1_enableConfig = ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp();
        Properties verifyFilter$1_props = new Properties();
        verifyFilter$1_props.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props.setProperty(verifyFilter$1_filterConfig3, (String)verifyFilter$1_validFilter3);
        Some verifyFilter$1_verifySuccess$1_size = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.remove(verifyFilter$1_enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.setProperty(verifyFilter$1_filterConfig3, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props, verifyFilter$1_enableConfig);
        verifyFilter$1_props.remove(verifyFilter$1_filterConfig3);
        None$ verifyFilter$1_verifySuccess$1_size2 = None$.MODULE$;
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size2, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size2, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.remove(verifyFilter$1_enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        String string2 = this.topicFilter();
        String string3 = ClusterLinkConfig$.MODULE$.TopicFiltersProp();
        String verifyFilter$1_enableConfig2 = ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp();
        Properties verifyFilter$1_props2 = new Properties();
        verifyFilter$1_props2.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props2.setProperty((String)verifyFilter$1_filterConfig2, (String)verifyFilter$1_validFilter2);
        Some verifyFilter$1_verifySuccess$1_size3 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size3, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size3, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.remove(verifyFilter$1_enableConfig2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.setProperty((String)verifyFilter$1_filterConfig2, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props2, verifyFilter$1_enableConfig2);
        verifyFilter$1_props2.remove(verifyFilter$1_filterConfig2);
        None$ verifyFilter$1_verifySuccess$1_size4 = None$.MODULE$;
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size4, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size4, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.remove(verifyFilter$1_enableConfig2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        String string4 = this.aclFilter();
        String string5 = ClusterLinkConfig$.MODULE$.AclFiltersProp();
        String verifyFilter$1_enableConfig3 = ClusterLinkConfig$.MODULE$.AclSyncEnableProp();
        Properties verifyFilter$1_props3 = new Properties();
        verifyFilter$1_props3.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props3.setProperty((String)verifyFilter$1_filterConfig, (String)verifyFilter$1_validFilter);
        Some verifyFilter$1_verifySuccess$1_size5 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size5, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size5, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.remove(verifyFilter$1_enableConfig3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.setProperty((String)verifyFilter$1_filterConfig, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props3, verifyFilter$1_enableConfig3);
        verifyFilter$1_props3.remove(verifyFilter$1_filterConfig);
        None$ verifyFilter$1_verifySuccess$1_size6 = None$.MODULE$;
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size6, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size6, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.remove(verifyFilter$1_enableConfig3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
    }

    private static final void verifyValidationSucceeds$1(Set protocols, Properties props$3) {
        protocols.foreach((Function1 & Serializable & scala.Serializable)protocol -> {
            props$3.setProperty("security.protocol", protocol.name);
            return ClusterLinkConfig$.MODULE$.create((Map)props$3, ClusterLinkConfig$.MODULE$.create$default$2());
        });
    }

    public static final /* synthetic */ void $anonfun$testSaslJaasConfigValidation$2(Properties props$3, String message$1, SecurityProtocol protocol) {
        props$3.setProperty("security.protocol", protocol.name);
        InvalidConfigurationException e = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props$3, ClusterLinkConfig$.MODULE$.create$default$2()));
        Assertions.assertTrue((boolean)e.getMessage().contains(message$1), (String)new StringBuilder(26).append("Unexpected error message: ").append(e.getMessage()).toString());
        Assertions.assertFalse((boolean)e.getMessage().contains("secret"), (String)new StringBuilder(41).append("Sensitive data exposed in error message: ").append(e.getMessage()).toString());
    }

    private static final void verifyValidationFails$1(Set protocols, String message, Properties props$3) {
        protocols.foreach((Function1 & Serializable & scala.Serializable)protocol -> {
            ClusterLinkConfigTest.$anonfun$testSaslJaasConfigValidation$2(props$3, message, protocol);
            return BoxedUnit.UNIT;
        });
    }

    private static final void verifyValidSaslJaasConfig$1(Properties props$3, Set saslProtocols$1, Set nonSaslProtocols$1) {
        props$3.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Inbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((GenTraversableOnce)nonSaslProtocols$1), props$3);
        props$3.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Outbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((GenTraversableOnce)nonSaslProtocols$1), props$3);
        props$3.remove(ClusterLinkConfig$.MODULE$.ConnectionModeProp());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((GenTraversableOnce)nonSaslProtocols$1), props$3);
    }

    private static final void verifyInvalidSaslJaasConfig$1(String message, Properties props$3, Set saslProtocols$1, Set nonSaslProtocols$1) {
        props$3.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Inbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((GenTraversableOnce)nonSaslProtocols$1), props$3);
        props$3.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Outbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1(nonSaslProtocols$1, props$3);
        ClusterLinkConfigTest.verifyValidationFails$1(saslProtocols$1, message, props$3);
        props$3.remove(ClusterLinkConfig$.MODULE$.ConnectionModeProp());
        ClusterLinkConfigTest.verifyValidationSucceeds$1(nonSaslProtocols$1, props$3);
        ClusterLinkConfigTest.verifyValidationFails$1(saslProtocols$1, message, props$3);
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$1(FilterJson x$1) {
        return x$1.filters().size();
    }

    private static final Option groupFilterSize$1(ClusterLinkConfig config) {
        return config.consumerGroupFilters().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$1(x$1)));
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$2(FilterJson x$2) {
        return x$2.filters().size();
    }

    private static final Option topicFilterSize$1(ClusterLinkConfig config) {
        return config.topicFilters().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$2(x$2)));
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$3(AclFiltersJson x$3) {
        return x$3.aclFilters().size();
    }

    private static final Option aclFilterSize$1(ClusterLinkConfig config) {
        return config.aclFilters().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$3(x$3)));
    }

    private static final void verifySuccess$1(Properties props, String enableConfig, Option size, Function1 filterSize) {
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
    }

    private static final void verifyFailure$1(Properties props, String enableConfig) {
        props.setProperty(enableConfig, "true");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
        props.setProperty(enableConfig, "false");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
        props.remove(enableConfig);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
    }

    private static final void verifyFilter$1(String enableConfig, String filterConfig, String validFilter, Function1 filterSize) {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty(filterConfig, validFilter);
        Some verifySuccess$1_size = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)verifySuccess$1_size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifySuccess$1_size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(filterConfig, "{");
        ClusterLinkConfigTest.verifyFailure$1(props, enableConfig);
        props.remove(filterConfig);
        None$ verifySuccess$1_size2 = None$.MODULE$;
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)verifySuccess$1_size2, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)verifySuccess$1_size2, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, ClusterLinkConfig$.MODULE$.create$default$2())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
    }
}

