/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherManager$;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.server.link.MetadataListener;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.PartitionAndState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMh\u0001\u0002-Z\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013EA\u000e\u0003\u0004z\u0001\u0001\u0006I!\u001c\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\tI\u0001\u0001Q\u0001\nqD\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fA\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003CA\u0011\"!\f\u0001\u0005\u0004%I!a\f\t\u0011\u0005]\u0002\u0001)A\u0005\u0003cA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005%\u0003\u0001)A\u0005\u0003{A\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u001fB\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003;B1\"!\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002l!Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011BA;\u0011-\t\t\t\u0001a\u0001\u0002\u0003\u0006K!!\u001c\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAM\u0001\u0001\u0006I!a%\t\u0017\u0005m\u0005\u00011AA\u0002\u0013%\u0011Q\u0014\u0005\f\u0003K\u0003\u0001\u0019!a\u0001\n\u0013\t9\u000bC\u0006\u0002,\u0002\u0001\r\u0011!Q!\n\u0005}\u0005bCAW\u0001\u0001\u0007\t\u0019!C\u0005\u0003_C1\"!1\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D\"Y\u0011q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BAY\u0011%\tI\r\u0001a\u0001\n\u0013\tY\rC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"A\u0011\u0011\u001c\u0001!B\u0013\ti\rC\u0006\u0002\\\u0002\u0001\r\u00111A\u0005\n\u0005u\u0007bCAs\u0001\u0001\u0007\t\u0019!C\u0005\u0003OD1\"a;\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002`\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bb\u0002B\u0004\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005#\u0001A\u0011AAx\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003_DqAa\b\u0001\t\u0003\ty\u000fC\u0004\u0003$\u0001!\t!a<\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002p\"9!1\u0006\u0001\u0005\u0002\u0005=\bb\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005#\u0002A\u0011AAx\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003_DqA!\u0017\u0001\t\u0003\ty\u000fC\u0004\u0003^\u0001!\t!a<\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002p\"9!Q\r\u0001\u0005\u0002\u0005=\bb\u0002B5\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005[\u0002A\u0011AAx\u0011\u001d\u0011\t\b\u0001C\u0001\u0003_DqA!\u001e\u0001\t\u0003\ty\u000fC\u0004\u0003z\u0001!\t!a<\t\u000f\tu\u0004\u0001\"\u0001\u0002p\"9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BY\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005k\u0003A\u0011AAx\u0011\u001d\u0011I\f\u0001C\u0001\u0003_DqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003V\u0002!\t!a<\t\u000f\te\u0007\u0001\"\u0001\u0002p\"9!Q\u001c\u0001\u0005\u0002\u0005=\bb\u0002Bq\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[DqA!?\u0001\t\u0013\u0011Y\u0010C\u0005\u00046\u0001\t\n\u0011\"\u0003\u00048!I1Q\n\u0001\u0012\u0002\u0013%1q\n\u0005\n\u0007'\u0002\u0011\u0013!C\u0005\u0007\u001fBqa!\u0016\u0001\t\u0013\u00199\u0006C\u0005\u0004\u0002\u0002\t\n\u0011\"\u0003\u0004\u0004\"I1q\u0011\u0001\u0012\u0002\u0013%11\u0011\u0005\n\u0007\u0013\u0003\u0011\u0013!C\u0005\u0007\u0017C\u0011ba$\u0001#\u0003%Ia!%\t\u000f\rU\u0005\u0001\"\u0003\u0004\u0018\"I1q\u0014\u0001\u0012\u0002\u0013%11\u0011\u0005\n\u0007C\u0003\u0011\u0013!C\u0005\u0007\u0017Cqaa)\u0001\t\u0013\u0019)\u000bC\u0005\u0004<\u0002\t\n\u0011\"\u0003\u0004>\"91\u0011\u0019\u0001\u0005\n\r\r\u0007bBBh\u0001\u0011%1\u0011\u001b\u0005\b\u00073\u0004A\u0011BBn\u0011\u001d\u00199\u000f\u0001C\u0005\u0007SDqa!=\u0001\t\u0013\tyOA\u000fDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\tQ6,\u0001\u0003mS:\\'B\u0001/^\u0003\u0019\u0019XM\u001d<fe*\ta,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SB\u0011!\u000eA\u0007\u00023\u0006\u0019\u0011N\u00199\u0016\u00035\u0004\"A\\<\u000e\u0003=T!\u0001]9\u0002\r\r|W.\\8o\u0015\ta&O\u0003\u0002_g*\u0011A/^\u0001\u0007CB\f7\r[3\u000b\u0003Y\f1a\u001c:h\u0013\tAxNA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0011I'\r\u001d\u0011\u0002\r1Lgn[%e+\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tA!\u001e;jY*\u0011\u00111A\u0001\u0005U\u00064\u0018-C\u0002\u0002\by\u0014A!V+J\t\u00069A.\u001b8l\u0013\u0012\u0004\u0013\u0001\u00037j].t\u0015-\\3\u0016\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\t\u0005U\u0011\u0011A\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001a\u0005M!AB*ue&tw-A\u0005mS:\\g*Y7fA\u0005i1o\\;sG\u0016$v\u000e]5d\u0013\u0012,\"!!\t\u0011\t\u0005\r\u0012qE\u0007\u0003\u0003KQ!\u0001\u001d:\n\t\u0005%\u0012Q\u0005\u0002\u0005+VLG-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002\u000f5,GO]5dgV\u0011\u0011\u0011\u0007\t\u0004U\u0006M\u0012bAA\u001b3\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003RA!a\u0011\u0002&\u0005)Q\u000f^5mg&!\u0011qIA!\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002T5\t1,C\u0002\u0002Vm\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003\rawnZ\u000b\u0003\u0003;\u0002B!a\u0018\u0002d5\u0011\u0011\u0011\r\u0006\u0004\u00033j\u0016\u0002BA3\u0003C\u00121\"\u00112tiJ\f7\r\u001e'pO\u0006!An\\4!\u00031\u0011'o\\6fe\u000e{gNZ5h+\t\ti\u0007\u0005\u0003\u0002R\u0005=\u0014bAA97\nY1*\u00194lC\u000e{gNZ5h\u0003A\u0011'o\\6fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002x\u0005u\u0004c\u00012\u0002z%\u0019\u00111P2\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u007f\u001a\u0012\u0011!a\u0001\u0003[\n1\u0001\u001f\u00132\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005YA.\u001b8l\u001b\u0006t\u0017mZ3s+\t\t9\tE\u0002k\u0003\u0013K1!a#Z\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u00191Lgn['b]\u0006<WM\u001d\u0011\u0002\u0017\r|gN\\'b]\u0006<WM]\u000b\u0003\u0003'\u00032A[AK\u0013\r\t9*\u0017\u0002!\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\u0007d_:tW*\u00198bO\u0016\u0014\b%\u0001\bgKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005}\u0005c\u00016\u0002\"&\u0019\u00111U-\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\u0013M\u0016$8\r[3s\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002x\u0005%\u0006\"CA@5\u0005\u0005\t\u0019AAP\u0003=1W\r^2iKJl\u0015M\\1hKJ\u0004\u0013a\u00043fgR\fE-\\5o\u00072LWM\u001c;\u0016\u0005\u0005E\u0006\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003w\u0013\u0018aB2mS\u0016tGo]\u0005\u0005\u0003\u007f\u000b)LA\u0003BI6Lg.A\neKN$\u0018\tZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002x\u0005\u0015\u0007\"CA@;\u0005\u0005\t\u0019AAY\u0003A!Wm\u001d;BI6Lgn\u00117jK:$\b%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u001b\u00042AYAh\u0013\r\t\tn\u0019\u0002\u0004\u0013:$\u0018!\u00058v[B\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011qOAl\u0011%\ty\bIA\u0001\u0002\u0004\ti-\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw-\u0006\u0002\u0002`B\u0019!.!9\n\u0007\u0005\r\u0018LA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\fQc\u00197vgR,'\u000fT5oW\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002x\u0005%\b\"CA@G\u0005\u0005\t\u0019AAp\u0003I\u0019G.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005]\u0004fA\u0013\u0002tB!\u0011Q\u001fB\u0002\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018aA1qS*!\u0011Q`A\u0000\u0003\u001dQW\u000f]5uKJT1A!\u0001v\u0003\u0015QWO\\5u\u0013\u0011\u0011)!a>\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1#1\u0002\t\u0005\u0003k\u0014i!\u0003\u0003\u0003\u0010\u0005](!C!gi\u0016\u0014X)Y2i\u0003I!Xm\u001d;NKR\fG-\u0019;b)>\u0004\u0018nY:)\u0007\u001d\u0012)\u0002\u0005\u0003\u0002v\n]\u0011\u0002\u0002B\r\u0003o\u0014A\u0001V3ti\u0006\u0001C/Z:u\u0005\u0006\u001c7n^1sIN{WO]2f\u000bB|7\r\u001b(p)>\u0004\u0018nY%eQ\rA#QC\u0001'i\u0016\u001cHOQ1dW^\f'\u000fZ*pkJ\u001cW-\u00129pG\"tunU8ve\u000e,Gk\u001c9jG&#\u0007fA\u0015\u0003\u0016\u0005!C/Z:u\u0005\u0006\u001c7n^1sIN{WO]2f\u000bB|7\r\u001b(p\t\u0016\u001cH\u000fV8qS\u000eLE\rK\u0002+\u0005+\tq\u0005^3ti\n\u000b7m[<be\u0012\u001cv.\u001e:dK\u0016\u0003xn\u00195ES\u001a4WM]3oiR{\u0007/[2JI\"\u001a1F!\u0006\u0002EQ,7\u000f\u001e\"bG.<\u0018M\u001d3T_V\u00148-Z#q_\u000eD7+Y7f)>\u0004\u0018nY%eQ\ra#QC\u0001\u0018i\u0016\u001cHOQ1dW^\f'\u000fZ*pkJ\u001cW-\u00129pG\"$B\"a\u001e\u00034\t]\"1\bB\u001f\u0005\u0003BqA!\u000e.\u0001\u0004\ti-A\u0006t_V\u00148-Z#q_\u000eD\u0007b\u0002B\u001d[\u0001\u0007\u0011QZ\u0001\nI\u0016\u001cH/\u00129pG\"Dq!!\b.\u0001\u0004\t\t\u0003C\u0004\u0003@5\u0002\r!!\t\u0002\u0017\u0011,7\u000f\u001e+pa&\u001c\u0017\n\u001a\u0005\b\u0005\u0007j\u0003\u0019\u0001B#\u0003e)\u0007\u0010]3di\u0016$W*\u001b:s_J4\u0015-\u001b7ve\u0016$\u0016\u0010]3\u0011\u000b\t\u00149Ea\u0013\n\u0007\t%3M\u0001\u0004PaRLwN\u001c\t\u0004U\n5\u0013b\u0001B(3\n\tR*\u001b:s_J4\u0015-\u001b7ve\u0016$\u0016\u0010]3\u0002%Q,7\u000f\u001e$fi\u000eDWM\u001d+ie\u0016\fGm\u001d\u0015\u0004]\tU\u0011a\u0006;fgR\fE\rZ*pkJ\u001cW\rU1si&$\u0018n\u001c8tQ\ry#QC\u0001\u0010i\u0016\u001cHOU3d_:4\u0017nZ;sK\"\u001a\u0001G!\u0006\u00021Q,7\u000f\u001e)bkN,GMR3uG\",'o\u0015;beR,\b\u000fK\u00022\u0005+\tq\u0003^3ti:{G/\u001b4z%\u0016\fG-\u001f$pe\u001a+Go\u00195)\u0007I\u0012)\"\u0001\fuKN$8k\\;sG\u0016tu\u000e^!wC&d\u0017M\u00197fQ\r\u0019$QC\u0001%i\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ti\u0006$XmU8ve\u000e,gj\u001c;Bm\u0006LG.\u00192mK\"\u001aAG!\u0006\u0002uQ,7\u000f\u001e)beRLG/[8o'R\fG/Z*pkJ\u001cWMT8u\u0003Z\f\u0017\u000e\\1cY\u0016$v\u000e]5d\u001d>$\u0018J\\'fi\u0006$\u0017\r^1P]\u000e,\u0007fA\u001b\u0003\u0016\u0005\u0001E/Z:u!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f'>,(oY3O_R\fe/Y5mC\ndW\rV8qS\u000etu\u000e^%o\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fV5nK>,H\u000fK\u00027\u0005+\tA\u0005^3tiB\u000b'\u000f^5uS>t7\u000b^1uKR{\u0007/[2O_RLe.T3uC\u0012\fG/\u0019\u0015\u0004o\tU\u0011\u0001\n;fgR\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cv.\u001e:dKR{\u0007/[2EK2,G/\u001a3)\u0007a\u0012)\"\u0001\u001cuKN$\b+\u0019:uSRLwN\\*uCR,7k\\;sG\u0016tu\u000e^!wC&d\u0017M\u00197f'>,(oY3U_BL7\rR3mKR,G\rK\u0002:\u0005+\t1D^3sS\u001aL\b+\u0019:uSRLwN\u001c$bS2,(/Z*uCR,GC\u0002BC\u0005\u0017\u00139\u000bE\u0002k\u0005\u000fK1A!#Z\u0005E\u0001\u0016M\u001d;ji&|g.\u00118e'R\fG/\u001a\u0005\b\u0005\u001bS\u0004\u0019\u0001BH\u0003!1\u0017-\u001b7ve\u0016\u001c\bC\u0002BI\u0005C\u0013YE\u0004\u0003\u0003\u0014\nue\u0002\u0002BK\u00057k!Aa&\u000b\u0007\teu,\u0001\u0004=e>|GOP\u0005\u0002I&\u0019!qT2\u0002\u000fA\f7m[1hK&!!1\u0015BS\u0005\u0011a\u0015n\u001d;\u000b\u0007\t}5\rC\u0004\u0003*j\u0002\rAa+\u0002/\u0015D\b/Z2u!\u0016\u00148/[:uK:$h)Y5mkJ,\u0007c\u00012\u0003.&\u0019!qV2\u0003\u000f\t{w\u000e\\3b]\u0006)C/Z:u'V\u001c7-Z:tMVdG*\u001b8lK\u0012dU-\u00193fe\u0016\u0003xn\u00195Va\u0012\fG/\u001a\u0015\u0004w\tU\u0011!\t;fgR4\u0015-\u001b7fI2Kgn[3e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00169eCR,\u0007f\u0001\u001f\u0003\u0016\u0005aC/Z:u+:,\u0007\u0010]3di\u0016$WI\u001d:pe&sG*\u001b8lK\u0012dU-\u00193fe\u0016\u0003xn\u00195Va\u0012\fG/\u001a\u0015\u0004{\tU\u0011!\b<fe&4\u0017\u0010T5oW\u0016$G*Z1eKJ,\u0005o\\2i+B$\u0017\r^3\u0015\r\u0005]$\u0011\u0019Bi\u0011\u001d\u0011\u0019M\u0010a\u0001\u0005\u000b\f1\"\u001e9eCR,WI\u001d:peB!!q\u0019Bg\u001b\t\u0011IM\u0003\u0003\u0003L\u0006\u0015\u0012\u0001\u00039s_R|7m\u001c7\n\t\t='\u0011\u001a\u0002\u0007\u000bJ\u0014xN]:\t\u000f\tMg\b1\u0001\u0003,\u0006\tR\r\u001f9fGRd\u0015N\\6GC&dWO]3\u0002?Q,7\u000f^*vG\u000e,7o\u001d4vY2Kgn\u001b$bS2,(/Z+qI\u0006$X\rK\u0002@\u0005+\t1\u0004^3ti\u001a\u000b\u0017\u000e\\3e\u0019&t7NR1jYV\u0014X-\u00169eCR,\u0007f\u0001!\u0003\u0016\u00059B/Z:u)>|W*\u00198z\u000bB|7\r[+qI\u0006$Xm\u001d\u0015\u0004\u0003\nU\u0011A\n;fgRtu.T3uC\u0012\fG/Y+qI\u0006$XMR8s\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]\"\u001a!I!\u0006\u0002/Y,'/\u001b4z\u0019&t7NR1jYV\u0014X-\u00169eCR,G\u0003BA<\u0005SDqAa1D\u0001\u0004\u0011)-\u0001\rde\u0016\fG/\u001a'j].4U\r^2iKJl\u0015M\\1hKJ$B!a(\u0003p\"9!\u0011\u001f#A\u0002\tM\u0018!\u00029s_B\u001c\bcA?\u0003v&\u0019!q\u001f@\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\u0019\u0005]$Q`B\u0011\u0007K\u0019Yc!\r\t\u000f\t}X\t1\u0001\u0004\u0002\u00051Ao\u001c9jGN\u0004\u0002ba\u0001\u0004\n\r511D\u0007\u0003\u0007\u000bQ1aa\u0002d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007\u0017\u0019)AA\u0002NCB\u0004Baa\u0004\u0004\u00189!1\u0011CB\n!\r\u0011)jY\u0005\u0004\u0007+\u0019\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\re!bAB\u000bGB!\u0011\u0011CB\u000f\u0013\u0011\u0019y\"a\u0005\u0003\u000f%sG/Z4fe\"911E#A\u0002\u00055\u0017!\u00057j].,G\rT3bI\u0016\u0014X\t]8dQ\"I1qE#\u0011\u0002\u0003\u00071\u0011F\u0001\u0007KJ\u0014xN]:\u0011\u0011\r\r1\u0011BB\u0007\u0005\u000bD\u0011b!\fF!\u0003\u0005\raa\f\u0002\u0011Q|\u0007/[2JIN\u0004\u0002ba\u0001\u0004\n\r5\u0011\u0011\u0005\u0005\n\u0007g)\u0005\u0013!a\u0001\u0007_\tab]8ve\u000e,Gk\u001c9jG&#7/\u0001\rva\u0012\fG/Z'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"a!\u000f+\t\r%21H\u0016\u0003\u0007{\u0001Baa\u0010\u0004J5\u00111\u0011\t\u0006\u0005\u0007\u0007\u001a)%A\u0005v]\u000eDWmY6fI*\u00191qI2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004L\r\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006AR\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rE#\u0006BB\u0018\u0007w\t\u0001$\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00136\u0003%\u0019X\r^;q\u001b>\u001c7\u000e\u0006\b\u0002x\re3\u0011NB:\u0007k\u001aIh! \t\u000f\rm\u0013\n1\u0001\u0004^\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0007?\u001a)'\u0004\u0002\u0004b)\u001911M/\u0002\u000f\rdWo\u001d;fe&!1qMB1\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0004l%\u0003\ra!\u001c\u0002\u0005Q\u0004\b\u0003BA\u0012\u0007_JAa!\u001d\u0002&\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"CB\u0012\u0013B\u0005\t\u0019AAg\u0011%\u00199(\u0013I\u0001\u0002\u0004\ti-A\bok6,\u0005o\\2i+B$\u0017\r^3t\u0011%\u0019Y(\u0013I\u0001\u0002\u0004\u0011Y+A\ndY\u0016\f'o\u00144gg\u0016$8\u000fU3oI&tw\rC\u0005\u0004\u0000%\u0003\n\u00111\u0001\u0002\"\u0005iA.\u001b8lK\u0012$v\u000e]5d\u0013\u0012\f1c]3ukBlunY6%I\u00164\u0017-\u001e7uIM*\"a!\"+\t\u0005571H\u0001\u0014g\u0016$X\u000f]'pG.$C-\u001a4bk2$H\u0005N\u0001\u0014g\u0016$X\u000f]'pG.$C-\u001a4bk2$H%N\u000b\u0003\u0007\u001bSCAa+\u0004<\u0005\u00192/\u001a;va6{7m\u001b\u0013eK\u001a\fW\u000f\u001c;%mU\u001111\u0013\u0016\u0005\u0003C\u0019Y$\u0001\u0006wKJLg-_'pG.$\u0002\"a\u001e\u0004\u001a\u000em5Q\u0014\u0005\b\u00077r\u0005\u0019AB/\u0011%\u00199H\u0014I\u0001\u0002\u0004\ti\rC\u0005\u0004|9\u0003\n\u00111\u0001\u0003,\u0006!b/\u001a:jMflunY6%I\u00164\u0017-\u001e7uII\nAC^3sS\u001aLXj\\2lI\u0011,g-Y;mi\u0012\u001a\u0014AF:fiV\u0004h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012lunY6\u0015\r\u0005]4qUBY\u0011\u001d\u0019I+\u0015a\u0001\u0007W\u000bQBZ3uG\",'\u000f\u00165sK\u0006$\u0007c\u00016\u0004.&\u00191qV-\u00031\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0005\u00044F\u0003\n\u00111\u0001\u00046\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\r=1qWB7\u0013\u0011\u0019Il!\u0007\u0003\u0007M+G/\u0001\u0011tKR,\bOR3uG\",'\u000f\u00165sK\u0006$Wj\\2lI\u0011,g-Y;mi\u0012\u0012TCAB`U\u0011\u0019)la\u000f\u0002\u001d5,G/\u00193bi\u0006$v\u000e]5dgV\u00111Q\u0019\t\u0007\u0007\u000f\u001ci-a\u0004\u000e\u0005\r%'\u0002BBf\u0007\u000b\t\u0011\"[7nkR\f'\r\\3\n\t\re6\u0011Z\u0001\u0016[\u0016$\u0018\rZ1uCJ+gM]3tQRC'/Z1e+\t\u0019\u0019\u000eE\u0002k\u0007+L1aa6Z\u0005e\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b)\"\u0014X-\u00193\u0002CM$\u0018M\u001d;NKR\fG-\u0019;b)\"\u0014X-\u00193B]\u0012\fE\r\u001a'jgR,g.\u001a:\u0015\t\u0005]4Q\u001c\u0005\b\u0007?,\u0006\u0019ABq\u0003!a\u0017n\u001d;f]\u0016\u0014\bc\u00016\u0004d&\u00191Q]-\u0003!5+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014\u0018aD7fi\u0006$\u0017\r^1DYV\u001cH/\u001a:\u0016\u0005\r-\b\u0003BA\u0012\u0007[LAaa<\u0002&\t91\t\\;ti\u0016\u0014\u0018\u0001\u0007<fe&4\u0017PR3uG\",'/T1oC\u001e,'\u000fT8dW\u0002")
public class ClusterLinkFetcherManagerTest {
    private final MetadataVersion ibp = MetadataVersion.latest();
    private final UUID kafka$server$link$ClusterLinkFetcherManagerTest$$linkId = UUID.randomUUID();
    private final String kafka$server$link$ClusterLinkFetcherManagerTest$$linkName;
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherManagerTest$$metrics = new ClusterLinkMetrics(this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), (LinkMode)LinkMode.Destination$.MODULE$, null, (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final MockTime kafka$server$link$ClusterLinkFetcherManagerTest$$time = new MockTime();
    private final ReplicaManager kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
    private KafkaConfig kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig;
    private final ClusterLinkManager kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkDestConnectionManager kafka$server$link$ClusterLinkFetcherManagerTest$$connManager = (ClusterLinkDestConnectionManager)Mockito.mock(ClusterLinkDestConnectionManager.class);
    private ClusterLinkFetcherManager kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager;
    private Admin kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient;
    private int kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions = 2;
    private ClusterLinkConfig kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig;

    public MetadataVersion ibp() {
        return this.ibp;
    }

    public UUID kafka$server$link$ClusterLinkFetcherManagerTest$$linkId() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId;
    }

    public String kafka$server$link$ClusterLinkFetcherManagerTest$$linkName() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherManagerTest$$metrics() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics;
    }

    public MockTime kafka$server$link$ClusterLinkFetcherManagerTest$$time() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$time;
    }

    public ReplicaManager kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager;
    }

    private AbstractLog log() {
        return this.log;
    }

    public KafkaConfig kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig;
    }

    private void kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig_$eq(KafkaConfig x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig = x$1;
    }

    public ClusterLinkManager kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager;
    }

    public ClusterLinkDestConnectionManager kafka$server$link$ClusterLinkFetcherManagerTest$$connManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager;
    }

    public ClusterLinkFetcherManager kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager;
    }

    private void kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager_$eq(ClusterLinkFetcherManager x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager = x$1;
    }

    public Admin kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient;
    }

    private void kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient_$eq(Admin x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient = x$1;
    }

    public int kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions;
    }

    private void kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(int x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions = x$1;
    }

    public ClusterLinkConfig kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig;
    }

    private void kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProps.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), this.ibp().shortVersion());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig_$eq(KafkaConfig$.MODULE$.fromProps(brokerProps));
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", "localhost:1234");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics().startup();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient_$eq((Admin)Mockito.mock(Admin.class));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager_$eq(this.createLinkFetcherManager(linkProps));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().initializeMetadata();
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.log().localLogEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.log().logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager().fetchResponseSize((ClusterLinkConfig)ArgumentMatchers.any())).thenReturn((Object)new FetchResponseSize(10, 10));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager().updateDynamicFetchSize();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            this.verifyFetcherManagerLock();
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager().reverseConnectionProvider((NetworkClient)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
    }

    @AfterEach
    public void tearDown() {
        if (this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager() != null) {
            this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics().shutdown();
    }

    @Test
    public void testMetadataTopics() {
        String topic1 = "testTopic1";
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        Partition partition1_0 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition1_0, tp1_0, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_0})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.metadataTopics());
        Assertions.assertEquals((long)0L, (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds()));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.metadataTopics());
        this.verifyMock(partition1_0, this.verifyMock$default$2(), this.verifyMock$default$3());
        String topic2 = "testTopic2";
        TopicPartition tp2_4 = new TopicPartition(topic2, 4);
        Partition partition2_4 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition2_4, tp2_4, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition2_4})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.verifyMock(partition2_4, this.verifyMock$default$2(), this.verifyMock$default$3());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), false);
        Assertions.assertEquals(Collections.singletonList(topic2), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics());
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        Partition partition1_1 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition1_1, tp1_1, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_1})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.verifyMock(partition1_1, this.verifyMock$default$2(), this.verifyMock$default$3());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_0})));
        Assertions.assertEquals((int)2, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
    }

    @Test
    public void testBackwardSourceEpochNoTopicId() {
        this.testBackwardSourceEpoch(4, 5, Uuid.ZERO_UUID, Uuid.ZERO_UUID, (Option<MirrorFailureType>)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$));
    }

    @Test
    public void testBackwardSourceEpochNoSourceTopicId() {
        this.testBackwardSourceEpoch(4, 5, Uuid.ZERO_UUID, this.sourceTopicId(), (Option<MirrorFailureType>)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$));
    }

    @Test
    public void testBackwardSourceEpochNoDestTopicId() {
        this.testBackwardSourceEpoch(4, 5, this.sourceTopicId(), Uuid.ZERO_UUID, (Option<MirrorFailureType>)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$));
    }

    @Test
    public void testBackwardSourceEpochDifferentTopicId() {
        this.testBackwardSourceEpoch(4, 5, this.sourceTopicId(), Uuid.randomUuid(), (Option<MirrorFailureType>)new Some((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$));
    }

    @Test
    public void testBackwardSourceEpochSameTopicId() {
        this.testBackwardSourceEpoch(4, 5, this.sourceTopicId(), this.sourceTopicId(), (Option<MirrorFailureType>)None$.MODULE$);
    }

    private void testBackwardSourceEpoch(int sourceEpoch, int destEpoch, Uuid sourceTopicId, Uuid destTopicId, Option<MirrorFailureType> expectedMirrorFailureType) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).updateLinkedLeaderEpoch(ArgumentMatchers.anyInt(), (Function1)ArgumentMatchers.any());
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        int x$4 = 0;
        boolean x$6 = this.setupMock$default$5();
        this.setupMock(partition, tp, destEpoch, x$4, x$6, destTopicId);
        Map x$9 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)destTopicId)}));
        Map x$10 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)sourceTopicId)}));
        Map<String, Errors> x$11 = this.updateMetadata$default$3();
        this.updateMetadata((Map<String, Integer>)topics, sourceEpoch, x$11, (Map<String, Uuid>)x$9, (Map<String, Uuid>)x$10);
        this.verifyMock(partition, 0, this.verifyMock$default$3());
        ConcurrentHashMap linkedPartitions = (ConcurrentHashMap)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"linkedPartitions");
        Assertions.assertEquals(expectedMirrorFailureType, (Object)((PartitionAndState)linkedPartitions.get(tp)).lastFailureType());
    }

    @Test
    public void testFetcherThreads() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 1, 1, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 5, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.verifyMock(partition, 1, this.verifyMock$default$3());
        this.setupMock(partition, tp, 5, 0, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 5, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.verifyMock(partition, 0, this.verifyMock$default$3());
        this.setupMock(partition, tp, 5, 1, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 6, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.verifyMock(partition, 0, this.verifyMock$default$3());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})), true);
        Assertions.assertEquals(Collections.singletonList(topic), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdownIdleFetcherThreads();
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.setupMock(partition, tp, 6, 0, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 6, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).nonEmpty());
        this.verifyMock(partition, 0, this.verifyMock$default$3());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager_$eq(null);
    }

    @Test
    public void testAddSourcePartitions() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        CreatePartitionsResult createPartitionsResult = (CreatePartitionsResult)Mockito.mock(CreatePartitionsResult.class);
        Mockito.when((Object)createPartitionsResult.values()).thenReturn(Collections.singletonMap(topic, KafkaFuture.completedFuture(null)));
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient().createPartitions((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)createPartitionsResult);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(1);
        Integer numSourcePartitions = Predef$.MODULE$.int2Integer(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).isDefined());
        Assertions.assertTrue((boolean)((AbstractFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).get()).fetchState(tp).isDefined());
        Assertions.assertEquals((Object)new Some((Object)this.sourceTopicId()), (Object)((PartitionFetchState)((AbstractFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).get()).fetchState(tp).get()).topicId());
        numSourcePartitions = Predef$.MODULE$.int2Integer(4);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        ArgumentCaptor capturedRequests = ArgumentCaptor.forClass(java.util.Map.class);
        ((Admin)Mockito.verify((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient())).createPartitions((java.util.Map)capturedRequests.capture());
        Assertions.assertEquals((int)1, (int)capturedRequests.getAllValues().size());
        java.util.Map captured1 = (java.util.Map)capturedRequests.getAllValues().get(0);
        Assertions.assertEquals((int)1, (int)captured1.size());
        Assertions.assertEquals((int)4, (int)((NewPartitions)captured1.get(topic)).totalCount());
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        capturedRequests = ArgumentCaptor.forClass(java.util.Map.class);
        ((Admin)Mockito.verify((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), (VerificationMode)Mockito.times((int)2))).createPartitions((java.util.Map)capturedRequests.capture());
        Assertions.assertEquals((int)2, (int)capturedRequests.getAllValues().size());
        java.util.Map captured2 = (java.util.Map)capturedRequests.getAllValues().get(1);
        Assertions.assertEquals((int)1, (int)captured2.size());
        Assertions.assertEquals((int)4, (int)((NewPartitions)captured2.get(topic)).totalCount());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(4);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        capturedRequests = ArgumentCaptor.forClass(java.util.Map.class);
        ((Admin)Mockito.verify((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), (VerificationMode)Mockito.times((int)2))).createPartitions((java.util.Map)capturedRequests.capture());
        Assertions.assertEquals((int)2, (int)capturedRequests.getAllValues().size());
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReconfigure() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startMetadataThread();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testReconfigure$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFetcherManagerTest.$anonfun$testReconfigure$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 2, 1, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 2, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        ClusterLinkFetcherThread fetcherThread1 = (ClusterLinkFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head();
        ClusterLinkMetadata metadata1 = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata();
        ClusterLinkMetadataThread metadataThread1 = this.metadataRefreshThread();
        ClusterLinkNetworkClient metadataClient1 = metadataThread1.clusterLinkClient();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(fetcherThread1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, 0)}))));
        ClusterLinkNetworkClient fetcherClient1 = fetcherThread1.clusterLinkClient();
        ((ClusterLinkNetworkClient)Mockito.doNothing().when((Object)fetcherClient1)).reconfigure((java.util.Map)ArgumentMatchers.any());
        HashMap<String, String> newDynamicProps = new HashMap<String, String>();
        newDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newDynamicProps.put("ssl.truststore.location", "truststore.jks");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newDynamicProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.truststore.location"})));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient1)).reconfigure((java.util.Map)ArgumentMatchers.any());
        HashMap newPeriodicMigrationProps = new HashMap();
        newDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newDynamicProps.put(ClusterLinkConfig$.MODULE$.AclSyncMsProp(), "120000");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newPeriodicMigrationProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.AclSyncMsProp()})));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient1)).reconfigure((java.util.Map)ArgumentMatchers.any());
        HashMap<String, String> newNonDynamicProps = new HashMap<String, String>();
        newNonDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newNonDynamicProps.put("bootstrap.servers", "localhost:5678");
        Mockito.reset((Object[])new ClusterLinkNetworkClient[]{fetcherThread1.clusterLinkClient()});
        ((ClusterLinkNetworkClient)Mockito.doNothing().when((Object)fetcherClient1)).close();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newNonDynamicProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertNotSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        this.updateMetadata((Map<String, Integer>)topics, 2, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertNotSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertFalse((boolean)metadataClient1.networkClient().active(), (String)"Metadata client not closed");
        ClusterLinkMetadataThread metadataThread2 = this.metadataRefreshThread();
        Assertions.assertNotSame((Object)metadataThread1, (Object)metadataThread2);
        Assertions.assertNotSame((Object)metadataClient1, (Object)metadataThread2.clusterLinkClient());
        Assertions.assertTrue((boolean)metadataThread2.clusterLinkClient().networkClient().active(), (String)"Metadata client not active");
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient1)).close();
        ClusterLinkFetcherThread fetcherThread2 = (ClusterLinkFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head();
        ClusterLinkNetworkClient metadataClient2 = metadataThread2.clusterLinkClient();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(fetcherThread2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, 0)}))));
        ClusterLinkNetworkClient fetcherClient2 = fetcherThread2.clusterLinkClient();
        ((ClusterLinkNetworkClient)Mockito.doNothing().when((Object)fetcherClient2)).reconfigure((java.util.Map)ArgumentMatchers.any());
        HashMap<String, String> pausedProps = new HashMap<String, String>();
        pausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        pausedProps.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        Mockito.reset((Object[])new ClusterLinkNetworkClient[]{fetcherThread2.clusterLinkClient()});
        ((ClusterLinkNetworkClient)Mockito.doNothing().when((Object)fetcherClient2)).close();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(pausedProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertFalse((boolean)metadataClient2.networkClient().active(), (String)"Metadata client not closed");
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient2)).close();
        HashMap<String, String> newNonDynamicButPausedProps = new HashMap<String, String>();
        newNonDynamicButPausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newNonDynamicButPausedProps.put("bootstrap.servers", "localhost:6789");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newNonDynamicButPausedProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient2)).close();
        HashMap<String, String> unpausedProps = new HashMap<String, String>();
        unpausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        unpausedProps.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "false");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(unpausedProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        ClusterLinkMetadataThread metadataThread3 = this.metadataRefreshThread();
        Assertions.assertNotSame((Object)metadataThread2, (Object)metadataThread3);
        Assertions.assertTrue((boolean)metadataThread3.clusterLinkClient().networkClient().active(), (String)"Metadata client not active");
        ((ClusterLinkNetworkClient)Mockito.verify((Object)fetcherClient2)).close();
    }

    @Test
    public void testPausedFetcherStartup() {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        props.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager_$eq(this.createLinkFetcherManager(props));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startup();
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        boolean x$3 = true;
        int x$4 = this.setupMock$default$3();
        int x$5 = this.setupMock$default$4();
        Uuid x$6 = this.setupMock$default$6();
        this.setupMock(partition, tp, x$4, x$5, x$3, x$6);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})), false);
        CreatePartitionsResult createPartitionsResult = (CreatePartitionsResult)Mockito.mock(CreatePartitionsResult.class);
        Mockito.when((Object)createPartitionsResult.values()).thenReturn(Collections.singletonMap(topic, KafkaFuture.completedFuture(null)));
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient().createPartitions((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)createPartitionsResult);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        boolean x$8 = true;
        int x$9 = this.verifyMock$default$2();
        this.verifyMock(partition, x$9, x$8);
    }

    @Test
    public void testNotifyReadyForFetch() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        IntRef notificationCount = IntRef.create((int)0);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 1000));
        ClusterLinkLeaderEndPoint leader = ClusterLinkLeaderEndPoint$.MODULE$.apply(new LogContext(), (Time)this.kafka$server$link$ClusterLinkFetcherManagerTest$$time(), mockBlockingSend, this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), null, this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics());
        ClusterLinkFetcherThread fetcherThread = new ClusterLinkFetcherThread(this, leader, tp, notificationCount){
            private final TopicPartition tp$1;
            private final IntRef notificationCount$1;

            public Set<TopicPartition> partitions() {
                return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1}));
            }

            public void notifyReadyForFetch() {
                super.notifyReadyForFetch();
                ++this.notificationCount$1.elem;
            }
            {
                this.tp$1 = tp$1;
                this.notificationCount$1 = notificationCount$1;
                super("thread-0", 0, leader$1, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig(), new ClusterLinkMetadata($outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), new FailedPartitions(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), null, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics(), (Time)new MockTime(), (Function0)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final FetchResponseSize apply() {
                        return new FetchResponseSize(100, 1000);
                    }
                }, (ClusterLinkNetworkClient)Mockito.mock(ClusterLinkNetworkClient.class), (Option)None$.MODULE$, (Option)None$.MODULE$);
            }
        };
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 1, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().put(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().keySet().head(), (Object)fetcherThread);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().updateFetcherThread(tp, (Option)new Some((Object)fetcherThread));
        this.setupLog$1(10L, 5L);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        Assertions.assertEquals((int)0, (int)notificationCount.elem);
        this.setupLog$1(10L, 10L);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        Assertions.assertEquals((int)1, (int)notificationCount.elem);
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceNotAvailable() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        AtomicReference currentCluster = new AtomicReference();
        this.startMetadataThreadAndAddListener(new MetadataListener(this, currentCluster){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;
            private final AtomicReference currentCluster$1;

            public void onMetadataFailure(Exception e) {
                MetadataListener.onMetadataFailure$((MetadataListener)this, (Exception)e);
            }

            public final void onNewMetadata(Cluster newCluster) {
                ClusterLinkFetcherManagerTest.kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$testSourceNotAvailable$1(newCluster, this.currentCluster$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentCluster$1 = currentCluster$1;
                MetadataListener.$init$((MetadataListener)this);
            }
        });
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertNull(currentCluster.get(), (String)"Unexpected metadata update");
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 2, 1, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 2, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$3(currentCluster)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onAvailabilityChange(false);
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.updateMetadata((Map<String, Integer>)topics, 2, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onAvailabilityChange(true);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$5(currentCluster)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testPartitionStateSourceNotAvailable() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.LinkNotAvailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.LinkNotAvailable$.MODULE$, (List)Nil$.MODULE$)), false);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.LinkNotAvailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableTopicNotInMetadataOnce() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.LinkNotAvailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)Nil$.MODULE$)), false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure < (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableTopicNotInMetadataForTimeout() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.LinkNotAvailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)Nil$.MODULE$))), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateTopicNotInMetadata() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)Nil$.MODULE$)), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceTopicDeleted() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$, (List)Nil$.MODULE$), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure < (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableSourceTopicDeleted() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)new .colon.colon((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$, (List)new .colon.colon((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$, (List)Nil$.MODULE$)), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    private PartitionAndState verifyPartitionFailureState(List<MirrorFailureType> failures, boolean expectPersistentFailure) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        if (expectPersistentFailure) {
            ((Partition)Mockito.doNothing().when((Object)partition)).failClusterLink((Function1)ArgumentMatchers.any());
        }
        ConcurrentHashMap linkedPartitions = (ConcurrentHashMap)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"linkedPartitions");
        AtomicReference currentCluster = new AtomicReference();
        this.startMetadataThreadAndAddListener(new MetadataListener(this, currentCluster){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;
            private final AtomicReference currentCluster$2;

            public void onMetadataFailure(Exception e) {
                MetadataListener.onMetadataFailure$((MetadataListener)this, (Exception)e);
            }

            public final void onNewMetadata(Cluster newCluster) {
                ClusterLinkFetcherManagerTest.kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$verifyPartitionFailureState$1(newCluster, this.currentCluster$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentCluster$2 = currentCluster$2;
                MetadataListener.$init$((MetadataListener)this);
            }
        });
        Assertions.assertEquals(Collections.emptyMap(), (Object)linkedPartitions);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertEquals(Collections.singleton(tp), (Object)linkedPartitions.keySet());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionAndState)linkedPartitions.get(tp)).apiFailureType());
        Assertions.assertEquals((long)0L, (long)((PartitionAndState)linkedPartitions.get(tp)).failureStartMs().get());
        Assertions.assertNull(currentCluster.get(), (String)"Unexpected metadata update");
        failures.foreach((Function1 & Serializable & scala.Serializable)failureType -> {
            ClusterLinkFetcherManagerTest.$anonfun$verifyPartitionFailureState$3(this, tp, linkedPartitions, failureType);
            return BoxedUnit.UNIT;
        });
        if (expectPersistentFailure) {
            ((Partition)Mockito.verify((Object)partition)).failClusterLink((Function1)ArgumentMatchers.any());
        }
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        return (PartitionAndState)linkedPartitions.get(tp);
    }

    @Test
    public void testSuccessfulLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.NONE, false);
    }

    @Test
    public void testFailedLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.OPERATION_NOT_ATTEMPTED, false);
    }

    @Test
    public void testUnexpectedErrorInLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.UNKNOWN_SERVER_ERROR, true);
    }

    private void verifyLinkedLeaderEpochUpdate(Errors updateError, boolean expectLinkFailure) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        ((Partition)Mockito.doNothing().when((Object)partition)).updateLinkedLeaderEpoch(ArgumentMatchers.anyInt(), (Function1)ArgumentMatchers.any());
        ((Partition)Mockito.doNothing().when((Object)partition)).linkedLeaderOffsetsPending(true);
        if (expectLinkFailure) {
            ((Partition)Mockito.doNothing().when((Object)partition)).failClusterLink((Function1)ArgumentMatchers.any());
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        sourceEpoch = 5;
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        long nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertTrue((nextMetadataUpdate > 1000L ? 1 : 0) != 0, (String)new StringBuilder(34).append("Unnecessary metadata update after ").append(nextMetadataUpdate).toString());
        ArgumentCaptor capturedRequests = ArgumentCaptor.forClass(Function1.class);
        ((Partition)Mockito.verify((Object)partition)).updateLinkedLeaderEpoch(ArgumentMatchers.anyInt(), (Function1)capturedRequests.capture());
        ((Function1)capturedRequests.getValue()).apply((Object)updateError);
        nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Errors errors = updateError;
        Errors errors2 = Errors.NONE;
        if (!(errors == null ? errors2 != null : !errors.equals(errors2)) || expectLinkFailure) {
            Assertions.assertTrue((nextMetadataUpdate > 1000L ? 1 : 0) != 0, (String)new StringBuilder(34).append("Unnecessary metadata update after ").append(nextMetadataUpdate).toString());
        } else {
            Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
        }
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        if (expectLinkFailure) {
            ((Partition)Mockito.verify((Object)partition)).failClusterLink((Function1)ArgumentMatchers.any());
        }
    }

    @Test
    public void testSuccessfulLinkFailureUpdate() {
        this.verifyLinkFailureUpdate(Errors.NONE);
    }

    @Test
    public void testFailedLinkFailureUpdate() {
        this.verifyLinkFailureUpdate(Errors.OPERATION_NOT_ATTEMPTED);
    }

    @Test
    public void testTooManyEpochUpdates() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager().onlinePartition(tp)).thenReturn((Object)new Some((Object)partition));
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
        this.setupMock(partition, tp, 1, 1, this.setupMock$default$5(), this.setupMock$default$6());
        this.updateMetadata((Map<String, Integer>)topics, 1, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock((ClusterLinkFetcherThread)((Tuple2)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().head())._2(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 22).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)epoch -> {
            this.setupMock(partition, tp, epoch, 1, this.setupMock$default$5(), this.setupMock$default$6());
            this.updateMetadata((Map<String, Integer>)topics, epoch + 1, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        });
        Assertions.assertEquals(Collections.singletonMap(tp, BoxesRunTime.boxToLong((long)0L)), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().waitingPartitions());
    }

    @Test
    public void testNoMetadataUpdateForFailedPartition() {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(1);
        String topic = "testTopic1";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().updateRequested()));
        ConcurrentHashMap linkedPartitions = (ConcurrentHashMap)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"linkedPartitions");
        ((PartitionAndState)linkedPartitions.get(tp)).apiFailureType_$eq((Option)new Some((Object)MirrorFailureType.TopicAuthorizationFailed$.MODULE$));
        ((PartitionAndState)linkedPartitions.get(tp)).failureStartMs().set(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() - 1L);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), 1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Errors.TOPIC_AUTHORIZATION_FAILED)}))), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().updateRequested()));
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
    }

    private void verifyLinkFailureUpdate(Errors updateError) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition, tp, this.setupMock$default$3(), this.setupMock$default$4(), this.setupMock$default$5(), this.setupMock$default$6());
        ((Partition)Mockito.doNothing().when((Object)partition)).failClusterLink((Function1)ArgumentMatchers.any());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions_$eq(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.updateMetadata((Map<String, Integer>)Map$.MODULE$.empty(), -1, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        long nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)0))).failClusterLink((Function1)ArgumentMatchers.any());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().sleep((long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs());
        this.updateMetadata((Map<String, Integer>)Map$.MODULE$.empty(), -1, this.updateMetadata$default$3(), this.updateMetadata$default$4(), this.updateMetadata$default$5());
        ArgumentCaptor capturedRequests = ArgumentCaptor.forClass(Function1.class);
        ((Partition)Mockito.verify((Object)partition)).failClusterLink((Function1)capturedRequests.capture());
        Assertions.assertEquals((int)1, (int)capturedRequests.getAllValues().size());
        ((Function1)capturedRequests.getValue()).apply((Object)updateError);
        nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
        this.verifyMock(partition, this.verifyMock$default$2(), this.verifyMock$default$3());
    }

    private ClusterLinkFetcherManager createLinkFetcherManager(Properties props) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig_$eq(ClusterLinkConfig$.MODULE$.create((java.util.Map)props, ClusterLinkConfig$.MODULE$.create$default$2()));
        return new ClusterLinkFetcherManager(this){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;

            public ClusterLinkFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)Mockito.mock(ClusterLinkFetcherThread.class);
                this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(thread, this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock$default$2());
                return thread;
            }

            public int partitionCount(String topic) {
                return this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Time)$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$time(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig().interBrokerProtocolVersion().isTruncationOnFetchSupported(), ClusterLinkFetcherManager$.MODULE$.$lessinit$greater$default$15());
            }
        };
    }

    private void updateMetadata(Map<String, Integer> topics, int linkedLeaderEpoch, Map<String, Errors> errors, Map<String, Uuid> topicIds, Map<String, Uuid> sourceTopicIds) {
        ClusterLinkMetadata metadata = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata();
        java.util.Map metadataUpdateWithIds_topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(topicIds).asJava();
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith((String)"sourceCluster", (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(errors).asJava()), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(topics).asJava()), x$1 -> Predef$.MODULE$.int2Integer(linkedLeaderEpoch), MetadataResponse.PartitionMetadata::new, (short)ApiKeys.METADATA.latestVersion(), (java.util.Map)metadataUpdateWithIds_topicIds);
        metadata.update(metadata.updateVersion(), metadataResponse, false, this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onNewMetadata(TestUtils.clusterWith((int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(topics).asJava()), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(sourceTopicIds).asJava())));
    }

    private Map<String, Errors> updateMetadata$default$3() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private Map<String, Uuid> updateMetadata$default$4() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private Map<String, Uuid> updateMetadata$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private void setupMock(Partition partition, TopicPartition tp, int linkedLeaderEpoch, int numEpochUpdates, boolean clearOffsetsPending, Uuid linkedTopicId) {
        Mockito.reset((Object[])new Partition[]{partition});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.getLinkedTopicId()).thenReturn((Object)linkedTopicId);
        Mockito.when((Object)partition.getLinkedLeaderEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)linkedLeaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)10));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)this.log());
        Mockito.when((Object)partition.leaderLogIfLocal()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUnderMinIsr())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, false);
        if (numEpochUpdates > 0) {
            ((Partition)Mockito.doNothing().when((Object)partition)).updateLinkedLeaderEpoch(ArgumentMatchers.anyInt(), (Function1)ArgumentMatchers.any());
        }
        if (this.ibp().isTruncationOnFetchSupported()) {
            ((Partition)Mockito.doNothing().when((Object)partition)).linkedLeaderOffsetsPending(false);
            return;
        }
        if (numEpochUpdates > 0) {
            ((Partition)Mockito.doNothing().when((Object)partition)).linkedLeaderOffsetsPending(true);
            return;
        }
        if (clearOffsetsPending) {
            ((Partition)Mockito.doNothing().when((Object)partition)).linkedLeaderOffsetsPending(false);
        }
    }

    private int setupMock$default$3() {
        return 1;
    }

    private int setupMock$default$4() {
        return 0;
    }

    private boolean setupMock$default$5() {
        return false;
    }

    private Uuid setupMock$default$6() {
        return this.sourceTopicId();
    }

    private void verifyMock(Partition partition, int numEpochUpdates, boolean clearOffsetsPending) {
        if (numEpochUpdates > 0) {
            ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)numEpochUpdates))).updateLinkedLeaderEpoch(ArgumentMatchers.anyInt(), (Function1)ArgumentMatchers.any());
        }
        if (!this.ibp().isTruncationOnFetchSupported()) {
            if (numEpochUpdates > 0) {
                ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)numEpochUpdates))).linkedLeaderOffsetsPending(true);
                return;
            }
            if (clearOffsetsPending) {
                ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)1))).linkedLeaderOffsetsPending(false);
                return;
            }
        }
    }

    private int verifyMock$default$2() {
        return 0;
    }

    private boolean verifyMock$default$3() {
        return false;
    }

    public void kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(ClusterLinkFetcherThread fetcherThread, scala.collection.immutable.Set<TopicPartition> partitions) {
        Mockito.reset((Object[])new ClusterLinkFetcherThread[]{fetcherThread});
        InitialFetchState initialFetchState = (InitialFetchState)Mockito.mock(InitialFetchState.class);
        scala.collection.immutable.Map partitionAndOffsets = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)initialFetchState), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Mockito.when((Object)fetcherThread.partitionsAndOffsets()).thenReturn((Object)partitionAndOffsets);
        PartitionFetchState fetchState = (PartitionFetchState)Mockito.mock(PartitionFetchState.class);
        Mockito.when((Object)fetchState.topicId()).thenReturn((Object)new Some((Object)this.sourceTopicId()));
        Mockito.when((Object)fetcherThread.fetchState((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)fetchState));
        ClusterLinkNetworkClient fetcherClient = (ClusterLinkNetworkClient)Mockito.mock(ClusterLinkNetworkClient.class);
        Mockito.when((Object)fetcherThread.clusterLinkClient()).thenReturn((Object)fetcherClient);
        fetcherThread.shutdown();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            fetcherClient.close();
            return BoxedUnit.UNIT;
        });
        ClusterLinkLeaderEndPoint mockLeader = (ClusterLinkLeaderEndPoint)Mockito.mock(ClusterLinkLeaderEndPoint.class);
        Mockito.when((Object)fetcherThread.leader()).thenReturn((Object)mockLeader);
        Mockito.when((Object)mockLeader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 1000));
        Mockito.when((Object)fetcherThread.removePartitions((Set)ArgumentMatchers.any())).thenAnswer(invocation -> ((TraversableOnce)((SetLike)invocation.getArgument(0, Set.class)).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)fetchState), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public scala.collection.immutable.Set<TopicPartition> kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private scala.collection.immutable.Set<String> metadataTopics() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics()).asScala()).toSet();
    }

    private ClusterLinkMetadataThread metadataRefreshThread() {
        return (ClusterLinkMetadataThread)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"metadataRefreshThread");
    }

    /*
     * WARNING - void declaration
     */
    private void startMetadataThreadAndAddListener(MetadataListener listener) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startMetadataThread();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$startMetadataThreadAndAddListener$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFetcherManagerTest.$anonfun$startMetadataThreadAndAddListener$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.metadataRefreshThread().addListener(listener);
    }

    private Cluster metadataCluster() {
        return (Cluster)TestUtils.fieldValue((Object)this.metadataRefreshThread(), ClusterLinkMetadataThread.class, (String)"currentMetadataCluster");
    }

    private void verifyFetcherManagerLock() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(() -> Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().deadThreadCount()), BoxesRunTime.boxToInteger((int)0)).get(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$1(ClusterLinkFetcherManagerTest $this) {
        return $this.metadataCluster() != null;
    }

    public static final /* synthetic */ String $anonfun$testReconfigure$2() {
        return "Metadata not updated";
    }

    private final void setupLog$1(long leo, long hwm) {
        Mockito.reset((Object[])new AbstractLog[]{this.log()});
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.log().logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)leo));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.log().highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)hwm));
    }

    public static final /* synthetic */ void kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$testSourceNotAvailable$1(Cluster cluster, AtomicReference currentCluster$1) {
        currentCluster$1.set(cluster);
    }

    public static final /* synthetic */ boolean $anonfun$testSourceNotAvailable$3(AtomicReference currentCluster$1) {
        return currentCluster$1.getAndSet(null) != null;
    }

    public static final /* synthetic */ String $anonfun$testSourceNotAvailable$4() {
        return "Metadata not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testSourceNotAvailable$5(AtomicReference currentCluster$1) {
        return currentCluster$1.getAndSet(null) != null;
    }

    public static final /* synthetic */ String $anonfun$testSourceNotAvailable$6() {
        return "Metadata not updated";
    }

    public static final /* synthetic */ void kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$verifyPartitionFailureState$1(Cluster cluster, AtomicReference currentCluster$2) {
        currentCluster$2.set(cluster);
    }

    public static final /* synthetic */ void $anonfun$verifyPartitionFailureState$3(ClusterLinkFetcherManagerTest $this, TopicPartition tp$2, ConcurrentHashMap linkedPartitions$1, MirrorFailureType failureType) {
        $this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().sleep((long)$this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs());
        ClusterLinkFetcherManager qual$1 = $this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager();
        String x$3 = failureType.toString();
        boolean x$4 = qual$1.onPartitionLinkFailure$default$4();
        qual$1.onPartitionLinkFailure(tp$2, failureType, x$3, x$4);
        Assertions.assertNotEquals((long)0L, (long)((PartitionAndState)linkedPartitions$1.get(tp$2)).failureStartMs().get());
    }

    public static final /* synthetic */ boolean $anonfun$startMetadataThreadAndAddListener$1(ClusterLinkFetcherManagerTest $this) {
        return $this.metadataCluster() != null;
    }

    public static final /* synthetic */ String $anonfun$startMetadataThreadAndAddListener$2() {
        return "Metadata not updated";
    }

    public ClusterLinkFetcherManagerTest() {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName = "testLink";
    }
}

