/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.LinkMode;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.TestUtils$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000154A!\u0005\n\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0018\u0001A\u0003%a\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\r]\u0002\u0001\u0015!\u00032\u0011\u001dA\u0004A1A\u0005\neBaA\u0010\u0001!\u0002\u0013Q\u0004bB \u0001\u0005\u0004%I\u0001\u0011\u0005\u0007\t\u0002\u0001\u000b\u0011B!\t\u0013\u0015\u0003\u0001\u0019!a\u0001\n\u00131\u0005\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0003O\u0011%!\u0006\u00011A\u0001B\u0003&q\tC\u0003V\u0001\u0011\u0005a\u000bC\u0003e\u0001\u0011\u0005a\u000bC\u0003j\u0001\u0011\u0005a\u000bC\u0003l\u0001\u0011\u0005aKA\fDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\rV3ti*\u00111\u0003F\u0001\u0005Y&t7N\u0003\u0002\u0016-\u000511/\u001a:wKJT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003I\ta\u0001\\5oW&#W#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001B;uS2T\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t!Q+V%E\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011AGK\u0001\u0005Y\u0006tw-\u0003\u00027g\t11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0016\u0003i\u0002\"a\u000f\u001f\u000e\u0003QI!!\u0010\u000b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012!\u0011\t\u0003G\tK!a\u0011\n\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0002\u00135,G/\u00193bi\u0006\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002M\u0013\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\u0007fq\u0016\u001cW\u000f^8s?\u0012*\u0017\u000f\u0006\u0002P%B\u00111\u0004U\u0005\u0003#r\u0011A!\u00168ji\"91kCA\u0001\u0002\u00049\u0015a\u0001=%c\u0005IQ\r_3dkR|'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tq\n\u000b\u0002\u000e1B\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!a\u00181\u0002\u000b),h.\u001b;\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u0019'LA\u0005BMR,'/R1dQ\u0006\u0019B/Z:u%\u00164'/Z:i\u0019&\u001cH/\u001a8fe\"\u0012aB\u001a\t\u00033\u001eL!\u0001\u001b.\u0003\tQ+7\u000f^\u0001#i\u0016\u001cHOU3ge\u0016\u001c\b\u000eT5ti\u0016tWM]*z]\u000eD'o\u001c8ju\u0006$\u0018n\u001c8)\u0005=1\u0017A\u0005;fgRlU\r^1eCR\fGk\u001c9jGND#\u0001\u00054")
public class ClusterLinkMetadataTest {
    private final UUID linkId = UUID.randomUUID();
    private final String linkName;
    private final KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataTest$$metadata = new ClusterLinkMetadata(this.brokerConfig(), this.linkName(), this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L);
    private ExecutorService kafka$server$link$ClusterLinkMetadataTest$$executor;

    private UUID linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataTest$$metadata() {
        return this.kafka$server$link$ClusterLinkMetadataTest$$metadata;
    }

    public ExecutorService kafka$server$link$ClusterLinkMetadataTest$$executor() {
        return this.kafka$server$link$ClusterLinkMetadataTest$$executor;
    }

    private void kafka$server$link$ClusterLinkMetadataTest$$executor_$eq(ExecutorService x$1) {
        this.kafka$server$link$ClusterLinkMetadataTest$$executor = x$1;
    }

    @AfterEach
    public void tearDown() {
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().close();
        if (this.kafka$server$link$ClusterLinkMetadataTest$$executor() != null) {
            this.kafka$server$link$ClusterLinkMetadataTest$$executor().shutdownNow();
        }
    }

    @Test
    public void testRefreshListener() {
        IntRef requestCount = IntRef.create((int)0);
        MetadataRefreshListener listener = new MetadataRefreshListener(null, requestCount){
            private final IntRef requestCount$1;

            public void onMetadataRequestUpdate() {
                ++this.requestCount$1.elem;
            }
            {
                this.requestCount$1 = requestCount$1;
            }
        };
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setRefreshListener(listener);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.kafka$server$link$ClusterLinkMetadataTest$$metadata().requestUpdate();
            Assertions.assertEquals((int)i, (int)requestCount$1.elem);
        });
    }

    @Test
    public void testRefreshListenerSynchronization() {
        CountDownLatch latch = new CountDownLatch(1);
        this.kafka$server$link$ClusterLinkMetadataTest$$executor_$eq(Executors.newSingleThreadExecutor());
        MetadataRefreshListener listener = new MetadataRefreshListener(this, latch){
            private final /* synthetic */ ClusterLinkMetadataTest $outer;
            private final CountDownLatch latch$1;

            public void onMetadataRequestUpdate() {
                this.$outer.kafka$server$link$ClusterLinkMetadataTest$$executor().submit(() -> {
                    ClusterLinkMetadata clusterLinkMetadata = $this.$outer.kafka$server$link$ClusterLinkMetadataTest$$metadata();
                    synchronized (clusterLinkMetadata) {
                        $this.latch$1.countDown();
                        return;
                    }
                }, BoxesRunTime.boxToInteger((int)0));
                this.latch$1.await(10L, TimeUnit.SECONDS);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setRefreshListener(listener);
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().requestUpdate();
        Assertions.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testMetadataTopics() {
        long nowMs = System.currentTimeMillis();
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        Assertions.assertEquals(Collections.emptyList(), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals(Collections.singletonList("test"), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"})));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"test1", "test2"}), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test1", false, nowMs));
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test2", false, nowMs));
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals(Collections.emptyList(), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test1", false, nowMs));
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test2", false, nowMs));
    }

    public ClusterLinkMetadataTest() {
        this.linkName = "testLink";
    }
}

