/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkBrokerMetrics;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\u0010 \u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u00033\u0011\u0019i\u0004\u0001)A\u0005g!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002'\u0001A\u0003%\u0001\tC\u0004N\u0001\t\u0007I\u0011\u0002(\t\ri\u0003\u0001\u0015!\u0003P\u0011\u001dY\u0006A1A\u0005\nqCa\u0001\u001a\u0001!\u0002\u0013i\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B4\t\u000f1\u0004!\u0019!C\u0005[\"11\u0010\u0001Q\u0001\n9Dq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0002\u0002CA\u0018\u0001\u0001\u0006I!!\u000b\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA\u001e\u0001\u0001\u0006I!!\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0002bBA4\u0001\u0011\u0005\u0011q\b\u0005\b\u0003W\u0002A\u0011AA \u0011\u001d\ty\u0007\u0001C\u0005\u0003\u007fAq!!\u001d\u0001\t\u0013\t\u0019H\u0001\fDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001cH+Z:u\u0015\t\u0001\u0013%\u0001\u0003mS:\\'B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002?\u00051A/\u001a8b]R,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA\u0001\\1oO*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u0019\u0019FO]5oO\u00069A/\u001a8b]R\u0004\u0013\u0001\u0004;f]\u0006tG\u000f\u0015:fM&D\u0018!\u0004;f]\u0006tG\u000f\u0015:fM&D\b%\u0001\u0005mS:\\G)\u0019;b+\u0005\u0001\u0005cA!E\r6\t!I\u0003\u0002DS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0013%aA*fcB\u0011qIS\u0007\u0002\u0011*\u0011\u0011jI\u0001\u0003u.L!a\u0013%\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u001bM|WO]2f)>\u0004\u0018nY%e+\u0005y\u0005C\u0001)Y\u001b\u0005\t&B\u0001*T\u0003\u0019\u0019w.\\7p]*\u0011A\u0005\u0016\u0006\u0003+Z\u000ba!\u00199bG\",'\"A,\u0002\u0007=\u0014x-\u0003\u0002Z#\n!Q+^5e\u00039\u0019x.\u001e:dKR{\u0007/[2JI\u0002\n!\u0002]1si&$\u0018n\u001c8t+\u0005i\u0006cA!E=B!\u0001fX1b\u0013\t\u0001\u0017F\u0001\u0004UkBdWM\r\t\u0003Q\tL!aY\u0015\u0003\u0007%sG/A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013A\u00029bkN,G-F\u0001h!\r\tE\t\u001b\t\u0003Q%L!A[\u0015\u0003\u000f\t{w\u000e\\3b]\u00069\u0001/Y;tK\u0012\u0004\u0013!\u00037j].lu\u000eZ3t+\u0005q\u0007cA!E_J!\u0001O];y\r\u0011\t\b\u0001A8\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005!\u001a\u0018B\u0001;*\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000b<\n\u0005]L#\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u0019z\u0013\tQxD\u0001\u0005MS:\\Wj\u001c3f\u0003)a\u0017N\\6N_\u0012,7\u000fI\u0001\u0007i>\u0004\u0018nY:\u0016\u0003y\u0004ba`A\u0003g\u0005%QBAA\u0001\u0015\r\t\u0019AQ\u0001\nS6lW\u000f^1cY\u0016LA!a\u0002\u0002\u0002\t\u0019Q*\u00199\u0013\r\u0005-!/^A\u0007\r\u0015\t\b\u0001AA\u0005!\r\u0001\u0014qB\u0005\u0004\u0003#y\"!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/Z\u0001\bi>\u0004\u0018nY:!\u0003\u001diW\r\u001e:jGN,\"!!\u0007\u0011\t\u0005m\u0011qD\u0007\u0003\u0003;Q1!!\u0006R\u0013\u0011\t\t#!\b\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0004nC:\fw-\u001a:\u0016\u0005\u0005%\u0002c\u0001\u0019\u0002,%\u0019\u0011QF\u0010\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\t[\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u00026A\u0019\u0001'a\u000e\n\u0007\u0005erD\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA/Z1s\t><h\u000e\u0006\u0002\u0002BA\u0019\u0001&a\u0011\n\u0007\u0005\u0015\u0013F\u0001\u0003V]&$\bf\u0001\r\u0002JA!\u00111JA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013aA1qS*!\u00111KA+\u0003\u001dQW\u000f]5uKJT1!a\u0016W\u0003\u0015QWO\\5u\u0013\u0011\tY&!\u0014\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0003;fgRlU\r\u001e:jGND3!GA1!\u0011\tY%a\u0019\n\t\u0005\u0015\u0014Q\n\u0002\u0005)\u0016\u001cH/\u0001\fuKN$\b+Y;tK\u0012$v\u000e]5d\u001b\u0016$(/[2tQ\rQ\u0012\u0011M\u0001\u001bi\u0016\u001cH\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]'fiJL7m\u001d\u0015\u00047\u0005\u0005\u0014!C:fiV\u0004Xj\\2l\u0003I\t7o]3si6+GO]5d\u000bF,\u0018\r\\:\u0015\r\u0005\u0005\u0013QOA@\u0011\u001d\t9(\ba\u0001\u0003s\nAA\\1nKB\u0019\u0001+a\u001f\n\u0007\u0005u\u0014K\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Dq!!!\u001e\u0001\u0004\t\u0019)A\u0007fqB,7\r^3e-\u0006dW/\u001a\t\u0004Q\u0005\u0015\u0015bAADS\t1Ai\\;cY\u0016\u0004")
public class ClusterLinkMetricsTest {
    private final String tenant;
    private final String tenantPrefix = new StringBuilder(1).append(this.tenant()).append("_").toString();
    private final Seq<ClusterLinkData> linkData = new .colon.colon((Object)new ClusterLinkData(new StringBuilder(11).append(this.tenantPrefix()).append("test-link-1").toString(), UUID.randomUUID(), (Option)None$.MODULE$, (Option)new Some((Object)this.tenantPrefix()), false), (List)new .colon.colon((Object)new ClusterLinkData("test-link-2", UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)Nil$.MODULE$));
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final Seq<Tuple2<Object, Object>> partitions = new .colon.colon((Object)new Tuple2.mcII.sp(4, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(6, 2), (List)Nil$.MODULE$));
    private final Seq<Object> paused = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}));
    private final Seq<Product> linkModes = new .colon.colon((Object)LinkMode.Destination$.MODULE$, (List)new .colon.colon((Object)LinkMode.Source$.MODULE$, (List)Nil$.MODULE$));
    private final Map<String, Product> topics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new ClusterLinkTopicState.StoppedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), (Seq)List$.MODULE$.empty(), ClusterLinkTopicState.StoppedMirror$.MODULE$.apply$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))}));
    private final Metrics metrics = new Metrics();
    private final ClusterLinkManager manager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);

    private String tenant() {
        return this.tenant;
    }

    private String tenantPrefix() {
        return this.tenantPrefix;
    }

    private Seq<ClusterLinkData> linkData() {
        return this.linkData;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private Seq<Tuple2<Object, Object>> partitions() {
        return this.partitions;
    }

    private Seq<Object> paused() {
        return this.paused;
    }

    private Seq<Product> linkModes() {
        return this.linkModes;
    }

    private Map<String, Product> topics() {
        return this.topics;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClusterLinkManager manager() {
        return this.manager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testMetrics() {
        this.setupMock();
        ClusterLinkBrokerMetrics brokerMetrics = new ClusterLinkBrokerMetrics(this.metrics());
        brokerMetrics.startup();
        Seq brokerSensors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Sensor[]{brokerMetrics.linkedTopicPartitionAdditionSensor(), brokerMetrics.linkedLeaderEpochChangeSensor(), brokerMetrics.aclsAddedSensor(), brokerMetrics.aclsAddFailedSensor(), brokerMetrics.aclsDeletedSensor(), brokerMetrics.aclsDeleteFailedSensor(), brokerMetrics.describeAclsFromSourceFailedSensor(), brokerMetrics.consumerOffsetCommitSensor(), brokerMetrics.consumerOffsetCommitFailedSensor(), brokerMetrics.topicConfigUpdateSensor(), brokerMetrics.topicConfigUpdateFailedSensor(), brokerMetrics.autoMirrorCreateSensor(), brokerMetrics.autoMirrorCreateFailedSensor(), brokerMetrics.autoMirrorListTopicsFromSourceFailedSensor(), brokerMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), brokerMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromDestinationFailedSensor(), brokerMetrics.listConsumerGroupsFromSourceFailedSensor(), brokerMetrics.prefixedAutoMirrorCreateSensor(), brokerMetrics.prefixedAutoMirrorCreateFailedSensor(), brokerMetrics.prefixedAutoMirrorTopicFilteredSensor(), brokerMetrics.sourceReverseConnectionCreatedSensor(), brokerMetrics.destReverseConnectionCreatedSensor(), brokerMetrics.sourceReverseConnectionClosedSensor(), brokerMetrics.destReverseConnectionClosedSensor(), brokerMetrics.destinationLagLinkFetcherThrottleSensor(), brokerMetrics.sourceReverseConnectionFailedSensor(), brokerMetrics.timeToStopMirrorTopicFailoverSensor(), brokerMetrics.timeToStopMirrorTopicPromoteSensor()}));
        brokerSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$1(this, s);
            return BoxedUnit.UNIT;
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)LinkMode.Source$.MODULE$, this.manager(), (Option)new Some((Object)brokerMetrics), this.metrics(), (Option)new Some((Object)this.tenant()));
        linkMetrics.startup();
        Seq linkSensors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Sensor[]{linkMetrics.activeLinkCountSensor(), linkMetrics.throttleTimeSensor(), linkMetrics.linkedTopicPartitionAdditionSensor(), linkMetrics.linkedLeaderEpochChangeSensor(), linkMetrics.aclsAddedSensor(), linkMetrics.aclsAddFailedSensor(), linkMetrics.aclsDeletedSensor(), linkMetrics.aclsDeleteFailedSensor(), linkMetrics.describeAclsFromSourceFailedSensor(), linkMetrics.consumerOffsetCommitSensor(), linkMetrics.consumerOffsetCommitFailedSensor(), linkMetrics.topicConfigUpdateSensor(), linkMetrics.topicConfigUpdateFailedSensor(), linkMetrics.autoMirrorCreateSensor(), linkMetrics.autoMirrorCreateFailedSensor(), linkMetrics.autoMirrorListTopicsFromSourceFailedSensor(), linkMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), linkMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromDestinationFailedSensor(), linkMetrics.listConsumerGroupsFromSourceFailedSensor(), linkMetrics.prefixedAutoMirrorCreateSensor(), linkMetrics.prefixedAutoMirrorCreateFailedSensor(), linkMetrics.prefixedAutoMirrorTopicFilteredSensor(), linkMetrics.linkSourceUnavailableSensor(), linkMetrics.reverseConnectionCreatedSensor(), linkMetrics.reverseConnectionClosedSensor(), linkMetrics.destinationLagLinkFetcherThrottleSensor(), linkMetrics.sourceReverseConnectionFailedSensor(), linkMetrics.timeToStopMirrorTopicFailoverSensor()}));
        linkSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$2(this, s);
            return BoxedUnit.UNIT;
        });
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 4.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
        linkSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$4(this, s);
            return BoxedUnit.UNIT;
        });
        brokerSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$5(this, s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPausedTopicMetrics() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().apply(1)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(1)).linkId(), (LinkMode)this.linkModes().apply(1), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 6.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @Test
    public void testLinkCoordinatorMetrics() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)this.linkModes().head(), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.shutdown();
    }

    private void setupMock() {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.manager().listClusterLinks()).thenReturn(this.linkData());
        ((TraversableLike)this.partitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Tuple2 data = (Tuple2)x0$1._1();
            int index = x0$1._2$mcI$sp();
            ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcherManager.mirrorPartitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)data._1$mcI$sp()));
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.manager().fetcherManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)fetcherManager));
            return ongoingStubbing;
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)this.paused().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            boolean paused = x0$2._1$mcZ$sp();
            int index = x0$2._2$mcI$sp();
            ClusterLinkConfig config = (ClusterLinkConfig)Mockito.mock(ClusterLinkConfig.class);
            Mockito.when((Object)config.clusterLinkPaused()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(paused));
            ClusterLinkClientManager clientManager = (ClusterLinkClientManager)Mockito.mock(ClusterLinkClientManager.class);
            Mockito.when((Object)clientManager.currentConfig()).thenReturn((Object)config);
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.manager().clientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)clientManager));
            return ongoingStubbing;
        });
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable & scala.Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            return Mockito.when((Object)this.manager().linkState(data.linkName())).thenReturn((Object)ActiveClusterLink$.MODULE$);
        });
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(((ClusterLinkData)this.linkData().head()).linkName())).thenReturn(this.topics().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$4(this, t))));
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(((ClusterLinkData)this.linkData().apply(1)).linkName())).thenReturn(this.topics().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$5(this, t))));
    }

    private void assertMetricEquals(MetricName name, double expectedValue) {
        Option option = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.metrics().metrics()).asScala()).get((Object)name);
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)expectedValue), (Object)metric.metricValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Metric ").append(name).append(" not found").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$1(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$2(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$3(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                bl = true;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    bl = false;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        bl = false;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            bl = true;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                bl = true;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, (double)bl);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$4(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNull((Object)$this.metrics().getSensor(s.name()), (String)new StringBuilder(32).append("Sensor ").append(s.name()).append(" should not be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$5(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(34).append("Sensor ").append(s.name()).append(" should still be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$1(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 2;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 2;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 0;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, n);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$4(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().head()).linkName());
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$5(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().apply(1)).linkName());
    }

    public ClusterLinkMetricsTest() {
        this.tenant = "test-tenant";
    }
}

