/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.LinkMode;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019!\u0004\u0001)A\u0005]!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002#\u0001A\u0003%q\u0007C\u0003F\u0001\u0011\u0005a\tC\u0003V\u0001\u0011%a\u000bC\u0004l\u0001E\u0005I\u0011\u00027\t\u000b]\u0004A\u0011\u0001$\t\u000be\u0004A\u0011\u0001$\t\u000bm\u0004A\u0011\u0002?\u00039\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG\u000fV3ti*\u0011\u0001#E\u0001\u0005Y&t7N\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003=\ta\u0001\\5oW&#W#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001B;uS2T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t!Q+V%E\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011gJ\u0001\u0005Y\u0006tw-\u0003\u00024a\t11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\tQLW.Z\u000b\u0002oA\u0011\u0001HQ\u0007\u0002s)\u0011!hO\u0001\u0006kRLGn\u001d\u0006\u0003yu\naaY8n[>t'B\u0001\u000b?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rK$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u00023Q,7\u000f\u001e'j].LE-\u00138SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0002\u000fB\u0011\u0001\u0004S\u0005\u0003\u0013f\u0011A!\u00168ji\"\u0012\u0001b\u0013\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b1!\u00199j\u0015\t\u0001\u0016+A\u0004kkBLG/\u001a:\u000b\u0005I\u0003\u0015!\u00026v]&$\u0018B\u0001+N\u0005\u0011!Vm\u001d;\u0002\u0019\r\u0014X-\u0019;f\u00072LWM\u001c;\u0015\u0007]Sf\r\u0005\u0002!1&\u0011\u0011l\u0004\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\b\"B.\n\u0001\u0004a\u0016\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t!\tiFM\u0004\u0002_EB\u0011q,G\u0007\u0002A*\u0011\u0011-F\u0001\u0007yI|w\u000e\u001e \n\u0005\rL\u0012A\u0002)sK\u0012,g-\u0003\u00024K*\u00111-\u0007\u0005\bO&\u0001\n\u00111\u0001i\u0003=qW\r^<pe.\u0014VmZ5p]&#\u0007c\u0001\rj9&\u0011!.\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0002-\r\u0014X-\u0019;f\u00072LWM\u001c;%I\u00164\u0017-\u001e7uII*\u0012!\u001c\u0016\u0003Q:\\\u0013a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005QL\u0012AC1o]>$\u0018\r^5p]&\u0011a/\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\r;fgRl\u0015-\u001f2f\u0003\u0012$g*\u001a;x_J\\'+Z4j_:LE\rV1hgN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:uQ\tY1*\u0001\u001cuKN$X*Y=cK\u0006#GMT3uo>\u00148NU3hS>t\u0017\n\u001a+bON\u001c\u0016m\u001d7BkRDWM\u001c;jG\u0006$XMU3rk\u0016\u001cH\u000f\u000b\u0002\r\u0017\u0006yB/Z:u\u001b\u0006L(-Z!eI:+Go^8sWJ+w-[8o\u0013\u0012$\u0016mZ:\u0015\t\u001dkhp \u0005\u000676\u0001\r\u0001\u0018\u0005\u0006O6\u0001\r\u0001\u001b\u0005\b\u0003\u0003i\u0001\u0019AA\u0002\u0003M)\u0007\u0010]3di:+Go^8sW&#G+Y4t!\rA\u0012QA\u0005\u0004\u0003\u000fI\"a\u0002\"p_2,\u0017M\u001c")
public class ClusterLinkNetworkClientTest {
    private final UUID linkId = UUID.randomUUID();
    private final String linkName;
    private final MockTime time = new MockTime();

    private UUID linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private MockTime time() {
        return this.time;
    }

    @Test
    public void testLinkIdInRequestHeader() {
        ClusterLinkNetworkClient client = this.createClient("localhost:1234", this.createClient$default$2());
        Assertions.assertNotNull((Object)client.networkClient());
        ((NetworkClient)client.networkClient()).enableDestinationClusterLink(this.linkId(), null, null);
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.emptyList(), false);
        RequestHeader header = client.networkClient().newClientRequest("0", (AbstractRequest.Builder)builder, this.time().milliseconds(), true, 30000, null).makeHeader(ApiKeys.METADATA.latestVersion());
        Assertions.assertEquals(Optional.of(this.linkId()), (Object)header.clusterLinkId());
    }

    private ClusterLinkNetworkClient createClient(String bootstrapServers, Option<String> networkRegionId) {
        Properties testBrokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        networkRegionId.foreach((Function1 & Serializable & scala.Serializable)nr -> testBrokerProps.put("confluent.traffic.network.region.id", nr));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(testBrokerProps);
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(brokerConfig, this.linkName(), this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L);
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, ClusterLinkConfig$.MODULE$.create$default$2());
        return new ClusterLinkNetworkClient(brokerConfig, linkConfig, "", (Option)new Some((Object)metadata), (Option)None$.MODULE$, new Metrics(), (Map)Map$.MODULE$.empty(), (Time)this.time(), "clientId", "fetcher", new LogContext());
    }

    private Option<String> createClient$default$2() {
        return Option$.MODULE$.empty();
    }

    @Test
    public void testMaybeAddNetworkRegionIdTagsSaslHandshakeRequest() {
        ClusterLinkNetworkClient client = this.createClient("foo.bar.us-west2.aws.confluent.cloud:9003", (Option<String>)new Some((Object)"nr1"));
        SaslHandshakeRequestData requestData = new SaslHandshakeRequestData().setMechanism("PLAIN");
        SaslHandshakeRequest request = (SaslHandshakeRequest)new SaslHandshakeRequest.Builder(requestData).build();
        client.maybeAddNetworkRegionIdTags((AbstractRequest)request);
        Assertions.assertTrue((boolean)requestData.unknownTaggedFields().isEmpty());
    }

    @Test
    public void testMaybeAddNetworkRegionIdTagsSaslAuthenticateRequest() {
        this.testMaybeAddNetworkRegionIdTags("foo.bar.us-west2.aws.confluent.cloud:9003", (Option<String>)new Some((Object)"nr1"), true);
        this.testMaybeAddNetworkRegionIdTags("localhost:9003", (Option<String>)new Some((Object)"nr1"), false);
        this.testMaybeAddNetworkRegionIdTags("foo.bar.us-west2.aws.confluent.cloud:9003", (Option<String>)new Some((Object)""), false);
        this.testMaybeAddNetworkRegionIdTags("foo.bar.us-west2.aws.confluent.cloud:9003", (Option<String>)Option$.MODULE$.empty(), false);
        this.testMaybeAddNetworkRegionIdTags("localhost:9003", (Option<String>)Option$.MODULE$.empty(), false);
    }

    private void testMaybeAddNetworkRegionIdTags(String bootstrapServers, Option<String> networkRegionId, boolean expectNetworkIdTags) {
        ClusterLinkNetworkClient client = this.createClient(bootstrapServers, networkRegionId);
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData();
        SaslAuthenticateRequest request = new SaslAuthenticateRequest.Builder(data).build((short)2);
        Assertions.assertNull((Object)data.networkRegionId());
        client.maybeAddNetworkRegionIdTags((AbstractRequest)request);
        if (expectNetworkIdTags) {
            Assertions.assertEquals((Object)networkRegionId.get(), (Object)data.networkRegionId());
            return;
        }
        if (!expectNetworkIdTags) {
            Assertions.assertNull((Object)data.networkRegionId());
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)expectNetworkIdTags));
    }

    public ClusterLinkNetworkClientTest() {
        this.linkName = "testLink";
    }
}

