/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import kafka.server.link.LinkMode;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Md\u0001\u00023f\u00011DQa\u001d\u0001\u0005\u0002QDqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t9\u0002\u0001Q\u0001\n}D\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005=\u0002\u0001)A\u0005\u0003SA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y!\u0011\b\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001e\u0011-\u0011\t\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\t\r\u0003\u00011AA\u0002\u0013%!Q\t\u0005\f\u0005\u0003\u0004\u0001\u0019!a\u0001\n\u0013\u0011\u0019\rC\u0006\u0003H\u0002\u0001\r\u0011!Q!\n\t\u001d\u0003\"\u0003Be\u0001\t\u0007I\u0011\u0002Bf\u0011!\u0011\u0019\u000e\u0001Q\u0001\n\t5\u0007\"\u0003Bk\u0001\t\u0007I\u0011\u0002Bl\u0011!\u0011y\u000e\u0001Q\u0001\n\te\u0007\"\u0003Bq\u0001\t\u0007I\u0011\u0002Br\u0011!\u0011Y\u000f\u0001Q\u0001\n\t\u0015\b\"\u0003Bw\u0001\t\u0007I\u0011\u0002Bx\u0011!\u0011\u0019\u0010\u0001Q\u0001\n\tE\b\"\u0003B{\u0001\t\u0007I\u0011\u0002B|\u0011!\u0019)\u0001\u0001Q\u0001\n\te\b\"CB\u0004\u0001\t\u0007I\u0011AB\u0005\u0011!\u0019Y\u0001\u0001Q\u0001\n\u0005}\b\"CB\u0007\u0001\t\u0007I\u0011AB\u0005\u0011!\u0019y\u0001\u0001Q\u0001\n\u0005}\b\"CB\t\u0001\t\u0007I\u0011AB\u0005\u0011!\u0019\u0019\u0002\u0001Q\u0001\n\u0005}\b\"CB\u000b\u0001\t\u0007I\u0011AB\u0005\u0011!\u00199\u0002\u0001Q\u0001\n\u0005}\bbBB\r\u0001\u0011\u0005!Q\u0005\u0005\b\u0007c\u0001A\u0011\u0001B\u0013\u0011\u001d\u0019Y\u0004\u0001C\u0005\u0005KAqa!\u0010\u0001\t\u0003\u0011)\u0003C\u0004\u0004H\u0001!\tA!\n\t\u000f\r-\u0003\u0001\"\u0001\u0003&!91q\n\u0001\u0005\u0002\t\u0015\u0002bBB*\u0001\u0011\u0005!Q\u0005\u0005\b\u0007/\u0002A\u0011\u0001B\u0013\u0011\u001d\u0019Y\u0006\u0001C\u0001\u0005KAqaa\u0018\u0001\t\u0003\u0011)\u0003C\u0004\u0004d\u0001!\tA!\n\t\u000f\r\u001d\u0004\u0001\"\u0001\u0003&!911\u000e\u0001\u0005\u0002\t\u0015\u0002bBB8\u0001\u0011%1\u0011\u000f\u0005\b\u0007s\u0002A\u0011\u0001B\u0013\u0011\u001d\u0019i\b\u0001C\u0001\u0005KAqa!!\u0001\t\u0003\u0011)\u0003C\u0004\u0004\u0006\u0002!\tA!\n\t\u000f\r%\u0005\u0001\"\u0001\u0003&!91Q\u0012\u0001\u0005\u0002\t\u0015\u0002bBBI\u0001\u0011\u0005!Q\u0005\u0005\b\u0007+\u0003A\u0011\u0001B\u0013\u0011\u001d\u0019I\n\u0001C\u0001\u0005KAqa!(\u0001\t\u0003\u0011)\u0003C\u0004\u0004\"\u0002!\tA!\n\t\u000f\te\u0006\u0001\"\u0003\u0004&\"91\u0011\u001d\u0001\u0005\n\r\r\bbBBt\u0001\u0011%1\u0011\u001e\u0005\b\u0007[\u0004A\u0011BBx\u0011\u001d\u0019I\u0010\u0001C\u0005\u0007wDqaa@\u0001\t\u0013!\t\u0001C\u0004\u0004z\u0002!I\u0001\"\u0002\t\u000f\u0011-\u0001\u0001\"\u0003\u0005\u000e!9A\u0011\u0003\u0001\u0005\n\u0011M\u0001b\u0002C\u0017\u0001\u0011%Aq\u0006\u0005\b\tg\u0001A\u0011\u0002C\u001b\u0011\u001d!I\u0004\u0001C\u0005\twAq\u0001\"\u0011\u0001\t\u0013!\u0019\u0005C\u0004\u0005R\u0001!I\u0001b\u0015\t\u000f\u0011U\u0003\u0001\"\u0003\u0005X!9A1\r\u0001\u0005\n\u0011\u0015\u0004b\u0002C6\u0001\u0011%AQ\u000e\u0004\u0007\u0005\u0013\u0002\u0001Aa\u0013\t\u0015\tMSJ!A!\u0002\u0013\u0011)\u0006\u0003\u0006\u0002L5\u0013\t\u0011)A\u0005\u0003\u001bBaa]'\u0005\u0002\tm\u0003\"\u0003B1\u001b\n\u0007I\u0011\u0001B2\u0011!\u0011\t(\u0014Q\u0001\n\t\u0015\u0004\"\u0003B:\u001b\n\u0007I\u0011\u0001B;\u0011!\u0011y(\u0014Q\u0001\n\t]\u0004b\u0002BA\u001b\u0012\u0005#1\u0011\u0005\b\u0005\u001bkE\u0011\tBH\u0011\u001d\u0011Y*\u0014C!\u0005;CqA!*N\t\u0003\u00119\u000bC\u0004\u0003.6#\tAa,\t\u000f\tMV\n\"\u0001\u00036\"9!1X'\u0005\u0002\tufABA\u001d\u0001\u0011\tY\u0004\u0003\u0006\u0002Lq\u0013\t\u0011)A\u0005\u0003\u001bBaa\u001d/\u0005\u0002\u00055\u0004bBA99\u0012\u0005\u00131\u000f\u0005\b\u0003\u000fdF\u0011IAe\u0011\u001d\ti\u000f\u0018C!\u0003_DqAa\t]\t\u0003\u0012)\u0003C\u0004\u0002Lq#\tEa\n\u0003/\rcWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:UKN$(B\u00014h\u0003\u0011a\u0017N\\6\u000b\u0005!L\u0017AB:feZ,'OC\u0001k\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A7\u0011\u00059\fX\"A8\u000b\u0003A\fQa]2bY\u0006L!A]8\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u000f\u0005\u0002w\u00015\tQ-A\u0005tG\",G-\u001e7feV\t\u0011\u0010\u0005\u0002wu&\u001110\u001a\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u0003bI6Lg.F\u0001\u0000!\u0011\t\t!a\u0005\u000e\u0005\u0005\r!bA?\u0002\u0006)!\u0011qAA\u0005\u0003\u001d\u0019G.[3oiNT1A[A\u0006\u0015\u0011\ti!a\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t\"A\u0002pe\u001eLA!!\u0006\u0002\u0004\tq1i\u001c8gYV,g\u000e^!e[&t\u0017AB1e[&t\u0007%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\ti\u0002E\u0002w\u0003?I1!!\tf\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%A\u0007dY&,g\u000e^'b]\u0006<WM]\u000b\u0003\u0003S\u00012A^A\u0016\u0013\r\ti#\u001a\u0002\u0019\u00072,8\u000f^3s\u0019&t7n\u00117jK:$X*\u00198bO\u0016\u0014\u0018AD2mS\u0016tG/T1oC\u001e,'\u000fI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014XCAA\u001b!\r\t9\u0004X\u0007\u0002\u0001\tqA+Z:u\u0003V$\bn\u001c:ju\u0016\u00148c\u0001/\u0002>A!\u0011qHA$\u001b\t\t\tE\u0003\u0003\u00022\u0005\r#bAA#S\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002J\u0005\u0005#!D!dY\u0006+H\u000f[8sSj,'/\u0001\u0003bG2\u001c\bCBA(\u00033\ni&\u0004\u0002\u0002R)!\u00111KA+\u0003\u001diW\u000f^1cY\u0016T1!a\u0016p\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\n\tFA\u0002TKR\u0004B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0002bG2TA!a\u001a\u0002\n\u000511m\\7n_:LA!a\u001b\u0002b\tQ\u0011i\u00197CS:$\u0017N\\4\u0015\t\u0005U\u0012q\u000e\u0005\b\u0003\u0017r\u0006\u0019AA'\u0003\u0015\u0019H/\u0019:u)\u0011\t)(a.1\t\u0005]\u00141\u0013\t\t\u0003s\n\u0019)a\"\u0002\u00106\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003vi&d'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BAE\u0003\u0017k!!!\u001a\n\t\u00055\u0015Q\r\u0002\t\u000b:$\u0007o\\5oiB!\u0011\u0011SAJ\u0019\u0001!1\"!&`\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\n\u0019q\fJ\u0019\u0012\t\u0005e\u0015q\u0014\t\u0004]\u0006m\u0015bAAO_\n9aj\u001c;iS:<\u0007CBAQ\u0003O\u000bY+\u0004\u0002\u0002$*!\u0011QUA>\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003S\u000b\u0019KA\bD_6\u0004H.\u001a;j_:\u001cF/Y4f!\u0011\ti+a-\u000e\u0005\u0005=&\u0002BAY\u0003\u007f\nA\u0001\\1oO&!\u0011QWAX\u0005\u00111v.\u001b3\t\u000f\u0005ev\f1\u0001\u0002<\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fSA!!\r\u0002B*\u0019\u0001.!\u0003\n\t\u0005\u0015\u0017q\u0018\u0002\u0015\u0003V$\bn\u001c:ju\u0016\u00148+\u001a:wKJLeNZ8\u0002\u0013\u0005,H\u000f[8sSj,GCBAf\u0003/\f\t\u000f\u0005\u0004\u0002z\u00055\u0017\u0011[\u0005\u0005\u0003\u001f\fYH\u0001\u0003MSN$\b\u0003BA_\u0003'LA!!6\u0002@\n\u0019\u0012)\u001e;i_JL'0\u0019;j_:\u0014Vm];mi\"9\u0011\u0011\u001c1A\u0002\u0005m\u0017A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0003{\u000bi.\u0003\u0003\u0002`\u0006}&AG!vi\"|'/\u001b>bE2,'+Z9vKN$8i\u001c8uKb$\bbBArA\u0002\u0007\u0011Q]\u0001\bC\u000e$\u0018n\u001c8t!\u0019\tI(!4\u0002hB!\u0011QXAu\u0013\u0011\tY/a0\u0003\r\u0005\u001bG/[8o\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u0003\u0002r\u0006]\bc\u00018\u0002t&\u0019\u0011Q_8\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003s\f\u0007\u0019AA~\u0003\u001d\u0019wN\u001c4jON\u0004D!!@\u0003\u0018AA\u0011\u0011PAB\u0003\u007f\u0014)\u0002\u0005\u0003\u0003\u0002\t=a\u0002\u0002B\u0002\u0005\u0017\u00012A!\u0002p\u001b\t\u00119AC\u0002\u0003\n-\fa\u0001\u0010:p_Rt\u0014b\u0001B\u0007_\u00061\u0001K]3eK\u001aLAA!\u0005\u0003\u0014\t11\u000b\u001e:j]\u001eT1A!\u0004p!\u0011\t\tJa\u0006\u0005\u0019\te\u0011q_A\u0001\u0002\u0003\u0015\tAa\u0007\u0003\u0007}##'\u0005\u0003\u0002\u001a\nu\u0001c\u00018\u0003 %\u0019!\u0011E8\u0003\u0007\u0005s\u00170A\u0003dY>\u001cX\r\u0006\u0002\u0002rR!!\u0011\u0006B\u0018!\u0019\tiKa\u000b\u0002^%!!QFAX\u0005!IE/\u001a:bE2,\u0007b\u0002B\u0019G\u0002\u0007!1G\u0001\u0007M&dG/\u001a:\u0011\t\u0005}#QG\u0005\u0005\u0005o\t\tG\u0001\tBG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;fe\u0006q\u0011-\u001e;i_JL'0\u001a:`I\u0015\fH\u0003BAy\u0005{A\u0011Ba\u0010\f\u0003\u0003\u0005\r!!\u000e\u0002\u0007a$\u0013'A\u0006bkRDwN]5{KJ\u0004\u0013!\u00033fgR\fE-\\5o+\t\u00119\u0005E\u0002\u000285\u0013q\u0002V3ti\u0006#W.\u001b8DY&,g\u000e^\n\u0004\u001b\n5\u0003\u0003BA\u0001\u0005\u001fJAA!\u0015\u0002\u0004\tyQj\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0001\u0003o_\u0012,\u0007\u0003BAE\u0005/JAA!\u0017\u0002f\t!aj\u001c3f)\u0019\u00119E!\u0018\u0003`!9!1\u000b)A\u0002\tU\u0003bBA&!\u0002\u0007\u0011QJ\u0001\u0012]\u0016DHo\u0011:fCR,'+Z:vYR\u001cXC\u0001B3!\u0019\t\tKa\u001a\u0003l%!!\u0011NAR\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u0004B!!\u0001\u0003n%!!qNA\u0002\u0005A\u0019%/Z1uK\u0006\u001bGn\u001d*fgVdG/\u0001\noKb$8I]3bi\u0016\u0014Vm];miN\u0004\u0013!\u00058fqR$U\r\\3uKJ+7/\u001e7ugV\u0011!q\u000f\t\u0007\u0003C\u00139G!\u001f\u0011\t\u0005\u0005!1P\u0005\u0005\u0005{\n\u0019A\u0001\tEK2,G/Z!dYN\u0014Vm];mi\u0006\u0011b.\u001a=u\t\u0016dW\r^3SKN,H\u000e^:!\u00031!Wm]2sS\n,\u0017i\u00197t)\u0011\u0011)Ia#\u0011\t\u0005\u0005!qQ\u0005\u0005\u0005\u0013\u000b\u0019A\u0001\nEKN\u001c'/\u001b2f\u0003\u000ed7OU3tk2$\bb\u0002B\u0019+\u0002\u0007!1G\u0001\u000bGJ,\u0017\r^3BG2\u001cH\u0003\u0002B6\u0005#CqAa%W\u0001\u0004\u0011)*A\u0004oK^\f5\r\\:\u0011\r\u0005e$qSA/\u0013\u0011\u0011I*a\u001f\u0003\u0015\r{G\u000e\\3di&|g.\u0001\u0006eK2,G/Z!dYN$BA!\u001f\u0003 \"9!\u0011U,A\u0002\t\r\u0016a\u00024jYR,'o\u001d\t\u0007\u0003s\u00129Ja\r\u0002!\u0005$Gm\u0011:fCR,'+Z:vYR\u001cH\u0003BAy\u0005SCqAa+Y\u0001\u0004\u0011Y'\u0001\u0004sKN,H\u000e^\u0001\u0011C\u0012$G)\u001a7fi\u0016\u0014Vm];miN$B!!=\u00032\"9!1V-A\u0002\te\u0014aD1eI\u0006\u001bGnT;u\u001f\u001a\u0014\u0015M\u001c3\u0015\t\u0005E(q\u0017\u0005\b\u0005sS\u0006\u0019AA/\u0003)\t7\r\u001c\"j]\u0012LgnZ\u0001\u0013e\u0016lwN^3BG2|U\u000f^(g\u0005\u0006tG\r\u0006\u0003\u0002r\n}\u0006b\u0002B]7\u0002\u0007\u0011QL\u0001\u000eI\u0016\u001cH/\u00113nS:|F%Z9\u0015\t\u0005E(Q\u0019\u0005\n\u0005\u007fq\u0011\u0011!a\u0001\u0005\u000f\n!\u0002Z3ti\u0006#W.\u001b8!\u0003\u0019a\u0017N\\6JIV\u0011!Q\u001a\t\u0005\u0003s\u0012y-\u0003\u0003\u0003R\u0006m$\u0001B+V\u0013\u0012\u000bq\u0001\\5oW&#\u0007%A\u0005bG2d\u0015N\\6JIV\u0011!\u0011\u001c\t\u0005\u0003\u0013\u0013Y.\u0003\u0003\u0003^\u0006\u0015$\u0001B+vS\u0012\f!\"Y2m\u0019&t7.\u00133!\u0003\u001diW\r\u001e:jGN,\"A!:\u0011\u0007Y\u00149/C\u0002\u0003j\u0016\u0014!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0004bG2d\u0015n\u001d;\u0016\u0005\tE\bCBA=\u0003\u001b\fi&\u0001\u0005bG2d\u0015n\u001d;!\u0003!a\u0017N\\6ECR\fWC\u0001B}!\u0011\u0011Yp!\u0001\u000e\u0005\tu(b\u0001B\u0000S\u0006\u0011!p[\u0005\u0005\u0007\u0007\u0011iPA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003%a\u0017N\\6ECR\f\u0007%A\u000enS\u001e\u0014\u0018\r^3P]\u0016\u0004&/\u001b8dSB\fG.Q2mg*\u001bxN\\\u000b\u0003\u0003\u007f\fA$\\5he\u0006$Xm\u00148f!JLgnY5qC2\f5\r\\:Kg>t\u0007%\u0001\nnS\u001e\u0014\u0018\r^3BY2\f5\r\\:Kg>t\u0017aE7jOJ\fG/Z!mY\u0006\u001bGn\u001d&t_:\u0004\u0013AF7jOJ\fG/\u001a#fM\u0006,H\u000e^!dYNT5o\u001c8\u0002/5LwM]1uK\u0012+g-Y;mi\u0006\u001bGn\u001d&t_:\u0004\u0013AF7vYRL\u0007\u000f\\3BG24\u0015\u000e\u001c;feNT5o\u001c8\u0002/5,H\u000e^5qY\u0016\f5\r\u001c$jYR,'o\u001d&t_:\u0004\u0013!B:fiV\u0003\bf\u0001\u0012\u0004\u001eA!1qDB\u0017\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012aA1qS*!1qEB\u0015\u0003\u001dQW\u000f]5uKJTAaa\u000b\u0002\u0010\u0005)!.\u001e8ji&!1qFB\u0011\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a1e!\u000e\u0011\t\r}1qG\u0005\u0005\u0007s\u0019\tCA\u0005BMR,'/R1dQ\u0006I1/\u001a;va6{7m[\u0001\u0014i\u0016\u001cH/Q2m\r&dG/\u001a:Va\u0012\fG/\u001a\u0015\u0004K\r\u0005\u0003\u0003BB\u0010\u0007\u0007JAa!\u0012\u0004\"\t!A+Z:u\u0003=!Xm\u001d;BG2\fE\rZ5uS>t\u0007f\u0001\u0014\u0004B\u0005\u0011C/Z:u\u0003\u000ed\u0017\t\u001a3fIR{G)Z:u\u00072,8\u000f^3s\u001fV$xJ\u001a\"b]\u0012D3aJB!\u0003\u0019\"Xm\u001d;BG2\u0014V-\\8wK\u00124%o\\7EKN$8\t\\;ti\u0016\u0014x*\u001e;PM\n\u000bg\u000e\u001a\u0015\u0004Q\r\u0005\u0013\u0001\f;fgR\f5\r\\!eI&$\u0018n\u001c8XSRDW*\u001e7uSBdW-Q2m\u0005&tG-\u001b8h\r&dG/\u001a:tQ\rI3\u0011I\u0001!i\u0016\u001cHOT8SKB,\u0017\r^3e+B$\u0017\r^3XQ\u0016tgj\\\"iC:<W\rK\u0002+\u0007\u0003\nQ\b^3ti:{'+\u001a9fCR,G-\u00169eCR,w\u000b[3o\u001d>\u001c\u0005.\u00198hK^KG\u000f['vYRL\u0007\u000f\\3BG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feND3aKB!\u0003=!Xm\u001d;BG2$U\r\\3uS>t\u0007f\u0001\u0017\u0004B\u0005aC/Z:u\u0003\u000edG)\u001a7fi&|gnV5uQ6+H\u000e^5qY\u0016\f5\r\u001c\"j]\u0012Lgn\u001a$jYR,'o\u001d\u0015\u0004[\r\u0005\u0013A\u0007;fgR\f5\r\\!eI&$\u0018n\u001c8B]\u0012$U\r\\3uS>t\u0007f\u0001\u0018\u0004B\u0005YC/Z:u\u0003\u000ed\u0017\t\u001a3ji&|g.\u00118e\t\u0016dW\r^5p]^KG\u000f\u001b#fM\u0006,H\u000e\u001e$jYR,'\u000fK\u00020\u0007\u0003\nAD^3sS\u001aL\u0018i\u00197BI\u0012LG/[8o\u0003:$G)\u001a7fi&|g\u000e\u0006\u0004\u0002r\u000eM4q\u000f\u0005\b\u0007k\u0002\u0004\u0019AA\u0000\u0003)1\u0017\u000e\u001c;fe*\u001bxN\u001c\u0005\b\u0005c\u0001\u0004\u0019\u0001B\u001a\u0003]\"Xm\u001d;BG2\fE\rZ5uS>t\u0017I\u001c3EK2,G/[8o/&$\b.T;mi&\u0004H.Z!dY\nKg\u000eZ5oO\u001aKG\u000e^3sg\"\u001a\u0011g!\u0011\u0002YQ,7\u000f^#yG\u0016\u0004H/[8o\u0013N$\u0006N]8x]&3WK\\1cY\u0016$vnR3u'>,(oY3BG2\u001c\bf\u0001\u001a\u0004B\u0005\tD/Z:u\u000bJ\u0014xN](o\u0003\u000ed\u0017\t\u001a3ji&|g.\u00169eCR,7\u000fT8dC2\f5\r\\*fi\u000e{'O]3di2L\bfA\u001a\u0004B\u0005\tD/Z:u\u000bJ\u0014xN](o\u0003\u000edG)\u001a7fi&|g.\u00169eCR,7\u000fT8dC2\f5\r\\*fi\u000e{'O]3di2L\bf\u0001\u001b\u0004B\u0005IB/Z:u\u0011\u0006tG\r\\3BG2$U\r\\3uKJ+7/\u001e7uQ\r)4\u0011I\u00018i\u0016\u001cH/\u0012:s_J|e.Q2m\u0003\u0012$\u0017\u000e^5p]\u001a+H/\u001e:f+B$\u0017\r^3t\u0019>\u001c\u0017\r\\!dYN+GoQ8se\u0016\u001cG\u000f\\=)\u0007Y\u001a\t%A\u001cuKN$XI\u001d:pe>s\u0017i\u00197EK2,G/[8o\rV$XO]3Va\u0012\fG/Z:M_\u000e\fG.Q2m\u001b\u0006\u00048i\u001c:sK\u000e$H.\u001f\u0015\u0004o\r\u0005\u0013!\u0006;fgR,%O]8s\u001f:\u001cv.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004q\r\u0005\u0013!\u000b;fgR\u001cVmY;sSRLH)[:bE2,G-\u0012=dKB$\u0018n\u001c8MS6LGoV1s]2{w\rK\u0002:\u0007\u0003\n!\u0003^3ti\u0012{Wm]%oSRL\u0017\r\\5{K\"\u001a!h!\u0011\u00029Q,7\u000f\u001e#pKNtu\u000e^%oSRL\u0017\r\\5{K>sWI\u001d:pe\"\u001a1h!\u0011\u0015!\u0005u3qUB\\\u0007w\u001b)m!3\u0004N\u000e]\u0007bBBUy\u0001\u000711V\u0001\re\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u0005\u0007[\u001b\u0019,\u0004\u0002\u00040*!1\u0011WA3\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BB[\u0007_\u0013ABU3t_V\u00148-\u001a+za\u0016Dqa!/=\u0001\u0004\ty0\u0001\u0007sKN|WO]2f\u001d\u0006lW\rC\u0004\u0004>r\u0002\raa0\u0002\u0017A\fG\u000f^3s]RK\b/\u001a\t\u0005\u0007[\u001b\t-\u0003\u0003\u0004D\u000e=&a\u0003)biR,'O\u001c+za\u0016Dqaa2=\u0001\u0004\ty0A\u0007qe&t7-\u001b9bY:\u000bW.\u001a\u0005\b\u0007\u0017d\u0004\u0019AA\u0000\u0003!Awn\u001d;OC6,\u0007bBBhy\u0001\u00071\u0011[\u0001\rC\u000edw\n]3sCRLwN\u001c\t\u0005\u0003?\u001a\u0019.\u0003\u0003\u0004V\u0006\u0005$\u0001D!dY>\u0003XM]1uS>t\u0007bBBmy\u0001\u000711\\\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\tyf!8\n\t\r}\u0017\u0011\r\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0017!D1eI\u0006\u001bGNQ5oI&tw\r\u0006\u0003\u0003r\u000e\u0015\bbBA2{\u0001\u0007\u0011QL\u0001\u0011e\u0016lwN^3BG2\u0014\u0015N\u001c3j]\u001e$BA!=\u0004l\"9\u00111\r A\u0002\u0005u\u0013\u0001D1os\u0006\u001bGNR5mi\u0016\u0014H\u0003\u0002B\u001a\u0007cDqaa=@\u0001\u0004\u0019)0A\u0004mS:\\\u0017\nZ:\u0011\r\t\u00051q\u001fBm\u0013\u0011\tYFa\u0005\u0002\u00111Lgn[!dYN$BA!=\u0004~\"9\u00111\n!A\u0002\tE\u0018a\u00027j].\f5\r\u001c\u000b\u0005\u0003;\"\u0019\u0001C\u0004\u0002d\u0005\u0003\r!!\u0018\u0015\t\u0011\u001dA\u0011\u0002\t\u0007\u0005\u0003\u001990!\u0018\t\u000f\u0005-#\t1\u0001\u0005\b\u000592M]3bi\u0016\f5\r\\:SKN,H\u000e^*vG\u000e,7o\u001d\u000b\u0005\u0005W\"y\u0001C\u0004\u0002L\r\u0003\rA!=\u0002/\r\u0014X-\u0019;f\u0003\u000ed7OU3tk2$h)Y5mkJ,GC\u0002B6\t+!9\u0002C\u0004\u0002L\u0011\u0003\rA!=\t\u000f\u0011eA\t1\u0001\u0005\u001c\u0005\u0011Q\r\u001f\t\u0005\t;!9C\u0004\u0003\u0005 \u0011\rb\u0002\u0002B\u0003\tCI\u0011\u0001]\u0005\u0004\tKy\u0017a\u00029bG.\fw-Z\u0005\u0005\tS!YCA\u0005UQJ|w/\u00192mK*\u0019AQE8\u0002/\u0011,G.\u001a;f\u0003\u000ed7OU3tk2$8+^2dKN\u001cH\u0003\u0002B=\tcAq!a\u0013F\u0001\u0004\u0011\t0A\u0012eK2,G/Z!dYN\u0014Vm];mi\u001a\u000b\u0017\u000e\\;sK\u0006\u0003\u0018.\u0012=dKB$\u0018n\u001c8\u0015\t\teDq\u0007\u0005\b\u0003\u00172\u0005\u0019\u0001By\u0003]!W\r\\3uK\u0006\u001bGn\u001d*fgVdGOR1jYV\u0014X\r\u0006\u0004\u0003z\u0011uBq\b\u0005\b\u0003\u0017:\u0005\u0019\u0001By\u0011\u001d!Ib\u0012a\u0001\t7\t\u0011B\\3x\u0007>tg-[4\u0015\t\u0011\u0015C1\n\t\u0004m\u0012\u001d\u0013b\u0001C%K\n\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\t\u000f\u0005e\b\n1\u0001\u0005NAA!\u0011\u0001C(\u0003\u007f\fy0\u0003\u0003\u0002\u0006\nM\u0011!E2veJ,g\u000e\u001e#fgR\f5\r\\*fiV\u0011AqA\u0001\u0013[\u0006$8\r[5oO\u0012+7\u000f^!dYN+G\u000f\u0006\u0003\u0005\b\u0011e\u0003b\u0002C.\u0015\u0002\u0007AQL\u0001\u000eC\u000edg)\u001b7uKJT5o\u001c8\u0011\u0007Y$y&C\u0002\u0005b\u0015\u0014a\"Q2m\r&dG/\u001a:t\u0015N|g.A\u0005bG24\u0015\u000e\u001c;feR!!1\u0007C4\u0011\u001d!Ig\u0013a\u0001\u0003\u007f\f\u0011BZ5mi\u0016\u00148\u000b\u001e:\u0002\u001d1|7-\u00197BG24\u0015\u000e\u001c;feR!!1\u0007C8\u0011\u001d!\t\b\u0014a\u0001\u0003;\nqAY5oI&tw\r")
public class ClusterLinkSyncAclsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)Mockito.mock(ClusterLinkClientManager.class);
    private TestAuthorizer authorizer;
    private TestAdminClient destAdmin;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid aclLinkId = CoreUtils$.MODULE$.toKafkaUUID(this.linkId());
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final java.util.List<AclBinding> aclList = new ArrayList<AclBinding>();
    private final ClusterLinkData linkData = new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final String migrateOnePrincipalAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
    private final String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\",\n      |     \"clusterLinkIds\": [\"").append(Uuid.ZERO_UUID).append("\", \"").append(this.aclLinkId()).append("\"]\n      |    }\n      |  }]\n      | }").toString())).stripMargin();
    private final String migrateDefaultAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
    private final String multipleAclFiltersJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"read\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"prefixed\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Alice\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"alter\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"cluster\",\n      |      \"name\": \"*\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Mallory\",\n      |     \"host\":\"badhost\",\n      |     \"operation\": \"clusterAction\",\n      |     \"permissionType\": \"deny\"\n      |    }\n      |  }]\n      | }")).stripMargin();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private TestAuthorizer authorizer() {
        return this.authorizer;
    }

    private void authorizer_$eq(TestAuthorizer x$1) {
        this.authorizer = x$1;
    }

    private TestAdminClient destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(TestAdminClient x$1) {
        this.destAdmin = x$1;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid aclLinkId() {
        return this.aclLinkId;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private java.util.List<AclBinding> aclList() {
        return this.aclList;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    public String migrateOnePrincipalAclsJson() {
        return this.migrateOnePrincipalAclsJson;
    }

    public String migrateAllAclsJson() {
        return this.migrateAllAclsJson;
    }

    public String migrateDefaultAclsJson() {
        return this.migrateDefaultAclsJson;
    }

    public String multipleAclFiltersJson() {
        return this.multipleAclFiltersJson;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
        scala.collection.mutable.Set sharedAcls = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.destAdmin_$eq(new TestAdminClient(this, new Node(1, "localhost", 9090), (scala.collection.mutable.Set<AclBinding>)sharedAcls));
        this.authorizer_$eq(new TestAuthorizer(this, (scala.collection.mutable.Set<AclBinding>)sharedAcls));
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
        this.destAdmin().close();
    }

    private void setupMock() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkClientManager[]{this.clientManager()});
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.admin());
        Mockito.when((Object)this.clientManager().getAuthorizer()).thenReturn((Object)new Some((Object)this.authorizer()));
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false));
    }

    @Test
    public void testAclFilterUpdate() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        AclBinding aliceAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        this.addAclBinding(aliceAcl);
        AclBinding malloryAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        java.util.List<AclBinding> linkedAcls = this.addAclBinding(malloryAcl);
        .colon.colon unlinkedAcls = new .colon.colon((Object)bobAcl, (List)new .colon.colon((Object)aliceAcl, (List)new .colon.colon((Object)malloryAcl, (List)Nil$.MODULE$)));
        DescribeAclsResult fullDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(linkedAcls));
        DescribeAclsResult bobDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)bobAcl, (List)Nil$.MODULE$)).asJava()));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateOnePrincipalAclsJson()))).thenReturn((Object)bobDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)fullDescribeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)bobAcl, (List)Nil$.MODULE$)).asJava())));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(linkedAcls));
        ClusterLinkConfig bobConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateOnePrincipalAclsJson())}))));
        ClusterLinkConfig allConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)bobConfig, (Object[])new ClusterLinkConfig[]{bobConfig, allConfig, bobConfig});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set bobAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)bobDescribeAclsResult.values().get()).asScala()).toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet), this.matchingDestAclSet((AclFiltersJson)bobConfig.aclFilters().get()));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set allAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)fullDescribeAclsResult.values().get()).asScala()).toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)allAclSet), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        List notMatchingUnlinkedAcls = ((TraversableOnce)unlinkedAcls.toSet().$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{bobAcl})))).toList();
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)notMatchingUnlinkedAcls).asJava())));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)notMatchingUnlinkedAcls).asJava()));
        TestUtils.setFieldValue((Object)syncAclsTask, (String)"initialized", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set<AclBinding> matchingAcls = this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet);
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)((SetLike)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(linkedAcls).asScala()).toSet().$minus$minus(matchingAcls)).map((Function1 & Serializable & scala.Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.emptySet()), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).$plus$plus(matchingAcls), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateOnePrincipalAclsJson()));
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclAddition() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testAclAddedToDestClusterOutOfBand() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        AclBinding outOfBandAclBind = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:OutOfBandUser", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        this.destAdmin().addAclOutOfBand(outOfBandAclBind);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(Collections.singletonList(outOfBandAclBind)));
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclRemovedFromDestClusterOutOfBand() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        AclBinding linkedBobAcl = this.linkAcl(bobAcl);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.destAdmin().removeAclOutOfBand(linkedBobAcl);
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(Collections.singletonList(linkedBobAcl)));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclAdditionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChange() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        scala.collection.immutable.Set expectedAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChangeWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletion() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{describeAclsResult2});
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls1));
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(deletedAclBinding))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult2.values().get()).asScala()).toSet(), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)deletedDescribeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(aclBinding1))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclAdditionAndDeletion() {
        this.verifyAclAdditionAndDeletion(this.migrateAllAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID, this.aclLinkId()})))));
    }

    @Test
    public void testAclAdditionAndDeletionWithDefaultFilter() {
        this.verifyAclAdditionAndDeletion(this.migrateDefaultAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID})))));
    }

    private void verifyAclAdditionAndDeletion(String filterJson, AclBindingFilter filter) {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        AclBinding addedAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        this.addAclBinding(addedAcl);
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        Mockito.when((Object)this.admin().describeAcls(filter)).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{describeAclsResult2});
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls1));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)addedAcl, (List)Nil$.MODULE$)).asJava())));
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(deletedAclBinding))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)filterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(filter);
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult2.values().get()).asScala()).toSet(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.destAdmin().describeAcls(AclBindingFilter.ANY).values().get()).asScala()).toSet());
    }

    @Test
    public void testAclAdditionAndDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult emptyDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{emptyDescribeAclsResult});
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)emptyDescribeAclsResult).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)Nil$.MODULE$))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(aclBinding1))));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testExceptionIsThrownIfUnableToGetSourceAcls() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.completeExceptionally((Throwable)new AuthorizationException("Unauthorized for DESCRIBE on Cluster"));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)new DescribeAclsResult((KafkaFuture)describeFuture));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(AuthorizationException.class, ex.getCause().getCause().getClass());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclAdditionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultFailure(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthorizationException("Unable to create ACLs")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1).thenReturn((Object)deletedDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultFailure(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthorizationException("Unable to delete ACLs")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testHandleAclDeleteResult() {
        this.setupMock();
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.tasksOutstanding_(1);
        Assertions.assertTrue((boolean)syncAclsTask.handleAclDeleteResult(this.deleteAclsResultFailureApiException(acls), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}));
        syncAclsTask.tasksOutstanding_(1);
        Assertions.assertTrue((boolean)syncAclsTask.handleAclDeleteResult(this.deleteAclsResultFailure(acls, new Exception("Unknown error")), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}));
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
    }

    @Test
    public void testErrorOnAclAdditionFutureUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultFailure(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthenticationException("Unable to authenticate")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionFutureUpdatesLocalAclMapCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1).thenReturn((Object)deletedDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultFailure(this.linkAcls((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthenticationException("Unable to authenticate")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnSourceAcls() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl completedFuture = new KafkaFutureImpl();
        completedFuture.completeExceptionally((Throwable)new TimeoutException("Timed out getting source ACLs"));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult((KafkaFuture)completedFuture);
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.startup();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testSecurityDisabledExceptionLimitWarnLog() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl futureCompletedWithSecDisException = new KafkaFutureImpl();
        futureCompletedWithSecDisException.completeExceptionally((Throwable)Errors.SECURITY_DISABLED.exception());
        KafkaFuture futureCompletedSuccessfully = KafkaFuture.completedFuture(Collections.emptyList());
        KafkaFutureImpl futureCompletedWithDifferentExecException = new KafkaFutureImpl();
        futureCompletedWithDifferentExecException.completeExceptionally((Throwable)Errors.REQUEST_TIMED_OUT.exception());
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult(futureCompletedSuccessfully)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithDifferentExecException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        Assertions.assertEquals(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974))).getCause().getCause().getClass(), TimeoutException.class);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)6))).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)6))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testDoesInitialize() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding acl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AclBinding linkedAcl = this.linkAcl(acl);
        this.destAdmin().addAclOutOfBand(linkedAcl);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(Collections.singletonList(linkedAcl)));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(Collections.singletonList(acl)));
        String aclFilterJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        Assertions.assertTrue((boolean)syncAclsTask.isInitialized());
    }

    @Test
    public void testDoesNotInitializeOnError() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding linkedAcl = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW));
        this.destAdmin().addAclOutOfBand(linkedAcl);
        this.destAdmin().addDeleteResults(this.deleteAclsResultFailure(Collections.singletonList(linkedAcl), new Exception("Unknown error")));
        String aclFilterJson = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:Bob\",\n        |     \"host\":\"*\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }")).stripMargin();
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
    }

    private AclBinding aclBinding(ResourceType resourceType, String resourceName, PatternType patternType, String principalName, String hostName, AclOperation aclOperation, AclPermissionType permissionType) {
        ResourcePattern resourcePattern = new ResourcePattern(resourceType, resourceName, patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(principalName, hostName, aclOperation, permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    private java.util.List<AclBinding> addAclBinding(AclBinding acl) {
        this.aclList().add(acl);
        return this.linkAcls(this.aclList());
    }

    private java.util.List<AclBinding> removeAclBinding(AclBinding acl) {
        this.aclList().remove(acl);
        return this.linkAcls(this.aclList());
    }

    private AclBindingFilter anyAclFilter(scala.collection.immutable.Set<Uuid> linkIds) {
        return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(linkIds).asJava()));
    }

    private java.util.List<AclBinding> linkAcls(java.util.List<AclBinding> acls) {
        return (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.aclLinkId())), Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    private AclBinding linkAcl(AclBinding acl) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.singleton(this.aclLinkId()));
    }

    private scala.collection.immutable.Set<AclBinding> linkAcls(scala.collection.immutable.Set<AclBinding> acls) {
        return (scala.collection.immutable.Set)acls.map((Function1 & Serializable & scala.Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.aclLinkId())), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private CreateAclsResult createAclsResultSuccess(java.util.List<AclBinding> acls) {
        void var3_3;
        scala.collection.immutable.Map values = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)acl -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete(null);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(acl), (Object)future);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        CreateAclsResult result = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)values).asJava());
        return var3_3;
    }

    private CreateAclsResult createAclsResultFailure(java.util.List<AclBinding> acls, Throwable ex) {
        scala.collection.immutable.Map values = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)acl -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(ex);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(acl), (Object)future);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        CreateAclsResult result = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)values).asJava());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private DeleteAclsResult deleteAclsResultSuccess(java.util.List<AclBinding> acls) {
        void var3_3;
        scala.collection.immutable.Map values = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)aclBinding -> {
            DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
            Mockito.when((Object)filterResult.binding()).thenReturn(aclBinding);
            Mockito.when((Object)((Object)filterResult.exception())).thenReturn(null);
            DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
            Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)filterResults);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)values).asJava());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private DeleteAclsResult deleteAclsResultFailureApiException(java.util.List<AclBinding> acls) {
        void var3_3;
        scala.collection.immutable.Map values = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)aclBinding -> {
            DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
            Mockito.when((Object)filterResult.binding()).thenReturn(aclBinding);
            Mockito.when((Object)((Object)filterResult.exception())).thenReturn((Object)new ApiException("Fail"));
            DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
            Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)filterResults);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)values).asJava());
        return var3_3;
    }

    private DeleteAclsResult deleteAclsResultFailure(java.util.List<AclBinding> acls, Throwable ex) {
        scala.collection.immutable.Map values = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).map((Function1 & Serializable & scala.Serializable)aclBinding -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(ex);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)values).asJava());
        return result;
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)props, ClusterLinkConfig$.MODULE$.create$default$2());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclSet() {
        return this.matchingDestAclSet((AclFiltersJson)this.clientManager().currentConfig().aclFilters().get());
    }

    private scala.collection.immutable.Set<AclBinding> matchingDestAclSet(AclFiltersJson aclFilterJson) {
        return ((TraversableForwarder)AclJson$.MODULE$.toAclBindingFilters(aclFilterJson).flatMap((Function1 & Serializable & scala.Serializable)filter -> {
            AclBindingFilter allFilter = SecurityUtils.aclFilterWithClusterLinkIds((AclBindingFilter)filter, Collections.emptyList());
            return (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.authorizer().acls(allFilter)).asScala();
        }, ListBuffer$.MODULE$.canBuildFrom())).toSet();
    }

    private AclBindingFilter aclFilter(String filterStr) {
        return (AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)Option$.MODULE$.option2Iterable(AclJson$.MODULE$.parse(filterStr)).head()).head();
    }

    private AclBindingFilter localAclFilter(AclBinding binding) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)binding, Collections.singleton(Uuid.ZERO_UUID)).toFilter();
    }

    public class TestAdminClient
    extends MockAdminClient {
        private final scala.collection.mutable.Set<AclBinding> acls;
        private final ConcurrentLinkedQueue<CreateAclsResult> nextCreateResults;
        private final ConcurrentLinkedQueue<DeleteAclsResult> nextDeleteResults;
        public final /* synthetic */ ClusterLinkSyncAclsTest $outer;

        public ConcurrentLinkedQueue<CreateAclsResult> nextCreateResults() {
            return this.nextCreateResults;
        }

        public ConcurrentLinkedQueue<DeleteAclsResult> nextDeleteResults() {
            return this.nextDeleteResults;
        }

        public DescribeAclsResult describeAcls(AclBindingFilter filter) {
            Set resultAcls = (Set)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)this.acls.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))).asJava();
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)resultAcls);
            DescribeAclsResult result = (DescribeAclsResult)Mockito.mock(DescribeAclsResult.class);
            Mockito.when((Object)result.values()).thenReturn((Object)future);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public CreateAclsResult createAcls(Collection<AclBinding> newAcls) {
            void var2_2;
            CreateAclsResult result = this.nextCreateResults().poll();
            if (result == null) {
                throw new IllegalArgumentException("No next CreateAclsResult");
            }
            scala.collection.mutable.Map resultValues = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.values()).asScala();
            newAcls.forEach(acl -> {
                if (!((KafkaFuture)resultValues.apply(acl)).isCompletedExceptionally()) {
                    $this.acls.add(acl);
                }
            });
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
            void var2_2;
            DeleteAclsResult result = this.nextDeleteResults().poll();
            if (result == null) {
                throw new IllegalArgumentException("No next DeleteAclsResult");
            }
            scala.collection.mutable.Map resultValues = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.values()).asScala();
            filters.forEach(filter -> {
                if (!((KafkaFuture)resultValues.apply(filter)).isCompletedExceptionally()) {
                    $this.acls.$minus$minus$eq((TraversableOnce)$this.acls.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1))));
                }
            });
            return var2_2;
        }

        public void addCreateResults(CreateAclsResult result) {
            this.nextCreateResults().add(result);
        }

        public void addDeleteResults(DeleteAclsResult result) {
            this.nextDeleteResults().add(result);
        }

        public void addAclOutOfBand(AclBinding aclBinding) {
            this.acls.$plus$eq((Object)aclBinding);
        }

        public void removeAclOutOfBand(AclBinding aclBinding) {
            this.acls.remove((Object)aclBinding);
        }

        public /* synthetic */ ClusterLinkSyncAclsTest kafka$server$link$ClusterLinkSyncAclsTest$TestAdminClient$$$outer() {
            return this.$outer;
        }

        public TestAdminClient(ClusterLinkSyncAclsTest $outer, Node node, scala.collection.mutable.Set<AclBinding> acls) {
            this.acls = acls;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(Collections.singletonList(node), node);
            this.nextCreateResults = new ConcurrentLinkedQueue();
            this.nextDeleteResults = new ConcurrentLinkedQueue();
        }
    }

    private class TestAuthorizer
    extends AclAuthorizer {
        private final scala.collection.mutable.Set<AclBinding> acls;
        public final /* synthetic */ ClusterLinkSyncAclsTest $outer;

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return Collections.emptyMap();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            throw new UnsupportedOperationException("authorize()");
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public void close() {
        }

        public java.lang.Iterable<AclBinding> acls(AclBindingFilter filter) {
            return (java.lang.Iterable)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)this.acls.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))).asJava();
        }

        public /* synthetic */ ClusterLinkSyncAclsTest kafka$server$link$ClusterLinkSyncAclsTest$TestAuthorizer$$$outer() {
            return this.$outer;
        }

        public TestAuthorizer(ClusterLinkSyncAclsTest $outer, scala.collection.mutable.Set<AclBinding> acls) {
            this.acls = acls;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

