/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.LinkMode;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0013'\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019i\u0005\u0001)A\u0005\u0001\"9a\n\u0001b\u0001\n\u0013y\u0005BB*\u0001A\u0003%\u0001\u000bC\u0004U\u0001\t\u0007I\u0011B+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007K\u0002\u0001\u000b\u0011\u00022\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0007\u0003\u000b\u0001A\u0011A:\t\r\u0005=\u0001\u0001\"\u0001t\u0011\u0019\tI\u0002\u0001C\u0001g\"1\u0011Q\u0004\u0001\u0005\u0002MDa!!\t\u0001\t\u0003\u0019\bBBA\u0013\u0001\u0011\u00051\u000f\u0003\u0004\u0002*\u0001!\ta\u001d\u0005\u0007\u0003[\u0001A\u0011A:\t\r\u0005E\u0002\u0001\"\u0001t\u0011\u0019\t)\u0004\u0001C\u0001g\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003+\u0003A\u0011BAL\u0011%\t)\rAI\u0001\n\u0013\t9\rC\u0004\u0002^\u0002!I!a8\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"I!Q\u0001\u0001\u0012\u0002\u0013%!q\u0001\u0005\n\u0005\u0017\u0001\u0011\u0013!C\u0005\u0005\u001b\u0011\u0001e\u00117vgR,'\u000fT5oWNKhn\u0019+pa&\u001c7oQ8oM&<7\u000fV3ti*\u0011q\u0005K\u0001\u0005Y&t7N\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003\u0019\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003i\u0002\"aN\u001e\n\u0005q2#\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n1b]8ve\u000e,\u0017\tZ7j]V\t\u0001\t\u0005\u0002B\u00176\t!I\u0003\u0002D\t\u0006)\u0011\rZ7j]*\u0011QIR\u0001\bG2LWM\u001c;t\u0015\tYsI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'C\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\fAb]8ve\u000e,\u0017\tZ7j]\u0002\n1\u0004\\8dC2\u001cE.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$X#\u0001)\u0011\u0005]\n\u0016B\u0001*'\u0005maunY1m\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u001cE.[3oi\u0006aBn\\2bY\u000ecWo\u001d;fe2Kgn[!e[&t7\t\\5f]R\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003Y\u0003\"aN,\n\u0005a3#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u00035\u0019G.[3oi6\u000bg.Y4feV\tA\f\u0005\u00028;&\u0011aL\n\u0002\u0019\u00072,8\u000f^3s\u0019&t7n\u00117jK:$X*\u00198bO\u0016\u0014\u0018AD2mS\u0016tG/T1oC\u001e,'\u000fI\u0001\b[\u0016$(/[2t+\u0005\u0011\u0007CA\u001cd\u0013\t!gE\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u00151Lgn[\"p]\u001aLw-F\u0001i!\t9\u0014.\u0003\u0002kM\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u00171Lgn[\"p]\u001aLw\rI\u0001\u0015i>\u0004\u0018nY\"p]\u001aLwmU=oGJ+H.Z:\u0016\u00039\u0004\"aN8\n\u0005A4#AG'jeJ|'\u000fV8qS\u000e\u001cuN\u001c4jONKhn\u0019*vY\u0016\u001c\u0018!\u0006;pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002iB\u0011q&^\u0005\u0003mB\u0012A!\u00168ji\"\u0012!\u0003\u001f\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018aA1qS*\u0011QP`\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0018*A\u0003kk:LG/C\u0002\u0002\u0004i\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\n\u0002\nA\u0019\u00110a\u0003\n\u0007\u00055!PA\u0005BMR,'/R1dQ\u0006\tB/Z:u+B$\u0017\r^3D_:4\u0017nZ:)\u0007Q\t\u0019\u0002E\u0002z\u0003+I1!a\u0006{\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f\u001e(p+B$\u0017\r^3D_:4\u0017nZ:)\u0007U\t\u0019\"\u0001\u000fuKN$X\t_2faRLwN\u001c$fi\u000eD\u0017N\\4D_:4\u0017nZ:)\u0007Y\t\u0019\"\u0001\u000fuKN$X\t_2faRLwN\\!mi\u0016\u0014\u0018N\\4D_:4\u0017nZ:)\u0007]\t\u0019\"\u0001\u000euKN$X\t_2faRLwN\\\"p]\u001aLwm\u001d*fgVdG\u000fK\u0002\u0019\u0003'\tq\u0004^3ti\u0016C8-\u001a9uS>t\u0017\t\u001c;fe\u000e{gNZ5hgJ+7/\u001e7uQ\rI\u00121C\u0001\u0011i\u0016\u001cHo\u00115b]\u001e,Gk\u001c9jGND3AGA\n\u0003\u0001\"Xm\u001d;DYV\u001cH/\u001a:MS:\\\u0017\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=)\u0007m\t\u0019\"\u0001\u0010uKN$\u0018\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=WS>d\u0017\r^5p]\"\u001aA$a\u0005\u0002#9,woQ8oM&<'+Z:pkJ\u001cW\r\u0006\u0003\u0002>\u00055\u0003\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007G>tg-[4\u000b\u0007\u0005\u001dc)\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u0017\n\tE\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000f\u0005=S\u00041\u0001\u0002R\u0005)Ao\u001c9jGB!\u00111KA1\u001d\u0011\t)&!\u0018\u0011\u0007\u0005]\u0003'\u0004\u0002\u0002Z)\u0019\u00111\f\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0006M\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0014Q\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}\u0003'A\u000bbYR,'oQ8oM&<'+Z9vKN$X*\u00199\u0015\t\u0005-\u0014q\u0011\t\t\u0003[\n9(!\u0010\u0002|5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0003vi&d'BAA;\u0003\u0011Q\u0017M^1\n\t\u0005e\u0014q\u000e\u0002\u0004\u001b\u0006\u0004\bCBA7\u0003{\n\t)\u0003\u0003\u0002\u0000\u0005=$AC\"pY2,7\r^5p]B\u0019\u0011)a!\n\u0007\u0005\u0015%IA\u0007BYR,'oQ8oM&<w\n\u001d\u0005\b\u0003\u0013s\u0002\u0019AAF\u0003%\u0019wN\u001c4jO6\u000b\u0007\u000f\u0005\u0005\u0002T\u00055\u0015\u0011KAH\u0013\u0011\tI(!\u001a\u0011\t\u00055\u0014\u0011S\u0005\u0005\u0003'\u000byG\u0001\u0006Qe>\u0004XM\u001d;jKN\fa#\\8dW\u0006cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u000b\u0007\u00033\u000by*!.\u0011\u0007\u0005\u000bY*C\u0002\u0002\u001e\n\u0013!#\u00117uKJ\u001cuN\u001c4jON\u0014Vm];mi\"9\u0011\u0011U\u0010A\u0002\u0005\r\u0016A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002&\u0006=\u0016\u0011\u000b\b\u0005\u0003O\u000bYK\u0004\u0003\u0002X\u0005%\u0016\"A\u0019\n\u0007\u00055\u0006'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00161\u0017\u0002\u0005\u0019&\u001cHOC\u0002\u0002.BB\u0011\"a. !\u0003\u0005\r!!/\u0002\u0013\u0015D8-\u001a9uS>t\u0007#B\u0018\u0002<\u0006}\u0016bAA_a\t1q\n\u001d;j_:\u0004B!!*\u0002B&!\u00111YAZ\u0005%!\u0006N]8xC\ndW-\u0001\u0011n_\u000e\\\u0017\t\u001c;fe\u000e{gNZ5hgJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u0012TCAAeU\u0011\tI,a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a61\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqD\\3x\u00072,8\u000f^3s\u0019&t7nU=oGR{\u0007/[2t\u0007>tg-[4t)\t\t\t\u000fE\u00028\u0003GL1!!:'\u0005q\u0019E.^:uKJd\u0015N\\6Ts:\u001cGk\u001c9jGN\u001cuN\u001c4jON\f\u0011b]3ukBlunY6\u0015\u000bQ\fY/a@\t\u0013\u00055(\u0005%AA\u0002\u0005=\u0018!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsB)q&a/\u0002rB!\u00111_A~\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018A\u00029pY&\u001c\u0017P\u0003\u0002*\r&!\u0011Q`A{\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0005\n\u0005\u0003\u0011\u0003\u0013!a\u0001\u0005\u0007\tA\u0002^3oC:$\bK]3gSb\u0004RaLA^\u0003#\n1c]3ukBlunY6%I\u00164\u0017-\u001e7uIE*\"A!\u0003+\t\u0005=\u00181Z\u0001\u0014g\u0016$X\u000f]'pG.$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fQCAa\u0001\u0002L\u0002")
public class ClusterLinkSyncTopicsConfigsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final LocalClusterLinkAdminClient localClusterLinkAdminClient = (LocalClusterLinkAdminClient)Mockito.mock(LocalClusterLinkAdminClient.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)Mockito.mock(ClusterLinkClientManager.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", UUID.randomUUID(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, ClusterLinkConfig$.MODULE$.create$default$2());
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private LocalClusterLinkAdminClient localClusterLinkAdminClient() {
        return this.localClusterLinkAdminClient;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.mockAlterConfigsResult$default$2());
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        newProps.remove("unclean.leader.election.enable");
    }

    @Test
    public void testNoUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
    }

    @Test
    public void testExceptionFetchingConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Set<ConfigResource> describeConfigsArg = Collections.singleton(this.newConfigResource(topic));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenThrow(new Throwable[]{new TopicAuthorizationException("")});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139))).getCause() instanceof TopicAuthorizationException));
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
    }

    @Test
    public void testExceptionAlteringConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenThrow(new Throwable[]{new TopicAuthorizationException("")});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177))).getCause() instanceof TopicAuthorizationException));
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
    }

    @Test
    public void testExceptionConfigsResult() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$)));
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)topics.toSet());
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl successConfig = new KafkaFutureImpl();
        successConfig.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl errorConfig = new KafkaFutureImpl();
        errorConfig.completeExceptionally((Throwable)new TopicAuthorizationException(""));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        HashSet describeConfigsArg = new HashSet(3);
        resources.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)describeConfigsArg.add(x$1)));
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)successConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)errorConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(2)), (Object)successConfig)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.head())).thenReturn((Object)curProps);
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.apply(2))).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        .colon.colon changedTopics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$));
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)changedTopics, this.mockAlterConfigsResult$default$2());
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((TraversableOnce)changedTopics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)newProps), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.head());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.apply(2));
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((TraversableOnce)changedTopics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)newProps), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
    }

    @Test
    public void testExceptionAlterConfigsResult() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        AlterConfigsResult alterConfigResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)new Some((Object)new TopicAuthorizationException("unauthorized")));
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
    }

    @Test
    public void testChangeTopics() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)Nil$.MODULE$));
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head()}))).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config1 = new KafkaFutureImpl();
        config1.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl config2 = new KafkaFutureImpl();
        config2.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("retention.ms", "1000000"), (List)Nil$.MODULE$)).asJavaCollection()));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        Set<Object> describeConfigsArg1 = Collections.singleton(resources.head());
        Set<Object> describeConfigsArg2 = Collections.singleton(resources.apply(1));
        DescribeConfigsResult describeConfigsResult1 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)config1)}))).asJava()));
        DescribeConfigsResult describeConfigsResult2 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)config2)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg1))).thenReturn((Object)describeConfigsResult1);
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg2))).thenReturn((Object)describeConfigsResult2);
        Properties curProps1 = new Properties();
        curProps1.put("cleanup.policy", "compact");
        Properties curProps2 = new Properties();
        curProps2.put("retention.ms", "1000000");
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.head())).thenReturn((Object)curProps1);
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.apply(1))).thenReturn((Object)curProps2);
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg1));
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg2));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.head());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.apply(1));
    }

    @Test
    public void testClusterLinkAlterConfigPolicy() {
        scala.collection.immutable.Map oldConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preallocate"), (Object)"true")}));
        scala.collection.immutable.Map newConfigs = Predef$.MODULE$.Map().empty();
        ClusterLinkAlterConfigPolicy policy = (ClusterLinkAlterConfigPolicy)Mockito.mock(ClusterLinkAlterConfigPolicy.class);
        Mockito.when((Object)policy.clusterLinkRestrictTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)oldConfigs).asJava()))).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava());
        ((ClusterLinkAlterConfigPolicy)Mockito.doNothing().when((Object)policy)).clusterLinkValidateTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()));
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)new Some((Object)"tenant_"));
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("preallocate", "true"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("preallocate", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.mockAlterConfigsResult$default$2());
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        ((ClusterLinkAlterConfigPolicy)Mockito.verify((Object)policy)).clusterLinkRestrictTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)oldConfigs).asJava()));
        ((ClusterLinkAlterConfigPolicy)Mockito.verify((Object)policy)).clusterLinkValidateTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()));
    }

    @Test
    public void testAlterConfigPolicyViolation() {
        AlterConfigPolicy policy = new AlterConfigPolicy(null){

            public void configure(java.util.Map<String, ?> configs) {
            }

            public void close() {
            }

            public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
                throw new PolicyViolationException("Violated!");
            }
        };
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), this.setupMock$default$2());
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
    }

    private ConfigResource newConfigResource(String topic) {
        return new ConfigResource(ConfigResource.Type.TOPIC, topic);
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<ConfigResource, Collection<AlterConfigOp>> alterConfigRequestMap(scala.collection.immutable.Map<String, Properties> configMap) {
        void var2_2;
        HashMap requestMap = new HashMap();
        configMap.foreach((Function1 & Serializable & scala.Serializable)entry2 -> {
            String topic = (String)entry2._1();
            Properties props = (Properties)entry2._2();
            HashSet configs = new HashSet();
            ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)configs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
            return requestMap.put(this.newConfigResource(topic), configs);
        });
        return var2_2;
    }

    private AlterConfigsResult mockAlterConfigsResult(List<String> topics, Option<Throwable> exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (exception instanceof Some) {
            Throwable e = (Throwable)((Some)exception).value();
            future.completeExceptionally(e);
        } else if (None$.MODULE$.equals(exception)) {
            future.complete(null);
        } else {
            throw new MatchError(exception);
        }
        scala.collection.immutable.Map valueMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)this.newConfigResource((String)t), (Object)future), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterConfigsResult result = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)future);
        Mockito.when((Object)result.values()).thenReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)valueMap).asJava());
        return result;
    }

    private Option<Throwable> mockAlterConfigsResult$default$2() {
        return None$.MODULE$;
    }

    private ClusterLinkSyncTopicsConfigs newClusterLinkSyncTopicsConfigs() {
        return new ClusterLinkSyncTopicsConfigs(this.clientManager(), this.metadataManager(), this.localClusterLinkAdminClient(), 100, this.metrics());
    }

    private void setupMock(Option<AlterConfigPolicy> alterConfigPolicy, Option<String> tenantPrefix) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.sourceAdmin()});
        Mockito.reset((Object[])new LocalClusterLinkAdminClient[]{this.localClusterLinkAdminClient()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkClientManager[]{this.clientManager()});
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)this.clientManager().alterConfigPolicy()).thenReturn(alterConfigPolicy);
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)new ClusterLinkData("link-name", UUID.randomUUID(), (Option)None$.MODULE$, tenantPrefix, false));
    }

    private Option<AlterConfigPolicy> setupMock$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setupMock$default$2() {
        return None$.MODULE$;
    }
}

