/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.MetadataVersion;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkTestUtils$ {
    public static ClusterLinkTestUtils$ MODULE$;
    private final Metrics metrics;
    private final MockTime time;
    private final AuthorizerServerInfo serverInfo;
    private final KafkaConfig props;
    private final boolean isMultiTenant;

    static {
        new ClusterLinkTestUtils$();
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private AuthorizerServerInfo serverInfo() {
        return this.serverInfo;
    }

    private KafkaConfig props() {
        return this.props;
    }

    private boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    public ClusterLinkManager createClusterLinkManager(MetadataVersion ibp) {
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(this.props(), "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), this.isMultiTenant(), ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        Mockito.when((Object)this.serverInfo().interBrokerEndpoint()).thenReturn((Object)brokerEndpoint);
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ZkMetadataCache metadataCache = (ZkMetadataCache)Mockito.mock(ZkMetadataCache.class);
        Mockito.when((Object)metadataCache.metadataVersion()).thenReturn((Object)ibp);
        Mockito.when((Object)zkClient.getChildren("/cluster_links")).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)zkClient.getClusterLinks((Set)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty());
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).transformEntityConfigs((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.clusterLinkExists((UUID)ArgumentMatchers.isA(UUID.class)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).setOrCreateEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.isA(Properties.class));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).createClusterLink((ClusterLinkData)ArgumentMatchers.isA(ClusterLinkData.class));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).createConfigChangeNotification(ArgumentMatchers.anyString());
        ZkSupport zkSupport = new ZkSupport(null, controller, zkClient, (Option)None$.MODULE$, metadataCache);
        manager.initialize(this.serverInfo(), null, (Option)None$.MODULE$, (MetadataSupport)zkSupport, (Option)None$.MODULE$, null);
        manager.startup();
        return (ClusterLinkManager)manager;
    }

    public MetadataVersion createClusterLinkManager$default$1() {
        return this.props().interBrokerProtocolVersion();
    }

    private ClusterLinkTestUtils$() {
        MODULE$ = this;
        this.metrics = new Metrics();
        this.time = new MockTime();
        this.serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        this.props = KafkaConfig$.MODULE$.apply((Map)TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20), KafkaConfig$.MODULE$.apply$default$2());
        this.isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((Map)this.props().values(), (Metrics)this.metrics()) != null;
    }
}

