/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.resource.PatternType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019I\u0004\u0001)A\u0005m!)!\b\u0001C\u0001w!)A\n\u0001C\u0001w!)a\n\u0001C\u0001w!)\u0001\u000b\u0001C\u0001w!)!\u000b\u0001C\u0001w!)A\u000b\u0001C\u0001w!)a\u000b\u0001C\u0001w!)\u0001\f\u0001C\u0001w!)!\f\u0001C\u0001w!)A\f\u0001C\u0001w!)a\f\u0001C\u0001w!)\u0001\r\u0001C\u0001w!)!\r\u0001C\u0001w!)A\r\u0001C\u0001w!)a\r\u0001C\u0001w!)\u0001\u000e\u0001C\u0001w!)!\u000e\u0001C\u0001w!)A\u000e\u0001C\u0001w!)a\u000e\u0001C\u0005_\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA'\u0001\u0011%\u0011q\n\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u0016;jYN$Vm\u001d;\u000b\u0005uq\u0012\u0001\u00027j].T!a\b\u0011\u0002\rM,'O^3s\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\u001d\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002aA\u0011Q&M\u0005\u0003eq\u0011\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t+\u00051\u0004CA\u00178\u0013\tADD\u0001\u000eNSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/A\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u0011\u0002%Q,7\u000f\u001e,bY&$G*\u001b8l\u001d\u0006lWm\u001d\u000b\u0002yA\u0011Q%P\u0005\u0003}\u0019\u0012A!\u00168ji\"\u0012a\u0001\u0011\t\u0003\u0003*k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b1!\u00199j\u0015\t)e)A\u0004kkBLG/\u001a:\u000b\u0005\u001dC\u0015!\u00026v]&$(\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0005\n!A+Z:u\u0003Q!Xm\u001d;J]Z\fG.\u001b3MS:\\g*Y7fg\"\u0012q\u0001Q\u0001\u0018i\u0016\u001cHOV1mS\u0012\fG/Z'jeJ|'\u000f\u0015:paND#\u0001\u0003!\u00029Q,7\u000f\u001e,bY&$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001cX)\u001c9us\"\u0012\u0011\u0002Q\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/Z%om\u0006d\u0017\u000eZ'jeJ|'\u000f\u0015:paND#A\u0003!\u0002KQ,7\u000f\u001e,bY&$\u0017\r^3J]Z\fG.\u001b3NSJ\u0014xN\u001d)s_B\u001c8+\u001f8p]fl\u0007FA\u0006A\u0003M!Xm\u001d;J]&$X*\u001b:s_J\u0004&o\u001c9tQ\ta\u0001)\u0001\u0010uKN$\u0018J\\5u\u001b&\u0014(o\u001c:Qe>\u00048\u000fT8dC2\fEn^1zg\"\u0012Q\u0002Q\u0001(i\u0016\u001cH/\u00138ji6K'O]8s!J|\u0007o]+oW:|wO\\\"p]\u001aLw-S4o_J,G\r\u000b\u0002\u000f\u0001\u0006)B/Z:u+B$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001c\bFA\bA\u0003%\"Xm\u001d;Va\u0012\fG/Z'jeJ|'\u000f\u0015:paN,fn\u001b8po:\u001cuN\u001c4jO&;gn\u001c:fI\"\u0012\u0001\u0003Q\u0001\u001fi\u0016\u001cHOU3t_24Xm\u0011:fCR,Gk\u001c9jGN#\u0018M\u001c3be\u0012D#!\u0005!\u00029Q,7\u000f\u001e*fg>dg/Z\"sK\u0006$X-T5se>\u0014Hk\u001c9jG\"\u0012!\u0003Q\u0001#i\u0016\u001cHOU3t_24Xm\u0011:fCR,W*\u001b:s_J$v\u000e]5d\u000bJ\u0014xN]:)\u0005M\u0001\u0015\u0001\b;fgR4\u0016\r\\5eCR,7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003)\u0001\u000b!\u0002^3ti\u001aKG\u000e^3sQ\t)\u0002)A\tuKN$H)\u001f8b[&\u001cGj\\4hKJD#A\u0006!\u0002CQ,7\u000f^5t\u0005>|Go\u001d;sCB\u001cuN\u001c4mk\u0016tGo\u00117pk\u0012Dun\u001d;)\u0005]\u0001\u0015AC7bW\u0016\u001cuN\u001c4jOR\u0011\u0001o\u001f\t\u0003cfl\u0011A\u001d\u0006\u0003gR\fQ!\u00193nS:T!!\u001e<\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0011e\u001e\u0006\u0003q\"\u000ba!\u00199bG\",\u0017B\u0001>s\u0005\u0019\u0019uN\u001c4jO\")A\u0010\u0007a\u0001{\u00069QM\u001c;sS\u0016\u001c\b#\u0002@\u0002\u000e\u0005MabA@\u0002\n9!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\t\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0007\u0005-a%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0011\u0011\u0003\u0002\u0004'\u0016\f(bAA\u0006MAIQ%!\u0006\u0002\u001a\u0005e\u0011\u0011F\u0005\u0004\u0003/1#A\u0002+va2,7\u0007\u0005\u0003\u0002\u001c\u0005\rb\u0002BA\u000f\u0003?\u00012!!\u0001'\u0013\r\t\tCJ\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005b\u0005E\u0002&\u0003WI1!!\f'\u0005\u001d\u0011un\u001c7fC:\fa\"\\1lKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u00024\u0005\r\u0003\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005kRLGN\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t\t%a\u000e\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004}3\u0001\u0007\u0011Q\t\t\u0006}\u00065\u0011q\t\t\bK\u0005%\u0013\u0011DA\r\u0013\r\tYE\n\u0002\u0007)V\u0004H.\u001a\u001a\u0002%5\f7.Z\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u000b\u000b\u0003#\nI'!\u001c\u0002x\u0005\u0005\u0005\u0003BA*\u0003GrA!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005uc/\u0001\u0004d_6lwN\\\u0005\u0005\u0003C\n9&A\fDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC&!\u0011QMA4\u00059\u0019%/Z1uC\ndW\rV8qS\u000eTA!!\u0019\u0002X!9\u00111\u000e\u000eA\u0002\u0005e\u0011\u0001\u00028b[\u0016Dq!a\u001c\u001b\u0001\u0004\t\t(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004K\u0005M\u0014bAA;M\t\u0019\u0011J\u001c;\t\u000f\u0005e$\u00041\u0001\u0002|\u0005AA.\u001b8l\u001d\u0006lW\rE\u0003&\u0003{\nI\"C\u0002\u0002\u0000\u0019\u0012aa\u00149uS>t\u0007bBAB5\u0001\u0007\u00111P\u0001\f[&\u0014(o\u001c:U_BL7\r")
public class ClusterLinkUtilsTest {
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, ClusterLinkConfig$.MODULE$.create$default$2());
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    public ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @Test
    public void testValidLinkNames() {
        ClusterLinkUtilsTest.assertValid$1("ABCXYZ.abcxyz-0123456789_");
        ClusterLinkUtilsTest.assertValid$1("...");
        ClusterLinkUtilsTest.assertValid$1("_.-");
        ClusterLinkUtilsTest.assertValid$1(new StringOps(Predef$.MODULE$.augmentString("0123456789")).$times(20));
    }

    @Test
    public void testInvalidLinkNames() {
        ClusterLinkUtilsTest.assertInvalid$1(null);
        ClusterLinkUtilsTest.assertInvalid$1("");
        ClusterLinkUtilsTest.assertInvalid$1(".");
        ClusterLinkUtilsTest.assertInvalid$1("..");
        ClusterLinkUtilsTest.assertInvalid$1("test/link");
        ClusterLinkUtilsTest.assertInvalid$1("test:link");
        ClusterLinkUtilsTest.assertInvalid$1("test\\link");
        ClusterLinkUtilsTest.assertInvalid$1("test\nlink");
        ClusterLinkUtilsTest.assertInvalid$1("test\tlink");
        ClusterLinkUtilsTest.assertInvalid$1(new StringOps(Predef$.MODULE$.augmentString("0123456789")).$times(30));
    }

    @Test
    public void testValidateMirrorProps() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props);
    }

    @Test
    public void testValidateMirrorPropsEmpty() {
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", new Properties());
    }

    @Test
    public void testValidateInvalidMirrorProps() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testValidateInvalidMirrorPropsSynonym() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testInitMirrorProps() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test");
        Assertions.assertEquals((Object)this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760"), (List)Nil$.MODULE$)))), (Object)newLocalProps);
    }

    @Test
    public void testInitMirrorPropsLocalAlways() {
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new MirrorTopicConfigsDelegate(localProps, this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$), this.topicConfigSyncRules()).initMirrorProps("test"));
    }

    @Test
    public void testInitMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = new Properties();
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test").isEmpty());
    }

    @Test
    public void testUpdateMirrorProps() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"delete"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"524288"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties expectedLocalProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test");
        Assertions.assertEquals((Object)expectedLocalProps, (Object)newLocalProps);
    }

    @Test
    public void testUpdateMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"another.bad.config.key"), (Object)"23456"), (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test").isEmpty());
    }

    @Test
    public void testResolveCreateTopicStandard() {
        Properties configs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        CreateTopicsRequestData.CreatableTopic topic = this.makeCreatableTopic("test-topic", 4, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        ClusterLinkUtils.ResolveCreateTopic result = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option)None$.MODULE$, configs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
        Assertions.assertEquals((Object)configs, (Object)result.configs());
        Assertions.assertTrue((boolean)result.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopic() {
        UUID linkId = UUID.randomUUID();
        Properties configs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties expectedConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$)));
        ClusterLinkUtils.ResolveCreateTopic result1 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, true, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
        Assertions.assertEquals((Object)configs, (Object)result1.configs());
        Assertions.assertTrue((boolean)result1.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result1.numPartitions());
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, remoteConfig));
        ClusterLinkUtils.ResolveCreateTopic result2 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
        Assertions.assertEquals((Object)expectedConfigs, (Object)result2.configs());
        Assertions.assertTrue((boolean)(result2.topicState().get() instanceof ClusterLinkTopicState.Mirror));
        Assertions.assertEquals((Object)"link-name", (Object)((ClusterLinkTopicState)result2.topicState().get()).linkName());
        Assertions.assertEquals((int)3, (int)result2.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopicErrors() {
        String topic = "test-topic";
        String linkName = "link-name";
        UUID linkId = UUID.randomUUID();
        Properties validConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Properties invalidConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)None$.MODULE$), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, 4, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)"different-topic")), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), invalidConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new TimeoutException("timeout"));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
        }, ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$9(this, (List)partitionInfos, topic, linkName, linkId, validConfigs), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        Assertions.assertEquals((Object)((ClusterLinkNotFoundException)Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$10(this, (List)partitionInfos, topic, linkName, validConfigs), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291))).getMessage(), (Object)new StringBuilder(41).append("Cluster link with name '").append(linkName).append("' does not exist.").toString());
    }

    @Test
    public void testValidateCreatePartitions() {
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, true, (Option)None$.MODULE$);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        future.complete(BoxesRunTime.boxToInteger((int)3));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some(future));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)new Some(future));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 4, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
    }

    @Test
    public void testFilter() {
        ClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$1("fooLiteral", PatternType.LITERAL, "include");
        ClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$1("bar", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$1("barExclude", PatternType.PREFIXED, "exclude");
        ClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$1("baz", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$1("bazExclude", PatternType.LITERAL, "exclude");
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (Seq)filters)._2()).toSet());
        Seq filters2 = (Seq)filters.$plus$plus((GenTraversableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "include"), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        Seq filters3 = (Seq)filters.$plus$plus((GenTraversableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "exclude"), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testDynamicLogger() {
        RuntimeException e1 = new RuntimeException("runtime exception");
        IllegalStateException e2 = new IllegalStateException("illegal state");
        IllegalArgumentException e3 = new IllegalArgumentException("illegal arg");
        .colon.colon exceptions = new .colon.colon((Object)e1, (List)new .colon.colon((Object)e2, (List)new .colon.colon((Object)e3, (List)Nil$.MODULE$)));
        scala.collection.mutable.Map errorCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map debugCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map warnCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Logging logging = new Logging(null, errorCounts, debugCounts, warnCounts){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final scala.collection.mutable.Map errorCounts$1;
            private final scala.collection.mutable.Map debugCounts$1;
            private final scala.collection.mutable.Map warnCounts$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.errorCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.errorCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent((String)msg.apply()), (Throwable)e.apply());
                    return;
                }
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.debugCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.debugCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent((String)msg.apply()), (Throwable)e.apply());
                    return;
                }
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.warnCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.warnCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent((String)msg.apply()), (Throwable)e.apply());
                    return;
                }
            }
            {
                this.errorCounts$1 = errorCounts$1;
                this.debugCounts$1 = debugCounts$1;
                this.warnCounts$1 = warnCounts$1;
                Logging.$init$((Logging)this);
            }
        };
        ClusterLinkDynamicLogger dynamicLogger = new ClusterLinkDynamicLogger(logging, 4, 2, 50);
        ClusterLinkUtilsTest.clearCounts$1((Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$2(dynamicLogger, e1, errorCounts, warnCounts, debugCounts, (Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$4(dynamicLogger, e1, e2, errorCounts, warnCounts, debugCounts, (Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> dynamicLogger.error(new StringBuilder(5).append("test ").append(i).toString(), (Throwable)e1));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> dynamicLogger.error("test", (Throwable)new RuntimeException(new StringBuilder(5).append("test ").append(i).toString(), e1)));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int n = i % 3;
            switch (n) {
                case 0: {
                    dynamicLogger.error("test", (Throwable)e1);
                    return;
                }
                case 1: {
                    dynamicLogger.error("test", (Throwable)e2);
                    return;
                }
                case 2: {
                    dynamicLogger.error("test", (Throwable)e3);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        exceptions.foreach((Function1 & Serializable & scala.Serializable)e -> {
            ClusterLinkUtilsTest.verifyCounts$1(e, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
            return BoxedUnit.UNIT;
        });
        dynamicLogger.resetErrors();
        ClusterLinkUtilsTest.clearCounts$1((Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> dynamicLogger.error(e1.getMessage(), (Throwable)e1));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> dynamicLogger.error(e2.getMessage(), (Throwable)e2));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 2, 94, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.verifyCounts$1(e2, 4, 4, 192, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((Seq)exceptions, errorCounts, debugCounts, warnCounts);
    }

    @Test
    public void testisBootstrapConfluentCloudHost() {
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("localhost:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("PLAINTEXT://:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("localhost:2345,test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("test.devel.cpdev.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003,foo.bar.us-east2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(ClusterLinkUtilsTest.linkConfig$1("SASL_PLAINTEXT://foo.bar.us-west2.aws.confluent.cloud:9003")));
    }

    private Config makeConfig(Seq<Tuple3<String, String, Object>> entries) {
        Seq configEntries = (Seq)entries.map((Function1 & Serializable & scala.Serializable)entry -> {
            ConfigEntry.ConfigSource source = BoxesRunTime.unboxToBoolean((Object)entry._3()) ? ConfigEntry.ConfigSource.DEFAULT_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
            return new ConfigEntry((String)entry._1(), (String)entry._2(), source, false, false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), ConfigEntry.ConfigType.UNKNOWN, null);
        }, Seq$.MODULE$.canBuildFrom());
        return new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)configEntries).asJavaCollection());
    }

    /*
     * WARNING - void declaration
     */
    private Properties makeProperties(Seq<Tuple2<String, String>> entries) {
        void var2_2;
        Properties props = new Properties();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(name, value);
            return object;
        });
        return var2_2;
    }

    private CreateTopicsRequestData.CreatableTopic makeCreatableTopic(String name, int numPartitions, Option<String> linkName, Option<String> mirrorTopic) {
        return new CreateTopicsRequestData.CreatableTopic().setName(name).setNumPartitions(numPartitions).setReplicationFactor((short)3).setLinkName((String)linkName.orNull(Predef$.MODULE$.$conforms())).setMirrorTopic((String)mirrorTopic.orNull(Predef$.MODULE$.$conforms()));
    }

    private static final void assertValid$1(String linkName) {
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
    }

    private static final void assertInvalid$1(String linkName) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateLinkName(linkName), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$9(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, UUID linkId$1, Properties validConfigs$1) {
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos$1).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$)));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)new Some((Object)linkId$1), validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$10(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Properties validConfigs$1) {
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos$1).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$)));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)None$.MODULE$, validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), ClusterLinkUtils$.MODULE$.resolveCreateTopic$default$7());
    }

    private static final ClusterLinkFilterInfo filterInfo$1(String name, PatternType patternType, String filterType) {
        return new ClusterLinkFilterInfo(name, patternType, filterType, new ClusterLinkFilter(name, patternType.name(), filterType));
    }

    private static final scala.collection.immutable.Set filter$1(scala.collection.immutable.Set items, Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilter(items, filters)._1();
    }

    private static final void clearCounts$1(Seq exceptions$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.mutable.Map warnCounts$1) {
        exceptions$1.foreach((Function1 & Serializable & scala.Serializable)e -> {
            errorCounts$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            debugCounts$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            return (scala.collection.mutable.Map)warnCounts$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
        });
    }

    private static final void verifyCounts$1(Throwable e, int expectedErrors, int expectedWarn, int expectedDebug, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, ClusterLinkDynamicLogger dynamicLogger$1) {
        Assertions.assertEquals((int)expectedErrors, (int)BoxesRunTime.unboxToInt((Object)errorCounts$1.apply(e.getClass())), (String)"Incorrect error count");
        Assertions.assertEquals((int)expectedWarn, (int)BoxesRunTime.unboxToInt((Object)warnCounts$1.apply(e.getClass())), (String)"Incorrect warn count");
        Assertions.assertEquals((int)expectedDebug, (int)BoxesRunTime.unboxToInt((Object)debugCounts$1.apply(e.getClass())), (String)"Incorrect debug count");
        dynamicLogger$1.resetErrors();
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$2(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, Seq exceptions$1, int x$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1));
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$4(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, IllegalStateException e2$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, Seq exceptions$1, int x$3) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int n = i % 2;
            switch (n) {
                case 0: {
                    dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1);
                    return;
                }
                case 1: {
                    dynamicLogger$1.error(e2$1.getMessage(), (Throwable)e2$1);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.verifyCounts$1(e2$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    private static final ClusterLinkConfig linkConfig$1(String bootstrapServers) {
        return ClusterLinkConfig$.MODULE$.create((Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, ClusterLinkConfig$.MODULE$.create$default$2());
    }
}

