/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageListener;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004^\u0001\u0001\u0006I!\u0015\u0005\u0006=\u0002!\ta\u0018\u0005\u0006]\u0002!Ia\u001c\u0005\n\u0003+\u0001\u0011\u0013!C\u0005\u0003/A\u0011\"!\f\u0001#\u0003%I!a\f\t\u0013\u0005M\u0002!%A\u0005\n\u0005U\u0002\"CA\u001d\u0001E\u0005I\u0011BA\u001e\u0011\u0019\ty\u0004\u0001C\u0001?\"1\u0011\u0011\n\u0001\u0005\u0002}Ca!!\u0014\u0001\t\u0003yfABA)\u0001\u0001\t\u0019\u0006\u0003\u0004L\u001b\u0011\u0005\u0011Q\u000b\u0005\n\u00037j\u0001\u0019!C\u0001\u0003;B\u0011\"!\u001b\u000e\u0001\u0004%\t!a\u001b\t\u0011\u0005ET\u0002)Q\u0005\u0003?B\u0011\"a\u001d\u000e\u0005\u0004%\t!!\u001e\t\u0011\u0005\u001dV\u0002)A\u0005\u0003oB\u0011\"!+\u000e\u0001\u0004%\t!a+\t\u0013\u00055V\u00021A\u0005\u0002\u0005=\u0006\u0002CAZ\u001b\u0001\u0006K!!\u0002\t\u0013\u0005UV\u00021A\u0005\u0002\u0005-\u0006\"CA\\\u001b\u0001\u0007I\u0011AA]\u0011!\ti,\u0004Q!\n\u0005\u0015\u0001\"CA`\u001b\u0001\u0007I\u0011AAa\u0011%\tI-\u0004a\u0001\n\u0003\tY\r\u0003\u0005\u0002P6\u0001\u000b\u0015BAb\u0011%\t\t.\u0004a\u0001\n\u0003\tY\u000bC\u0005\u0002T6\u0001\r\u0011\"\u0001\u0002V\"A\u0011\u0011\\\u0007!B\u0013\t)\u0001C\u0004\u0002\\6!\t%!8\u0007\r\u00055\b\u0001AAx\u0011\u0019Y\u0015\u0005\"\u0001\u0002x\"I\u00111L\u0011A\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003S\n\u0003\u0019!C\u0001\u0003wD\u0001\"!\u001d\"A\u0003&\u0011q\f\u0005\n\u0003\u007f\f\u0003\u0019!C\u0001\u0005\u0003A\u0011Ba\u0003\"\u0001\u0004%\tA!\u0004\t\u0011\tE\u0011\u0005)Q\u0005\u0005\u0007AqAa\u0005\"\t\u0003\u0012)\u0002C\u0004\u0003$\u0005\"\tE!\n\t\u000f\tE\u0012\u0005\"\u0011\u00034!9!QI\u0011\u0005B\u0005-\u0006\"\u0003B$\u0001\t\u0007I\u0011\u0002B%\u0011!\u00119\u0006\u0001Q\u0001\n\t-\u0003\"\u0003B-\u0001\t\u0007I\u0011\u0002B%\u0011!\u0011Y\u0006\u0001Q\u0001\n\t-\u0003b\u0002B/\u0001\u0011%!q\f\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u0019\u0011y\u0007\u0001C\u0001?\"1!1\u000f\u0001\u0005\u0002}CaAa\u001e\u0001\t\u0003y\u0006B\u0002B>\u0001\u0011\u0005q\f\u0003\u0004\u0003\u0000\u0001!\ta\u0018\u0005\u0007\u0005\u0007\u0003A\u0011A0\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0002\u001b\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8feR+7\u000f\u001e\u0006\u0003}}\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u0001\u0006\u000baa]3sm\u0016\u0014(\"\u0001\"\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0005C\u0001(\u0001\u001b\u0005i\u0014aG7fi\u0006$\u0017\r^1M_\u0006$\u0017N\\4GCVdG\u000fS1oI2,'/F\u0001R!\t\u00116,D\u0001T\u0015\t!V+A\u0003gCVdGO\u0003\u0002A-*\u0011!i\u0016\u0006\u00031f\u000ba!\u00199bG\",'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]'\n\u0001Rj\\2l\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001d[\u0016$\u0018\rZ1uC2{\u0017\rZ5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:!\u000391XM]5gs:{g)Y;miN$\u0012\u0001\u0019\t\u0003\r\u0006L!AY$\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t\u0011\u0004\"!\u001a7\u000e\u0003\u0019T!a\u001a5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002jU\u00069!.\u001e9ji\u0016\u0014(BA6Z\u0003\u0015QWO\\5u\u0013\tigMA\u0005BMR,'/R1dQ\u0006Ib.Z<Ce>\\WM]'fi\u0006$\u0017\r^1MSN$XM\\3s)\u001d\u00018\u000f_A\u0001\u0003\u0017\u0001\"AT9\n\u0005Il$A\u0006\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:\t\u000fQ,\u0001\u0013!a\u0001k\u00069Q.\u001a;sS\u000e\u001c\bC\u0001(w\u0013\t9XHA\nCe>\\WM]*feZ,'/T3ue&\u001c7\u000fC\u0004z\u000bA\u0005\t\u0019\u0001>\u0002\u0017Mt\u0017\r]:i_R$XM\u001d\t\u0004\rnl\u0018B\u0001?H\u0005\u0019y\u0005\u000f^5p]B\u0011aJ`\u0005\u0003\u007fv\u00121#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;uKJD\u0011\"a\u0001\u0006!\u0003\u0005\r!!\u0002\u000215\f\u0007PQ=uKN\u0014U\r^<fK:\u001cf.\u00199tQ>$8\u000fE\u0002G\u0003\u000fI1!!\u0003H\u0005\u0011auN\\4\t\u0013\u00055Q\u0001%AA\u0002\u0005=\u0011\u0001\u00044bk2$\b*\u00198eY\u0016\u0014\bc\u0001*\u0002\u0012%\u0019\u00111C*\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002G9,wO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004k\u0006m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dr)\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002G9,wO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0007\u0016\u0004u\u0006m\u0011a\t8fo\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003oQC!!\u0002\u0002\u001c\u0005\u0019c.Z<Ce>\\WM]'fi\u0006$\u0017\r^1MSN$XM\\3sI\u0011,g-Y;mi\u0012\"TCAA\u001fU\u0011\ty!a\u0007\u0002%Q,7\u000f^\"sK\u0006$X-\u00118e\u00072|7/\u001a\u0015\u0004\u0015\u0005\r\u0003cA3\u0002F%\u0019\u0011q\t4\u0003\tQ+7\u000f^\u0001\fi\u0016\u001cH\u000fU;cY&\u001c\b\u000eK\u0002\f\u0003\u0007\nq\u0003^3tiB+(\r\\5tQ2+\u0017\rZ3s\u0007\"\fgnZ3)\u00071\t\u0019EA\fN_\u000e\\W*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e;feN\u0019Q\"R?\u0015\u0005\u0005]\u0003cAA-\u001b5\t\u0001!A\u0003j[\u0006<W-\u0006\u0002\u0002`A!\u0011\u0011MA3\u001b\t\t\u0019GC\u0002\u0002\\YKA!a\u001a\u0002d\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011\"[7bO\u0016|F%Z9\u0015\u0007\u0001\fi\u0007C\u0005\u0002pA\t\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\u0002\r%l\u0017mZ3!\u0003\u001d1\u0017-\u001b7ve\u0016,\"!a\u001e\u0011\r\u0005e\u00141RAH\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014AB1u_6L7M\u0003\u0003\u0002\u0002\u0006\r\u0015AC2p]\u000e,(O]3oi*!\u0011QQAD\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0015\u0001\u00026bm\u0006LA!!$\u0002|\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u0012\u0006\u0005f\u0002BAJ\u0003;sA!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033\u001b\u0015A\u0002\u001fs_>$h(C\u0001I\u0013\r\tyjR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019+!*\u0003\u0013QC'o\\<bE2,'bAAP\u000f\u0006Aa-Y5mkJ,\u0007%\u0001\u000bbGRLg/Z*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u000b\u0003\u0003\u000b\t\u0001$Y2uSZ,7K\\1qg\"|Go\u00144gg\u0016$x\fJ3r)\r\u0001\u0017\u0011\u0017\u0005\n\u0003_*\u0012\u0011!a\u0001\u0003\u000b\tQ#Y2uSZ,7K\\1qg\"|Go\u00144gg\u0016$\b%A\nqe\u001648i\\7nSR$X\rZ(gMN,G/A\fqe\u001648i\\7nSR$X\rZ(gMN,Go\u0018\u0013fcR\u0019\u0001-a/\t\u0013\u0005=\u0004$!AA\u0002\u0005\u0015\u0011\u0001\u00069sKZ\u001cu.\\7jiR,Gm\u00144gg\u0016$\b%\u0001\nqe\u001648i\\7nSR$X\rZ#q_\u000eDWCAAb!\r1\u0015QY\u0005\u0004\u0003\u000f<%aA%oi\u00061\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i?\u0012*\u0017\u000fF\u0002a\u0003\u001bD\u0011\"a\u001c\u001c\u0003\u0003\u0005\r!a1\u0002'A\u0014XM^\"p[6LG\u000f^3e\u000bB|7\r\u001b\u0011\u00021A\u0014XM\u001e'bgR\u001cuN\u001c;bS:,G\rT8h)&lW-\u0001\u000fqe\u00164H*Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016|F%Z9\u0015\u0007\u0001\f9\u000eC\u0005\u0002py\t\t\u00111\u0001\u0002\u0006\u0005I\u0002O]3w\u0019\u0006\u001cHoQ8oi\u0006Lg.\u001a3M_\u001e$\u0016.\\3!\u0003Ii\u0017-\u001f2f'R\f'\u000f^*oCB\u001c\bn\u001c;\u0015\r\u0005}\u0017Q]Au!\r1\u0015\u0011]\u0005\u0004\u0003G<%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003O\u0004\u0003\u0019AA\u0003\u0003Qa\u0017m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\"9\u00111\u001e\u0011A\u0002\u0005}\u0013\u0001\u00038fo&k\u0017mZ3\u0003+5{7m['fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feN!\u0011%RAy!\rq\u00151_\u0005\u0004\u0003kl$!E'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feR\u0011\u0011\u0011 \t\u0004\u00033\nCc\u00011\u0002~\"I\u0011q\u000e\u0013\u0002\u0002\u0003\u0007\u0011qL\u0001\tY\u0016\fG-\u001a:JIV\u0011!1\u0001\t\u0005\u0005\u000b\u00119!\u0004\u0002\u0002\u0004&!!\u0011BAB\u0005-y\u0005\u000f^5p]\u0006d\u0017J\u001c;\u0002\u00191,\u0017\rZ3s\u0013\u0012|F%Z9\u0015\u0007\u0001\u0014y\u0001C\u0005\u0002p\u001d\n\t\u00111\u0001\u0003\u0004\u0005IA.Z1eKJLE\rI\u0001\baV\u0014G.[:i)\u0015\u0001'q\u0003B\u0011\u0011\u001d\u0011I\"\u000ba\u0001\u00057\tQ\u0001Z3mi\u0006\u0004B!!\u0019\u0003\u001e%!!qDA2\u00055iU\r^1eCR\fG)\u001a7uC\"9\u00111^\u0015A\u0002\u0005}\u0013\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0007\u0001\u00149\u0003C\u0004\u0003*)\u0002\rAa\u000b\u0002\u00111L7\u000f^3oKJ\u0004B!!\u0019\u0003.%!!qFA2\u0005UiU\r^1eCR\f\u0017*\\1hK2K7\u000f^3oKJ\f1\u0003];cY&\u001c\b\u000eT3bI\u0016\u00148\t[1oO\u0016$2\u0001\u0019B\u001b\u0011\u001d\u00119d\u000ba\u0001\u0005s\ta\u0001\\3bI\u0016\u0014\b\u0003\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}b+\u0001\u0003sC\u001a$\u0018\u0002\u0002B\"\u0005{\u0011a\u0002T3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007.A\bqk\nd\u0017n\u001d5fI>3gm]3u\u0003\u00191ujT0J\tV\u0011!1\n\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)\u0019!\u0011\u000b,\u0002\r\r|W.\\8o\u0013\u0011\u0011)Fa\u0014\u0003\tU+\u0018\u000eZ\u0001\b\r>{u,\u0013#!\u0003\u0019\u0011\u0015IU0J\t\u00069!)\u0011*`\u0013\u0012\u0003\u0013aE4f]\u0016\u0014\u0018\r^3NC:L(+Z2pe\u0012\u001cH#\u00021\u0003b\t\r\u0004B\u0002B\u0015c\u0001\u0007\u0001\u000fC\u0004\u0003fE\u0002\r!!\u0002\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018AE4f]\u0016\u0014\u0018\r^3CC\u0012\u0014VmY8sIN$R\u0001\u0019B6\u0005[BaA!\u000b3\u0001\u0004\u0001\bb\u0002B3e\u0001\u0007\u0011QA\u0001*i\u0016\u001cH\u000fS1oI2,7i\\7nSR\u001cx+\u001b;i\u001d>\u001cf.\u00199tQ>$H/\u001a:EK\u001aLg.\u001a3)\u0007M\n\u0019%\u0001\nuKN$8I]3bi\u0016\u001cf.\u00199tQ>$\bf\u0001\u001b\u0002D\u0005ID/Z:u\u001d>$8K\\1qg\"|G/\u00114uKJlU\r^1eCR\fg+\u001a:tS>t7\t[1oO\u0016\u0014UMZ8sKB+(\r\\5tQ&tw\rK\u00026\u0003\u0007\n!\u0007^3tiNs\u0017\r]:i_R\fe\r^3s\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u000eC\u0017M\\4f/\",gn\u0015;beRLgn\u001a\u0015\u0004m\u0005\r\u0013A\n;fgR\u001cf.\u00199tQ>$\u0018I\u001a;fe6+G/\u00193bi\u00064VM]:j_:\u001c\u0005.\u00198hK\"\u001aq'a\u0011\u00021Q,7\u000f\u001e(p':\f\u0007o\u001d5pi\u00063G/\u001a:FeJ|'\u000fK\u00029\u0003\u0007\nqB]3hSN$XM\u001d\"s_.,'o\u001d\u000b\bA\n-%Q\u0012BL\u0011\u0019\u0011I#\u000fa\u0001a\"9!qR\u001dA\u0002\tE\u0015!\u00032s_.,'/\u00133t!\u0019\t\tJa%\u0002D&!!QSAS\u0005!IE/\u001a:bE2,\u0007b\u0002B3s\u0001\u0007\u0011QA\u0001\u001cGJ,\u0017\r^3U_BL7mV5uQ>sW\rU1si&$\u0018n\u001c8\u0015\u000f\u0001\u0014iJa(\u0003*\"1!\u0011\u0006\u001eA\u0002ADqA!);\u0001\u0004\u0011\u0019+\u0001\u0005sKBd\u0017nY1t!\u0019\t\tJ!*\u0002D&!!qUAS\u0005\r\u0019V-\u001d\u0005\b\u0005KR\u0004\u0019AA\u0003\u00035)\b\u000fZ1uK\u001a+\u0017\r^;sKRI\u0001Ma,\u00032\n\u0015'q\u001a\u0005\u0007\u0005SY\u0004\u0019\u00019\t\u000f\tM6\b1\u0001\u00036\u00069a-Z1ukJ,\u0007\u0003\u0002B\\\u0005\u007fsAA!/\u0003<B\u0019\u0011QS$\n\u0007\tuv)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0003\u0014\u0019M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005{;\u0005b\u0002Bdw\u0001\u0007!\u0011Z\u0001\bm\u0016\u00148/[8o!\r1%1Z\u0005\u0004\u0005\u001b<%!B*i_J$\bb\u0002B3w\u0001\u0007\u0011Q\u0001")
public class BrokerMetadataListenerTest {
    private final MockFaultHandler metadataLoadingFaultHandler = new MockFaultHandler("metadata loading");
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");
    private final Uuid BAR_ID = Uuid.fromString((String)"SzN5j0LvSEaRIJHrxfMAlg");

    private MockFaultHandler metadataLoadingFaultHandler() {
        return this.metadataLoadingFaultHandler;
    }

    @AfterEach
    public void verifyNoFaults() {
        this.metadataLoadingFaultHandler().maybeRethrowFirstException();
    }

    private BrokerMetadataListener newBrokerMetadataListener(BrokerServerMetrics metrics, Option<MetadataSnapshotter> snapshotter, long maxBytesBetweenSnapshots, FaultHandler faultHandler) {
        MetadataEncryptorFactory encryptorFactory = new MetadataEncryptorFactory(Collections.emptyMap());
        return new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, maxBytesBetweenSnapshots, snapshotter, metrics, faultHandler, x$1 -> null, encryptorFactory, KafkaConfigSchema.EMPTY);
    }

    private BrokerServerMetrics newBrokerMetadataListener$default$1() {
        return BrokerServerMetrics$.MODULE$.apply(new Metrics());
    }

    private Option<MetadataSnapshotter> newBrokerMetadataListener$default$2() {
        return None$.MODULE$;
    }

    private long newBrokerMetadataListener$default$3() {
        return 1000000L;
    }

    private FaultHandler newBrokerMetadataListener$default$4() {
        return this.metadataLoadingFaultHandler();
    }

    @Test
    public void testCreateAndClose() {
        this.newBrokerMetadataListener(this.newBrokerMetadataListener$default$1(), this.newBrokerMetadataListener$default$2(), this.newBrokerMetadataListener$default$3(), this.newBrokerMetadataListener$default$4()).close();
    }

    @Test
    public void testPublish() {
        BrokerServerMetrics metrics = BrokerServerMetrics$.MODULE$.apply(new Metrics());
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(metrics, this.newBrokerMetadataListener$default$2(), this.newBrokerMetadataListener$default$3(), this.newBrokerMetadataListener$default$4());){
            long unfencedTimestamp = 300L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, (long)unfencedTimestamp, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0)})));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)2, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)0L, (long)metrics.lastAppliedRecordOffset().get());
            Assertions.assertEquals((long)0L, (long)metrics.lastAppliedRecordTimestamp().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
            long fencedTimestamp = 500L;
            long fencedLastOffset = 200L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)fencedLastOffset, (long)fencedTimestamp, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0)})));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true, false), (Object)delta.clusterDelta().broker(1));
                }

                public void register(MetadataImageListener listener) {
                }

                public void publishLeaderChange(LeaderAndEpoch leader) {
                }

                public long publishedOffset() {
                    return -1L;
                }
            }).get();
            Assertions.assertEquals((long)fencedLastOffset, (long)metrics.lastAppliedRecordOffset().get());
            Assertions.assertEquals((long)fencedTimestamp, (long)metrics.lastAppliedRecordTimestamp().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
        }
    }

    @Test
    public void testPublishLeaderChange() {
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(this.newBrokerMetadataListener$default$1(), this.newBrokerMetadataListener$default$2(), this.newBrokerMetadataListener$default$3(), this.newBrokerMetadataListener$default$4());){
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(1), 100));
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(2), 100));
            listener.startPublishing((MetadataPublisher)publisher).get();
            Assertions.assertEquals((int)2, (int)publisher.leaderId().getAsInt());
            listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(4), 900));
            listener.getImageRecords().get();
            Assertions.assertEquals((int)4, (int)publisher.leaderId().getAsInt());
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private Uuid BAR_ID() {
        return this.BAR_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)}))));
        listener.getImageRecords().get();
    }

    private void generateBadRecords(BrokerMetadataListener listener, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)})));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        long x$1 = 1000L;
        BrokerServerMetrics x$2 = this.newBrokerMetadataListener$default$1();
        Option<MetadataSnapshotter> x$3 = this.newBrokerMetadataListener$default$2();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(x$2, x$3, x$1, x$4);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        long x$2 = 1000L;
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(x$3, (Option<MetadataSnapshotter>)x$1, x$2, x$4);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    @Test
    public void testNotSnapshotAfterMetadataVersionChangeBeforePublishing() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        long x$2 = 1000L;
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        BrokerMetadataListener listener = this.newBrokerMetadataListener(x$3, (Option<MetadataSnapshotter>)x$1, x$2, x$4);
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().apacheFeatureLevel(), 100L);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset(), (String)"We won't generate snapshot on metadata version change before starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChangeWhenStarting() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        long x$2 = 1000L;
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        BrokerMetadataListener listener = this.newBrokerMetadataListener(x$3, (Option<MetadataSnapshotter>)x$1, x$2, x$4);
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().apacheFeatureLevel(), endOffset);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should try to generate snapshot when starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChange() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        long x$2 = 1000L;
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        BrokerMetadataListener listener = this.newBrokerMetadataListener(x$3, (Option<MetadataSnapshotter>)x$1, x$2, x$4);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", (short)(MetadataVersion.latest().apacheFeatureLevel() - 1), endOffset);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should generate snapshot on feature update");
    }

    @Test
    public void testNoSnapshotAfterError() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        MockFaultHandler faultHandler = new MockFaultHandler("metadata loading");
        Some x$1 = new Some((Object)snapshotter);
        long x$2 = 1000L;
        BrokerServerMetrics x$4 = this.newBrokerMetadataListener$default$1();
        try (BrokerMetadataListener listener = this.newBrokerMetadataListener(x$4, (Option<MetadataSnapshotter>)x$1, x$2, (FaultHandler)faultHandler);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateBadRecords(listener, 1000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 2000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)}))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()).setLeader(0).setReplicas((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()), (short)0)})));
    }

    private void updateFeature(BrokerMetadataListener listener, String feature, short version, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(feature).setFeatureLevel(version), (short)0)})));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;
        private OptionalInt leaderId;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public OptionalInt leaderId() {
            return this.leaderId;
        }

        public void leaderId_$eq(OptionalInt x$1) {
            this.leaderId = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public void register(MetadataImageListener listener) {
        }

        public void publishLeaderChange(LeaderAndEpoch leader) {
            this.leaderId_$eq(leader.leaderId());
        }

        public long publishedOffset() {
            return -1L;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.leaderId = OptionalInt.empty();
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

