/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.AbstractLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.MetadataPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\b\u0011\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004=\u0001\u0001\u0006I\u0001\n\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u001f\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u00063\u0002!\tA\u0010\u0005\u00067\u0002!I\u0001\u0018\u0005\u0006g\u0002!I\u0001\u001e\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kA\u0011\"a\u0017\u0001#\u0003%I!!\u0018\t\r\u0005M\u0004\u0001\"\u0001?\u0011\u0019\ty\b\u0001C\u0001}\tY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!!\u0005\n\u0002\u00115,G/\u00193bi\u0006T!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0011\u00035)\u00070\u001b;Fq\u000e,\u0007\u000f^5p]V\tA\u0005E\u0002&]Aj\u0011A\n\u0006\u0003O!\na!\u0019;p[&\u001c'BA\u0015+\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018'\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\u0019:\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026-\u00051AH]8pizJ\u0011aG\u0005\u0003qi\tq\u0001]1dW\u0006<W-\u0003\u0002;w\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003qi\ta\"\u001a=ji\u0016C8-\u001a9uS>t\u0007%A\u0003tKR,\u0006\u000fF\u0001@!\tI\u0002)\u0003\u0002B5\t!QK\\5uQ\t!1\t\u0005\u0002E\u001b6\tQI\u0003\u0002G\u000f\u0006\u0019\u0011\r]5\u000b\u0005!K\u0015a\u00026va&$XM\u001d\u0006\u0003\u0015.\u000bQA[;oSRT\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(F\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q!\u0015\t\u0003\tJK!aU#\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uC\"\u0012aA\u0016\t\u0003\t^K!\u0001W#\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cHOR5oIN#(/Y=SKBd\u0017nY1tQ\t9a+A\u0004n_\u000e\\Gj\\4\u0015\u0007u\u001bg\u000e\u0005\u0002_C6\tqL\u0003\u0002a)\u0005\u0019An\\4\n\u0005\t|&aC!cgR\u0014\u0018m\u0019;M_\u001eDQ\u0001\u001a\u0005A\u0002\u0015\fq\u0001^8qS\u000eLE\r\u0005\u0002gY6\tqM\u0003\u0002iS\u000611m\\7n_:T!!\u00066\u000b\u0005-\\\u0015AB1qC\u000eDW-\u0003\u0002nO\n!Q+^5e\u0011\u0015y\u0007\u00021\u0001q\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"AZ9\n\u0005I<'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000bi>\u0004\u0018nY%nC\u001e,G#B;|y\u00065\u0001C\u0001<z\u001b\u00059(B\u0001=j\u0003\u0015IW.Y4f\u0013\tQxO\u0001\u0006U_BL7-S7bO\u0016DQ\u0001Z\u0005A\u0002\u0015DQ!`\u0005A\u0002y\fQ\u0001^8qS\u000e\u00042a`A\u0004\u001d\u0011\t\t!a\u0001\u0011\u0005MR\u0012bAA\u00035\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\u001b\u0011\u001d\ty!\u0003a\u0001\u0003#\t!\u0002]1si&$\u0018n\u001c8t!\u001dy\u00181CA\f\u0003;IA!!\u0006\u0002\f\t\u0019Q*\u00199\u0011\u0007e\tI\"C\u0002\u0002\u001ci\u00111!\u00138u!\u0015\t\u0014qDA\f\u0013\r\t\tc\u000f\u0002\u0004'\u0016\f\u0018a\u0003;pa&\u001c7/S7bO\u0016$B!a\n\u0002.A\u0019a/!\u000b\n\u0007\u0005-rOA\u0006U_BL7m]%nC\u001e,\u0007bBA\u0018\u0015\u0001\u0007\u0011\u0011G\u0001\u0007i>\u0004\u0018nY:\u0011\tE\ny\"^\u0001\u0011]\u0016<Xj\\2l!V\u0014G.[:iKJ$b!a\u000e\u0002>\u0005%\u0003cA\u0011\u0002:%\u0019\u00111\b\t\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\bbBA \u0017\u0001\u0007\u0011\u0011I\u0001\u0007EJ|7.\u001a:\u0011\t\u0005\r\u0013QI\u0007\u0002%%\u0019\u0011q\t\n\u0003\u0019\t\u0013xn[3s'\u0016\u0014h/\u001a:\t\u0013\u0005-3\u0002%AA\u0002\u00055\u0013\u0001D3se>\u0014\b*\u00198eY\u0016\u0014\b\u0003BA(\u0003/j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0006M\u0006,H\u000e\u001e\u0006\u0003'%LA!!\u0017\u0002R\taa)Y;mi\"\u000bg\u000e\u001a7fe\u0006Qb.Z<N_\u000e\\\u0007+\u001e2mSNDWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0005\u0003\u001b\n\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\tiGG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%\"Xm\u001d;SK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012QB\u0016\u0015\u0004\u001b\u0005e\u0004c\u0001#\u0002|%\u0019\u0011QP#\u0003\u0011\u0011K7/\u00192mK\u0012\f\u0001\u0005^3ti\u0016C8-\u001a9uS>t\u0017J\\+qI\u0006$XmQ8pe\u0012Lg.\u0019;pe\"\u0012aB\u0016")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        AbstractLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        AbstractLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        AbstractLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        AbstractLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        AbstractLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), LeaderRecoveryState.RECOVERED, 0, 0));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava(), null);
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map namesMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)idsMap).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)namesMap).asJava(), Collections.emptyMap(), Collections.emptyMap());
    }

    private BrokerMetadataPublisher newMockPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (BrokerMetadataPublisher)Mockito.spy((Object)new BrokerMetadataPublisher(broker.clusterId(), broker.config(), broker.metadataCache(), broker.logManager(), broker.replicaManager(), broker.groupCoordinator(), broker.transactionCoordinator(), broker.clientQuotaMetadataManager(), broker.dynamicConfigHandlers().toMap(Predef$.MODULE$.$conforms()), Option$.MODULE$.empty(), errorHandler, errorHandler, Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.empty()));
    }

    private FaultHandler newMockPublisher$default$2() {
        return new MockFaultHandler("publisher");
    }

    /*
     * WARNING - void declaration
     */
    @Disabled
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            BrokerMetadataPublisher publisher = this.newMockPublisher(broker, this.newMockPublisher$default$2());
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$4());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        MockFaultHandler errorHandler = new MockFaultHandler("publisher");
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setMetadataFaultHandler(errorHandler).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.metadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l2 = 60000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(errorHandler);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
        }
        finally {
            errorHandler.setIgnore(true);
            cluster.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.metadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(MockFaultHandler errorHandler$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)errorHandler$1.firstException()).flatMap((Function1 & Serializable & scala.Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "(none)")).contains("injected failure"));
    }
}

