/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import kafka.server.KafkaRaftServer$;
import kafka.server.metadata.BrokerMetadataSnapshotter;
import kafka.server.metadata.RecordListConsumer;
import kafka.server.metadata.SnapshotWriterBuilder;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.MockRawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005\u0002A2A!\u0011\u0001\u0001\u0005\")1f\u0001C\u0001\r\"9\u0011j\u0001a\u0001\n\u0003Q\u0005bB/\u0004\u0001\u0004%\tA\u0018\u0005\u0007C\u000e\u0001\u000b\u0015B&\t\u000b\t\u001cA\u0011I2\t\u000f\u0005\u00051\u0001\"\u0001\u0002\u0004\u00191\u00111\u0004\u0001\u0001\u0003;Aaa\u000b\u0006\u0005\u0002\u0005}\u0002\"CA\"\u0015\t\u0007I\u0011AA#\u0011!\tiE\u0003Q\u0001\n\u0005\u001d\u0003BBA(\u0015\u0011\u0005\u0003\u0007\u0003\u0004\u0002R\u0001!\t\u0001\r\u0004\u0007\u0003+\u0002\u0001!a\u0016\t\r-\u0002B\u0011AA-\u0011%\ti\u0006\u0005b\u0001\n\u0003\ty\u0006\u0003\u0005\u0002pA\u0001\u000b\u0011BA1\u0011\u001d\t\t\b\u0005C!\u0003gBq!!!\u0011\t\u0003\n\u0019\tC\u0004\u0002\u0006B!\t%a\"\t\u000f\u0005%\u0005\u0003\"\u0011\u0002\f\"9\u00111\u0013\t\u0005B\u0005U\u0005BBAN!\u0011\u0005\u0003\u0007\u0003\u0004\u0002\u001eB!\t\u0005\r\u0005\u0007\u0003?\u0003A\u0011\u0001\u0019\u0003;\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$XM\u001d+fgRT!AH\u0010\u0002\u00115,G/\u00193bi\u0006T!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u001e\u0003I!Xm\u001d;De\u0016\fG/Z!oI\u000ecwn]3\u0015\u0003E\u0002\"A\n\u001a\n\u0005M:#\u0001B+oSRD#AA\u001b\u0011\u0005YzT\"A\u001c\u000b\u0005aJ\u0014aA1qS*\u0011!hO\u0001\bUV\u0004\u0018\u000e^3s\u0015\taT(A\u0003kk:LGOC\u0001?\u0003\ry'oZ\u0005\u0003\u0001^\u0012A\u0001V3ti\nIRj\\2l':\f\u0007o\u001d5pi^\u0013\u0018\u000e^3s\u0005VLG\u000eZ3s'\r\u0019Qe\u0011\t\u0003]\u0011K!!R\u000f\u0003+Ms\u0017\r]:i_R<&/\u001b;fe\n+\u0018\u000e\u001c3feR\tq\t\u0005\u0002I\u00075\t\u0001!A\u0003j[\u0006<W-F\u0001L!\ra5+V\u0007\u0002\u001b*\u0011ajT\u0001\u000bG>t7-\u001e:sK:$(B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000bAA[1wC&\u0011A+\u0014\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007C\u0001,\\\u001b\u00059&BA%Y\u0015\t\u0011\u0013L\u0003\u0002[{\u00051\u0011\r]1dQ\u0016L!\u0001X,\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003%IW.Y4f?\u0012*\u0017\u000f\u0006\u00022?\"9\u0001MBA\u0001\u0002\u0004Y\u0015a\u0001=%c\u00051\u0011.\\1hK\u0002\nQAY;jY\u0012$B\u0001\u001a;z}B\u0019a%Z4\n\u0005\u0019<#AB(qi&|g\u000eE\u0002iW6l\u0011!\u001b\u0006\u0003Ub\u000b\u0001b\u001d8baNDw\u000e^\u0005\u0003Y&\u0014ab\u00158baNDw\u000e^,sSR,'\u000f\u0005\u0002oe6\tqN\u0003\u0002qc\u000611m\\7n_:T!\u0001\t-\n\u0005M|'\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g\u000eC\u0003v\u0011\u0001\u0007a/A\bd_6l\u0017\u000e\u001e;fI>3gm]3u!\t1s/\u0003\u0002yO\t!Aj\u001c8h\u0011\u0015Q\b\u00021\u0001|\u00039\u0019w.\\7jiR,G-\u00129pG\"\u0004\"A\n?\n\u0005u<#aA%oi\")q\u0010\u0003a\u0001m\u0006!B.Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016\fQcY8ogVlWm\u00158baNDw\u000e\u001e\"vM\u001a,'\u000f\u0006\u0004\u0002\u0006\u0005]\u0011\u0011\u0004\u000b\u0004c\u0005\u001d\u0001bBA\u0005\u0013\u0001\u0007\u00111B\u0001\u0007EV4g-\u001a:\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005R\u0003\rq\u0017n\\\u0005\u0005\u0003+\tyA\u0001\u0006CsR,')\u001e4gKJDQ!^\u0005A\u0002YDQA_\u0005A\u0002m\u0014QB\u00117pG.LgnZ#wK:$8#\u0002\u0006\u0002 \u0005-\u0002\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\u0012+\u0001\u0003mC:<\u0017\u0002BA\u0015\u0003G\u0011aa\u00142kK\u000e$\b\u0003BA\u0017\u0003sqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gA\u0016!B9vKV,\u0017\u0002BA\u001c\u0003c\t!\"\u0012<f]R\fV/Z;f\u0013\u0011\tY$!\u0010\u0003\u000b\u00153XM\u001c;\u000b\t\u0005]\u0012\u0011\u0007\u000b\u0003\u0003\u0003\u0002\"\u0001\u0013\u0006\u0002\u000b1\fGo\u00195\u0016\u0005\u0005\u001d\u0003c\u0001'\u0002J%\u0019\u00111J'\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u00061A.\u0019;dQ\u0002\n1A];o\u0003I!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;)\u0005=)$AE'pG.\u001cf.\u00199tQ>$xK]5uKJ\u001cB\u0001EA\u0010OR\u0011\u00111\f\t\u0003\u0011B\tqAY1uG\",7/\u0006\u0002\u0002bA1\u00111MA3\u0003Sj\u0011aT\u0005\u0004\u0003Oz%!C!se\u0006LH*[:u!\u0015\t\u0019'a\u001bn\u0013\r\tig\u0014\u0002\u0005\u0019&\u001cH/\u0001\u0005cCR\u001c\u0007.Z:!\u0003)\u0019h.\u00199tQ>$\u0018\n\u001a\u000b\u0003\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wB\u0016\u0001\u0002:bMRLA!a \u0002z\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0017A\u00067bgR\u001cuN\u001c;bS:,G\rT8h\u001f\u001a47/\u001a;\u0015\u0003Y\fQ\u0003\\1ti\u000e{g\u000e^1j]\u0016$Gj\\4Fa>\u001c\u0007\u000eF\u0001|\u0003!I7O\u0012:pu\u0016tGCAAG!\r1\u0013qR\u0005\u0004\u0003#;#a\u0002\"p_2,\u0017M\\\u0001\u0007CB\u0004XM\u001c3\u0015\u0007E\n9\nC\u0004\u0002\u001ab\u0001\r!!\u001b\u0002\u000b\t\fGo\u00195\u0002\r\u0019\u0014X-\u001a>f\u0003\u0015\u0019Gn\\:f\u0003Y!Xm\u001d;SK\u000e|'\u000f\u001a'jgR\u001cuN\\:v[\u0016\u0014\bFA\u000e6\u0001")
public class BrokerMetadataSnapshotterTest {
    @Test
    public void testCreateAndClose() {
        new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (x$1, x$2, x$3) -> {
            throw new RuntimeException("unimplemented");
        }, KafkaRaftServer$.MODULE$.configSchema()).close();
    }

    @Test
    public void testCreateSnapshot() {
        MockSnapshotWriterBuilder writerBuilder = new MockSnapshotWriterBuilder();
        BlockingEvent blockingEvent = new BlockingEvent();
        try (BrokerMetadataSnapshotter snapshotter = new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (SnapshotWriterBuilder)writerBuilder, KafkaRaftServer$.MODULE$.configSchema());){
            try {
                snapshotter.eventQueue().append((EventQueue.Event)blockingEvent);
                Assertions.assertTrue((boolean)snapshotter.maybeStartSnapshot(10000L, MetadataImageTest.IMAGE1));
                Assertions.assertFalse((boolean)snapshotter.maybeStartSnapshot(11000L, MetadataImageTest.IMAGE2));
                blockingEvent.latch().countDown();
                Assertions.assertEquals((Object)MetadataImageTest.IMAGE1, (Object)writerBuilder.image().get());
            }
            catch (Throwable throwable) {
                blockingEvent.latch().countDown();
                Assertions.fail((Throwable)throwable);
            }
        }
    }

    @Test
    public void testRecordListConsumer() {
        MockSnapshotWriter writer = new MockSnapshotWriter();
        RecordListConsumer consumer = new RecordListConsumer(3, (SnapshotWriter)writer);
        ApiMessageAndVersion m = new ApiMessageAndVersion((ApiMessage)new FenceBrokerRecord().setId(1).setEpoch(1L), (short)0);
        consumer.accept(Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m}));
        Assertions.assertEquals(Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m})}), writer.batches());
        consumer.accept(Arrays.asList((Object[])new ApiMessageAndVersion[]{m}));
        Assertions.assertEquals(Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m})}), writer.batches());
        consumer.accept(Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m, m}));
        Assertions.assertEquals(Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m})}), writer.batches());
        consumer.accept(Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m, m, m, m, m, m}));
        Assertions.assertEquals(Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m, m}), Arrays.asList((Object[])new ApiMessageAndVersion[]{m, m})}), writer.batches());
    }

    public class BlockingEvent
    implements EventQueue.Event {
        private final CountDownLatch latch;

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public CountDownLatch latch() {
            return this.latch;
        }

        public void run() {
            this.latch().await();
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$BlockingEvent$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public BlockingEvent() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.latch = new CountDownLatch(1);
        }
    }

    public class MockSnapshotWriter
    implements SnapshotWriter<ApiMessageAndVersion> {
        private final ArrayList<List<ApiMessageAndVersion>> batches;

        public ArrayList<List<ApiMessageAndVersion>> batches() {
            return this.batches;
        }

        public OffsetAndEpoch snapshotId() {
            return new OffsetAndEpoch(0L, 0);
        }

        public long lastContainedLogOffset() {
            return 0L;
        }

        public int lastContainedLogEpoch() {
            return 0;
        }

        public boolean isFrozen() {
            return false;
        }

        public void append(List<ApiMessageAndVersion> batch) {
            this.batches().add(batch);
        }

        public void freeze() {
        }

        public void close() {
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$MockSnapshotWriter$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public MockSnapshotWriter() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.batches = new ArrayList();
        }
    }

    public class MockSnapshotWriterBuilder
    implements SnapshotWriterBuilder {
        private CompletableFuture<MetadataImage> image;

        public CompletableFuture<MetadataImage> image() {
            return this.image;
        }

        public void image_$eq(CompletableFuture<MetadataImage> x$1) {
            this.image = x$1;
        }

        public Option<SnapshotWriter<ApiMessageAndVersion>> build(long committedOffset, int committedEpoch, long lastContainedLogTime) {
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(committedOffset, committedEpoch);
            return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(RecordsSnapshotWriter.createWithHeader(() -> Optional.of(new MockRawSnapshotWriter(offsetAndEpoch, buffer -> this.consumeSnapshotBuffer(committedOffset, committedEpoch, (ByteBuffer)buffer))), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)Time.SYSTEM, (long)lastContainedLogTime, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE)));
        }

        public void consumeSnapshotBuffer(long committedOffset, int committedEpoch, ByteBuffer buffer) {
            MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, x$4 -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
            AbstractIterator batchIterator = MemoryRecords.readableRecords((ByteBuffer)buffer).batchIterator();
            while (batchIterator.hasNext()) {
                MutableRecordBatch batch = (MutableRecordBatch)batchIterator.next();
                if (batch.isControlBatch()) continue;
                batch.forEach(record -> {
                    ByteBuffer recordBuffer = record.value().duplicate();
                    ApiMessageAndVersion messageAndVersion = MetadataRecordSerde.INSTANCE.read((Readable)new ByteBufferAccessor(recordBuffer), recordBuffer.remaining());
                    delta.replay(committedOffset, committedEpoch, messageAndVersion.message());
                });
            }
            this.image().complete(delta.apply());
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$MockSnapshotWriterBuilder$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public MockSnapshotWriterBuilder() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.image = new CompletableFuture();
        }
    }
}

