/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.network.SocketServer;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.junit.ClusterInstanceParameterResolver;
import kafka.test.junit.GenericParameterResolver;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import scala.Function0;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class RaftClusterInvocationContext
implements TestTemplateInvocationContext {
    private final ClusterConfig clusterConfig;
    private final AtomicReference<KafkaClusterTestKit> clusterReference;
    private final boolean isCoResident;

    public RaftClusterInvocationContext(ClusterConfig clusterConfig, boolean isCoResident) {
        this.clusterConfig = clusterConfig;
        this.clusterReference = new AtomicReference();
        this.isCoResident = isCoResident;
    }

    public String getDisplayName(int invocationIndex) {
        String clusterDesc = this.clusterConfig.nameTags().entrySet().stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("[%d] Type=Raft-%s, %s", invocationIndex, this.isCoResident ? "CoReside" : "Distributed", clusterDesc);
    }

    public List<Extension> getAdditionalExtensions() {
        RaftClusterInstance clusterInstance = new RaftClusterInstance(this.clusterReference, this.clusterConfig);
        return Arrays.asList(context -> {
            KafkaClusterTestKit cluster = RaftClusterInvocationContext.createClusterReference(this.clusterConfig, this.isCoResident);
            this.clusterReference.set(cluster);
            if (this.clusterConfig.isAutoStart()) {
                clusterInstance.start();
            }
            kafka.utils.TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> cluster.brokers().get(0).brokerState() == BrokerState.RUNNING), (Function0<String>)((Function0)() -> "Broker never made it to RUNNING state."), 15000L, 100L);
        }, context -> clusterInstance.stop(), new ClusterInstanceParameterResolver(clusterInstance), new GenericParameterResolver<ClusterConfig>(this.clusterConfig, ClusterConfig.class));
    }

    public static KafkaClusterTestKit createClusterReference(ClusterConfig clusterConfig, boolean isCoResident) throws Exception {
        TestKitNodes nodes = new TestKitNodes.Builder().setBootstrapMetadataVersion(clusterConfig.metadataVersion()).setCoResident(isCoResident).setNumBrokerNodes(clusterConfig.numBrokers()).setNumControllerNodes(clusterConfig.numControllers()).build();
        nodes.brokerNodes().forEach((brokerId, brokerNode) -> clusterConfig.brokerServerProperties((int)brokerId).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> brokerNode.propertyOverrides().put(key.toString(), value.toString()))));
        KafkaClusterTestKit.Builder builder = new KafkaClusterTestKit.Builder(nodes);
        clusterConfig.serverProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.setConfigProp(key.toString(), value.toString())));
        return builder.build();
    }

    public static class RaftClusterInstance
    implements ClusterInstance {
        private final AtomicReference<KafkaClusterTestKit> clusterReference;
        private final ClusterConfig clusterConfig;
        final AtomicBoolean started = new AtomicBoolean(false);
        final AtomicBoolean stopped = new AtomicBoolean(false);
        private final ConcurrentLinkedQueue<Admin> admins = new ConcurrentLinkedQueue();

        RaftClusterInstance(AtomicReference<KafkaClusterTestKit> clusterReference, ClusterConfig clusterConfig) {
            this.clusterReference = clusterReference;
            this.clusterConfig = clusterConfig;
        }

        @Override
        public String bootstrapServers() {
            return this.clusterReference.get().clientProperties().getProperty("bootstrap.servers");
        }

        @Override
        public Collection<SocketServer> brokerSocketServers() {
            return this.brokersStream().map(BrokerServer::socketServer).collect(Collectors.toList());
        }

        @Override
        public ListenerName clientListener() {
            return ListenerName.normalised((String)"EXTERNAL");
        }

        @Override
        public ListenerName controllerListener() {
            return ListenerName.normalised((String)"CONTROLLER");
        }

        @Override
        public Optional<ListenerName> controllerListenerName() {
            return OptionConverters.toJava((Option)this.controllersStream().findAny().get().config().controllerListenerNames().headOption().map(ListenerName::new));
        }

        @Override
        public Collection<SocketServer> controllerSocketServers() {
            return this.controllersStream().map(ControllerServer::socketServer).collect(Collectors.toList());
        }

        @Override
        public SocketServer anyBrokerSocketServer() {
            return this.brokersStream().map(BrokerServer::socketServer).findFirst().orElseThrow(() -> new RuntimeException("No broker SocketServers found"));
        }

        @Override
        public SocketServer anyControllerSocketServer() {
            return this.controllersStream().map(ControllerServer::socketServer).findFirst().orElseThrow(() -> new RuntimeException("No controller SocketServers found"));
        }

        @Override
        public SocketServer activeController() throws InterruptedException {
            TestUtils.waitForCondition(() -> this.controllersStream().anyMatch(controller -> controller.controller().isActive()), (String)"Timed out waiting for active controller");
            return this.controllersStream().filter(controller -> controller.controller().isActive()).map(ControllerServer::socketServer).findFirst().orElseThrow(() -> new RuntimeException("No controller SocketServers found"));
        }

        @Override
        public Map<Integer, BrokerFeatures> brokerFeatures() {
            return this.brokersStream().collect(Collectors.toMap(brokerServer -> brokerServer.config().nodeId(), BrokerServer::brokerFeatures));
        }

        public Collection<ControllerServer> controllerServers() {
            return this.controllersStream().collect(Collectors.toList());
        }

        @Override
        public ClusterInstance.ClusterType clusterType() {
            return ClusterInstance.ClusterType.RAFT;
        }

        @Override
        public String clusterId() {
            return this.brokersStream().map(BrokerServer::clusterId).findFirst().orElseThrow(() -> new RuntimeException("No BrokerServers found"));
        }

        @Override
        public ClusterConfig config() {
            return this.clusterConfig;
        }

        @Override
        public Set<Integer> controllerIds() {
            return this.controllersStream().map(controllerServer -> controllerServer.config().nodeId()).collect(Collectors.toSet());
        }

        @Override
        public Set<Integer> brokerIds() {
            return this.brokersStream().map(brokerServer -> brokerServer.config().nodeId()).collect(Collectors.toSet());
        }

        @Override
        public KafkaClusterTestKit getUnderlying() {
            return this.clusterReference.get();
        }

        @Override
        public RaftClusterInstance duplicateCluster(Consumer<ClusterConfig.Builder> builderConsumer) {
            try {
                ClusterConfig newConfig = this.clusterConfig.copyOf(builderConsumer);
                AtomicReference<KafkaClusterTestKit> newClusterRef = new AtomicReference<KafkaClusterTestKit>(RaftClusterInvocationContext.createClusterReference(newConfig, false));
                RaftClusterInstance newClusterInstance = new RaftClusterInstance(newClusterRef, newConfig);
                if (this.clusterConfig.isAutoStart()) {
                    newClusterInstance.start();
                    try {
                        newClusterInstance.waitForReadyBrokers();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted while waiting for ready brokers", e);
                    }
                }
                return newClusterInstance;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create duplicate cluster", e);
            }
        }

        @Override
        public Admin createAdminClient(Properties configOverrides) {
            Admin admin = Admin.create((Properties)this.clusterReference.get().clientProperties(configOverrides));
            this.admins.add(admin);
            return admin;
        }

        @Override
        public void start() {
            if (this.started.compareAndSet(false, true)) {
                try {
                    this.clusterReference.get().format();
                    this.clusterReference.get().startup();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to start Raft server", e);
                }
            }
        }

        @Override
        public void stop() {
            if (this.stopped.compareAndSet(false, true)) {
                this.admins.forEach(admin -> Utils.closeQuietly((AutoCloseable)admin, (String)"admin"));
                Utils.closeQuietly((AutoCloseable)this.clusterReference.get(), (String)"cluster");
            }
        }

        @Override
        public void shutdownBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).shutdown();
        }

        @Override
        public void startBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).startup();
        }

        @Override
        public void waitForReadyBrokers() throws InterruptedException {
            try {
                this.clusterReference.get().waitForReadyBrokers();
            }
            catch (ExecutionException e) {
                throw new AssertionError("Failed while waiting for brokers to become ready", e);
            }
        }

        @Override
        public Map<Integer, KafkaBroker> brokersMap() {
            return this.brokersStream().collect(Collectors.toMap(broker -> broker.config().nodeId(), Function.identity()));
        }

        @Override
        public void rollingBrokerRestart() {
            throw new UnsupportedOperationException("Restarting Raft servers is not yet supported.");
        }

        public Map<Integer, MetadataImage> metadataImage() {
            return this.brokersStream().collect(Collectors.toMap(brokerServer -> brokerServer.config().nodeId(), brokerServer -> brokerServer.metadataCache().currentImage()));
        }

        private BrokerServer findBrokerOrThrow(int brokerId) {
            return Optional.ofNullable(this.clusterReference.get().brokers().get(brokerId)).orElseThrow(() -> new IllegalArgumentException("Unknown brokerId " + brokerId));
        }

        public Stream<BrokerServer> brokersStream() {
            return this.clusterReference.get().brokers().values().stream();
        }

        public Map<Integer, ControllerServer> controllersMap() {
            return this.controllersStream().collect(Collectors.toMap(controller -> controller.config().nodeId(), Function.identity()));
        }

        public Stream<ControllerServer> controllersStream() {
            return this.clusterReference.get().controllers().values().stream();
        }
    }
}

