/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.server.MetaProperties;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.testkit.BrokerNode;
import kafka.testkit.ControllerNode;
import kafka.testkit.TestKitNodes;
import kafka.tools.StorageTool;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.MockControllerMetrics;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class KafkaClusterTestKit
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KafkaClusterTestKit.class);
    private final ExecutorService executorService;
    private final TestKitNodes nodes;
    private final Map<Integer, ControllerServer> controllers;
    private final Map<Integer, BrokerServer> brokers;
    private final Map<Integer, KafkaRaftManager<ApiMessageAndVersion>> raftManagers;
    private final ControllerQuorumVotersFutureManager controllerQuorumVotersFutureManager;
    private final File baseDirectory;
    private final MockFaultHandler metadataFaultHandler;
    private final MockFaultHandler fatalFaultHandler;

    private KafkaClusterTestKit(ExecutorService executorService, TestKitNodes nodes, Map<Integer, ControllerServer> controllers, Map<Integer, BrokerServer> brokers, Map<Integer, KafkaRaftManager<ApiMessageAndVersion>> raftManagers, ControllerQuorumVotersFutureManager controllerQuorumVotersFutureManager, File baseDirectory, MockFaultHandler metadataFaultHandler, MockFaultHandler fatalFaultHandler) {
        this.executorService = executorService;
        this.nodes = nodes;
        this.controllers = controllers;
        this.brokers = brokers;
        this.raftManagers = raftManagers;
        this.controllerQuorumVotersFutureManager = controllerQuorumVotersFutureManager;
        this.baseDirectory = baseDirectory;
        this.metadataFaultHandler = metadataFaultHandler;
        this.fatalFaultHandler = fatalFaultHandler;
    }

    public void format() throws Exception {
        ArrayList futures = new ArrayList();
        try {
            int nodeId;
            for (Map.Entry<Integer, ControllerServer> entry : this.controllers.entrySet()) {
                nodeId = entry.getKey();
                ControllerServer controller = entry.getValue();
                this.formatNodeAndLog(this.nodes.controllerProperties(nodeId), controller.config().metadataLogDir(), (Logging)controller, futures::add);
            }
            for (Map.Entry<Integer, ControllerServer> entry : this.brokers.entrySet()) {
                nodeId = entry.getKey();
                BrokerServer broker = (BrokerServer)entry.getValue();
                this.formatNodeAndLog(this.nodes.brokerProperties(nodeId), broker.config().metadataLogDir(), (Logging)broker, futures::add);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw e;
        }
    }

    private void formatNodeAndLog(MetaProperties properties, String metadataLogDir, Logging loggingMixin, Consumer<Future<?>> futureConsumer) {
        futureConsumer.accept(this.executorService.submit(() -> {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                try {
                    block27: {
                        PrintStream out;
                        block28: {
                            out = new PrintStream(stream);
                            Throwable throwable = null;
                            try {
                                StorageTool.formatCommand((PrintStream)out, (Seq)JavaConverters.asScalaBuffer(Collections.singletonList(metadataLogDir)).toSeq(), (MetaProperties)properties, (MetadataVersion)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (boolean)false);
                                if (out == null) break block27;
                                if (throwable == null) break block28;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (out == null) throw throwable4;
                                    if (throwable == null) {
                                        out.close();
                                        throw throwable4;
                                    }
                                    try {
                                        out.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        out.close();
                    }
                }
                finally {
                    String[] stringArray = stream.toString().split(String.format("%n", new Object[0]));
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        loggingMixin.info(() -> line);
                        ++n2;
                    }
                    return;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public void startup() throws ExecutionException, InterruptedException {
        ArrayList<Object> futures = new ArrayList<Object>();
        try {
            for (KafkaRaftManager<ApiMessageAndVersion> kafkaRaftManager : this.raftManagers.values()) {
                futures.add(this.controllerQuorumVotersFutureManager.future.thenRunAsync(() -> kafkaRaftManager.startup()));
            }
            for (ControllerServer controllerServer : this.controllers.values()) {
                futures.add(this.executorService.submit(() -> ((ControllerServer)controllerServer).startup()));
            }
            for (BrokerServer brokerServer : this.brokers.values()) {
                futures.add(this.executorService.submit(() -> ((BrokerServer)brokerServer).startup()));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw e;
        }
    }

    public void waitForReadyBrokers() throws ExecutionException, InterruptedException {
        ControllerServer controllerServer = this.controllers.values().iterator().next();
        Controller controller = controllerServer.controller();
        controller.waitForReadyBrokers(this.brokers.size()).get();
        TestUtils.waitForCondition(() -> this.brokers().values().stream().allMatch(brokerServer -> brokerServer.metadataCache().getAliveBrokers().size() == this.brokers.size()), (String)"Failed to wait for publisher to publish the metadata update to each broker.");
    }

    public Properties controllerClientProperties() throws ExecutionException, InterruptedException {
        Properties properties = new Properties();
        if (!this.controllers.isEmpty()) {
            List controllerNodes = RaftConfig.voterConnectionsToNodes((Map)((Map)this.controllerQuorumVotersFutureManager.future.get()));
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (Node node : controllerNodes) {
                bld.append(prefix).append(node.id()).append('@');
                bld.append(node.host()).append(":").append(node.port());
                prefix = ",";
            }
            properties.setProperty("controller.quorum.voters", bld.toString());
            properties.setProperty("bootstrap.servers", controllerNodes.stream().map(n -> n.host() + ":" + n.port()).collect(Collectors.joining(",")));
        }
        return properties;
    }

    public Properties clientProperties() {
        return this.clientProperties(new Properties());
    }

    public Properties clientProperties(Properties configOverrides) {
        if (!this.brokers.isEmpty()) {
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (Map.Entry<Integer, BrokerServer> entry : this.brokers.entrySet()) {
                ListenerName listenerName;
                int brokerId = entry.getKey();
                BrokerServer broker = entry.getValue();
                int port = broker.boundPort(listenerName = this.nodes.externalListenerName());
                if (port <= 0) {
                    throw new RuntimeException("Broker " + brokerId + " does not yet have a bound port for " + listenerName + ".  Did you start the cluster yet?");
                }
                bld.append(prefix).append("localhost:").append(port);
                prefix = ",";
            }
            configOverrides.putIfAbsent("bootstrap.servers", bld.toString());
        }
        return configOverrides;
    }

    public Map<Integer, ControllerServer> controllers() {
        return this.controllers;
    }

    public Map<Integer, BrokerServer> brokers() {
        return this.brokers;
    }

    public CompletableFuture<String> quorumVotersString() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.controllerQuorumVotersFutureManager.future.whenComplete((map, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(String.join((CharSequence)",", RaftConfig.voterConnectionsToNodes((Map)map).stream().map(n -> String.format("%d@%s:%d", n.id(), n.host(), n.port())).collect(Collectors.toList())));
            }
        });
        return future;
    }

    public Map<Integer, KafkaRaftManager<ApiMessageAndVersion>> raftManagers() {
        return this.raftManagers;
    }

    public TestKitNodes nodes() {
        return this.nodes;
    }

    public void shutdownAll() throws Exception {
        ArrayList futureEntries = new ArrayList();
        try {
            this.controllerQuorumVotersFutureManager.close();
            for (Map.Entry<Integer, BrokerServer> entry : this.brokers.entrySet()) {
                int n = entry.getKey();
                BrokerServer broker = entry.getValue();
                futureEntries.add(new AbstractMap.SimpleImmutableEntry("broker" + n, this.executorService.submit(() -> ((BrokerServer)broker).shutdown())));
            }
            this.waitForAllFutures(futureEntries);
            futureEntries.clear();
            for (Map.Entry<Integer, BrokerServer> entry : this.raftManagers.entrySet()) {
                int n = entry.getKey();
                KafkaRaftManager raftManager = (KafkaRaftManager)entry.getValue();
                futureEntries.add(new AbstractMap.SimpleImmutableEntry("raftManager" + n, this.executorService.submit(() -> ((KafkaRaftManager)raftManager).shutdown())));
            }
            this.waitForAllFutures(futureEntries);
            futureEntries.clear();
            for (Map.Entry<Integer, BrokerServer> entry : this.controllers.entrySet()) {
                int n = entry.getKey();
                ControllerServer controller = (ControllerServer)entry.getValue();
                futureEntries.add(new AbstractMap.SimpleImmutableEntry("controller" + n, this.executorService.submit(() -> ((ControllerServer)controller).shutdown())));
            }
            this.waitForAllFutures(futureEntries);
            futureEntries.clear();
        }
        catch (Exception e) {
            for (Map.Entry entry : futureEntries) {
                ((Future)entry.getValue()).cancel(true);
            }
            throw e;
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.shutdownAll();
            Utils.delete((File)this.baseDirectory);
        }
        finally {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(5L, TimeUnit.MINUTES);
        }
        this.metadataFaultHandler.maybeRethrowFirstException();
        this.fatalFaultHandler.maybeRethrowFirstException();
    }

    private void waitForAllFutures(List<Map.Entry<String, Future<?>>> futureEntries) throws Exception {
        for (Map.Entry<String, Future<?>> entry : futureEntries) {
            log.debug("waiting for {} to shut down.", (Object)entry.getKey());
            entry.getValue().get();
            log.debug("{} successfully shut down.", (Object)entry.getKey());
        }
    }

    public String clusterId() {
        return this.nodes.clusterId().toString();
    }

    public static class Builder {
        private TestKitNodes nodes;
        private Map<String, String> configProps = new HashMap<String, String>();
        private MockFaultHandler metadataFaultHandler = new MockFaultHandler("metadataFaultHandler");
        private MockFaultHandler fatalFaultHandler = new MockFaultHandler("fatalFaultHandler");

        public Builder(TestKitNodes nodes) {
            this.nodes = nodes;
        }

        public Builder setConfigProp(String key, String value) {
            this.configProps.put(key, value);
            return this;
        }

        public Builder setMetadataFaultHandler(MockFaultHandler metadataFaultHandler) {
            this.metadataFaultHandler = metadataFaultHandler;
            return this;
        }

        public KafkaClusterTestKit build() throws Exception {
            HashMap<Integer, ControllerServer> controllers = new HashMap<Integer, ControllerServer>();
            HashMap<Integer, BrokerServer> brokers = new HashMap<Integer, BrokerServer>();
            HashMap<Integer, KafkaRaftManager> raftManagers = new HashMap<Integer, KafkaRaftManager>();
            String uninitializedQuorumVotersString = this.nodes.controllerNodes().keySet().stream().map(controllerNode -> String.format("%d@0.0.0.0:0", controllerNode)).collect(Collectors.joining(","));
            int numOfExecutorThreads = (this.nodes.brokerNodes().size() + this.nodes.controllerNodes().size()) * 2;
            ExecutorService executorService = null;
            ControllerQuorumVotersFutureManager connectFutureManager = new ControllerQuorumVotersFutureManager(this.nodes.controllerNodes().size());
            File baseDirectory = null;
            try {
                TopicPartition metadataPartition;
                MetaProperties metaProperties;
                String threadNamePrefix;
                KafkaConfig config;
                HashMap<String, String> props;
                baseDirectory = TestUtils.tempDirectory();
                this.nodes = this.nodes.copyWithAbsolutePaths(baseDirectory.getAbsolutePath());
                executorService = Executors.newFixedThreadPool(numOfExecutorThreads, ThreadUtils.createThreadFactory((String)"KafkaClusterTestKit%d", (boolean)false));
                for (ControllerNode controllerNode2 : this.nodes.controllerNodes().values()) {
                    props = new HashMap<String, String>(this.configProps);
                    props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), this.roles(controllerNode2.id()));
                    props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(controllerNode2.id()));
                    props.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), controllerNode2.metadataDirectory());
                    props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,CONTROLLER:PLAINTEXT");
                    props.put(KafkaConfig$.MODULE$.ListenersProp(), this.listeners(controllerNode2.id()));
                    props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.nodes.interBrokerListenerName().value());
                    props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
                    props.put("controller.quorum.voters", uninitializedQuorumVotersString);
                    props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
                    Builder.setupNodeDirectories(baseDirectory, controllerNode2.metadataDirectory(), Collections.emptyList());
                    config = new KafkaConfig(props, false, Option.empty());
                    threadNamePrefix = String.format("controller%d_", controllerNode2.id());
                    metaProperties = MetaProperties.apply((String)this.nodes.clusterId().toString(), (int)controllerNode2.id());
                    metadataPartition = new TopicPartition(KafkaRaftServer.MetadataTopic(), 0);
                    BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)this.nodes.bootstrapMetadataVersion(), (String)"testkit", (boolean)false);
                    KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)new MetadataRecordSerde(), metadataPartition, KafkaRaftServer.MetadataTopicId(), Time.SYSTEM, new Metrics(), Option.apply((Object)threadNamePrefix), connectFutureManager.future);
                    ControllerServer controller = new ControllerServer(this.nodes.controllerProperties(controllerNode2.id()), config, (RaftManager)raftManager, Option.empty(), Time.SYSTEM, new Metrics(), (ControllerMetrics)new MockControllerMetrics(), Option.apply((Object)threadNamePrefix), connectFutureManager.future, KafkaRaftServer.configSchema(), raftManager.apiVersions(), bootstrapMetadata, (FaultHandler)this.metadataFaultHandler, (FaultHandler)this.fatalFaultHandler, Option.empty());
                    controllers.put(controllerNode2.id(), controller);
                    controller.socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                        if (e != null) {
                            connectFutureManager.fail((Throwable)e);
                        } else {
                            connectFutureManager.registerPort(controllerNode2.id(), (int)port);
                        }
                    });
                    raftManagers.put(controllerNode2.id(), raftManager);
                }
                for (BrokerNode brokerNode : this.nodes.brokerNodes().values()) {
                    KafkaRaftManager raftManager;
                    props = new HashMap<String, String>(this.configProps);
                    props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), this.roles(brokerNode.id()));
                    props.put(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(brokerNode.id()));
                    props.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), brokerNode.metadataDirectory());
                    props.put(KafkaConfig$.MODULE$.LogDirsProp(), String.join((CharSequence)",", brokerNode.logDataDirectories()));
                    props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,CONTROLLER:PLAINTEXT");
                    props.put(KafkaConfig$.MODULE$.ListenersProp(), this.listeners(brokerNode.id()));
                    props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.nodes.interBrokerListenerName().value());
                    props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
                    props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
                    Builder.setupNodeDirectories(baseDirectory, brokerNode.metadataDirectory(), brokerNode.logDataDirectories());
                    props.put("controller.quorum.voters", uninitializedQuorumVotersString);
                    props.putAll(brokerNode.propertyOverrides());
                    Builder.disableUnsupportedConfigsEnabledByDefault(props);
                    config = new KafkaConfig(props, false, Option.empty());
                    threadNamePrefix = String.format("broker%d_", brokerNode.id());
                    metaProperties = MetaProperties.apply((String)this.nodes.clusterId().toString(), (int)brokerNode.id());
                    metadataPartition = new TopicPartition(KafkaRaftServer.MetadataTopic(), 0);
                    if (raftManagers.containsKey(brokerNode.id())) {
                        raftManager = (KafkaRaftManager)raftManagers.get(brokerNode.id());
                    } else {
                        raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)new MetadataRecordSerde(), metadataPartition, KafkaRaftServer.MetadataTopicId(), Time.SYSTEM, new Metrics(), Option.apply((Object)threadNamePrefix), connectFutureManager.future);
                        raftManagers.put(brokerNode.id(), raftManager);
                    }
                    Metrics metrics = new Metrics();
                    BrokerServer broker = new BrokerServer(config, this.nodes.brokerProperties(brokerNode.id()), (RaftManager)raftManager, Option.empty(), Time.SYSTEM, metrics, BrokerServerMetrics$.MODULE$.apply(metrics), Option.apply((Object)threadNamePrefix), JavaConverters.asScalaBuffer(Collections.emptyList()).toSeq(), connectFutureManager.future, (FaultHandler)this.fatalFaultHandler, (FaultHandler)this.metadataFaultHandler, (FaultHandler)this.metadataFaultHandler, Option.empty());
                    brokers.put(brokerNode.id(), broker);
                }
            }
            catch (Exception e2) {
                if (executorService != null) {
                    executorService.shutdownNow();
                    executorService.awaitTermination(5L, TimeUnit.MINUTES);
                }
                for (BrokerServer brokerServer : brokers.values()) {
                    brokerServer.shutdown();
                }
                for (KafkaRaftManager raftManager : raftManagers.values()) {
                    raftManager.shutdown();
                }
                for (ControllerServer controller : controllers.values()) {
                    controller.shutdown();
                }
                connectFutureManager.close();
                if (baseDirectory != null) {
                    Utils.delete((File)baseDirectory);
                }
                throw e2;
            }
            return new KafkaClusterTestKit(executorService, this.nodes, controllers, brokers, raftManagers, connectFutureManager, baseDirectory, this.metadataFaultHandler, this.fatalFaultHandler);
        }

        private static void disableUnsupportedConfigsEnabledByDefault(Map<String, String> props) {
            List configsThatMustNotBeEnabled = Collections.emptyList();
            String requiredValue = Boolean.FALSE.toString();
            configsThatMustNotBeEnabled.stream().forEach(key -> {
                String value = props.getOrDefault(key, requiredValue);
                if (!value.equals(requiredValue)) {
                    throw new IllegalStateException(String.format("KRaft does not yet support a value other than %s for %s: %s", requiredValue, key, value));
                }
                props.put((String)key, requiredValue);
            });
        }

        private String listeners(int node) {
            if (this.nodes.isCoResidentNode(node)) {
                return "EXTERNAL://localhost:0,CONTROLLER://localhost:0";
            }
            if (this.nodes.controllerNodes().containsKey(node)) {
                return "CONTROLLER://localhost:0";
            }
            return "EXTERNAL://localhost:0";
        }

        private String roles(int node) {
            if (this.nodes.isCoResidentNode(node)) {
                return "broker,controller";
            }
            if (this.nodes.controllerNodes().containsKey(node)) {
                return "controller";
            }
            return "broker";
        }

        private static void setupNodeDirectories(File baseDirectory, String metadataDirectory, Collection<String> logDataDirectories) throws Exception {
            Files.createDirectories(new File(baseDirectory, "local").toPath(), new FileAttribute[0]);
            Files.createDirectories(Paths.get(metadataDirectory, new String[0]), new FileAttribute[0]);
            for (String logDataDirectory : logDataDirectories) {
                Files.createDirectories(Paths.get(logDataDirectory, new String[0]), new FileAttribute[0]);
            }
        }
    }

    private static class ControllerQuorumVotersFutureManager
    implements AutoCloseable {
        private final int expectedControllers;
        private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> future = new CompletableFuture();
        private final Map<Integer, Integer> controllerPorts = new TreeMap<Integer, Integer>();

        ControllerQuorumVotersFutureManager(int expectedControllers) {
            this.expectedControllers = expectedControllers;
        }

        synchronized void registerPort(int nodeId, int port) {
            this.controllerPorts.put(nodeId, port);
            if (this.controllerPorts.size() >= this.expectedControllers) {
                this.future.complete(this.controllerPorts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", (int)((Integer)entry.getValue()))))));
            }
        }

        void fail(Throwable e) {
            this.future.completeExceptionally(e);
        }

        @Override
        public void close() {
            this.future.cancel(true);
        }
    }
}

