/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u0012%\u0001%BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019\u0001\u0006\u0001)A\u0005\u000f\"9\u0011\u000b\u0001b\u0001\n\u00031\u0005B\u0002*\u0001A\u0003%q\tC\u0004T\u0001\u0001\u0007I\u0011\u0001+\t\u000f\r\u0004\u0001\u0019!C\u0001I\"1!\u000e\u0001Q!\nUCqa\u001b\u0001A\u0002\u0013\u0005A\u000eC\u0004z\u0001\u0001\u0007I\u0011\u0001>\t\rq\u0004\u0001\u0015)\u0003n\u0011\u001di\bA1A\u0005\u0002yDq!a\u0005\u0001A\u0003%q\u0010C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011\u0011\u0006\u0001!\u0002\u0013\tI\u0002C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003#Bq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002^\u0002!I!a8\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA~\u0001\u0011%\u0011Q \u0005\u0007\u0005\u001f\u0001A\u0011\u00027\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!Q\u0003\u0001\u0005\n\t]\u0001\"\u0003B\u0013\u0001E\u0005I\u0011\u0002B\u0014\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fA\u0011B!\u0019\u0001#\u0003%\tAa\u0019\u0003;QKWM]#q_\u000eD7\u000b^1uKJ+\u0007\u000f\\5dCRLwN\u001c+fgRT!!\n\u0014\u0002\tQLWM\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005=b#!E)v_J,X\u000eV3ti\"\u000b'O\\3tgB\u0011\u0011\u0007N\u0007\u0002e)\u00111GJ\u0001\u0006kRLGn]\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002I\u0005)Ao\u001c9jGV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005\u0019Qn]4\u0016\u0003\u001d\u00032\u0001S&N\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%!B!se\u0006L\bC\u0001%O\u0013\ty\u0015J\u0001\u0003CsR,\u0017\u0001B7tO\u0002\n\u0011\"\\:h\u0005&<w-\u001a:\u0002\u00155\u001cxMQ5hO\u0016\u0014\b%A\u0004ce>\\WM]:\u0016\u0003U\u0003BAV.^A6\tqK\u0003\u0002Y3\u00069Q.\u001e;bE2,'B\u0001.J\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039^\u00131!T1q!\tAe,\u0003\u0002`\u0013\n\u0019\u0011J\u001c;\u0011\u0005-\n\u0017B\u00012-\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002\u0017\t\u0014xn[3sg~#S-\u001d\u000b\u0003K\"\u0004\"\u0001\u00134\n\u0005\u001dL%\u0001B+oSRDq![\u0005\u0002\u0002\u0003\u0007Q+A\u0002yIE\n\u0001B\u0019:pW\u0016\u00148\u000fI\u0001\taJ|G-^2feV\tQ\u000e\u0005\u0003oo\u001e;U\"A8\u000b\u0005-\u0004(BA9s\u0003\u001d\u0019G.[3oiNT!aJ:\u000b\u0005Q,\u0018AB1qC\u000eDWMC\u0001w\u0003\ry'oZ\u0005\u0003q>\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHCA3|\u0011\u001dIG\"!AA\u00025\f\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\r\u0015D\u0018\u000e^3e+\u0005y\b\u0003BA\u0001\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007CR|W.[2\u000b\t\u0005%\u00111B\u0001\u000bG>t7-\u001e:sK:$(bAA\u0007\u0001\u0006!Q\u000f^5m\u0013\u0011\t\t\"a\u0001\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u00059a.\u001a;x_J\\'bAA\u0012e\u000611m\\7n_:LA!a\n\u0002\u001e\taA*[:uK:,'OT1nK\u0006iA.[:uK:,'OT1nK\u0002\nQa]3u+B$2!ZA\u0018\u0011\u001d\t\tD\u0005a\u0001\u0003g\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003k\t\u0019%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\r\t\u0007/\u001b\u0006\u0005\u0003{\ty$A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0005S/A\u0003kk:LG/\u0003\u0003\u0002F\u0005]\"\u0001\u0003+fgRLeNZ8)\u0007I\tI\u0005\u0005\u0003\u00026\u0005-\u0013\u0002BA'\u0003o\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A3)\u0007M\t)\u0006\u0005\u0003\u00026\u0005]\u0013\u0002BA-\u0003o\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0003\u0002`\u0005-\u0004\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015\u0004/A\u0003bI6Lg.\u0003\u0003\u0002j\u0005\r$aC!e[&t7\t\\5f]RDaa\u0015\u000bA\u0002\u00055\u0004#BA8\u0003c\u0002W\"A-\n\u0007\u0005M\u0014LA\u0002TKF\fA\u0005^3tiRKWM]*uCR,'+Z:u_J,wJ\u001c'bO\u001eLgn\u001a*fa2L7-\u0019\u000b\u0004K\u0006e\u0004bBA>+\u0001\u0007\u0011QP\u0001\u0007cV|'/^7\u0011\t\u0005}\u0014Q\u0012\b\u0005\u0003\u0003\u000bI\tE\u0002\u0002\u0004&k!!!\"\u000b\u0007\u0005\u001d\u0005&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017K\u0015A\u0002)sK\u0012,g-C\u0002D\u0003\u001fS1!a#JQ\u001d)\u00121SAR\u0003K\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\ti*a\u000f\u0002\rA\f'/Y7t\u0013\u0011\t\t+a&\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\t9+\t\u0002\u0002*\u0006\u0011!p\u001b\u0015\b+\u00055\u0016QWA\\!\u0011\ty+!-\u000e\u0005\u0005m\u0015\u0002BAZ\u00037\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005e\u0016\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u00061q-\u001a;M_\u001e$b!a0\u0002L\u0006=\u0007\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015g%A\u0002m_\u001eLA!!3\u0002D\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u0019\tiM\u0006a\u0001A\u00061!M]8lKJDa!!5\u0017\u0001\u0004i\u0016!\u00039beRLG/[8o\u00035\u0011'o\\6fe\u000eC\u0017M\\4fI\u0006!1\u000f^8q)\r)\u0017\u0011\u001c\u0005\u0007\u00037D\u0002\u0019A/\u0002\u0005%$\u0017!B:uCJ$HcA3\u0002b\"1\u00111\\\rA\u0002u\u000baAY8v]\u000e,GcA3\u0002h\"1\u00111\u001c\u000eA\u0002u\u000b!\"\u001a9pG\"\u001c\u0015m\u00195f)\u0011\ti/!?\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=-\u0003\u0015)\u0007o\\2i\u0013\u0011\t90!=\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0011\u0019\tim\u0007a\u0001A\u0006A\u0011m^1ji&\u001b&\u000bF\u0003f\u0003\u007f\u0014Y\u0001C\u0004\u0003\u0002q\u0001\rAa\u0001\u0002\u0005Q\u0004\b\u0003\u0002B\u0003\u0005\u000fi!!!\t\n\t\t%\u0011\u0011\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011i\u0001\ba\u0001;\u0006Ya.^7SKBd\u0017nY1t\u00039\u0019'/Z1uKB\u0013x\u000eZ;dKJ\fqbY;se\u0016tG\u000fT3bI\u0016\u0014\u0018\nZ\u000b\u0002;\u0006\u00112M]3bi\u0016\u0014%o\\6fe^KG\u000f[%e)\u0015\u0001'\u0011\u0004B\u000e\u0011\u0019\tYn\ba\u0001;\"I!QD\u0010\u0011\u0002\u0003\u0007!qD\u0001\u001cK:\f'\r\\3V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8\u0011\u0007!\u0013\t#C\u0002\u0003$%\u0013qAQ8pY\u0016\fg.\u0001\u000fde\u0016\fG/\u001a\"s_.,'oV5uQ&#G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%\"\u0006\u0002B\u0010\u0005WY#A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005oI\u0015AC1o]>$\u0018\r^5p]&!!1\bB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0006\u0003B\t-#Q\nB)\u0005+\u0002bAa\u0011\u0003JukVB\u0001B#\u0015\r\u00119%W\u0001\nS6lW\u000f^1cY\u0016L1\u0001\u0018B#\u0011\u0019Q\u0014\u00051\u0001\u0002~!1!qJ\u0011A\u0002u\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002B*C\u0001\u0007Q,A\tsKBd\u0017nY1uS>tg)Y2u_JD\u0011Ba\u0016\"!\u0003\u0005\rA!\u0017\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0005\u00057\u0012i&\u0004\u0002\u0002\f%!!qLA\u0006\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)G\u000b\u0003\u0003Z\t-\u0002")
public class TierEpochStateReplicationTest
extends QuorumTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Map<Object, KafkaBroker> brokers = Map$.MODULE$.empty();
    private KafkaProducer<byte[], byte[]> producer = null;
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private final ListenerName listenerName = ListenerName.normalised((String)"PLAINTEXT");

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Map<Object, KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Map<Object, KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers().values().toSeq(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public AdminClient createAdminClient(Seq<KafkaBroker> brokers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(brokers, this.listenerName()));
        properties.put("request.timeout.ms", "20000");
        return AdminClient.create((Properties)properties);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testTierStateRestoreOnLaggingReplica(String quorum) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).foreach((Function1 & Serializable & scala.Serializable)id -> TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$1(this, BoxesRunTime.unboxToInt((Object)id)));
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("segment.bytes", "10000");
        properties.put("retention.bytes", "-1");
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        int leaderId = ((Tuple2)this.createTopic(this.topic(), 1, 2, properties).head())._2$mcI$sp();
        int followerId = BoxesRunTime.unboxToInt((Object)this.brokers().keys().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != leaderId).get());
        KafkaBroker leader = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)leaderId));
        KafkaBroker follower = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)followerId));
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochBeforeLeaderBounce = BoxesRunTime.unboxToInt((Object)this.epochCache(leader).latestEpoch().get());
        this.bounce(leaderId);
        this.awaitISR(tp, 2);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$3(this, leaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaBroker newLeader = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$5(newLeader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochAfterLeaderBounce = BoxesRunTime.unboxToInt((Object)this.epochCache(newLeader).latestEpoch().get());
        Assertions.assertTrue((epochAfterLeaderBounce > epochBeforeLeaderBounce ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.epochCache(newLeader).epochEntries(), (Object)this.epochCache(follower).epochEntries());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)kv -> {
            TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$7(kv);
            return BoxedUnit.UNIT;
        });
        this.stop(followerId);
        this.awaitISR(tp, 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 999).foreach((Function1 & Serializable & scala.Serializable)_ -> TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$10(this, BoxesRunTime.unboxToInt((Object)_)));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$11(newLeader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)this.epochCache(newLeader).latestEpoch().get()) > epochAfterLeaderBounce ? 1 : 0) != 0);
        this.start(followerId);
        this.awaitISR(tp, 2);
        KafkaBroker newFollower = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)followerId));
        Assertions.assertEquals((Object)this.epochCache(newLeader).epochEntries(), (Object)this.epochCache(newFollower).epochEntries());
    }

    private AbstractLog getLog(KafkaBroker broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(x$1, x$2).orNull(Predef$.MODULE$.$conforms());
    }

    private void brokerChanged() {
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void stop(int id) {
        this.brokers().remove((Object)BoxesRunTime.boxToInteger((int)id)).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierEpochStateReplicationTest.$anonfun$stop$1(broker);
            return BoxedUnit.UNIT;
        });
        this.brokerChanged();
    }

    private void start(int id) {
        this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)this.createBrokerWithId(id, this.createBrokerWithId$default$2()));
        this.brokerChanged();
    }

    private void bounce(int id) {
        this.brokers().remove((Object)BoxesRunTime.boxToInteger((int)id)).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierEpochStateReplicationTest.$anonfun$bounce$1(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)this.createBrokerWithId(id, this.createBrokerWithId$default$2()));
        this.brokerChanged();
    }

    private LeaderEpochFileCache epochCache(KafkaBroker broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$awaitISR$1(this, tp, numReplicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$awaitISR$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers().values().toSeq(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
    }

    private int currentLeaderId() {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)((Tuple2)this.brokers().head())._2()).metadataCache().getPartitionInfo(this.topic(), 0).get()).leader();
    }

    private KafkaBroker createBrokerWithId(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(enableUncleanLeaderElection));
        config.setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        config.setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "10");
        return this.createBroker(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, this.createBroker$default$3(), this.createBroker$default$4());
    }

    private boolean createBrokerWithId$default$2() {
        return false;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.brokers().values().toSeq(), topicConfig);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public static final /* synthetic */ Option $anonfun$testTierStateRestoreOnLaggingReplica$1(TierEpochStateReplicationTest $this, int id) {
        return $this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)$this.createBrokerWithId(id, $this.createBrokerWithId$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$3(TierEpochStateReplicationTest $this, int leaderId$1) {
        return $this.currentLeaderId() == leaderId$1;
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$4() {
        return "Timed out waiting for preferred leader to be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$5(KafkaBroker newLeader$1) {
        return ((TierTopicManager)newLeader$1.tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$6() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$8(Tuple2 kv$1) {
        return ((TierTopicManager)((KafkaBroker)kv$1._2()).tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$9() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierStateRestoreOnLaggingReplica$7(Tuple2 kv) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$8(kv)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testTierStateRestoreOnLaggingReplica$10(TierEpochStateReplicationTest $this, int _) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg())).get();
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$11(KafkaBroker newLeader$1, TopicPartition tp$1) {
        boolean x$2;
        LogManager qual$1 = newLeader$1.replicaManager().logManager();
        return ((AbstractLog)qual$1.getLog(tp$1, x$2 = qual$1.getLog$default$2()).get()).localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$12() {
        return "timed out waiting for segment tiering and hotset retention";
    }

    public static final /* synthetic */ void $anonfun$stop$1(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    public static final /* synthetic */ void $anonfun$bounce$1(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$2(int numReplicas$1, Partition x$4) {
        return x$4.inSyncReplicaIds().size() == numReplicas$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierEpochStateReplicationTest $this, TopicPartition tp$2, int numReplicas$1) {
        return ((KafkaBroker)$this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)$this.currentLeaderId()))).replicaManager().onlinePartition(tp$2).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierEpochStateReplicationTest.$anonfun$awaitISR$2(numReplicas$1, x$4)));
    }

    public static final /* synthetic */ String $anonfun$awaitISR$3() {
        return "Timed out waiting for replicas to join ISR";
    }

    public TierEpochStateReplicationTest() {
        this.topic = "topic1";
    }
}

