/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataComparator;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.TierPartitionStateRestoreTrigger;
import kafka.tier.tools.TierPartitionUnfreezeLogStartOffsetTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005RABQa\u000e\u0001\u0005\naBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u00031\u0011\u0019A\u0005\u0001)A\u0005c!)\u0011\n\u0001C\u0005\u0015\"9!\r\u0001b\u0001\n\u0003\u0019\u0007B\u00028\u0001A\u0003%A\rC\u0003p\u0001\u0011\u0005\u0003\u000f\u0003\u0004\u0002\u0002\u0001!\t\u0005\u000f\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002.\u0002!I!a,\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011Q\u0018\u0001\u0005\u0002\u0005%\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!a>\u0001\t\u0013\tI\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005[BqA!\u001e\u0001\t\u0013\u00119HA\u000eUS\u0016\u0014\u0018J\u001c;fOJ\fG/[8o\u000b:$Gk\\#oIR+7\u000f\u001e\u0006\u0003A\u0005\nA\u0001^5fe*\t!%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\"\u0003\r\t\u0007/[\u0005\u0003U\u001d\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003}\t1B\u0019:pW\u0016\u00148i\\;oiV\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0002J]R\fQbY8oM&<WO]3N_\u000e\\G#A\u001d\u0011\u0005IR\u0014BA\u001e4\u0005\u0011)f.\u001b;\u0002\u000bQ|\u0007/[2\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0015A\f'\u000f^5uS>t7/A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003-\u00032\u0001\u0014+X\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002QG\u00051AH]8pizJ\u0011\u0001N\u0005\u0003'N\nq\u0001]1dW\u0006<W-\u0003\u0002V-\n\u00191+Z9\u000b\u0005M\u001b\u0004C\u0001-a\u001b\u0005I&B\u0001.\\\u0003\u0019\u0019w.\\7p]*\u0011!\u0005\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b3\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB3ySR,G-F\u0001e!\t)G.D\u0001g\u0015\t9\u0007.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003S*\f!bY8oGV\u0014(/\u001a8u\u0015\tY')\u0001\u0003vi&d\u0017BA7g\u00055\tEo\\7jG\n{w\u000e\\3b]\u00069Q\r_5uK\u0012\u0004\u0013!B:fiV\u0003HCA\u001dr\u0011\u0015\u00118\u00021\u0001t\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001;{\u001b\u0005)(B\u0001\u0015w\u0015\t9\b0A\u0004kkBLG/\u001a:\u000b\u0005et\u0016!\u00026v]&$\u0018BA>v\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0006~!\t!h0\u0003\u0002\u0000k\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3\u0001DA\u0003!\r!\u0018qA\u0005\u0004\u0003\u0013)(!C!gi\u0016\u0014X)Y2i\u0003]!Xm\u001d;Be\u000eD\u0017N^3B]\u0012$\u0016.\u001a:GKR\u001c\u0007\u000eF\u0002:\u0003\u001fAq!!\u0005\u000e\u0001\u0004\t\u0019\"\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005e\u0001C\u0001(4\u0013\r\tYbM\u0001\u0007!J,G-\u001a4\n\u0007\u0015\u000byBC\u0002\u0002\u001cMBs!DA\u0012\u0003g\t)\u0004\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0011A\u0014xN^5eKJT1!!\fw\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011GA\u0014\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011qGA\u001eC\t\tI$\u0001\u0002{W\u0006\u0012\u0011QH\u0001\u0006WJ\fg\r\u001e\u0015\b\u001b\u0005\u0005\u0013\u0011JA&!\u0011\t\u0019%!\u0012\u000e\u0005\u0005-\u0012\u0002BA$\u0003W\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u00055\u0013\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006\u0001C/Z:u\u0003J\u001c\u0007.\u001b<f\u0003:$\u0007K]3gKJ\u0014X\r\u001a+jKJ4U\r^2i)\rI\u00141\u000b\u0005\b\u0003#q\u0001\u0019AA\nQ\u001dq\u00111EA\u001a\u0003/bC!a\u000e\u0002<!:a\"!\u0011\u0002J\u0005-\u0013\u0001\u0007<bY&$\u0017\r^3GK:\u001cW\rV8pYJ+7/\u001e7ugRI\u0011(a\u0018\u0002z\u0005=\u0015Q\u0014\u0005\b\u0003Cz\u0001\u0019AA2\u0003-1WM\\2f\u000bZ,g\u000e^:\u0011\r\u0005\u0015\u0014qMA6\u001b\u0005Q\u0017bAA5U\n!A*[:u!\u0011\ti'!\u001e\u000e\u0005\u0005=$b\u0001.\u0002r)\u0019\u00111O\u0010\u0002\u000bQ|w\u000e\\:\n\t\u0005]\u0014q\u000e\u0002\u000f\r\u0016t7-Z#wK:$\u0018J\u001c4p\u0011\u001d\tYh\u0004a\u0001\u0003{\nq\u0002\u001e9JIN$vNQ3GK:\u001cW\r\u001a\t\t\u0003+\ty(a!\u0002\n&!\u0011\u0011QA\u0010\u0005\ri\u0015\r\u001d\t\u0004]\u0005\u0015\u0015bAAD?\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0004e\u0005-\u0015bAAGg\t9!i\\8mK\u0006t\u0007bBAI\u001f\u0001\u0007\u00111S\u0001\u0004Y><\u0007\u0003BAK\u00033k!!a&\u000b\u0007\u0005E\u0015%\u0003\u0003\u0002\u001c\u0006]%!C'fe\u001e,G\rT8h\u0011\u001d\tyj\u0004a\u0001\u0003C\u000b!\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKB!\u00111UAU\u001b\t\t)KC\u0002\u0002(~\tQa\u001d;bi\u0016LA!a+\u0002&\n\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003m1\u0018\r\\5eCR,'+Z:u_J,Gk\\8mgJ+7/\u001e7ugRY\u0011(!-\u00024\u0006]\u0016\u0011XA^\u0011\u001d\t\t\u0007\u0005a\u0001\u0003GBq!!.\u0011\u0001\u0004\t\u0019\"A\tsKN$xN]3PkR\u0004X\u000f\u001e&t_:Dq!a\u001f\u0011\u0001\u0004\ti\bC\u0004\u0002\u0012B\u0001\r!a%\t\u000f\u0005}\u0005\u00031\u0001\u0002\"\u00069C/Z:u\u0003J\u001c\u0007.\u001b<f\u0003:$G+[3s\r\u0016$8\r\u001b$f]\u000e,\u0017I\u001c3SK\u000e|g/\u001a:z)\u0015I\u0014\u0011YAc\u0011\u001d\t\u0019-\u0005a\u0001\u0003\u0013\u000b!#^:f%\u0016\u001cHo\u001c:f%\u0006<\u0018J\u001c9vi\"9\u0011qY\tA\u0002\u0005%\u0015A\u00074sK\u0016TX-T3sO\u0016$Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$HcA\u001d\u0002L\"9\u0011\u0011\u0003\nA\u0002\u0005M\u0001f\u0002\n\u0002$\u0005M\u0012q\u001a\u0017\u0005\u0003o\tY\u0004K\u0004\u0013\u0003\u0003\nI%a\u0013\u0002uQ,7\u000f^!sG\"Lg/Z!oIRKWM\u001d$fi\u000eDg)\u001a8dK\u0006sGMU3d_Z,'/_,ji\"\u0014Vm\u001d;pe\u0016\u0014\u0016m^%oaV$HcA\u001d\u0002X\"9\u0011\u0011C\nA\u0002\u0005M\u0001fB\n\u0002$\u0005M\u00121\u001c\u0017\u0005\u0003o\tY\u0004K\u0004\u0014\u0003\u0003\nI%a\u0013\u0002\u000bR,7\u000f^!sG\"Lg/Z!oIRKWM\u001d$fi\u000eDg)\u001a8dK\u0006sGMU3d_Z,'/_,ji\"lUM]4fI2{wm\u0015;beR|eMZ:fi\u001a\u0013xN_3o)\rI\u00141\u001d\u0005\b\u0003#!\u0002\u0019AA\nQ\u001d!\u00121EA\u001a\u0003OdC!a\u000e\u0002<!:A#!\u0011\u0002J\u0005-\u0013A\u00049s_\u0012,8-\u001a*fG>\u0014Hm\u001d\u000b\u0006s\u0005=\u00181\u001f\u0005\u0007\u0003c,\u0002\u0019A\u0019\u0002\u00119\u0014\u0015\r^2iKNDa!!>\u0016\u0001\u0004\t\u0014a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\u00025\u001d,G\u000fT3bI\u0016\u0014hi\u001c:U_BL7\rU1si&$\u0018n\u001c8\u0015\u000bE\nY0a@\t\r\u0005uh\u00031\u0001X\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!\u0001\u0017\u0001\u0004\u0011\u0019!\u0001\u000bqCJ$\u0018\u000e^5p]R{G*Z1eKJl\u0015\r\u001d\t\u0007\u0003+\ty(M\u0019\u0002/]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$G#B\u001d\u0003\n\t5\u0001B\u0002B\u0006/\u0001\u0007\u0011'\u0001\bnS:tU/\\*fO6,g\u000e^:\t\u000f\t\u0005q\u00031\u0001\u0003\u0004\u0005\t2/[7vY\u0006$XMU3uK:$\u0018n\u001c8\u0015\u0007e\u0012\u0019\u0002C\u0004\u0003\u0002a\u0001\rAa\u0001\u00027\r|gn];nK\u0006sGMV1mS\u0012\fG/\u001a+jKJ4U\r^2i)\u001dI$\u0011\u0004B\u000e\u0005;AqA!\u0001\u001a\u0001\u0004\u0011\u0019\u0001\u0003\u0004\u0002rf\u0001\r!\r\u0005\u0007\u0003kL\u0002\u0019A\u0019\u0002%]\u0014\u0018\u000e^3SK\u000e|g/\u001a:D_:4\u0017n\u001a\u000b\t\u0005G\u0011yC!\u0010\u0003BA!!Q\u0005B\u0016\u001b\t\u00119CC\u0002\u0003*\t\u000b!![8\n\t\t5\"q\u0005\u0002\u0005\r&dW\rC\u0004\u00032i\u0001\rAa\r\u0002!QLWM]\"mS\u0016tGoQ8oM&<\u0007\u0003CA3\u0005k\t\u0019Ba\u000e\n\u0007\u0005\u0005%\u000eE\u0002@\u0005sI1Aa\u000fA\u0005\u0019y%M[3di\"9!q\b\u000eA\u0002\t\r\u0012AC<pe.Lgn\u001a#je\"9!1\t\u000eA\u0002\t\r\u0012!\u00052s_.,'oV8sW\u0012L'\u000fT5ti\u0006)\u0013m]:feR$\u0016.\\3ti\u0006l\u0007OR8s\u001f\u001a47/\u001a;M_>\\W\u000f]\"peJ,7\r\u001e\u000b\ns\t%#1\nB/\u0005OBa!!@\u001c\u0001\u00049\u0006b\u0002B'7\u0001\u0007!qJ\u0001\tG>t7/^7feBA!\u0011\u000bB-\u0003'\t\u0019\"\u0004\u0002\u0003T)!!Q\nB+\u0015\r\u00119fW\u0001\bG2LWM\u001c;t\u0013\u0011\u0011YFa\u0015\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0011\u001d\u0011yf\u0007a\u0001\u0005C\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007I\u0012\u0019'C\u0002\u0003fM\u0012A\u0001T8oO\"9!\u0011N\u000eA\u0002\t\u0005\u0014AD3ya\u0016\u001cG/\u001a3PM\u001a\u001cX\r^\u0001&CN\u001cXM\u001d;US6,7\u000f^1na\u001a{'o\u00144gg\u0016$Hj\\8lkBl\u0015n]:j]\u001e$r!\u000fB8\u0005c\u0012\u0019\b\u0003\u0004\u0002~r\u0001\ra\u0016\u0005\b\u0005\u001bb\u0002\u0019\u0001B(\u0011\u001d\u0011y\u0006\ba\u0001\u0005C\n1b\u0019:fCR,Gk\u001c9jGRa!\u0011\u0010BD\u0005\u0013\u0013iI!%\u0003\u001cB1!1\u0010BCcEj!A! \u000b\t\t}$\u0011Q\u0001\nS6lW\u000f^1cY\u0016T1Aa!4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u0013i\b\u0003\u0004=;\u0001\u0007\u00111\u0003\u0005\u0007\u0005\u0017k\u0002\u0019A\u0019\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0019\u0011y)\ba\u0001c\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\tMU\u00041\u0001\u0003\u0016\u0006YAo\u001c9jG\u000e{gNZ5h!\u0011\t)Ga&\n\u0007\te%N\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!(\u001e\u0001\u0004\u0011)*A\tbI6Lgn\u00117jK:$8i\u001c8gS\u001e\u0004")
public class TierIntegrationEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Seq<TopicPartition> topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable & scala.Serializable)p -> TierIntegrationEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndPreferredTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    /*
     * WARNING - void declaration
     */
    private void validateFenceToolResults(java.util.List<FenceEventInfo> fenceEvents, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        TopicIdPartition topicIdToBeFenced = (TopicIdPartition)((Tuple2)tpIdsToBeFenced.head())._1();
        boolean freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        Assertions.assertTrue((fenceEvents.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((new TopicIdPartition(fenceEvents.get(0).topic(), CoreUtils$.MODULE$.uuidFromBase64(fenceEvents.get((int)0).topicIdBase64), fenceEvents.get((int)0).partition).equals(topicIdToBeFenced) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals((Object)fenceEvents.get((int)0).freezeMergedLogStartOffset, (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset)) ? 1 : 0) != 0);
        if (freezeMergedLogStartOffset) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$1(tierPartitionState, log)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateRestoreToolsResults(java.util.List<FenceEventInfo> fenceEvents, String restoreOutputJson, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        restoreRawOutputList = RestoreInfo.RestoreRawOutput.readJsonFromFile((Path)Paths.get(restoreOutputJson, new String[0]));
        if (restoreRawOutputList.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreRawOutput)restoreRawOutputList.get((int)0)).input().fenceEventInfo().freezeMergedLogStartOffset;
        var8_8 = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var8_8) == false : var8_8 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1);
        if (freezeMergedLogStartOffset) {
            var11_9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            var9_10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$1(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        var17_12 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var15_13 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$3(tierPartitionState, log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testArchiveAndTierFetchFenceAndRecovery(boolean useRestoreRawInput, boolean freezeMergedLogStartOffset) {
        props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        nBatches = 100;
        recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        x$2 = qual$1.getLog$default$2();
        log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        tpIdsToBeFenced = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierPartitionState.topicIdPartition().get()), (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset))}));
        topicIdPartitionsFile = TestUtils$.MODULE$.tempFile();
        RecoveryTestUtils$.MODULE$.writeFencingFile(topicIdPartitionsFile, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced);
        workingDir = TestUtils$.MODULE$.tempDir();
        brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        outputDir = TestUtils$.MODULE$.tempDir();
        fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), topicIdPartitionsFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile})));
        fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), new String[]{tierPartitionState.topicPartition().toString()}).toFile();
        tpDir.mkdir();
        flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Files.copy(flushedPath, Paths.get(tpDir.getAbsolutePath(), new String[]{flushedPath.getFileName().toString()}), new CopyOption[0]);
        comparatorOutputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/comparator-output.json").toString();
        TierMetadataComparator.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"input.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"output.json"), comparatorOutputJson})));
        comparatorOutput = RestoreInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
        if (comparatorOutput.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreComparatorInput)comparatorOutput.get((int)0)).input().freezeMergedLogStartOffset;
        var25_25 = ((FenceEventInfo)fenceEvents.get((int)0)).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var25_25) == false : var25_25 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        if (useRestoreRawInput) {
            restoreComparatorInputList = RestoreInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
            restoreRawInputList = (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(restoreComparatorInputList).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(kafka.tier.tools.common.RestoreInfo$RestoreComparatorInput ), (Lkafka/tier/tools/common/RestoreInfo$RestoreComparatorInput;)Lkafka/tier/tools/common/RestoreInfo$RestoreRawInput;)(), Buffer$.MODULE$.canBuildFrom())).asJava();
            restoreRawInputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/restore-raw-input.json").toString();
            fos = new FileOutputStream(restoreRawInputJson);
            RestoreInfo.RestoreRawInput.writeJsonToFile((java.util.List)restoreRawInputList, (OutputStream)fos);
            fos.close();
            TierPartitionStateRestoreTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"raw.json"), restoreRawInputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson})));
            this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        } else {
            TierPartitionStateRestoreTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"comparator.json"), comparatorOutputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson})));
            if (freezeMergedLogStartOffset) {
                var36_31 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                var34_32 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$2(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$3());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            } else {
                var42_34 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                var40_35 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$4(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$5());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
        if (freezeMergedLogStartOffset && !useRestoreRawInput) {
            return;
        }
        if (freezeMergedLogStartOffset) {
            unfreezeOutputJson = new StringBuilder(29).append(outputDir.getAbsolutePath()).append("/unfreeze-trigger-output.json").toString();
            TierPartitionUnfreezeLogStartOffsetTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"restore.json"), restoreOutputJson, RecoveryUtils.makeArgument((String)"output.json"), unfreezeOutputJson})));
            var48_38 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            var46_39 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$6(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        var54_42 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var52_43 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$8(endOffset, tierPartitionState)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecovery(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithRestoreRawInput(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithMergedLogStartOffsetFrozen(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, true);
    }

    private void produceRecords(int nBatches, int recordsPerBatch) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nBatches).foreach((Function1 & Serializable & scala.Serializable)b -> TierIntegrationEndToEndTest.$anonfun$produceRecords$1(this, recordsPerBatch, producer, BoxesRunTime.unboxToInt((Object)b)));
        }
    }

    private int getLeaderForTopicPartition(TopicPartition topicPartition, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        return BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$1(this, partitionToLeaderMap, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$simulateRetention$1(this, partitionToLeaderMap, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch) {
        void var31_27;
        void var17_17;
        void var27_24;
        void var23_21;
        void var19_18;
        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
        KafkaConsumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
        consumer.assign(partitions);
        consumer.seekToBeginning(partitions);
        ArrayList valuesRead = new ArrayList();
        ArrayList timestampsOffsets = new ArrayList();
        while (valuesRead.size() != nBatches * recordsPerBatch) {
            consumer.poll(Duration.ofMillis(1000L)).forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(null, valuesRead, timestampsOffsets){
                private final ArrayList valuesRead$1;
                private final ArrayList timestampsOffsets$1;

                public Consumer<ConsumerRecord<String, String>> andThen(Consumer<? super ConsumerRecord<String, String>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                public void accept(ConsumerRecord<String, String> r) {
                    this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                    this.timestampsOffsets$1.add(new Tuple2.mcJJ.sp(r.timestamp(), r.offset()));
                }
                {
                    this.valuesRead$1 = valuesRead$1;
                    this.timestampsOffsets$1 = timestampsOffsets$1;
                }
            });
        }
        Assertions.assertEquals(new ArrayList((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, nBatches * recordsPerBatch)).asJava()), valuesRead);
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(timestampsOffsets).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$2(this, timestampsOffsets, topicPartition, consumer, x$4);
            return BoxedUnit.UNIT;
        });
        this.assertTimestampForOffsetLookupCorrect(topicPartition, consumer, 0L, 0L);
        this.assertTimestampForOffsetLookupMissing(topicPartition, consumer, Long.MAX_VALUE);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int partitionsInErrorDuringArchivalCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringArchival"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$4(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringArchivalCount, (String)"tier archiver shows partitions in error state during archival");
        int partitionsInErrorDuringDeletionCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringDeletion"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$5(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringDeletionCount, (String)"tier deletion process shows partitions in error state during deletion");
        List memoryTrackerMetrics = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierFetcherMemoryTracker"), (String[])((Object[])new String[]{"Leased", "PoolSize", "MaxLeaseLagMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$6(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        String bean = "kafka.server:type=TierFetcher";
        String[] attrs = (String[])((Object[])new String[]{"BytesFetchedTotal", "OffsetCacheHitRatio"});
        List list = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName(bean), attrs).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$7(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)list);
        }
        double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0));
        double offsetCacheHitRatio = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(1));
        Assertions.assertEquals((double)1.0, (double)var19_18, (double)1.0E-6, (String)"offset cache should not have shown misses");
        List list2 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), (String[])((Object[])new String[]{"HeartbeatMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$8(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some2 = List$.MODULE$.unapplySeq((Seq)list2);
        if (some2.isEmpty() || some2.get() == null || ((LinearSeqOptimized)some2.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list2);
        }
        double heartbeat = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some2.get()).apply(0));
        Assertions.assertTrue((var23_21 < (double)2000 ? 1 : 0) != 0, (String)"tier topic consumer heartbeat is alive");
        List list3 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=HeartbeatMs"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToLong((long)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$9(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some3 = List$.MODULE$.unapplySeq((Seq)list3);
        if (some3.isEmpty() || some3.get() == null || ((LinearSeqOptimized)some3.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list3);
        }
        long tierTasksHeartbeat = BoxesRunTime.unboxToLong((Object)((LinearSeqOptimized)some3.get()).apply(0));
        Assertions.assertTrue((var27_24 < 10000L ? 1 : 0) != 0, (String)"tier tasks heartbeat is alive");
        Assertions.assertTrue((var17_17 > (double)100 ? 1 : 0) != 0, (String)"tier fetch metric shows no data fetched from tiered storage");
        List list4 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), (String[])((Object[])new String[]{"MeanRate"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$10(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some4 = List$.MODULE$.unapplySeq((Seq)list4);
        if (some4.isEmpty() || some4.get() == null || ((LinearSeqOptimized)some4.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list4);
        }
        double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some4.get()).apply(0));
        Assertions.assertTrue((var31_27 > (double)100 ? 1 : 0) != 0, (String)"tier archiver mean rate shows no data uploaded to tiered storage");
        Buffer partitionsStatusCounts = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), (String[])((Object[])new String[]{"ImmigratingPartitions", "CatchupConsumerPartitions", "PrimaryConsumerPartitions", "ErrorPartitions", "NumListeners", "MaxListeningMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$11(attr)), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0})), (Object)partitionsStatusCounts, (String)"tier topic manager fully immigrated the partition and metric works");
        int partitionsInErrorCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$12(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorCount, (String)"tier archiver shows no partitions in error state");
        Assertions.assertEquals((double)1.0, (double)var19_18, (double)1.0E-6, (String)"offset cache should not have shown misses");
        Assertions.assertTrue((var17_17 > (double)100 ? 1 : 0) != 0, (String)new StringBuilder(61).append("tier fetch metric shows no data fetched from tiered storage: ").append((double)var17_17).toString());
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.head()), (double)0.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.apply(1)), (double)1048576.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.last()), (double)0.0, (double)0.0, (String)"expected no value for oldestLease, since all leases should be reclaimed");
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$13(server);
            return BoxedUnit.UNIT;
        });
    }

    private File writeRecoverConfig(java.util.Map<String, Object> tierClientConfig, File workingDir, File brokerWorkdirList) {
        File recoveryConfFile = TestUtils$.MODULE$.tempFile();
        Properties props = Utils.mkProperties((java.util.Map)new HashMap<String, String>(this, workingDir, brokerWorkdirList){
            {
                this.put(KafkaConfig$.MODULE$.TierBackendProp(), "Mock");
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
                this.put("confluent.tier.recovery.validate", "false");
                this.put("confluent.tier.recovery.materialize", "true");
                this.put("confluent.tier.recovery.dump.events", "false");
                this.put("confluent.tier.recovery.broker.workdir.list", brokerWorkdirList$1.getAbsolutePath());
            }
        });
        props.putAll(tierClientConfig);
        props.store(new PrintWriter(recoveryConfFile), "");
        return recoveryConfFile;
    }

    private void assertTimestampForOffsetLookupCorrect(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp, long expectedOffset) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals((long)expectedOffset, (long)((OffsetAndTimestamp)consumer.offsetsForTimes(timestampsToSearch).get(topicPartition)).offset(), (String)"timestamp should match offset read");
    }

    private void assertTimestampForOffsetLookupMissing(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals(null, consumer.offsetsForTimes(timestampsToSearch).get(topicPartition), (String)"offset should not be returned");
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, Properties adminClientConfig) {
        scala.collection.immutable.Map map;
        void resource_resource;
        Admin admin = this.createAdminClient(this.listenerName(), adminClientConfig);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var8_7 = resource_resource;
            map = TierIntegrationEndToEndTest.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, (Admin)var8_7);
        }
        finally {
            resource_resource.close();
        }
        return map;
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierIntegrationEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$1(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$2() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$3(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$4() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$1(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$3(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ RestoreInfo.RestoreRawInput $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(RestoreInfo.RestoreComparatorInput restoreComparatorInput) {
        Assertions.assertTrue((boolean)restoreComparatorInput.choice().validationSuccess());
        return new RestoreInfo.RestoreRawInput(restoreComparatorInput.input(), restoreComparatorInput.choice().path());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$2(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$3() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$4(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$5() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$6(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$7() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$8(long endOffset$1, FileTierPartitionState tierPartitionState$3) {
        return endOffset$1 < tierPartitionState$3.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$9() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceRecords$2(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, int b$1, long timestamp$1, int i) {
        int m = recordsPerBatch$1 * b$1 + i;
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(timestamp$1), (Object)"foo".getBytes(StandardCharsets.UTF_8), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)m)).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$produceRecords$1(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, KafkaProducer producer$1, int b) {
        long timestamp = System.currentTimeMillis();
        return (IndexedSeq)((TraversableLike)((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), recordsPerBatch$1).map((Function1 & Serializable & scala.Serializable)i -> TierIntegrationEndToEndTest.$anonfun$produceRecords$2($this, recordsPerBatch$1, b, timestamp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer$1.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierPartitionState$4, int minNumSegments$1) {
        return tierPartitionState$4.numSegments() > minNumSegments$1 && tierPartitionState$4.endOffset() == tierPartitionState$4.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(int minNumSegments$1) {
        return new StringBuilder(61).append("timeout waiting for at least ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$1, int minNumSegments$1, TopicPartition tp) {
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$1);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp, x$2).get()).tierPartitionState();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$2(tierPartitionState, minNumSegments$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$simulateRetention$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$2, TopicPartition tp) {
        boolean x$2;
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$2);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().logManager();
        Assertions.assertTrue((((AbstractLog)qual$1.getLog(tp, x$2 = qual$1.getLog$default$2()).get()).deleteOldSegments() > 0 ? 1 : 0) != 0, (String)"tiered segments should have been deleted");
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$3(long timestamp$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$1._1$mcJ$sp() >= timestamp$2;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$2(TierIntegrationEndToEndTest $this, ArrayList timestampsOffsets$1, TopicPartition topicPartition$1, KafkaConsumer consumer$1, Tuple2 x$4) {
        if (x$4 != null) {
            long timestamp = x$4._1$mcJ$sp();
            long expectedOffset = ((Tuple2)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)timestampsOffsets$1).asScala()).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$3(timestamp, x0$1))).get())._2$mcJ$sp();
            $this.assertTimestampForOffsetLookupCorrect(topicPartition$1, (KafkaConsumer<String, String>)consumer$1, timestamp, expectedOffset);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$4(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$5(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$6(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$7(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$8(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ long $anonfun$consumeAndValidateTierFetch$9(Attribute attr) {
        return BoxesRunTime.unboxToLong((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$10(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$11(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$12(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$13(KafkaBroker server) {
        MemoryTracker memoryTracker = ((TierFetcher)server.tierFetcherOpt().get()).memoryTracker();
        Assertions.assertEquals((long)0L, (long)memoryTracker.leased(), (String)new StringBuilder(54).append("expected leased TierFetcher memory for broker ").append(server.config().brokerId()).append(" to be 0").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(TierIntegrationEndToEndTest $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$6 = $this.brokers();
        Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$6, numPartitions$1, replicationFactor$1, x$7, topicConfig$1);
    }

    public TierIntegrationEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

