/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.network.ConnectionQuotas;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.backupobjectlifecycle.TierTopicReader;
import kafka.tier.backupobjectlifecycle.TierTopicReaderConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00048\u0001\u0001\u0006I!\r\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019i\u0004\u0001)A\u0005u!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0011\u001dy\u0005A1A\u0005\u0002ACa\u0001\u0018\u0001!\u0002\u0013\t\u0006bB/\u0001\u0005\u0004%\tA\u0018\u0005\u0007]\u0002\u0001\u000b\u0011B0\t\u000f=\u0004!\u0019!C\u0001a\"1!\u0010\u0001Q\u0001\nEDqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011B?\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0004\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u00111\f\u0001\u0005\u0002\u0005u\u0002bBA3\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003S\u0002A\u0011AA\u001f\u0011\u001d\ti\u0007\u0001C\u0001\u0003{Aq!!\u001d\u0001\t\u0003\tiD\u0001\u0017CC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014H+Z:ug*\u0011adH\u0001\u0016E\u0006\u001c7.\u001e9pE*,7\r\u001e7jM\u0016\u001c\u0017p\u00197f\u0015\t\u0001\u0013%\u0001\u0003uS\u0016\u0014(\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005i\u0012A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A'I\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Y\u001a$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005i\u0011N\u001c;fe:\fG.\u00113nS:,\u0012A\u000f\t\u0003emJ!\u0001P\u001a\u0003\u001b%sG/\u001a:oC2\fE-\\5o\u00039Ig\u000e^3s]\u0006d\u0017\tZ7j]\u0002\nQ\u0001\u001d:paN,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA!\u001e;jY*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002\r\r|gNZ5h+\u0005Y\u0005C\u0001\u001aM\u0013\ti5GA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\nG2,8\u000f^3s\u0013\u0012,\u0012!\u0015\t\u0003%fs!aU,\u0011\u0005Q;S\"A+\u000b\u0005Y\u001b\u0013A\u0002\u001fs_>$h(\u0003\u0002YO\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv%\u0001\u0006dYV\u001cH/\u001a:JI\u0002\n\u0001%\u001b8uKJ\u0014%o\\6fe\u000ec\u0017.\u001a8u\u0007>tg-[4t'V\u0004\b\u000f\\5feV\tq\fE\u0002aG\u0016l\u0011!\u0019\u0006\u0003E\n\u000b\u0001BZ;oGRLwN\\\u0005\u0003I\u0006\u0014\u0001bU;qa2LWM\u001d\t\u0005\u0003\u001a\f\u0006.\u0003\u0002h\u0005\n\u0019Q*\u00199\u0011\u0005%dW\"\u00016\u000b\u0005-$\u0015\u0001\u00027b]\u001eL!!\u001c6\u0003\r=\u0013'.Z2u\u0003\u0005Jg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLwm]*vaBd\u0017.\u001a:!\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0016\u0003E\u00042A\n:u\u0013\t\u0019xE\u0001\u0004PaRLwN\u001c\t\u0003kbl\u0011A\u001e\u0006\u0003o~\tQa\u001d;pe\u0016L!!\u001f<\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'.Z2u'R|'/Z(qi\u0002\n1\u0003^5feR{\u0007/[2NC:\fw-\u001a:PaR,\u0012! \t\u0004MIt\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0012!\u0002;pa&\u001c\u0017\u0002BA\u0004\u0003\u0003\u0011\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002)QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014x\n\u001d;!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0001\u0003BA\t\u0003Ki!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0006kRLGn\u001d\u0006\u0005\u00033\tY\"\u0001\u0004d_6lwN\u001c\u0006\u0004E\u0005u!\u0002BA\u0010\u0003C\ta!\u00199bG\",'BAA\u0012\u0003\ry'oZ\u0005\u0005\u0003O\t\u0019B\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003_\u0001B!!\r\u000265\u0011\u00111\u0007\u0006\u0005\u0003W\t9\"\u0003\u0003\u00028\u0005M\"aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005AA/Z1sI><h\u000e\u0006\u0002\u0002@A\u0019a%!\u0011\n\u0007\u0005\rsE\u0001\u0003V]&$\bf\u0001\f\u0002HA!\u0011\u0011JA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013aA1qS*!\u0011\u0011KA*\u0003\u001dQW\u000f]5uKJTA!!\u0016\u0002\"\u0005)!.\u001e8ji&!\u0011\u0011LA&\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\buKN$xJ\\#mK\u000e$\u0018n\u001c8)\u0007]\ty\u0006\u0005\u0003\u0002J\u0005\u0005\u0014\u0002BA2\u0003\u0017\u0012A\u0001V3ti\u0006\tB/Z:u\u001f:\u0014Vm]5h]\u0006$\u0018n\u001c8)\u0007a\ty&A\buKN$(+Z2p]\u001aLw-\u001e:fQ\rI\u0012qL\u0001>i\u0016\u001cHO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:O_RLg-[3t\u0019&4WmY=mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u00045\u0005}\u0013\u0001\r;fgR$\u0016.\u001a:U_BL7MU3bI\u0016\u0014X\t_2mk\u0012,7/T3ue&\u001c7OU3q_J$X\rZ\"p]\u001aLw\rK\u0002\u001c\u0003?\u0002")
public class BackupObjectLifecycleManagerCoordinatorTests {
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private final Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
    private final KafkaConfig config;
    private final String clusterId;
    private final Supplier<Map<String, Object>> interBrokerClientConfigsSupplier;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final Time time;
    private final Metrics metrics;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Supplier<Map<String, Object>> interBrokerClientConfigsSupplier() {
        return this.interBrokerClientConfigsSupplier;
    }

    public Option<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void teardown() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void testOnElection() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
    }

    @Test
    public void testOnResignation() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.onResignation(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.onResignation(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
    }

    @Test
    public void testReconfigure() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        TopicPartition tp = new TopicPartition("_confluent-tier-state", BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(tp)).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        this.props().setProperty("confluent.clm.enabled", "false");
        KafkaConfig configWithCLMDisabled = new KafkaConfig((Map)this.props());
        this.props().setProperty("confluent.clm.enabled", "true");
        KafkaConfig configWithCLMEnabled = new KafkaConfig((Map)this.props());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.reconfigure(configWithCLMDisabled, configWithCLMEnabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.reconfigure(configWithCLMEnabled, configWithCLMEnabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.reconfigure(configWithCLMEnabled, configWithCLMDisabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.reconfigure(configWithCLMDisabled, configWithCLMDisabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
    }

    @Test
    public void testBrokerMetadataPublisherNotifiesLifecyleManagerCoordinator() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)Nil$.MODULE$);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        ConnectionQuotas connectionQuotas = (ConnectionQuotas)Mockito.mock(ConnectionQuotas.class);
        ClientQuotaMetadataManager clientQuotaMetadataManager = new ClientQuotaMetadataManager(quotaManagers, connectionQuotas);
        scala.collection.immutable.Map dynamicConfigHandlers = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Some tieredCoordinator = new Some(Mockito.mock(TierDeletedPartitionsCoordinator.class));
        Some quotaCoordinatorOpt = new Some(Mockito.mock(QuotaCoordinator.class));
        ClusterLinkDisabled.LinkManager clusterLinkManager = new ClusterLinkDisabled.LinkManager();
        MockFaultHandler faultHandler = new MockFaultHandler("publisher");
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Some backupObjectLifecycleManagerCoordinatorOpt = new Some((Object)new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics()));
        BrokerMetadataPublisher publisher = new BrokerMetadataPublisher(this.clusterId(), this.config(), metadataCache, logManager, this.replicaManager(), groupCoordinator, txnCoordinator, clientQuotaMetadataManager, dynamicConfigHandlers, (Option)None$.MODULE$, (FaultHandler)faultHandler, (FaultHandler)faultHandler, (Option)new Some((Object)clusterLinkManager), (Option)tieredCoordinator, (Option)backupObjectLifecycleManagerCoordinatorOpt, (Option)quotaCoordinatorOpt);
        int localId = 1;
        int[] replicas = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{localId, 2, 0}), ClassTag$.MODULE$.Int());
        Uuid topicId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        PartitionRegistration partitionRegistration = new PartitionRegistration(replicas, replicas, Replicas.NONE, Replicas.NONE, replicas[1], LeaderRecoveryState.RECOVERED, 1, 1);
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        partitionMap.put(Predef$.MODULE$.int2Integer(0), partitionRegistration);
        partitionMap.put(Predef$.MODULE$.int2Integer(1), partitionRegistration);
        ArrayBuffer topics = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        topics.$plus$eq((Object)new TopicImage("_confluent-tier-state", topicId, partitionMap, null));
        HashMap topicsById = new HashMap();
        HashMap topicsByName = new HashMap();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            topicsById.put(topic.id(), topic);
            return topicsByName.put(topic.name(), topic);
        });
        HashMap topicNamesByTenant = new HashMap();
        HashMap topicsByLinkId = new HashMap();
        TopicsImage topicsImage = new TopicsImage(topicsById, topicsByName, topicNamesByTenant, topicsByLinkId);
        MetadataImage metadataImage = new MetadataImage(new OffsetAndEpoch(100L, 100), FeaturesImage.EMPTY, ClusterImage.EMPTY, topicsImage, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        MetadataDelta metadataDelta = new MetadataDelta(metadataImage, x$1 -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(1).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(1).setLeader(localId + 1));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId + 1));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        ArrayList<Integer> removingReplicas = new ArrayList<Integer>();
        removingReplicas.add(Predef$.MODULE$.int2Integer(localId));
        ArrayList<Integer> addingReplicas = new ArrayList<Integer>();
        addingReplicas.add(Predef$.MODULE$.int2Integer(3));
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId + 1).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        faultHandler.maybeRethrowFirstException();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testTierTopicReaderExcludesMetricsReportedConfig() {
        clientConfigs = new HashMap<String, String>();
        clientConfigs.put("bootstrap", "127.0.0.1");
        clientConfigs.put("metric.reporters", "blah");
        consumerProps = TierTopicReader.getProperties((TierTopicReaderConfig)new TierTopicReaderConfig((Supplier<Map>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$1(java.util.HashMap ), ()Ljava/util/Map;)(clientConfigs), this.clusterId(), 0, 50, 50L, Collections.nCopies(50, Predef$.MODULE$.long2Long(0L)), Predef$.MODULE$.long2Long(10000L), (Consumer<Long>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$2(java.lang.Long ), (Ljava/lang/Long;)V)(), (Supplier<Boolean>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$3(), ()Ljava/lang/Boolean;)(), (Supplier<Boolean>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$4(), ()Ljava/lang/Boolean;)(), (Time)new MockTime(), 10, (Supplier<Integer>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$5(), ()Ljava/lang/Integer;)()));
        if (!consumerProps.containsKey("bootstrap")) ** GOTO lbl-1000
        v0 = consumerProps.get("bootstrap");
        var3_3 = "127.0.0.1";
        if (v0 != null && v0.equals(var3_3)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        Predef$.MODULE$.assert(consumerProps.containsKey("metric.reporters") == false);
    }

    public static final /* synthetic */ Map $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$1(HashMap clientConfigs$1) {
        return clientConfigs$1;
    }

    public static final /* synthetic */ void $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$2(Long x$2) {
    }

    public static final /* synthetic */ Boolean $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$3() {
        return Predef$.MODULE$.boolean2Boolean(true);
    }

    public static final /* synthetic */ Boolean $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$4() {
        return Predef$.MODULE$.boolean2Boolean(false);
    }

    public static final /* synthetic */ Integer $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$5() {
        return Predef$.MODULE$.int2Integer(10);
    }

    public BackupObjectLifecycleManagerCoordinatorTests() {
        this.props().setProperty("confluent.tier.feature", "true");
        this.props().setProperty("confluent.clm.enabled", "true");
        this.props().setProperty("node.id", "1");
        this.config = new KafkaConfig((Map)this.props());
        this.clusterId = "Test";
        this.interBrokerClientConfigsSupplier = () -> new HashMap();
        this.tierObjectStoreOpt = new Some(Mockito.mock(TierObjectStore.class));
        this.tierTopicManagerOpt = new Some(Mockito.mock(TierTopicManager.class));
        this.time = (Time)Mockito.mock(Time.class);
        this.metrics = new Metrics();
    }
}

